// MainDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ProfUIS_Controls.h"
#include "MainDlg.h"
#include "TabDemoDlg.h"

#include <ExtPopupMenuWnd.h>
#include <ExtPaintManager.h>
#include <exdlgbase.h>
//#include <ExtAnimEffect.h>
#include <ExtCmdManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_ICON_NOTIFY (WM_USER+11)
NOTIFYICONDATA g_NotifyIconData;
LPCTSTR g_sFriendlyProgramName = _T("Prof-UIS");

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CExtDlgBase
{
	bool m_bFirstShow;
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CExtButton	m_BtnOK;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CExtDlgBase(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
	m_bFirstShow = true;
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CExtDlgBase::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDOK, m_BtnOK);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CExtDlgBase)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog

CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
	: CExtResizableDialog(CMainDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bDialogInitComplete = false;
	m_bShowIconInTray = false;
	m_bDialogWithCtxMenu = true;
	m_nThinColorBtnHeight = 8;
}

void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
	CExtResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlg)
	DDX_Control(pDX, IDC_BUTTON_TAB_DEMO, m_BtnTabDemo);
	DDX_Control(pDX, IDC_SHOW_TAB, m_CheckShowTab);
	DDX_Control(pDX, IDC_TAB1, m_MainTab);
	DDX_Control(pDX, IDC_CHECK_MENU_WITH_SHADOWS, m_CheckMenuWithShadows);
	DDX_Control(pDX, IDC_COMBO_MENU_OPEN_EFFECT, m_ComboMenuEffect);
	DDX_Control(pDX, IDC_CHECK_MENU_ANIM_EXPANDING, m_CheckAnimateMenuWhenExpanding);
	DDX_Control(pDX, IDC_BUTTON_COLOR2, m_btnColor2);
	DDX_Control(pDX, IDC_BUTTON_COLOR1, m_btnColor1);
	DDX_Control(pDX, IDC_BUTTON_WITH_MENU, m_btn2);
	DDX_Control(pDX, IDC_EDIT_SAMPLE, m_EditSample);
	DDX_Control(pDX, IDC_COMBO_EDITABLE, m_ComboEditable);
	DDX_Control(pDX, IDC_COMBO_UI_LOOK, m_ComboUiLook);
	DDX_Control(pDX, IDC_ENABLE_DIALOG_CONTEXT_MENU, m_CheckEnableContextMenu);
	DDX_Control(pDX, IDC_CHECK_SHOW_IN_TRAY, m_CheckShowIconInTray);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOK);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_MY_MENUBAR, m_wndMenuBar);
	DDX_Control(pDX, IDC_MY_TOOLBAR_TOP, m_wndToolBarTop);
	DDX_Control(pDX, IDC_MY_TOOLBAR_LEFT, m_wndToolBarLeft);
#if (!defined __EXT_MFC_NO_TAB_CTRL)
	DDX_Control(pDX, ID_EXTTABCTRL, m_wndExtTabCtrl);
#endif // (!defined __EXT_MFC_NO_TAB_CTRL)
}

BEGIN_MESSAGE_MAP(CMainDlg, CExtResizableDialog)
	//{{AFX_MSG_MAP(CMainDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_WM_CONTEXTMENU()
	ON_CBN_SELENDOK(IDC_COMBO_UI_LOOK, OnSelendokComboUiLook)
	ON_COMMAND(IDC_CHECK_SHOW_IN_TRAY, OnCheckShowInTray)
	ON_COMMAND(IDC_ENABLE_DIALOG_CONTEXT_MENU, OnEnableDialogContextMenu)
	ON_COMMAND(IDC_LOOK_2K, OnLook2k)
	ON_UPDATE_COMMAND_UI(IDC_LOOK_2K, OnUpdateLook2k)
	ON_COMMAND(IDC_LOOK_XP, OnLookXp)
	ON_UPDATE_COMMAND_UI(IDC_LOOK_XP, OnUpdateLookXp)
	ON_BN_CLICKED(IDC_CHECK_MENU_ANIM_EXPANDING, OnCheckMenuAnimExpanding)
	ON_CBN_SELENDOK(IDC_COMBO_MENU_OPEN_EFFECT, OnSelendokComboMenuOpenEffect)
	ON_BN_CLICKED(IDC_CHECK_MENU_WITH_SHADOWS, OnCheckMenuWithShadows)
	ON_WM_DESTROY()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_SHOW_TAB, OnShowTab)
	ON_BN_CLICKED(IDC_BUTTON_TAB_DEMO, OnButtonTabDemo)
	ON_BN_CLICKED(IDC_CHECK_SHOW_IN_TRAY, OnCheckShowInTray)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_UPDATE_COMMAND_UI(IDC_BUTTON_TAB_DEMO, OnUpdateButtonTabDemo)
	ON_UPDATE_COMMAND_UI(IDC_CHECK_SHOW_IN_TRAY, OnUpdateCheckShowInTray)
	ON_UPDATE_COMMAND_UI(IDC_ENABLE_DIALOG_CONTEXT_MENU, OnUpdateEnableDialogContextMenu)
	ON_MESSAGE(WM_ICON_NOTIFY,OnInconNotify)
	ON_REGISTERED_MESSAGE(CExtPopupMenuWnd::g_nMsgPopupDrawItem,OnDrawPopupMenuItem)
	ON_REGISTERED_MESSAGE(CExtPopupMenuWnd::g_nMsgPopupDrawLeftArea,OnDrawPopupLeftArea)
	ON_REGISTERED_MESSAGE(CExtPopupColorMenuWnd::g_nMsgNotifyColorChangedFinally,OnColorChangedFinally)
	ON_REGISTERED_MESSAGE(CExtPopupColorMenuWnd::g_nMsgNotifyCustColor,OnColorSelectCustom)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers

LRESULT CMainDlg::OnInconNotify(WPARAM wParam, LPARAM lParam)
{
	wParam;
	if(WM_ICON_NOTIFY != g_NotifyIconData.uCallbackMessage)
		return 0;
UINT nShellNotifyCode = (UINT)lParam; // LOWORD(lParam);
	if( nShellNotifyCode != WM_RBUTTONUP
		&& nShellNotifyCode != WM_LBUTTONUP
		)
		return 0;
CPoint ptCursorPos;
	VERIFY( ::GetCursorPos( &ptCursorPos ) );
	ShowCtxMenu( ptCursorPos );
	return 1;
}

LRESULT CMainDlg::OnColorSelectCustom(WPARAM wParam, LPARAM lParam)
{
	wParam;
	lParam;
	MessageBox(
		_T("\"Custom color\" button pressed"),
		_T("Color menu event"),
		MB_OK|MB_ICONINFORMATION
		);
	return 0;
}

LRESULT CMainDlg::OnColorChangedFinally(WPARAM wParam, LPARAM lParam)
{
	lParam; // <- is CExtColorButton::m_lParamCookie value
COLORREF clrChanged = (COLORREF)wParam;
COLORREF clr = (COLORREF)wParam;
CString sMsg;
	if( clr == ((COLORREF)(-1)) )
	{
		// if CExtColorButton::m_clrDefault is ((COLORREF)(-1))
		sMsg = _T("\"Default color\" button");
	}
	else
	{
		sMsg.Format(
			_T("red - %d\ngreen - %d\nblue - %d"),
			INT(GetRValue(clrChanged)),
			INT(GetGValue(clrChanged)),
			INT(GetBValue(clrChanged))
			);
	}
	MessageBox(
		LPCTSTR( sMsg ),
		_T("Color chganged"),
		MB_OK|MB_ICONINFORMATION
		);
	return 0;
}

LRESULT CMainDlg::OnDrawPopupLeftArea(WPARAM wParam, LPARAM lParam)
{
	wParam;
CExtPopupMenuWnd::DRAWLEFTAREADATA * pDrawLeftAreaData =
		reinterpret_cast < CExtPopupMenuWnd::DRAWLEFTAREADATA * > ( lParam );
	ASSERT( pDrawLeftAreaData != NULL );

	// get draw DC
CDC & dc = *( (CDC *) *pDrawLeftAreaData );

CRect rcItem = LPCRECT(*pDrawLeftAreaData);
	CExtPaintManager::stat_PaintGradientRect(
		dc,
		&rcItem,
		dc.GetNearestColor( RGB( 0, 0, 0 ) ),
		dc.GetNearestColor( RGB( 0, 0, 196 ) ),
		true
		);

LOGFONT lf;
	::memset(&lf,0,sizeof(LOGFONT));
	g_PaintManager->m_FontNormalVertX.GetLogFont( &lf );
	lf.lfHeight = -18;
	lf.lfWidth = 0;
	lf.lfWeight = 900;
	_tcscpy( lf.lfFaceName, _T("Times New Roman") );
CFont font;
	VERIFY(
		font.CreateFontIndirect(&lf)
		);
CFont * pOldFont = dc.SelectObject( &font );
INT nOldBkMode = dc.SetBkMode( TRANSPARENT );
COLORREF clrOldText = dc.SetTextColor( RGB( 0, 0, 0 ) );

static CString sTitle( _T("Prof-UIS") );
CPoint ptText( rcItem.left+4, rcItem.bottom-5 );
	dc.DrawState(
		ptText, rcItem.Size(), (LPCTSTR)sTitle,
		DSS_NORMAL,  TRUE, 0, (CBrush*)NULL
		);
	dc.SetTextColor( RGB( 255, 255, 255 ) );
	ptText.Offset( -1, -2 );
	dc.DrawState(
		ptText, rcItem.Size(), (LPCTSTR)sTitle,
		DSS_NORMAL,  TRUE, 0, (CBrush*)NULL
		);

const int nIconMetric = 24;
HICON hIcon = (HICON)
		::LoadImage(
			::AfxGetInstanceHandle(),
			MAKEINTRESOURCE(IDI_ICON_FOR_MENU),
			IMAGE_ICON,
			nIconMetric,
			nIconMetric,
			0
			);
	if( hIcon != NULL )
	{
		int nOffset = (rcItem.Width() - nIconMetric) / 2;
		VERIFY(
			::DrawIconEx(
				dc.GetSafeHdc(),
				rcItem.left + nOffset,
				rcItem.top + nOffset,
				hIcon,
				nIconMetric,
				nIconMetric,
				0,
				(HBRUSH)NULL,
				DI_NORMAL
				)
			);
		VERIFY( DestroyIcon( hIcon ) );
	}

	dc.SetBkMode( nOldBkMode );
	dc.SetTextColor( clrOldText );
	dc.SelectObject( pOldFont );

	return !0;
}

LRESULT CMainDlg::OnDrawPopupMenuItem(WPARAM wParam, LPARAM lParam)
{
	wParam;
CExtPopupMenuWnd::DRAWITEMDATA * pDrawItemData =
		reinterpret_cast < CExtPopupMenuWnd::DRAWITEMDATA * > ( lParam );
	ASSERT( pDrawItemData != NULL );
UINT nCmdID = pDrawItemData->GetCmdID();
	if( nCmdID != ID_OWNERDRAW_ITEM )
		return 0; // default painting

	// paint default menu item background
	pDrawItemData->PaintDefaultBk();

	// paint some staff in a little bit rect
CRect rcItem = LPCRECT(*pDrawItemData);
	rcItem.DeflateRect( 10, 1, 10, 4 );

LPCTSTR sItemText = LPCTSTR(*pDrawItemData);
INT nItemTextLen = _tcslen( sItemText );

	// get draw DC
CDC & dc = *( (CDC *) *pDrawItemData );

CExtWndShadow _shadow;
	_shadow.Paint(
		dc, rcItem, CRect(0,0,0,0), CRect(0,0,0,0),
		3,
		CExtWndShadow::DEF_BRIGHTNESS_MIN,
		CExtWndShadow::DEF_BRIGHTNESS_MAX,
		false
		);
	CExtPaintManager::stat_PaintGradientRect(
		dc,
		&rcItem,
		dc.GetNearestColor( RGB( 255, 0, 0 ) ),
		dc.GetNearestColor( RGB( 0, 0, 255 ) ),
		false
		);

INT nOldBkMode = dc.SetBkMode( TRANSPARENT );
COLORREF clrOldText = dc.SetTextColor( RGB( 0, 0, 0 ) );
CFont * pOldFont = dc.SelectObject( &g_PaintManager->m_FontBold );

	rcItem.OffsetRect( 2, 1 );
	dc.DrawText(
		sItemText, nItemTextLen, &rcItem, 
		DT_SINGLELINE | DT_CENTER | DT_VCENTER | DT_END_ELLIPSIS
		);
	clrOldText = dc.SetTextColor( RGB( 255, 255, 255 ) );
	rcItem.OffsetRect( -2, -1 );
	dc.DrawText(
		sItemText, nItemTextLen, &rcItem, 
		DT_SINGLELINE | DT_CENTER | DT_VCENTER | DT_END_ELLIPSIS
		);

	dc.SelectObject( pOldFont );
	dc.SetBkMode( nOldBkMode );
	dc.SetTextColor( clrOldText );
	
	return !0;
}

BOOL CMainDlg::OnInitDialog()
{
	if( !CExtResizableDialog::OnInitDialog() )
	{
		ASSERT( FALSE );
		return FALSE;
	}

	m_btn2.m_dwMenuOpt |= TPMX_OWNERDRAW_FIXED;
	m_btnColor1.m_nMenuLeftAreaWidth = 30;

CWinApp * pApp = ::AfxGetApp();
	ASSERT( pApp != NULL );

	VERIFY(
		g_CmdManager->ProfileWndAdd(
			pApp->m_pszRegistryKey,
			GetSafeHwnd()
			)
		);

	VERIFY(
		g_CmdManager->UpdateFromToolBar(
			pApp->m_pszRegistryKey,
			IDR_TOOLBAR1
			)
		);

	ASSERT( m_wndMenuBar.GetSafeHwnd() != NULL );
	if(	!m_wndMenuBar.LoadMenuBar( IDR_MENU2 ) )
	{
		ASSERT( FALSE );
		return FALSE;
	}

	ASSERT( m_wndToolBarTop.GetSafeHwnd() != NULL );
	if(	!m_wndToolBarTop.LoadToolBar( IDR_TOOLBAR1 ) )
	{
		ASSERT( FALSE );
		return FALSE;
	}

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_MY_INDICATOR_1,
	ID_MY_INDICATOR_2,
	ID_MY_INDICATOR_3,
};
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		ASSERT( FALSE );
		return FALSE;
	}

	// update some commands in the command manager
CExtCmdManager::cmd_t * p_cmd = g_CmdManager->CmdGetPtr(
		pApp->m_pszRegistryKey,
		m_BtnTabDemo.GetDlgCtrlID()
		);
	ASSERT( p_cmd != NULL );
	m_BtnTabDemo.GetWindowText( p_cmd->m_sMenuText );
	p_cmd->m_sToolbarText = p_cmd->m_sMenuText;

	p_cmd = g_CmdManager->CmdGetPtr(
		pApp->m_pszRegistryKey,
		IDC_LOOK_2K
		);
	ASSERT( p_cmd != NULL );
	p_cmd->m_sToolbarText = p_cmd->m_sMenuText;

	p_cmd = g_CmdManager->CmdGetPtr(
		pApp->m_pszRegistryKey,
		IDC_LOOK_XP
		);
	ASSERT( p_cmd != NULL );
	p_cmd->m_sToolbarText = p_cmd->m_sMenuText;

	// init bitmap label in the menu bar
INT nIdxBmpLabel = m_wndMenuBar.CommandToIndex( ID_BITMAP_LABEL );
	ASSERT( nIdxBmpLabel >= 0 );
	VERIFY(
		m_wndMenuBar.RemoveButton( nIdxBmpLabel, FALSE )
		);
	VERIFY(
		m_wndMenuBar.InsertSpecButton(
			nIdxBmpLabel,
			new
				CBitmapLabelInMenuBar(
					&m_wndMenuBar,
					ID_BITMAP_LABEL,
					IDB_BITMAP2
					),
			FALSE
			)
		);

	// init combobox in the menu bar
	if(	!m_ComboAskQuestion.Create(
			WS_CHILD|WS_VISIBLE
				|CBS_DROPDOWN|CBS_HASSTRINGS,
			CRect( 0, 0, 300, 100 ),
			&m_wndMenuBar,
			ID_COMBO_ASK_QUESTION
			)
		|| !m_wndMenuBar.SetButtonCtrl(
				m_wndMenuBar.CommandToIndex(ID_COMBO_ASK_QUESTION),
				&m_ComboAskQuestion
				)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_ComboAskQuestion.SetFont( &g_PaintManager->m_FontNormal );
	m_ComboAskQuestion.SetItemHeight(
		-1,
		m_ComboUiLook.GetItemHeight( -1 ) - 1
		);
	m_ComboAskQuestion.AddString( _T("\"ComboBox\" in menu bar") );
	m_ComboAskQuestion.SetCurSel( 0 );

	// init left toolbar buttons
	ASSERT( m_wndToolBarLeft.GetSafeHwnd() != NULL );

	VERIFY(
		m_wndToolBarLeft.InsertButton(
			-1,
			ID_COLOR_BTN_HEIGHT,
			FALSE
			)
		);

CMenu menuWidthCommands;
	VERIFY( menuWidthCommands.LoadMenu(IDR_MENU3) );
	VERIFY(
		m_wndToolBarLeft.SetButtonMenu(
			m_wndToolBarLeft.CommandToIndex(ID_COLOR_BTN_HEIGHT),
			menuWidthCommands.Detach(),
			TRUE,
			TRUE,
			FALSE
			)
		);
	VERIFY(
		m_wndToolBarLeft.InsertButton( -1, ID_SEPARATOR, FALSE )
		);

const int nLeftToolbarGrayscaleButtonsCount = 8;
const int nLeftToolbarColorButtonsCount = 18;

	for( int nGrayscaleBtn = 0; nGrayscaleBtn < nLeftToolbarGrayscaleButtonsCount; nGrayscaleBtn++ )
	{
		VERIFY(
			m_wndToolBarLeft.InsertSpecButton(
				-1,
				new
					CThinColorButtonInToolBar(
						CExtPaintManager::stat_HLStoRGB(
							0.0,
							double(nLeftToolbarGrayscaleButtonsCount - nGrayscaleBtn - 1)
								/ double(nLeftToolbarGrayscaleButtonsCount-1),
							0.0
							),
						&m_wndToolBarLeft
						),
				FALSE
				)
			);
	}
	VERIFY(
		m_wndToolBarLeft.InsertButton( -1, ID_SEPARATOR, FALSE )
		);
	for( int nColorBtn = 0; nColorBtn < nLeftToolbarColorButtonsCount; nColorBtn++ )
	{
		VERIFY(
			m_wndToolBarLeft.InsertSpecButton(
				-1,
				new
					CThinColorButtonInToolBar(
						CExtPaintManager::stat_HLStoRGB(
							double(nColorBtn) / double(nLeftToolbarColorButtonsCount),
							0.5,
							1.0
							),
						&m_wndToolBarLeft
						),
				FALSE
				)
			);
	}
	VERIFY(
		m_wndToolBarLeft.InitContentExpandButton()
		);

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, ID_APP_ABOUT /*IDM_ABOUTBOX*/, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

CMenu _menu;
	VERIFY(
		_menu.LoadMenu(IDR_MENU1)
		);
	m_btn2.m_menu.Attach(
		_menu.Detach()
		);
HICON hIconForBtn = (HICON)
		::LoadImage(
			::AfxGetInstanceHandle(),
			MAKEINTRESOURCE(IDR_MAINFRAME),
			IMAGE_ICON,
			16,
			16,
			0
			);
	ASSERT( hIconForBtn != NULL );
	m_btn2.SetIcon( hIconForBtn );

	AddAnchor( IDOK, __RDA_RT );
	AddAnchor( IDCANCEL, __RDA_RT );
	AddAnchor( IDC_COMBO_EDITABLE, __RDA_LT, __RDA_RT );
	AddAnchor( IDC_EDIT_SAMPLE, __RDA_LT, __RDA_RT );
	AddAnchor( IDC_STATIC_BEFORE_MENU, __RDA_LT, __RDA_RT );
	AddAnchor( IDC_COMBO_MENU_OPEN_EFFECT, __RDA_LB, __RDA_RB );
	AddAnchor( IDC_STATIC_BEFORE_MENU, __RDA_LB, __RDA_RB );
	AddAnchor( IDC_STATIC_GRP_BOX, __RDA_LB, __RDA_RB );
	AddAnchor( IDC_TAB1, __RDA_LT, __RDA_RB );
	AddAnchor( IDC_BUTTON_WITH_MENU, CSize(0,0), CSize(33,100) );
	AddAnchor( IDC_BUTTON_COLOR1, CSize(33,0), CSize(66,100) );
	AddAnchor( IDC_BUTTON_COLOR2, CSize(66,0), CSize(100,100) );
	
//	AddAnchor( IDC_CHECK_MENU_ANIM_EXPANDING, CSize(50,100) );
//	AddAnchor( IDC_CHECK_MENU_WITH_SHADOWS, CSize(50,100) );
	AddAnchor( IDC_CHECK_MENU_ANIM_EXPANDING, __RDA_LB, __RDA_RB );
	AddAnchor( IDC_CHECK_MENU_WITH_SHADOWS, __RDA_LB, __RDA_RB );

	AddAnchor( IDC_BUTTON_TAB_DEMO, __RDA_RT );
	
	m_MainTab.InsertItem( 0, _T("Normal") );
	m_MainTab.InsertItem( 1, _T("With image") );
	m_MainTab.InsertItem( 2, _T("White") );

#if (!defined __EXT_MFC_NO_TAB_CTRL)
	ASSERT( m_wndExtTabCtrl.GetSafeHwnd() != NULL );
	m_wndExtTabCtrl.ItemInsert( _T("Normal") );
	m_wndExtTabCtrl.ItemInsert( _T("With image") );
	m_wndExtTabCtrl.ItemInsert( _T("White") );
	m_wndExtTabCtrl.SelectionSet( 0 );
#endif // (!defined __EXT_MFC_NO_TAB_CTRL)

CRect rcWnd, rcMax;
	GetWindowRect( &rcWnd );
	GetDesktopWindow()->GetClientRect( &rcMax );
	SetMaxTrackSize( CSize(rcMax.Width(), rcWnd.Height()) );
	SetMaximizedRect( rcMax );

	EnableSaveRestore( _T("ExtResizableDialog"), _T("MainDlg") );

	m_ComboUiLook.SetCurSel( 0 );
	m_ComboMenuEffect.SetCurSel( (int)CExtPopupMenuWnd::__AT_FADE );
	m_CheckMenuWithShadows.SetCheck( 1 );
	m_CheckEnableContextMenu.SetCheck( 1 );
	m_CheckAnimateMenuWhenExpanding.SetCheck( CExtPopupMenuWnd::g_bMenuExpandAnimation ? 1 : 0 );
	m_bDialogInitComplete = true;

	PostMessage(WM_COMMAND,IDC_LOOK_2K);


	memset( &g_NotifyIconData, 0, sizeof(NOTIFYICONDATA) );
	g_NotifyIconData.cbSize = sizeof(NOTIFYICONDATA);
	g_NotifyIconData.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;

	g_NotifyIconData.hWnd   = GetSafeHwnd();
	g_NotifyIconData.uCallbackMessage = WM_ICON_NOTIFY;

	g_NotifyIconData.hIcon  = m_hIcon;
		
	// tooltip is 64-1 chars max
	_tcscpy(g_NotifyIconData.szTip,g_sFriendlyProgramName);

	CWnd::RepositionBars(0,0xFFFF,0);

	///SetMinTrackSize( CSize(10,10) );

	m_btnColor1.SetTooltipText( _T("Color Button With Text") );
	m_btnColor2.SetTooltipText( _T("Color Button") );
	m_btn2.SetTooltipText( _T("Button With Menu") );

	m_BtnTabDemo.SetTooltipText( _T("Show Tab Window Demo Dialog") );
	m_BtnTabDemo.SetBtnCursor( 32649 ); // magic IDC_HELP value
	m_BtnTabDemo.SetFlat();
	
	m_BtnOK.SetTooltipText( _T("\"OK\" Button") );
	m_BtnCancel.SetTooltipText( _T("\"Cancel\" Button") );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CExtResizableDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMainDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CExtResizableDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMainDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CAboutDlg::OnInitDialog() 
{
	CExtDlgBase::OnInitDialog();

	EnableResizing( false );
	EnableSaveRestore( _T("ExtResizableDialog"), _T("AboutDlg") );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CExtDlgBase::OnShowWindow(bShow, nStatus);
	
	if( !bShow )
		return;
	if( !m_bFirstShow )
		return;
	m_bFirstShow = false;
}

void CAboutDlg::OnOK() 
{
	CExtDlgBase::OnOK();
}

void CAboutDlg::OnCancel() 
{
	CExtDlgBase::OnCancel();
}

void CMainDlg::OnAppAbout() 
{
CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CMainDlg::ShowCtxMenu(CPoint ptScreen)
{
	if( m_menu.GetSafeHmenu() == NULL )
	{
		if( !m_menu.LoadMenu(IDR_MENU1) )
		{
			ASSERT( FALSE );
			return;
		}
	}
CExtPopupMenuWnd * pPopup = new CExtPopupMenuWnd;
	pPopup->SetLeftAreaWidth( 30 );
	pPopup->UpdateFromMenu(
		GetSafeHwnd(),
		&m_menu
		);

	pPopup->ItemInsert(); // separator
CExtPopupColorMenuWnd * pColorPopup = new CExtPopupColorMenuWnd;
	pPopup->ItemInsertSpecPopup( pColorPopup, -1, _T("Color popup") );
	pColorPopup->m_clrDefault = COLORREF(-1);
	pColorPopup->m_clrInitial = RGB(0,0,0);
	pPopup->ItemSetDisplayed(
		pPopup->ItemGetCount()-1,
		true
		);

	SetForegroundWindow();

	if( !pPopup->TrackPopupMenu(
			TPMX_OWNERDRAW_FIXED,
			ptScreen.x,
			ptScreen.y
			)
		)
		delete pPopup;
}

void CMainDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	pWnd;
	if( m_CheckEnableContextMenu.GetCheck() == 0 )
		return;
	ShowCtxMenu( point );
}

void CMainDlg::OnSelendokComboUiLook() 
{
	if( !m_bDialogInitComplete )
		return;
BOOL bCurStyleIsXP = 
		g_PaintManager->IsKindOf(
			RUNTIME_CLASS( CExtPaintManagerXP )
			);
int nCurSel = m_ComboUiLook.GetCurSel();
	if(nCurSel == 0)
	{
		if( !bCurStyleIsXP )
			return;
		VERIFY(
			g_PaintManager.InstallPaintManager(
				new CExtPaintManager
				)
			);
	}
	else
	{
		if( bCurStyleIsXP )
			return;
		VERIFY(
			g_PaintManager.InstallPaintManager(
				new CExtPaintManagerXP
				)
			);
	}
	RedrawWindow( NULL, NULL,
		RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASE|RDW_ERASENOW
			|RDW_ALLCHILDREN
		);
	UpdateDialogControls( this, FALSE );
}

void CMainDlg::OnCheckShowInTray() 
{
	m_bShowIconInTray = !m_bShowIconInTray;
	m_CheckShowIconInTray.SetCheck(
		m_bShowIconInTray ? 1 : 0
		);
/*
BOOL bShell_NotifyIconRetVal =
		Shell_NotifyIcon(NIM_ADD,&g_NotifyIconData);
	ASSERT( bShell_NotifyIconRetVal );
	if( !bShell_NotifyIconRetVal )
		return FALSE;
*/
	if( m_bShowIconInTray )
	{
		VERIFY(
			Shell_NotifyIcon(
				NIM_ADD,
				&g_NotifyIconData
				)
			);
	}
	else
	{
		VERIFY(
			Shell_NotifyIcon(
				NIM_DELETE,
				&g_NotifyIconData
				)
			);
	}
}
void CMainDlg::OnUpdateCheckShowInTray(CCmdUI* pCmdUI)
{
	pCmdUI->Enable();
	pCmdUI->SetCheck( m_bShowIconInTray ? TRUE : FALSE );
}

void CMainDlg::OnEnableDialogContextMenu() 
{
	m_bDialogWithCtxMenu = !m_bDialogWithCtxMenu;
	m_CheckEnableContextMenu.SetCheck(
		m_bDialogWithCtxMenu ? 1 : 0
		);
}
void CMainDlg::OnUpdateEnableDialogContextMenu(CCmdUI* pCmdUI)
{
	pCmdUI->Enable();
	pCmdUI->SetCheck( m_bDialogWithCtxMenu ? TRUE : FALSE );
}


void CMainDlg::OnLook2k() 
{
	m_ComboUiLook.SetCurSel(0);
	OnSelendokComboUiLook();
}
void CMainDlg::OnUpdateLook2k(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
INT nCurSel = m_ComboUiLook.GetCurSel();
	pCmdUI->SetRadio(
		( nCurSel == 0 ) ? TRUE : FALSE
		);
}

void CMainDlg::OnLookXp() 
{
	m_ComboUiLook.SetCurSel(1);
	OnSelendokComboUiLook();
}
void CMainDlg::OnUpdateLookXp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
INT nCurSel = m_ComboUiLook.GetCurSel();
	pCmdUI->SetRadio(
		( nCurSel != 0 ) ? TRUE : FALSE
		);
}

void CMainDlg::OnCheckMenuAnimExpanding() 
{
	CExtPopupMenuWnd::g_bMenuExpandAnimation =
		m_CheckAnimateMenuWhenExpanding.GetCheck() ?
			true : false;
}

void CMainDlg::OnSelendokComboMenuOpenEffect() 
{
	if( !m_bDialogInitComplete )
		return;
int nCurSel = m_ComboMenuEffect.GetCurSel();
	CExtPopupMenuWnd::g_DefAnimationType =
		(CExtPopupMenuWnd::e_animation_type_t)nCurSel;
}

void CMainDlg::OnCheckMenuWithShadows() 
{
	CExtPopupMenuWnd::g_bMenuWithShadows =
		m_CheckMenuWithShadows.GetCheck() ?
			true : false;
}

void CMainDlg::OnDestroy() 
{
	if( m_bShowIconInTray )
	{
		VERIFY(
			Shell_NotifyIcon(
				NIM_DELETE,
				&g_NotifyIconData
				)
			);
	}	

	VERIFY(
		g_CmdManager->ProfileWndRemove(
			GetSafeHwnd()
			)
		);

	CExtResizableDialog::OnDestroy();
}

void CMainDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR;
	*pResult = 0;
	
#if (!defined __EXT_MFC_NO_TAB_CTRL)
INT nCurSel = m_MainTab.GetCurSel();
	if( m_wndExtTabCtrl.SelectionGet() != nCurSel )
	{
		m_wndExtTabCtrl.SelectionSet(
			nCurSel,
			true,
			true
			);
		RedrawWindow();
	}
#else
		RedrawWindow();
#endif // else from (!defined __EXT_MFC_NO_TAB_CTRL)
}

void CMainDlg::OnShowTab() 
{
BOOL bShow = m_CheckShowTab.GetCheck() ? TRUE : FALSE;
	m_MainTab.ShowWindow( bShow );
}

void CMainDlg::OnUpdateButtonTabDemo(CCmdUI* pCmdUI)
{
#if (!defined __EXT_MFC_NO_TAB_CTRL)
	pCmdUI->Enable( TRUE );
#else
	pCmdUI->Enable( FALSE );
#endif // else from (!defined __EXT_MFC_NO_TAB_CTRL)
}

void CMainDlg::OnButtonTabDemo() 
{
#if (!defined __EXT_MFC_NO_TAB_CTRL)
CTabDemoDlg dlg( this );
	dlg.DoModal();
#endif // (!defined __EXT_MFC_NO_TAB_CTRL)
}

void CMainDlg::OnSize(UINT nType, int cx, int cy) 
{
	CExtResizableDialog::OnSize(nType, cx, cy);

	if( nType != SIZE_MINIMIZED )
		CWnd::RepositionBars(0,0xFFFF,0);
	
}

BOOL CMainDlg::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if(		nCode == CN_UPDATE_COMMAND_UI
		||	nCode == CN_COMMAND
		)
	{
		if( nID == ID_BITMAP_LABEL )
		{
			if( nCode == CN_UPDATE_COMMAND_UI )
			{
				CCmdUI * pCmdUI = (CCmdUI *)pExtra;
				ASSERT( pCmdUI != NULL );
				pCmdUI->Enable();
			}
			else
			{
static bool bMessageBoxWasDisplayed = false;
				if( !bMessageBoxWasDisplayed )
				{
					bMessageBoxWasDisplayed = true;
					::AfxMessageBox( _T("Bitmap label transparency has been changed") );
				}
			}
			return TRUE;
		}

		if( nID == ID_COMBO_ASK_QUESTION )
		{
			if( nCode == CN_UPDATE_COMMAND_UI )
			{
				CCmdUI * pCmdUI = (CCmdUI *)pExtra;
				ASSERT( pCmdUI != NULL );
				pCmdUI->Enable();
			}
			else
			{
				::AfxMessageBox( _T("\"ComboBox\" command in the menubar") );
			}
			return TRUE;
		}

		if( m_wndToolBarLeft.GetSafeHwnd() != NULL )
		{
			INT nBtnHeight = 0;
			switch( nID )
			{
			case ID_HEIGHT_8PX: nBtnHeight = 8; break;
			case ID_HEIGHT_10PX: nBtnHeight = 10; break;
			case ID_HEIGHT_12PX: nBtnHeight = 12; break;
			case ID_HEIGHT_14PX: nBtnHeight = 14; break;
			case ID_HEIGHT_16PX: nBtnHeight = 16; break;
			case ID_HEIGHT_18PX: nBtnHeight = 18; break;
			case ID_HEIGHT_20PX: nBtnHeight = 20; break;
			case ID_HEIGHT_22PX: nBtnHeight = 22; break;
			case ID_HEIGHT_24PX: nBtnHeight = 24; break;
			case ID_HEIGHT_26PX: nBtnHeight = 26; break;
			case ID_HEIGHT_28PX: nBtnHeight = 28; break;
			case ID_HEIGHT_30PX: nBtnHeight = 30; break;
			} // switch( nID )

			if( nBtnHeight != 0 )
			{
				if( nCode == CN_UPDATE_COMMAND_UI )
				{
					CCmdUI * pCmdUI = (CCmdUI *)pExtra;
					ASSERT( pCmdUI != NULL );
					pCmdUI->Enable();
					pCmdUI->SetRadio(
						(m_nThinColorBtnHeight == nBtnHeight) ? TRUE : FALSE
						);
				}
				else
				{
					if( m_nThinColorBtnHeight != nBtnHeight  )
					{
						m_nThinColorBtnHeight = nBtnHeight;
						CWnd::RepositionBars(0,0xFFFF,0);
						m_wndToolBarLeft.RedrawWindow();
					}
				}
				return TRUE;
			}

			INT nColorCmdIndex =
				m_wndToolBarLeft.CommandToIndex( nID );
			if( nColorCmdIndex >= 0 )
			{
				if( nCode == CN_UPDATE_COMMAND_UI )
				{
					CCmdUI * pCmdUI = (CCmdUI *)pExtra;
					ASSERT( pCmdUI != NULL );
					pCmdUI->Enable();
				}
				else
				{
					CWinApp * pApp = ::AfxGetApp();
					ASSERT( pApp != NULL );
					CExtCmdManager::cmd_t * p_cmd =
						g_CmdManager->CmdGetPtr(
							pApp->m_pszRegistryKey,
							nID
							);
					ASSERT( p_cmd != NULL );
					CString sMsg;
					sMsg.Format(
						_T("Command from the left toolbar:\n\n%s"),
						p_cmd->m_sMenuText
						);
					::AfxMessageBox( LPCTSTR(sMsg) );
				}
				return TRUE;
			}
		}
	}
	
	return CExtResizableDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

LRESULT CMainDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	
LRESULT lResult =
		CExtResizableDialog::WindowProc(message, wParam, lParam);

	if( message >= WM_CTLCOLORMSGBOX && message <= WM_CTLCOLORSTATIC )
	{
		switch( m_MainTab.GetCurSel() )
		{
		case 1:
		{
			HDC hDC =
				__EXT_GET_WM_CTLCOLOR_HDC(wParam,lParam,message);
			::SetBkMode( hDC, TRANSPARENT );
			static CBrush _brImage;
			if( _brImage.GetSafeHandle() != NULL )
				return (LRESULT)_brImage.GetSafeHandle();
			CBitmap bmp;
			VERIFY( bmp.LoadBitmap(IDB_BITMAP1) );
			VERIFY( _brImage.CreatePatternBrush(&bmp) );;
			return (LRESULT)_brImage.GetSafeHandle();
		} // if( m_MainTab.GetCurSel() == 1 )
		break;
		case 2:
		{
			HDC hDC =
				__EXT_GET_WM_CTLCOLOR_HDC(wParam,lParam,message);
			::SetBkMode( hDC, TRANSPARENT );
			return (LRESULT)::GetStockObject( WHITE_BRUSH );
		}
		break;
		} // switch( m_MainTab.GetCurSel() )
		return lResult;
	} // if( message >= WM_CTLCOLORMSGBOX && message <= WM_CTLCOLORSTATIC )

	return lResult;
}
