unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, HashTrie;

type
  TForm1 = class(TForm)
    Button2: TButton;
    Memo1: TMemo;
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    ht: TStringHashTrie;
  public
    procedure TraverseMeth(UserData: Pointer; const Value: string;
      Data: TObject; var Done: Boolean);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  MaxLevel, PeakCnt, FillCnt, EmptyCnt: integer;
  LenStat: TLenStat;

procedure TraverseProc(UserData: Pointer; const Value: string;
  Data: TObject; var Done: Boolean);
type
  PTextFile = ^TextFile;
begin
  writeln(PTextFile(UserData)^,Value);
end;

procedure TForm1.TraverseMeth(UserData: Pointer; const Value: string;
  Data: TObject; var Done: Boolean);
type
  PTextFile = ^TextFile;
begin
  writeln(PTextFile(UserData)^,Value);
end;

procedure TForm1.Button2Click(Sender: TObject);
var f: TextFile;
    S: string;
begin
  // traverse
  AssignFile(f,'dic.out');
  try
   Rewrite(f);
   //ht.Traverse(@f,TraverseProc);
   ht.Traverse(@f,TraverseMeth);
  finally
   CloseFile(f);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var f: TextFile;
    S: string;
    j,ipos: integer;
begin
  ht:=TStringHashTrie.Create;
  // fill test
  AssignFile(f,'dic.txt');
  try
   Reset(f);
   ipos:=0;
   while not Eof(f) do begin
     readln(f,S);
     ht.Add(S,Pointer(ipos));
     Inc(ipos);
   end;
  finally
   CloseFile(f);
  end;
  // count stats
  MaxLevel:=0; PeakCnt:=0; FillCnt:=0; EmptyCnt:=0;
  for j:=1 to BucketSize do LenStat[j]:=0;
  Stat(ht, MaxLevel, PeakCnt, FillCnt, EmptyCnt, LenStat);
  Memo1.Lines.Add('MaxLevel: '+IntToStr(MaxLevel));
  Memo1.Lines.Add('PeakCnt: '+IntToStr(PeakCnt));
  Memo1.Lines.Add('FillCnt: '+IntToStr(FillCnt));
  Memo1.Lines.Add('EmptyCnt: '+IntToStr(EmptyCnt));
  for j:=1 to BucketSize do
    Memo1.Lines.Add('Count of Buckets with len='+IntToStr(j)+': '+IntToStr(LenStat[j]));
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ht.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
var Data: TObject;
begin
  if ht.Find(Edit1.Text,Data) then
    Memo1.Lines.Add('String "'+Edit1.Text+'" found. Line No. '+IntToStr(integer(Data)))
  else
    Memo1.Lines.Add('String "'+Edit1.Text+'" not found.')
end;

end.
