//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description:  Parsing SWF file
//  Last date update:  21 dec 2004

unit UWinParse;

interface

uses Windows, Classes, Graphics, Forms, Controls, StdCtrls, ExtCtrls,
  ComCtrls, SWFStreams, SWFConst, Grids, ValEdit, RVScroll, RichView,
  RVStyle, VirtualTrees, Buttons, OleCtrls, ShockwaveFlashObjects_TLB,
  ShockwaveEx;

type
  TMDIChild = class(TForm)
    Pages: TPageControl;
    Tab1: TTabSheet;
    Label2: TLabel;
    Label5: TLabel;
    Label3: TLabel;
    Label1: TLabel;
    L1: TLabel;
    LInfo: TLabel;
    CBCompress: TCheckBox;
    EFPS: TEdit;
    EYMax: TEdit;
    EYMin: TEdit;
    EXMax: TEdit;
    EXMin: TEdit;
    Tab2: TTabSheet;
    TreeParams: TVirtualStringTree;
    Bevel1: TBevel;
    Player: TShockwaveFlashEx;
    bPlay: TSpeedButton;
    bStop: TSpeedButton;
    PImage: TPanel;
    SplitImage: TSplitter;
    Image: TImage;
    Splitter1: TSplitter;
    VTree: TVirtualStringTree;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure VTreeGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure VTreeChange(Sender: TBaseVirtualTree; Node: PVirtualNode);
    procedure FormCreate(Sender: TObject);
    procedure VTreeBeforeCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellRect: TRect);
    procedure bPlayClick(Sender: TObject);
    procedure bStopClick(Sender: TObject);
    procedure Tab1Resize(Sender: TObject);
    procedure TreeParamsGetText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
  private
    { Private declarations }
  public
    SwfName: string;
    isModif: boolean;
    SWF: TSWFStreamReader;
    ParseAction: boolean;
    Procedure LoadSWF(fn: string);
    procedure bDelClick;
    procedure bActionSaveClick;
    procedure SaveSound;
    Procedure SaveSelTag(fn:string; AsText: boolean);
    procedure SaveImage(fn: string);
  end;

implementation
{$R *.dfm}

Uses SysUtils, SWFTools, SWFObjects, math, SoundReader,
     SWFStrings, Contnrs, AtoPas, MAIN, JPEG, ZLib;

Type
  TMyRecNode = record
    Check: boolean;
    ImageIndex: Integer;
    TagInfo: Pointer;
  end;
  PMyRecNode = ^TMyRecNode;

  TRecParamNode = record
    Key, Value: string;
  end;
  PRecParamNode = ^TRecParamNode;

const
 PushTypes : array [0..9] of pChar = ('string literal', 'floating-point literal', 'null',
   'undefined', 'register', 'boolean', 'double', 'integer', 'constant 8', 'constant 16');

procedure TMDIChild.FormCreate(Sender: TObject);
  var L: LongInt;
begin
 VTree.NodeDataSize := SizeOf(TMyRecNode);
 TreeParams.NodeDataSize := SizeOf(TRecParamNode);
{ L := GetWindowLong(EFPS.Handle, GWL_EXSTYLE);
 L := L or WS_EX_TRANSPARENT;
 SetWindowLong(EFPS.Handle, GWL_EXSTYLE, L); }
end;

procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

Procedure TMDIChild.LoadSWF(fn: string);
 var MN: tTreeNode;
     il, il2, il3: word;
     STag: TSWFTagInfo;
     Node, Node2: PVirtualNode;
 var L: LongInt;
begin
  SwfName := fn;

  SWF:=TSWFStreamReader.Create(fn);

  LInfo.Caption:=Format('Ver: %d   Size: %d bytes   Frames count: %d',[SWF.Version, SWF.SWFHeader.FileSize, SWF.SWFHeader.FramesCount]);

  With SWF.MovieRect do
   begin
    EXMin.Text:= IntToStr(Left);
    EXMax.Text:= IntToStr(Right);
    EYMin.Text:= IntToStr(Top);
    EYMax.Text:= IntToStr(Bottom);
   end;
  EFPS.Text:=FloatToStr(SWF.FPS);
  CBCompress.Checked := SWF.Compressed;
  SWF.ReadBody(true, ParseAction);

  for il:=0 to SWF.TagList.count - 1 do
    begin
     Node := VTree.AddChild(nil);
     PMyRecNode(VTree.GetNodeData(Node))^.TagInfo :=  SWF.TagList.Items[il];
     if il < (SWF.TagList.count - 1) then
       begin
        Node.CheckType := ctCheckBox;
        VTree.CheckState[Node] := csUncheckedNormal;
        if TSWFTagInfo(SWF.TagList.Items[il]).TagID = tagDefineSprite then
         with TSWFTagInfo(SWF.TagList.Items[il]) do
          for il2 := 0 to SubTags.Count - 1 do
            begin
              Node2 := VTree.AddChild(Node);
              PMyRecNode(VTree.GetNodeData(Node2))^.TagInfo := SubTags.Items[il2];
            end;
       end;
   end;
//  VTree.RootNodeCount := SWF.TagList.count;

   Player.Movie := fn;
end;

procedure TMDIChild.FormDestroy(Sender: TObject);
 var TN: tTreeNode;
begin

 SWF.Free;
end;

Function SoundCompression(id: byte):string;
begin
 case id of
  0: Result := 'PCM';
  1: Result := 'ADPCM';
  2: Result := 'MP3';
  3: Result := 'uncompressed little-endian';
  6: Result := 'Nellymoser';
 end;
end;

Function SoundRate(id:byte): string;
begin
 case id of
  0: Result :='5.5 kHz';
  1: Result :='11 kHz';
  2: Result :='22 kHz';
  3: Result :='44 kHz';
 end;
end;


Function GetFillStyleName(FT: TSWFFillType):string;
begin
  Case FT of
    SWFFillSolid: Result := 'SWFFillSolid';
    SWFFillLinearGradient: Result := 'SWFFillLinearGradient';
    SWFFillRadialGradient: Result := 'SWFFillRadialGradient';
    SWFFillTileBitmap: Result := 'SWFFillTileBitmap';
    SWFFillClipBitmap: Result := 'SWFFillClipBitmap';
    SWFFillNonSmoothTileBitmap: Result := 'SWFFillNonSmoothTileBitmap';
    SWFFillNonSmoothClipBitmap: Result := 'SWFFillNonSmoothClipBitmap';
  end;
end;

Function GetNameBMFormat(b: byte): string;
begin
  case b of
    BMP_8bit: Result := '8 bit';
    BMP_15bit: Result := '15 bit';
    BMP_24bit: Result := '24 bit';
  end;
end;

procedure TMDIChild.VTreeGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);

  var Tag: TSWFTagInfo;
      SWFObj: TSWFObject;
begin
  Tag := TSWFTagInfo(PMyRecNode(VTree.GetNodeData(Node))^.TagInfo);
  case Column of
   0: CellText := GetTagName(Tag.TagID);
   1: CellText := IntToStr(Tag.BodySize);
   2: if VTree.NodeParent[Node] = nil then CellText := IntToStr(Node.Index)
      else CellText := Format('%d.%d',[Node.Parent.Index, Node.Index]);
   3: if Tag.TagID <> tagEnd then  CellText := IntToStr(Tag.FramePlace);
  end;
end;

// Warning! MakeBMPFromTag does not work correctly with colors yet
Procedure MakeBMPFromTag(Dest:TBitmap; Lossles: TSWFDefineBitsLossless; Ex: boolean);
 var datawidth, il: word;
     MS: TMemoryStream;
     P: Pointer;
     DecS: TDeCompressionStream;
     DecSize, PSize: longint;
     bpp, alpha: byte;
     LP: TMaxLogPalette;
     PE: TPaletteEntry;
     TranspInd : integer;
     PB: pByte;
begin

  DecompressBuf(Lossles.Data, Lossles.DataSize, 0, P, PSize);
  MS := TMemoryStream.Create;
  MS.Write(P^, PSize);
  MS.Position := 0;
  FreeMem(P, PSize);
  pB := MS.Memory;

  case Lossles.BitmapFormat of
    BMP_8bit:
      begin
       Dest.PixelFormat := pf8bit;
       bpp := 1;
       LP.palVersion := $300;
       LP.palNumEntries := Lossles.BitmapColorTableSize + 1;
       TranspInd := -1;
       PE.peFlags := 0;
       For il := 0 to Lossles.BitmapColorTableSize do
        begin
          MS.Read(PE.peRed, 1);
          MS.Read(PE.peGreen, 1);
          MS.Read(PE.peBlue, 1);
          inc(PB, 3);
          if Ex then
            begin
              MS.Read(alpha, 1);
              if alpha = 0 then TranspInd := il;
              inc(PB);
            end;
        end;
        Dest.Palette := CreatePalette(PLogPalette(@LP)^);
        if Ex and (TranspInd > -1) then
           begin
            Dest.Transparent := true;
            Dest.TransparentMode := tmFixed;
            with LP.palPalEntry[TranspInd] do
              Dest.TransparentColor := RGB(peRed, peGreen, peBlue);
           end;
      end;
    BMP_15bit:
      begin
        Dest.PixelFormat := pf16bit;
        bpp := 2;
      end;
    BMP_24bit:
      begin
       bpp := 4;
       if Ex then Dest.PixelFormat := pf32bit
                     else Dest.PixelFormat := pf24bit;
      end;
  end;

  Dest.Width := Lossles.BitmapWidth;
  Dest.Height := Lossles.BitmapHeight;

  datawidth := (MS.Size - MS.Position) div (Lossles.BitmapHeight * bpp);
  For il := 0 to Lossles.BitmapHeight - 1 do
    begin
      Move(PB^, Dest.ScanLine[il]^, Lossles.BitmapWidth * bpp);
      inc(PB, datawidth * bpp);
    end;

  MS.Free;
end;

Const
 Abool : array [false..true] of pchar = ('false', 'true');

procedure TMDIChild.VTreeChange(Sender: TBaseVirtualTree; Node: PVirtualNode);
 var STag: TSWFTagInfo;
     {W,} checksum: Word;
     b: byte;
     le, isMp3Stream: boolean;
     il, il2, il3:integer;
     ACH: Array [0..255] of char;
     SL:tStringList;
     _4b: array [0..4] of byte;
     BitsEnginie : TBitsEngine;
     stt: string;
     LastConstPool: TStringList;
     LO: TObjectList;
     NodeRoot, Node1, Node2, Node3: PVirtualNode;
     WCh: WideChar;
     MS: TMemoryStream;
     JPG: TJPEGImage;
     BMP: TBitMap;

 Procedure ShowSection(s: string; root: PVirtualNode = nil);
 begin
   NodeRoot := TreeParams.AddChild(root, nil);
   PRecParamNode(TreeParams.GetNodeData(NodeRoot))^.Key := s;
 end;

 Function ShowParam(k, s: string): PVirtualNode; overload;
 begin
   Result := TreeParams.AddChild(NodeRoot, nil);
   With PRecParamNode(TreeParams.GetNodeData(Result))^ do
    begin
      Key := k;
      value := s;
    end;
 end;

 Function ShowParam(k: string; w: word): PVirtualNode; overload;
 begin
   Result := ShowParam(k, intToStr(w));
 end;

 Procedure AddMatrix(RM: TSWFMatrix; root: PVirtualNode = nil);
 begin
   ShowSection('Matrix', root);
   ShowParam('Translate X', Format('%d (%3.2f)', [RM.TranslateX, RM.TranslateX / twips]));
   ShowParam('Translate Y', Format('%d (%3.2f)', [RM.TranslateY, RM.TranslateY / twips]));

   if RM.hasScale then
     begin
       ShowParam('Scale X', Format('%2.2f',[RM.ScaleX]));
       ShowParam('Scale Y', Format('%2.2f',[RM.ScaleY]));
     end;

   if RM.hasSkew then
     begin
       ShowParam('Skew X', Format('%2.2f',[RM.SkewX]));
       ShowParam('Skew Y', Format('%2.2f',[RM.SkewY]));
     end;

 end;

 Procedure AddColor(C: recRGBA; a: boolean; cap: string; rn: PVirtualNode = nil);
 begin
   ShowSection(Cap, rn);
   ShowParam('R', IntToStr(C.R));
   ShowParam('G', IntToStr(C.G));
   ShowParam('B', IntToStr(C.B));
   if a then ShowParam('A', IntToStr(C.A));
 end;

 Procedure AddTransformColor(CT: recColorTransform; rn: PVirtualNode = nil);
 begin
   if CT.hasAdd or CT.hasMULT then
     begin
      ShowSection('COLORTRANSFORM', rn);
      if CT.hasAdd then
       begin
         ShowParam('Add R',IntToStr(CT.addR));
         ShowParam('Add G',IntToStr(CT.addG));
         ShowParam('Add B',IntToStr(CT.addB));
         if CT.hasAlpha then
          begin
           ShowParam('Add A',IntToStr(CT.addA));
          end;
       end;

      if CT.hasMULT then
       begin
         ShowParam('Mult R',IntToStr(CT.multR));
         ShowParam('Mult G',IntToStr(CT.multG));
         ShowParam('Mult B',IntToStr(CT.multB));
         if CT.hasAlpha then
          begin
           ShowParam('Mult A',IntToStr(CT.multA));
          end;
       end;
     end;
 end;

 Procedure AddRect(R: TRect; name: string = 'RECT');
 begin
   ShowSection(name);
   ShowParam('Left', Format('%d (%d)', [R.left, R.Left div twips]));
   ShowParam('Top', Format('%d (%d)', [R.top, R.top div twips]));
   ShowParam('Right', Format('%d (%d)', [R.Right, R.Right div twips]));
   ShowParam('Bottom', Format('%d (%d)', [R.Bottom, R.Bottom div twips]));
 end;

 procedure ShowStartSound(SS: TSWFStartSound);
  var il:integer;
 begin
  With SS do
   begin
    ShowParam('SoundId', IntToStr(SoundId));
    ShowParam('SyncNoMultiple', ABool[SyncNoMultiple]);
    ShowParam('SyncStop', ABool[SyncStop]);
    ShowParam('HasLoops', ABool[HasLoops]);
    if HasLoops then ShowParam('LoopCount', LoopCount);
    if HasInPoint then ShowParam('InPoint', IntToStr(InPoint));
    if HasOutPoint then ShowParam('OutPoint', IntToStr(OutPoint));
    if HasEnvelope then
     begin
      ShowSection('Envelopes', NodeRoot);
      ShowParam('OutPoint', IntToStr(SoundEnvelopes.Count));
      if SoundEnvelopes.Count > 0 then
        for il := 0 to SoundEnvelopes.Count - 1 do
         With TSWFSoundEnvelope(SoundEnvelopes[il]) do
          begin
            ShowParam('Pos44', IntToStr(Pos44));
            ShowParam('LeftLevel', LeftLevel);
            ShowParam('RightLevel', RightLevel);
          end;
     end;
   end;
 end;

 Procedure ParseString (len: integer);
  var il1, il2:integer;
      st: string;
 begin
  il2:=0;
  SL.Clear;
  st:='';
  For il1:=0 to len do
   if ACH[il1]=#0 then
   begin
    if il2<il1 then
     begin
      SL.Add(st);
     end;
    il2:=il1+1;
    St:='';
   end else st:=st+ACH[il1];
 end;

 Procedure ReadACTIONRECORD(rn: PVirtualNode; AList: TSWFActionList);
  var AC, b: byte;
      L, fP: dWord;
      ARCount: word;
      stt: string;
      il1, il2:longint;
      Act: TSWFAction;
 begin

 if AList.Count > 0 then
   For il1 := 0 to AList.Count - 1 do
     begin
       Act := AList[il1];
       ShowSection(GetActionName(Act.ActionCode), rn);
       case Act.ActionCode of
        ActionByteCode:
          With TSWFActionByteCode(Act) do
           ShowParam('bytecode', StrByteCode);

        ActionGotoFrame:
          With TSWFActionGotoFrame(Act) do
           ShowParam('Frame', Frame);

        ActionGetUrl:
          With TSWFActionGetUrl(Act) do
            begin
              ShowParam('Target', Target);
              ShowParam('URL', URL);
            end;


        ActionWaitForFrame:
         With TSWFActionWaitForFrame(Act) do
           begin
              ShowParam('Frame', Frame);
              ShowParam('SkipCount', SkipCount);
           end;

        ActionSetTarget:
          With TSWFActionSetTarget(Act) do
           ShowParam('TargetName', TargetName);

        ActionGoToLabel:
         With TSWFActionGoToLabel(Act) do
           ShowParam('FrameLabel', FrameLabel);

        ActionPush:
         With TSWFActionPush(Act) do
          for il2:=0 to ValueCount - 1 do
           begin
             stt := Value[il2];
             if (ValueInfo[il2].ValueType in [vtConstant8, vtConstant16]) and (LastConstPool<>nil) then
               stt := stt + ' (' +  LastConstPool[Value[il2]] +')';
             ShowParam(stt, PushTypes[byte(ValueInfo[il2].ValueType)]);
           end;

        actionJump, actionIf:
          With TSWFActionJump(Act) do
            begin
              ShowParam('GoTo:', BranchOffsetMarker.MarkerName);
            end;

        ActionGetURL2:
          With TSWFActionGetUrl2(Act) do
            begin
              ShowParam('Send Method', SendVarsMethod);
              ShowParam('LoadTargetFlag', ABool[LoadTargetFlag]);
              ShowParam('LoadVariablesFlag', ABool[LoadVariablesFlag]);
            end;

        ActionGotoFrame2:
          with TSWFActionGotoFrame2(Act) do
            begin
              ShowParam('PlayFlag', ABool[PlayFlag]);
              if SceneBiasFlag then ShowParam('SceneBias', SceneBias);
            end;

        ActionConstantPool:
         With TSWFActionConstantPool(Act) do
          begin
            LastConstPool := ConstantPool;
            For il2:=0 to ConstantPool.Count - 1 do
             ShowParam(IntToStr(il2), ConstantPool[il2]);
          end;

        ActionDefineFunction:
          With TSWFActionDefineFunction(Act) do
           begin
            ShowParam('FunctionName', FunctionName);
            For il2:=0 to Params.Count - 1 do
              ShowParam(IntToStr(il2), Params[il2]);
            ShowParam('DO:', CodeSizeMarker.MarkerName);
           end;

        ActionStoreRegister:
          With TSWFActionStoreRegister(Act) do
            ShowParam('RegisterNumber', RegisterNumber);

        ActionDefineFunction2:
          With TSWFActionDefineFunction2(Act) do
           begin
            ShowParam('FunctionName', FunctionName);
            For il2:=0 to Parameters.Count - 1 do
              ShowParam(IntToStr(il2), Parameters[il2]);
            ShowParam('RegisterCount', RegisterCount);
            ShowParam('PreloadArgumentsFlag', ABool[PreloadArgumentsFlag]);
            ShowParam('PreloadGlobalFlag', ABool[PreloadGlobalFlag]);
            ShowParam('PreloadParentFlag', ABool[PreloadParentFlag]);
            ShowParam('PreloadRootFlag', ABool[PreloadRootFlag]);
            ShowParam('PreloadSuperFlag', ABool[PreloadSuperFlag]);
            ShowParam('PreloadThisFlag', ABool[PreloadThisFlag]);

            ShowParam('SuppressArgumentsFlag', ABool[SuppressArgumentsFlag]);
            ShowParam('SuppressSuperFlag', ABool[SuppressSuperFlag]);
            ShowParam('SuppressThisFlag', ABool[SuppressThisFlag]);
            ShowParam('DO:', CodeSizeMarker.MarkerName);
           end;


        actionTry:
          With TSWFactionTry(Act) do
            begin
              ShowParam('CatchInRegisterFlag', ABool[CatchInRegisterFlag]);
              ShowParam('CatchBlockFlag', ABool[CatchBlockFlag]);
              ShowParam('FinallyBlockFlag', ABool[FinallyBlockFlag]);
              ShowParam('Try DO:', TrySizeMarker.MarkerName);
              if CatchBlockFlag then
                ShowParam('Catch DO:', CatchSizeMarker.MarkerName);
              if FinallyBlockFlag then
                ShowParam('Finally DO:', FinallySizeMarker.MarkerName);
            end;

        ActionOffsetWork:
          With TSWFOffsetMarker(Act) do
            ShowParam('Label', MarkerName);
       end;

     end;
 end;

begin
  if not Sender.Selected[Node] then exit;
  NodeRoot := nil;

  TreeParams.Clear;

    SL:=tStringList.Create;
    STag:=TSWFTagInfo(PMyRecNode(VTree.GetNodeData(Node))^.TagInfo);
    Player.Stop;
    Player.GotoFrame(STag.FramePlace - 1);
    SWF.BodyStream.Position := STag.Position + STag.GetFullSize;
    BitsEnginie := TBitsEngine.Create(SWF.BodyStream);
    Case STag.TagID of
     tagErrorTag:
      with TSWFErrorTag(STag.SWFObject) do
       begin
        ShowParam('ID', GetTagName(TagIDFrom));
        ShowParam('Text', Text);
       end;
// Display List
     tagPlaceObject:
      with TSWFPlaceObject(STag.SWFObject) do
       begin
        ShowParam('CharacterID', IntToStr(CharacterID));
        ShowParam('Depth', IntToStr(Depth));

        AddMatrix(Matrix);
       end;

     tagPlaceObject2:
      with TSWFPlaceObject2(STag.SWFObject) do
       begin

        if PlaceFlagHasClipActions then ShowParam('PlaceFlagHasClipActions', ABool[PlaceFlagHasClipActions]);
        if PlaceFlagHasName then ShowParam('PlaceFlagHasName', ABool[PlaceFlagHasName]);
        if PlaceFlagHasRatio then ShowParam('PlaceFlagHasRatio', ABool[PlaceFlagHasRatio]);
        if PlaceFlagHasColorTransform then ShowParam('PlaceFlagHasColorTransform', ABool[PlaceFlagHasColorTransform]);
        if PlaceFlagHasMatrix then ShowParam('PlaceFlagHasMatrix', ABool[PlaceFlagHasMatrix]);
        if PlaceFlagHasCharacter then ShowParam('PlaceFlagHasCharacter', ABool[PlaceFlagHasCharacter]);
        if PlaceFlagMove then ShowParam('PlaceFlagMove', ABool[PlaceFlagMove]);

        ShowParam('Depth', Depth);

        if PlaceFlagHasCharacter then ShowParam('CharacterId', CharacterId);
        if PlaceFlagHasRatio then ShowParam('Ratio', Ratio);
        if PlaceFlagHasName then ShowParam('Name', Name);
        if PlaceFlagHasClipDepth then ShowParam('ClipDepth', ClipDepth);

        if PlaceFlagHasMatrix then AddMatrix(Matrix);
        if PlaceFlagHasColorTransform then AddTransformColor(ColorTransform.REC);

        if PlaceFlagHasClipActions then
          begin
            ShowSection('ClipActions');
            Node1 := NodeRoot;
            for il := 0 to ClipActions.ActionRecords.Count -1 do
             with TSWFClipActionRecord(ClipActions.ActionRecords[il]) do
              begin
                NodeRoot := Node1;
                NodeRoot := ShowParam(GetClipEventFlagsName(EventFlags), IntToStr(il));
                ReadACTIONRECORD(NodeRoot, Actions);
              end;
          end;
       end;

     tagRemoveObject:
      with TSWFRemoveObject(STag.SWFObject) do
       begin
         ShowParam('CharacterID', IntToStr(CharacterID));
         ShowParam('Depth', IntToStr(Depth));
       end;

     tagRemoveObject2:
      with TSWFRemoveObject2(STag.SWFObject) do
         ShowParam('Depth', IntToStr(Depth));

     tagShowFrame:
         ShowSection('without parameters');


// Control Tags
     tagSetBackgroundColor:
       AddColor(SWFRGBA(TSWFSetBackgroundColor(STag.SWFObject).color.RGB), false, 'Color');

     tagFrameLabel:
      with TSWFFrameLabel(STag.SWFObject) do
        ShowParam('Name', Name);

     tagProtect,
     tagEnableDebugger,
     tagEnableDebugger2:
        with TSWFProtect(STag.SWFObject) do
          ShowParam('Hash', Hash);

     tagEnd:
        ShowSection('without parameters');

     tagExportAssets,
     tagImportAssets:
       With TSWFExportAssets(STag.SWFObject) do
        for il:=0 to Assets.count - 1 do
         ShowParam(Assets[il], LongInt(Assets.Objects[il]));
   //  tagEnableDebugger
   //  tagEnableDebugger2

     tagScriptLimits:
       with TSWFScriptLimits(STag.SWFObject) do
        begin
         ShowParam('MaxRecursionDepth', MaxRecursionDepth);
         ShowParam('ScriptTimeoutSeconds', ScriptTimeoutSeconds);
        end;

     tagSetTabIndex:
       With TSWFSetTabIndex(STag.SWFObject) do
         begin
         ShowParam('Depth', Depth);
         ShowParam('TabIndex', TabIndex);
         end;
//Actions
     tagDoAction:
        readACTIONRECORD(nil, TSWFDoAction(STag.SWFObject).Actions);

     tagDoInitAction:
       With TSWFDoInitAction(STag.SWFObject) do
         begin
           ShowParam('SpriteID', SpriteID);
           readACTIONRECORD(nil, TSWFDoAction(STag.SWFObject).Actions);
         end;

// Shapes
     tagDefineShape, tagDefineShape2, tagDefineShape3:
       With TSWFDefineShape(STag.SWFObject) do
        begin
          ShowParam('ShapeId', ShapeId);
          AddRect(ShapeBounds.Rect, 'ShapeBounds');
          if FillStyles.Count > 0 then
           begin
             ShowSection('Fill styles');
             Node1 := NodeRoot;
             for il:=0 to FillStyles.Count - 1 do
              With TSWFFillStyle(FillStyles[il]) do
              begin
                ShowSection(GetFillStyleName(SWFFillType) + '  ('+IntToStr(il + 1)+')', Node1);
                Node2 := NodeRoot;
                case SWFFillType of
                  SWFFillSolid:
                    with TSWFColorFill(FillStyles[il]) do
                      AddColor(Color.RGBA, hasAlpha, 'Color', Node2);
                  SWFFillLinearGradient, SWFFillRadialGradient:
                    with TSWFGradientFill(FillStyles[il]) do
                      begin
                        AddMatrix(Matrix, Node2);
                        for il2:=1 to Count do
                          begin
                            NodeRoot := Node2;
                            ShowParam('Ratio ' + IntToStr(il2), Gradient[il2].ratio);
                            AddColor(Gradient[il2].color, hasAlpha, 'Gradient color ' + IntToStr(il2), Node2);
                          end;
                      end;
                  SWFFillTileBitmap, SWFFillClipBitmap,
                  SWFFillNonSmoothTileBitmap, SWFFillNonSmoothClipBitmap:
                    with TSWFImageFill(FillStyles[il]) do
                      begin
                       NodeRoot := Node2;
                       ShowParam('ImageID', ImageID);
                       AddMatrix(Matrix, Node2);
                      end;
                end;
              end;
           end;
          if LineStyles.Count > 0 then
           begin
             ShowSection('Line styles');
             Node1 := NodeRoot;
             For il := 0 to LineStyles.Count - 1 do
              With TSWFLineStyle(LineStyles[il]) do
                begin
                  ShowSection('Style ' + IntToStr(il + 1), Node1);
                  ShowParam('Width', Width);
                  AddColor(Color.RGBA, hasAlpha, 'Color', NodeRoot);
                end;
           end;

          ShowSection('Edges');
          Node1 := NodeRoot;
          for il:=0 to Edges.Count - 1 do
           case TSWFShapeRecord(Edges[il]).ShapeRecType of
            EndShapeRecord:
              begin
                NodeRoot := Node1;
                ShowParam('End', '-----');
              end;
            StyleChangeRecord:
              with TSWFStyleChangeRecord(Edges[il]) do
              begin
                ShowSection('StyleChange', Node1);
                ShowParam('StateFillStyle0', Abool[StateFillStyle0]);
                ShowParam('StateFillStyle1', Abool[StateFillStyle1]);
                ShowParam('StateLineStyle', Abool[StateLineStyle]);
                ShowParam('StateMoveTo', Abool[StateMoveTo]);
                ShowParam('StateNewStyles', Abool[StateNewStyles]);

                if StateMoveTo then
                 begin
                  ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                  ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                 end;
                if StateFillStyle0 then ShowParam('Fill0Id', Fill0Id);
                if StateFillStyle1 then ShowParam('Fill1Id', Fill1Id);
                if StateLineStyle then ShowParam('LineId', LineId);
                if StateNewStyles then
                  begin
                   if FillStyles.Count > 0 then
                   begin

                     ShowSection('New fill styles', Node1);
                     Node3 := NodeRoot;
                     NodeRoot := Node1;
                     for il3:=0 to NewFillStyles.Count - 1 do
                      With TSWFFillStyle(NewFillStyles[il3]) do
                      begin
                        ShowSection(GetFillStyleName(SWFFillType) + '  ('+IntToStr(il3 + 1)+')', Node1);
                        Node2 := NodeRoot;
                        case SWFFillType of
                          SWFFillSolid:
                            with TSWFColorFill(NewFillStyles[il3]) do
                              AddColor(Color.RGBA, hasAlpha, 'Color', Node2);
                          SWFFillLinearGradient, SWFFillRadialGradient:
                            with TSWFGradientFill(NewFillStyles[il3]) do
                              begin
                                AddMatrix(Matrix, Node2);
                                for il2:=1 to Count do
                                  begin
                                    NodeRoot := Node2;
                                    ShowParam('Ratio ' + IntToStr(il2), Gradient[il2].ratio);
                                    AddColor(Gradient[il2].color, hasAlpha, 'Gradient color ' + IntToStr(il2), Node2);
                                  end;
                              end;
                          SWFFillTileBitmap, SWFFillClipBitmap,
                          SWFFillNonSmoothTileBitmap, SWFFillNonSmoothClipBitmap:
                            with TSWFImageFill(NewFillStyles[il3]) do
                              begin
                               NodeRoot := Node2;
                               ShowParam('ImageID', ImageID);
                               AddMatrix(Matrix, Node2);
                              end;
                        end;
                      end;
                     NodeRoot := Node3; 
                   end;
                  if NewLineStyles.Count > 0 then
                   begin
                     Node3 := NodeRoot.Parent;
                     ShowSection('New line styles', NodeRoot);
//                     NodeRoot := Node1;

                     Node2 := NodeRoot;
                     For il3 := 0 to NewLineStyles.Count - 1 do
                      With TSWFLineStyle(NewLineStyles[il3]) do
                        begin
                          ShowSection('Style ' + IntToStr(il3 + 1), Node2);
                          ShowParam('Width', Width);
                          AddColor(Color.RGBA, hasAlpha, 'Color', NodeRoot);
                        end;
                     NodeRoot := Node3;   
                   end;

                  end;
              end;
            StraightEdgeRecord:
              with TSWFStraightEdgeRecord(Edges[il]) do
              begin
                ShowSection('LineDelta', Node1);
                ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
              end;
            CurvedEdgeRecord:
              with TSWFCurvedEdgeRecord(Edges[il]) do
              begin
                ShowSection('CurveDelta', Node1);
                ShowParam('ControlX', Format('%d (%2.2f)', [ControlX, ControlX / twips]));
                ShowParam('ControlY', Format('%d (%2.2f)', [ControlY, ControlY / twips]));
                ShowParam('Anchor X', Format('%d (%2.2f)', [AnchorX, AnchorX / twips]));
                ShowParam('Anchor Y', Format('%d (%2.2f)', [AnchorY, AnchorY / twips]));
              end;
           end;
        end;

     tagDefineMorphShape:
       With TSWFDefineMorphShape(STag.SWFObject) do
        begin
          ShowParam('CharacterId', CharacterId);
          AddRect(StartBounds.Rect, 'Start Bounds');
          AddRect(EndBounds.Rect, 'End Bounds');
          if MorphFillStyles.Count > 0 then
           begin
             ShowSection('Fill styles');
             Node1 := NodeRoot;
             for il:=0 to MorphFillStyles.Count - 1 do
              With TSWFMorphFillStyle(MorphFillStyles[il]) do
              begin
                ShowSection(GetFillStyleName(SWFFillType) + '  ('+IntToStr(il + 1)+')', Node1);
                Node2 := NodeRoot;
                case SWFFillType of
                  SWFFillSolid:
                    with TSWFMorphColorFill(MorphFillStyles[il]) do
                      begin
                       AddColor(StartColor.RGBA, true, 'Start Color', Node2);
                       AddColor(EndColor.RGBA, true, 'End Color', Node2);
                      end;
                  SWFFillLinearGradient, SWFFillRadialGradient:
                    with TSWFMorphGradientFill(MorphFillStyles[il]) do
                      begin
                        AddMatrix(StartMatrix, Node2);
                        AddMatrix(EndMatrix, Node2);
                        for il2:=1 to Count do
                          begin
                            NodeRoot := Node2;
                            ShowParam('Start Ratio ' + IntToStr(il2), StartRatio[il2]);
                            ShowParam('End Ratio ' + IntToStr(il2), EndRatio[il2]);
                            AddColor(StartColor[il2].RGBA, true, 'Start color ' + IntToStr(il2), Node2);
                            AddColor(EndColor[il2].RGBA, true, 'End color ' + IntToStr(il2), Node2);
                          end;
                      end;
                  SWFFillTileBitmap, SWFFillClipBitmap,
                  SWFFillNonSmoothTileBitmap, SWFFillNonSmoothClipBitmap:
                    with TSWFMorphImageFill(MorphFillStyles[il]) do
                      begin
                       NodeRoot := Node2;
                       ShowParam('ImageID', ImageID);
                       AddMatrix(StartMatrix, Node2);
                       AddMatrix(EndMatrix, Node2);
                      end;
                end;
              end;
           end;
          if MorphLineStyles.Count > 0 then
           begin
             ShowSection('Line styles');
             Node1 := NodeRoot;
             For il := 0 to MorphLineStyles.Count - 1 do
              With TSWFMorphLineStyle(MorphLineStyles[il]) do
                begin
                  ShowSection('Style ' + IntToStr(il + 1), Node1);
                  Node2 :=  NodeRoot;
                  ShowParam('Start Width', StartWidth);
                  ShowParam('End Width', EndWidth);
                  AddColor(StartColor.RGBA, true, 'Start Color', Node2);
                  AddColor(EndColor.RGBA, true, 'End Color', Node2);
                end;
           end;

          ShowSection('Start Edges');
          Node1 := NodeRoot;
          for il:=0 to StartEdges.Count - 1 do
           case TSWFShapeRecord(StartEdges[il]).ShapeRecType of
            EndShapeRecord:
              begin
                NodeRoot := Node1;
                ShowParam('End', '-----');
              end;
            StyleChangeRecord:
              with TSWFStyleChangeRecord(StartEdges[il]) do
              begin
                ShowSection('StyleChange', Node1);
                ShowParam('StateFillStyle0', Abool[StateFillStyle0]);
                ShowParam('StateFillStyle1', Abool[StateFillStyle1]);
                ShowParam('StateLineStyle', Abool[StateLineStyle]);
                ShowParam('StateMoveTo', Abool[StateMoveTo]);
                ShowParam('StateNewStyles', Abool[StateNewStyles]);

                if StateMoveTo then
                 begin
                  ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                  ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                 end;
                if StateFillStyle0 then ShowParam('Fill0Id', Fill0Id);
                if StateFillStyle1 then ShowParam('Fill1Id', Fill1Id);
                if StateLineStyle then ShowParam('LineId', LineId);
              end;
            StraightEdgeRecord:
              with TSWFStraightEdgeRecord(StartEdges[il]) do
              begin
                ShowSection('LineDelta', Node1);
                ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
              end;
            CurvedEdgeRecord:
              with TSWFCurvedEdgeRecord(StartEdges[il]) do
              begin
                ShowSection('CurveDelta', Node1);
                ShowParam('ControlX', Format('%d (%2.2f)', [ControlX, ControlX / twips]));
                ShowParam('ControlY', Format('%d (%2.2f)', [ControlY, ControlY / twips]));
                ShowParam('Anchor X', Format('%d (%2.2f)', [AnchorX, AnchorX / twips]));
                ShowParam('Anchor Y', Format('%d (%2.2f)', [AnchorY, AnchorY / twips]));
              end;
           end;

          ShowSection('End Edges');
          Node1 := NodeRoot;
          for il:=0 to EndEdges.Count - 1 do
           case TSWFShapeRecord(EndEdges[il]).ShapeRecType of
            EndShapeRecord:
              begin
                NodeRoot := Node1;
                ShowParam('End', '-----');
              end;
            StyleChangeRecord:
              with TSWFStyleChangeRecord(EndEdges[il]) do
              begin
                ShowSection('StyleChange', Node1);
                ShowParam('StateFillStyle0', Abool[StateFillStyle0]);
                ShowParam('StateFillStyle1', Abool[StateFillStyle1]);
                ShowParam('StateLineStyle', Abool[StateLineStyle]);
                ShowParam('StateMoveTo', Abool[StateMoveTo]);
                ShowParam('StateNewStyles', Abool[StateNewStyles]);

                if StateMoveTo then
                 begin
                  ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                  ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                 end;
                if StateFillStyle0 then ShowParam('Fill0Id', Fill0Id);
                if StateFillStyle1 then ShowParam('Fill1Id', Fill1Id);
                if StateLineStyle then ShowParam('LineId', LineId);
              end;
            StraightEdgeRecord:
              with TSWFStraightEdgeRecord(EndEdges[il]) do
              begin
                ShowSection('LineDelta', Node1);
                ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
              end;
            CurvedEdgeRecord:
              with TSWFCurvedEdgeRecord(EndEdges[il]) do
              begin
                ShowSection('CurveDelta', Node1);
                ShowParam('X', Format('%d (%2.2f)', [ControlX, ControlX / twips]));
                ShowParam('Y', Format('%d (%2.2f)', [ControlY, ControlY / twips]));
                ShowParam('Anchor X', Format('%d (%2.2f)', [AnchorX, AnchorX / twips]));
                ShowParam('Anchor Y', Format('%d (%2.2f)', [AnchorY, AnchorY / twips]));
              end;
           end;

        end;


// Bitmaps
     tagDefineBits,
     tagDefineBitsJPEG2:
       With TSWFDefineBits(STag.SWFObject) do
        begin
          ShowParam('CharacterID', CharacterID);
          ShowParam('DataSize', DataSize);
        end;
     tagJPEGTables:
       With TSWFJPEGTables(STag.SWFObject) do
          ShowParam('DataSize', DataSize);
     tagDefineBitsJPEG3:
       With TSWFDefineBitsJPEG3(STag.SWFObject) do
        begin
          ShowParam('CharacterID', CharacterID);
          ShowParam('DataSize', DataSize);
          ShowParam('AlphaDataSize', AlphaDataSize);
        end;
     tagDefineBitsLossless,
     tagDefineBitsLossless2:
       With TSWFDefineBitsLossless(STag.SWFObject) do
        begin
          ShowParam('CharacterID', CharacterID);
          ShowParam('Width', BitmapWidth);
          ShowParam('Height', BitmapHeight);
          ShowParam('DataSize', DataSize);
          if TagID = tagDefineBitsLossless
             then ShowParam('BitmapFormat', GetNameBMFormat(BitmapFormat))
             else
             begin
               if BitmapFormat = BMP_8bit then ShowParam('BitmapFormat', '8 bit')
                 else ShowParam('BitmapFormat', '32 bit');
             end;

          if BitmapFormat = BMP_8bit then
            ShowParam('BitmapColorTableSize', BitmapColorTableSize);
        end;

// Fonts and Text
     tagDefineFont:
       With TSWFDefineFont(STag.SWFObject) do
         begin
           ShowParam('FontID', FontID);
           ShowParam('Glyphs Count', GlyphShapeTable.Count);
           for il := 0 to GlyphShapeTable.Count - 1 do
             begin
              ShowSection('Glyph '+ IntToStr(il+1));
              Node1 := NodeRoot;
              LO:= TObjectList(GlyphShapeTable[il]);
              for il2:=0 to LO.Count - 1 do
               case TSWFShapeRecord(LO[il2]).ShapeRecType of
                EndShapeRecord:
                  begin
                    NodeRoot := Node1;
                    ShowParam('End', '-----');
                  end;
                StyleChangeRecord:
                  with TSWFStyleChangeRecord(LO[il2]) do
                  begin
                    ShowSection('StyleChange', Node1);
                    ShowParam('StateFillStyle0', Abool[StateFillStyle0]);
                    ShowParam('StateFillStyle1', Abool[StateFillStyle1]);
                    ShowParam('StateLineStyle', Abool[StateLineStyle]);
                    ShowParam('StateMoveTo', Abool[StateMoveTo]);
                    ShowParam('StateNewStyles', Abool[StateNewStyles]);

                    if StateMoveTo then
                     begin
                      ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                      ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                     end;
                    if StateFillStyle0 then ShowParam('Fill0Id', Fill0Id);
                    if StateFillStyle1 then ShowParam('Fill1Id', Fill1Id);
                    if StateLineStyle then ShowParam('LineId', LineId);
                  end;
                StraightEdgeRecord:
                  with TSWFStraightEdgeRecord(LO[il2]) do
                  begin
                    ShowSection('LineTo', Node1);
                    ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                    ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                  end;
                CurvedEdgeRecord:
                  with TSWFCurvedEdgeRecord(LO[il2]) do
                  begin
                    ShowSection('CurveTo', Node1);
                    ShowParam('X', Format('%d (%2.2f)', [ControlX, ControlX / twips]));
                    ShowParam('Y', Format('%d (%2.2f)', [ControlY, ControlY / twips]));
                    ShowParam('Anchor X', Format('%d (%2.2f)', [AnchorX, AnchorX / twips]));
                    ShowParam('Anchor Y', Format('%d (%2.2f)', [AnchorY, AnchorY / twips]));
                  end;
               end;

             end;
         end;

     tagDefineFontInfo,
     tagDefineFontInfo2:
       With TSWFDefineFontInfo(STag.SWFObject) do
         begin
          ShowParam('FontID', FontID);
          ShowParam('FontName', FontName);
          ShowParam('FontFlagsANSI', ABool[FontFlagsANSI]);
          ShowParam('FontFlagsBold', ABool[FontFlagsBold]);
          ShowParam('FontFlagsItalic', ABool[FontFlagsItalic]);
          ShowParam('FontFlagsSmallText', ABool[FontFlagsSmallText]);
          ShowParam('FontFlagsWideCodes', ABool[FontFlagsWideCodes]);
          if TagID = tagDefineFontInfo2 then
            ShowParam('LanguageCode', TSWFDefineFontInfo2(STag.SWFObject).LanguageCode);
          if CodeTable.Count > 0 then
            begin
             ShowSection('Code Table');
             for il := 0 to CodeTable.Count-1 do
               begin
                 if Longint(CodeTable[il]) > 255 then
                     stt := WideChar(longint(CodeTable[il]))
                   else Stt := Chr(Longint(CodeTable[il]));
                 if Longint(CodeTable[il]) > 32 then stt := stt + ' (' + char(Longint(CodeTable[il])) + ')';
               ShowParam('Code '+ IntToStr(il+1), stt);
               end;
            end;

         end;
     tagDefineText, tagDefineText2:
       With TSWFDefineText(STag.SWFObject) do
         begin
           ShowParam('CharacterID', CharacterID);
           AddRect(TextBounds.Rect);
           AddMatrix(TextMatrix);
           NodeRoot := nil;
           ShowParam('GlyphBits', GlyphBits);
           ShowParam('AdvanceBits', AdvanceBits);

           Node2 := NodeRoot;
           ShowParam('RECORDS Count', IntToStr(TextRecords.Count));
           For il:=0 to TextRecords.Count-1 do
             with TSWFTextRecord(TextRecords[il]) do
              begin
                ShowSection('REC ' + IntToStr(il + 1), Node2);
                ShowParam('FontFlagsHasLayout', ABool[StyleFlagsHasFont]);
                ShowParam('StyleFlagsHasColor' ,ABool[StyleFlagsHasColor]);
                ShowParam('StyleFlagsHasXOffset',ABool[StyleFlagsHasXOffset]);
                ShowParam('StyleFlagsHasYOffset',ABool[StyleFlagsHasYOffset]);
                if StyleFlagsHasFont then ShowParam('FontID', IntToStr(FontID));
                if StyleFlagsHasFont then ShowParam('TextHeight', TextHeight);
                if StyleFlagsHasXOffset then ShowParam('XOffset' , IntToStr(XOffset));
                if StyleFlagsHasYOffset then ShowParam('YOffset', IntToStr(YOffset));
                if StyleFlagsHasColor then AddColor(TextColor.RGBA, hasAlpha, 'TextColor', NodeRoot);
                NodeRoot := NodeRoot.Parent;
                Node1 := NodeRoot;

                ShowParam('GLYPHS Count', IntToStr(GlyphEntries.Count));
                For il2:=0 to GlyphEntries.Count-1 do
                 With TSWFGlyphEntry(GlyphEntries[il2]) do
                  begin
                    ShowSection('GLYPHS' + IntToStr(il2 + 1), Node1);
                    stt := IntToStr(GlyphIndex);
                    if GlyphIndex > 32 then stt := stt + ' (' + UTF8ToAnsi(char(GlyphIndex)) + ')';
                    ShowParam('GlyphIndex', stt);
                    ShowParam('GlyphAdvance', IntToStr(GlyphAdvance));
                  end;
              end;
         end;
     tagDefineFont2:
       With TSWFDefineFont2(STag.SWFObject) do
         begin
           ShowParam('FontID', IntToStr(FontID));
           ShowParam('FontName', FontName);
           ShowParam('FontFlagsHasLayout', ABool[FontFlagsHasLayout]);
           ShowParam('FontFlagsShiftJIS', ABool[FontFlagsShiftJIS]);
           ShowParam('FontFlagsSmallText', ABool[FontFlagsSmallText]);
           ShowParam('FontFlagsANSI', ABool[FontFlagsANSI]);
           ShowParam('FontFlagsWideOffsets', ABool[FontFlagsWideOffsets]);
           ShowParam('FontFlagsWideCodes', ABool[FontFlagsWideCodes]);
           ShowParam('FontFlagsItalic', ABool[FontFlagsItalic]);
           ShowParam('FontFlagsBold', ABool[FontFlagsBold]);
           ShowParam('LanguageCode', LanguageCode);
           ShowParam('Count', CodeTable.Count);
           if CodeTable.Count > 0 then
            begin
             ShowSection('Code Table');
             for il := 0 to CodeTable.Count-1 do
               begin
                 if Longint(CodeTable[il]) > 255 then
                     stt := WideChar(longint(CodeTable[il]))
                   else Stt := Chr(Longint(CodeTable[il]));

                 if Longint(CodeTable[il]) > 32 then stt := IntToStr(Longint(CodeTable[il])) + ' (' + stt + ')';
               ShowParam('Code '+ IntToStr(il+1), stt);
               end;
            end;

           for il := 0 to GlyphShapeTable.Count - 1 do
             begin
              ShowSection('Glyph '+ IntToStr(il+1));
              Node1 := NodeRoot;
              LO:= TObjectList(GlyphShapeTable[il]);
              for il2:=0 to LO.Count - 1 do
               case TSWFShapeRecord(LO[il2]).ShapeRecType of
                EndShapeRecord:
                  begin
                    NodeRoot := Node1;
                    ShowParam('End', '-----');
                  end;
                StyleChangeRecord:
                  with TSWFStyleChangeRecord(LO[il2]) do
                  begin
                    ShowSection('StyleChange', Node1);
                    ShowParam('StateFillStyle0', Abool[StateFillStyle0]);
                    ShowParam('StateFillStyle1', Abool[StateFillStyle1]);
                    ShowParam('StateLineStyle', Abool[StateLineStyle]);
                    ShowParam('StateMoveTo', Abool[StateMoveTo]);
                    ShowParam('StateNewStyles', Abool[StateNewStyles]);

                    if StateMoveTo then
                     begin
                      ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                      ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                     end;
                    if StateFillStyle0 then ShowParam('Fill0Id', Fill0Id);
                    if StateFillStyle1 then ShowParam('Fill1Id', Fill1Id);
                    if StateLineStyle then ShowParam('LineId', LineId);
                  end;
                StraightEdgeRecord:
                  with TSWFStraightEdgeRecord(LO[il2]) do
                  begin
                    ShowSection('LineTo', Node1);
                    ShowParam('X', Format('%d (%2.2f)', [X, X / twips]));
                    ShowParam('Y', Format('%d (%2.2f)', [Y, Y / twips]));
                  end;
                CurvedEdgeRecord:
                  with TSWFCurvedEdgeRecord(LO[il2]) do
                  begin
                    ShowSection('CurveTo', Node1);
                    ShowParam('X', Format('%d (%2.2f)', [ControlX, ControlX / twips]));
                    ShowParam('Y', Format('%d (%2.2f)', [ControlY, ControlY / twips]));
                    ShowParam('Anchor X', Format('%d (%2.2f)', [AnchorX, AnchorX / twips]));
                    ShowParam('Anchor Y', Format('%d (%2.2f)', [AnchorY, AnchorY / twips]));
                  end;
               end;

             end;
             if FontFlagsHasLayout then
               begin
                 NodeRoot := nil;
                 ShowParam('FontAscent', inttostr(FontAscent));
                 ShowParam('FontDescent', inttostr(FontDescent));
                 ShowParam('FontLeading', inttostr(FontLeading));
                 ShowSection('AdvanceTable', nil);
                 for il := 0 to FontAdvanceTable.Count - 1 do
                   ShowParam(IntToStr(il), LongInt(FontAdvanceTable[il]));
                 ShowSection('BoundsTable', nil);
                 Node1 := NodeRoot;
                 for il := 0 to FontBoundsTable.Count - 1 do
                   With TSWFRect(FontBoundsTable[il]) do
                     AddRect(Rect , 'Rect ' + IntToStr(il));
               end;
         end;

    tagDefineEditText:
      with TSWFDefineEditText(STag.SWFObject) do
        begin
          ShowParam('CharacterID', CharacterID);
          AddRect(Bounds.Rect);

          if HasFont then
             begin
               ShowParam('FontID', FontID);
               ShowParam('FontHeight', FontHeight);
             end;

          ShowParam('VariableName', VariableName);
          if HasText then
            ShowParam('InitialText', UTF8ToAnsi(InitialText));

          if HasTextColor then
             AddColor(TextColor.RGBA, true, 'TextColor');

          if HasLayout then
            begin
              ShowSection('Layout');
              ShowParam('Align', Align);
              ShowParam('Indent', Indent);
              ShowParam('Leading', Leading);
              ShowParam('LeftMargin', LeftMargin);
              ShowParam('RightMargin', RightMargin);
              NodeRoot := nil;
            end;


          ShowParam('Border', ABool[Border]);
          ShowParam('AutoSize', ABool[AutoSize]);
          ShowParam('Multiline', ABool[Multiline]);
          ShowParam('NoSelect', ABool[NoSelect]);
          ShowParam('ReadOnly', ABool[ReadOnly]);
          ShowParam('HTML', ABool[HTML]);
          ShowParam('Password', ABool[Password]);
          ShowParam('WordWrap', ABool[WordWrap]);
          if HasMaxLength then
            ShowParam('MaxLength', MaxLength);
          ShowParam('UseOutlines', ABool[UseOutlines]);
        end;

// SOUND
     tagSoundStreamHead, tagSoundStreamHead2:
      with TSWFSoundStreamHead(STag.SWFObject) do
       begin
        ShowParam('PlaybackSoundRate',IntToStr(PlaybackSoundRate));
        ShowParam('PlaybackSoundSize',ABool[PlaybackSoundSize]);
        ShowParam('PlaybackSoundType',ABool[PlaybackSoundType]);
        ShowParam('StreamSoundCompression',IntToStr(StreamSoundCompression) +' ('+SoundCompression(StreamSoundCompression)+')');
        ShowParam('StreamSoundRate',IntToStr(StreamSoundRate) + ' ('+SoundRate(StreamSoundRate)+')');
        ShowParam('StreamSoundSize (16 bit)',ABool[StreamSoundSize]);
        ShowParam('StreamSoundType (stereo)',ABool[StreamSoundType]);
        ShowParam('StreamSoundSampleCount',IntToStr(StreamSoundSampleCount));
        ShowParam('LatencySeek',IntToStr(LatencySeek));
        isMp3Stream := StreamSoundCompression = 2;
       end;

     tagSoundStreamBlock:
      with TSWFSoundStreamBlock(STag.SWFObject) do
       begin
        if isMp3Stream then
         begin
          ShowParam('SampleCount',IntToStr(SampleCount));
          ShowParam('SeekSamples',IntToStr(SeekSamples));
         end else
          ShowSection('without parameters');
       end;

     tagDefineSound:
       With TSWFDefineSound(STag.SWFObject) do
         begin
           ShowParam('SoundId', IntToStr(SoundId));
           ShowParam('SoundFormat',IntToStr(SoundFormat));
           ShowParam('SoundRate',IntToStr(SoundRate) + ' ('+UWinParse.SoundRate(SoundRate)+')');

           ShowParam('SoundSize (16 bit)',ABool[SoundSize]);
           ShowParam('SoundType (stereo)',ABool[SoundType]);
           ShowParam('SoundSampleCount',IntToStr(SoundSampleCount));

           ShowParam('SeekSamples', IntToStr(SeekSamples));
           ShowParam('DataSize', IntToStr(DataSize));
         end;

     tagStartSound:
       ShowStartSound( TSWFStartSound(STag.SWFObject) );

     tagDefineSprite:
      With TSWFDefineSprite(STag.SWFObject) do
        begin
          ShowParam('SpriteID', SpriteID);
          ShowParam('FrameCount', FrameCount);
        end;

     tagDefineButton:
      With TSWFDefineButton(STag.SWFObject) do
       begin
        ShowParam('ButtonId', ButtonId);
        for il := 0 to ButtonRecords.Count - 1 do
         begin
           ShowSection('Button Record ' + IntToStr(il + 1));
           Node1 := NodeRoot;
           with TSWFButtonRecord(ButtonRecords[il]) do
             begin
               ShowParam('CharacterID', CharacterID);
               ShowParam('Depth', Depth);
               if bsHitTest in ButtonState then stt := 'HitTest'
                  else stt := '';
               if SWFConst.bsDown in ButtonState then stt := stt + ', Down';
               if bsOver in ButtonState then stt := stt + ', Over';
               if SWFConst.bsUp in ButtonState then stt := stt + ', Up';
               if (stt[1] = ',') then Delete(stt, 1, 2);
               ShowParam('ButtonState', Stt);
               AddMatrix(Matrix, Node1);
               if hasColorTransform then
                 AddTransformColor(ColorTransform.REC, Node1);
             end;
         end;
       end;

     tagDefineButton2:
      With TSWFDefineButton2(STag.SWFObject) do
       begin
        ShowParam('ButtonId', ButtonId);
        ShowParam('AsMenu', ABool[TrackAsMenu]);
        for il := 0 to ButtonRecords.Count - 1 do
         begin
           ShowSection('Button Record ' + IntToStr(il + 1));
           Node1 := NodeRoot;
           with ButtonRecord[il] do
             begin
               ShowParam('CharacterID', CharacterID);
               ShowParam('Depth', Depth);
               if bsHitTest in ButtonState then stt := 'HitTest'
                  else stt := '';
               if SWFConst.bsDown in ButtonState then stt := stt + ', Down';
               if bsOver in ButtonState then stt := stt + ', Over';
               if SWFConst.bsUp in ButtonState then stt := stt + ', Up';
               if (stt[1] = ',') then Delete(stt, 1, 2);
               ShowParam('ButtonState', Stt);
               AddMatrix(Matrix, Node1);
               if hasColorTransform then
                 AddTransformColor(ColorTransform.REC, Node1);
             end;
         end;
        if Actions.Count > 0 then
          for il := 0 to Actions.Count -1 do
           with TSWFButtonCondAction(Actions[il]) do
            begin
               ShowSection('Condition Action ' + IntToStr(il + 1));
               Node1 := NodeRoot;

               if IdleToOverDown in ActionConditions then stt := 'IdleToOverDown' else stt := '';
               if OutDownToIdle in ActionConditions then stt := stt + ', OutDownToIdle';
               if OutDownToOverDown in ActionConditions then stt := stt + ', OutDownToOverDown';
               if OverDownToOutDown in ActionConditions then stt := stt + ', OverDownToOutDown';
               if OverDownToOverUp in ActionConditions then stt := stt + ', OverDownToOverUp';
               if OverUpToOverDown in ActionConditions then stt := stt + ', OverUpToOverDown';
               if OverUpToIdle in ActionConditions then stt := stt + ', OverUpToIdle';
               if IdleToOverUp in ActionConditions then stt := stt + ', IdleToOverUp';
               if OverDownToIdle in ActionConditions then stt := stt + ', OverDownToIdle';
               if (stt<>'') and (stt[1] = ',') then Delete(stt, 1, 2);
               ShowParam('State Transition', Stt);
               if ID_KEY > 0 then ShowParam('Key', word(ID_KEY));
               ReadACTIONRECORD(Node1, Actions)

            end;
       end; // tagDefineButton2

      tagDefineButtonSound:
        With TSWFDefineButtonSound(STag.SWFObject) do
         begin
           ShowParam('ButtonId', ButtonId);
           if HasOverUpToIdle then
             begin
              ShowSection('OverUpToIdle');
              //Node1 := RootNode;
              ShowStartSound(SndOverUpToIdle);
             end;
           if HasIdleToOverUp then
             begin
              ShowSection('IdleToOverUp');
              ShowStartSound(SndIdleToOverUp);
             end;
           if HasOverUpToOverDown then
             begin
              ShowSection('OverUpToOverDown');
              ShowStartSound(SndOverUpToOverDown);
             end;
           if HasOverDownToOverUp then
             begin
              ShowSection('OverDownToOverUp');
              ShowStartSound(SndOverDownToOverUp);
             end;
         end;

      tagDefineButtonCxform:
        with TSWFDefineButtonCxform(STag.SWFObject) do
          begin
            ShowParam('ButtonId', ButtonId);
            AddTransformColor(ButtonColorTransform.REC);
          end;

      tagDefineVideoStream:
        with TSWFDefineVideoStream(STag.SWFObject) do
          begin
            ShowParam('CharacterID', CharacterID);
            ShowParam('CodecID', CodecID);
            ShowParam('Width', Width);
            ShowParam('Height', Height);
            ShowParam('NumFrames', NumFrames);
            ShowParam('VideoFlagsDeblocking', VideoFlagsDeblocking);
            ShowParam('VideoFlagsSmoothing', ABool[VideoFlagsSmoothing]);
          end;

      tagVideoFrame:
        with TSWFVideoFrame(STag.SWFObject) do
          begin
            ShowParam('StreamID', StreamID);
            ShowParam('FrameNum', FrameNum);
          end;

      else ShowSection('no released');
    end;

    Case STag.TagID of
      tagDefineBitsJPEG2,
      tagDefineBitsJPEG3:
       With TSWFDefineBitsJPEG2(STag.SWFObject) do
        begin
          SplitImage.Visible := true;
          PImage.Visible := true;
          MS := TMemoryStream.Create;
          if DataSize > 0 then
            begin
              MS.Write(Data^, DataSize);
              MS.Position := 0;
              JPG := TJPEGImage.Create;
              JPG.LoadFromStream(MS);
              Image.Picture.Assign(JPG);
              JPG.Free;
            end;
          MS.Free;
        end;

      tagDefineBitsLossless,
      tagDefineBitsLossless2:
       With TSWFDefineBitsLossless(STag.SWFObject) do
        begin
          PImage.Visible := true;
          SplitImage.Visible := true;

          BMP := TBitMap.Create;
          MakeBMPFromTag(BMP, TSWFDefineBitsLossless(STag.SWFObject), STag.SWFObject.TagID = tagDefineBitsLossless2);
          Image.Picture.Assign(BMP);
          BMP.Free;
        end;

      else
       begin
        PImage.Visible := false;
        SplitImage.Visible := false;
       end;
    end;

    Pages.ActivePageIndex := Byte(STag.TagID <> tagShowFrame);
    SL.Free;
    BitsEnginie.Free;
    TreeParams.FullExpand;
end;

procedure TMDIChild.VTreeBeforeCellPaint(Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  CellRect: TRect);
  var Tag: TSWFTagInfo;
  Obj: TObject;
begin
 Obj := TObject(PMyRecNode(VTree.GetNodeData(Node))^.TagInfo);
 if Obj is TSWFTagInfo then
   begin
     Tag := TSWFTagInfo(Obj);
     Case Tag.TagID of
      tagEnd, tagShowFrame:
       begin
         TargetCanvas.Brush.Color := $F0F0F0;
         TargetCanvas.FillRect( CellRect );
       end;
      tagErrorTag:
       begin
         TargetCanvas.Brush.Color := $C0C0FF;
         TargetCanvas.FillRect( CellRect );
       end;

     end;
   end;
end;


procedure TMDIChild.bDelClick;
  var TN, TN2: PVirtualNode;
      Tag: TSWFTagInfo;
      DelFr: integer;
begin
 if id_No=MessageBox(handle, 'Delete selected tags?', pChar(SwfName), MB_YesNo + MB_ICONQUESTION) then exit;

 DelFr := 0;
 
 TN := VTree.GetFirst;
 Repeat
  TN2 := TN.NextSibling;
  if TN.CheckState = csCheckedNormal then
    begin
      Tag := TSWFTagInfo(PMyRecNode(VTree.GetNodeData(TN))^.TagInfo);
      if Tag.TagID = tagShowFrame then inc(DelFr);
      With SWF.TagList do Delete(Indexof(Tag));
      VTree.DeleteNode(TN);
      isModif := true;
    end;
  TN := TN2;

 Until TN = nil;
 SWF.SWFHeader.FramesCount := SWF.FramesCount - DelFr;
end;

type
  tWawePCMHead = record
     Marker1:        Array[0..3] of Char;
     BytesFollowing: LongInt;
     Marker2:        Array[0..3] of Char;
     Marker3:        Array[0..3] of Char;
     Fixed1:         LongInt;
     FormatTag:      Word;
     Channels:       Word;
     SampleRate:     LongInt;
     BytesPerSecond: LongInt;
     BytesPerSample: Word;
     BitsPerSample:  Word;
     Marker4:        Array[0..3] of Char;
     DataBytes:      LongInt;
  end;

procedure TMDIChild.SaveSound;
  var il, p:integer;
      d1, d2: longint;
      WaveHeader: tWawePCMHead;
      FS, FF: tFileStream;
      isFirst: boolean;
begin
 For il:=0 to SWF.TagList.Count-1 do
  with TSWFTagInfo(SWF.TagList[il]) do
  begin
    Case TagID of
      tagSoundStreamHead, tagSoundStreamHead2:
         with TSWFSoundStreamHead(SWFObject) do
         begin
           WaveHeader.Marker1 := 'RIFF';
         //  WaveHeader.BytesFollowing := DataBytes + 36;
           WaveHeader.Marker2 := 'WAVE';
           WaveHeader.Marker3 := 'fmt ';
           WaveHeader.Fixed1 := 16;
           if StreamSoundCompression = 3 then WaveHeader.FormatTag := 1
               else WaveHeader.FormatTag := 2;
           WaveHeader.SampleRate := SndRates[StreamSoundRate];
           WaveHeader.Channels := ifthen(StreamSoundType, 2, 1);
           WaveHeader.BitsPerSample := ifthen(StreamSoundSize, 16, 8);
           WaveHeader.BytesPerSample := WaveHeader.Channels * WaveHeader.BitsPerSample div 8;
           WaveHeader.BytesPerSecond := WaveHeader.Channels * WaveHeader.SampleRate;

           WaveHeader.Marker4 := 'data';
           WaveHeader.DataBytes := 0;
           DeleteFile('C:\Delphi7\Flash_SWF\ss.wav');
           FS:=tFileStream.Create('C:\Delphi7\Flash_SWF\ss.wav', fmcreate);
           d1 := 0;
           if WaveHeader.FormatTag = 1 then
                FS.Write(WaveHeader, SizeOf(WaveHeader))
              else d1 := 4;
           p:=1;
         end;
      tagSoundStreamBlock:
        begin
          SWF.BodyStream.Position := Position + 6 + d1;

//          FF:=  TFileStream.Create('C:\Delphi7\Flash_SWF\r'+IntToStr(p)+'.dat', fmCreate);
//          FF.CopyFrom(SWF.BodyStream, Size);
//          SWF.BodyStream.Position := SWF.BodyStream.Position - Size;
//          inc(p);
//          FF.Free;
          if (BodySize - d1) > 0 then
            FS.CopyFrom(SWF.BodyStream, BodySize - d1);
          WaveHeader.DataBytes := WaveHeader.DataBytes + BodySize - d1;
        end;
    end;
  end;
  WaveHeader.BytesFollowing := WaveHeader.DataBytes + 36;
  FS.Position := 0;
  if WaveHeader.FormatTag = 1 then
    FS.Write(WaveHeader, SizeOf(WaveHeader));
  FS.Free;
end;

procedure TMDIChild.bPlayClick(Sender: TObject);
begin
 Player.Play;
end;

procedure TMDIChild.bStopClick(Sender: TObject);
begin
Player.Stop;
end;

procedure TMDIChild.Tab1Resize(Sender: TObject);
begin
 Player.CreateWnd;
end;

procedure TMDIChild.TreeParamsGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);
begin
  Case Column of
    0: CellText := PRecParamNode(TreeParams.GetNodeData(Node))^.Key;
    1: CellText := PRecParamNode(TreeParams.GetNodeData(Node))^.Value;
  end;
end;

procedure TMDIChild.bActionSaveClick;
  var Node: PVirtualNode;
begin
 Node := VTree.GetFirstSelected;
 if Node = nil then
   begin
     MessageBeep(0);
     Exit;
   end;

 With TSWFTagInfo(PMyRecNode(VTree.GetNodeData(Node))^.TagInfo) do
 case TagID of
  tagDoAction: GetDoAction(TSWFDoAction(SWFObject));
  tagPlaceObject2: GetPlaceObjectAction(TSWFPlaceObject2(SWFObject));
  tagDefineButton: GetButtonAction(TSWFDefineButton(SWFObject));
  tagDefineButton2: GetButton2Action(TSWFDefineButton2(SWFObject));
  else MessageBeep(0);
 end;

end;

procedure TMDIChild.SaveImage(fn: string);
 var Node: PVirtualNode;
     MS : TMemoryStream;
begin
 Node := VTree.GetFirstSelected;
 if Node = nil then
   begin
     MessageBeep(0);
     Exit;
   end;

 With TSWFTagInfo(PMyRecNode(VTree.GetNodeData(Node))^.TagInfo) do
 case TagID of
      tagDefineBitsJPEG2,
      tagDefineBitsJPEG3:
       With TSWFDefineBitsJPEG2(SWFObject) do
        begin
          SplitImage.Visible := true;
          PImage.Visible := true;
          MS := TMemoryStream.Create;
          if DataSize > 0 then
            begin
              MS.Write(Data^, DataSize);
              MS.SaveToFile(fn);
            end;
          MS.Free;
        end;


  else MessageBeep(0);
 end;

end;

Procedure TMDIChild.SaveSelTag(fn:string; AsText: boolean);
  var MS: TMemoryStream;
      BE: TBitsEngine;
      TN, TN2: PVirtualNode;
      Tag: TSWFTagInfo;
      ch: byte;
      TF: textFile;
begin
  MS := TMemoryStream.Create;

  TN := VTree.GetFirst;
  Repeat
   TN2 := TN.NextSibling;
   if TN.CheckState = csCheckedNormal then
     begin
       Tag := TSWFTagInfo(PMyRecNode(VTree.GetNodeData(TN))^.TagInfo);
       SWF.BodyStream.Position := Tag.Position;
       MS.CopyFrom(SWF.BodyStream, Tag.GetFullSize);
     end;
   TN := TN2;

  Until TN = nil;

  if MS.Size > 0 then
    begin
      if asText then
        begin
          MS.Position :=0;
          AssignFile(TF, FN);
          Rewrite(TF);
          While MS.Position < MS.Size do
           begin
            MS.Read(CH, 1);
            Write(tf, ch, ', ');
           end;
          CloseFile(TF); 
        end
        else MS.SaveToFile(fn);
    end;
  MS.Free;
end;

end.
