
CFLAGS=-O2 -Wno-deprecated -Wno-ctor-dtor-privacy -DWINVER=0x0500
LFLAGS=

all:  XSP_GUI.lib

clean:
	rm *.o *.lib

INCDIR=-I ../Includes \
	-I ../../Core/Includes \
	-I ../../File/Includes \
	-I ../../Codecs/Includes \
	-I ../../../Libs/regexpp2/include

HEADER=-include ../../Targets/Includes/TargetAPI_Win32.h

ALL_HEADER= ../../Targets/Includes/TargetAPI_Win32.h \
	../Includes/XSP_GUI.h \
	../Includes/XSP_GUI_Module.h \
	../Includes/XSP_BackgroundView.h \
	../Includes/XSP_ButtonView.h \
	../Includes/XSP_Codec.h \
	../Includes/XSP_DialogWindow.h \
	../Includes/XSP_DragDrop.h \
	../Includes/XSP_DropDown.h \
	../Includes/XSP_FileView.h \
	../Includes/XSP_Graphics.h \
	../Includes/XSP_ImageView.h \
	../Includes/XSP_LabelView.h \
	../Includes/XSP_ListBox.h \
	../Includes/XSP_MouseCursor.h \
	../Includes/XSP_MView.h \
	../Includes/XSP_OSIcon.h \
	../Includes/XSP_ScrollView.h \
	../Includes/XSP_TabView.h \
	../Includes/XSP_TextFont.h \
	../Includes/XSP_TextView.h \
	../Includes/XSP_ToolBar.h \
	../Includes/XSP_UIEvent.h \
	../Includes/XSP_View.h \
	../Includes/XSP_ViewSkin.h \
	../Includes/XSP_Window.h 

ALL_OBJ= GUI.o \
	GUI_Carbon.o \
	GUI_Linux.o \
	GUI_Test.o \
	GUI_Win32.o \
	GUI_XWindows.o \
	BackgroundView.o \
	ButtonView.o \
	Codec.o \
	DialogWindow.o \
	DragDrop.o \
	DragDrop_Win32.o \
	DropDown.o \
	ImageView.o \
	LabelView.o \
	ListBox.o \
	MouseCursor.o \
	MView.o \
	ScrollView.o \
	TabView.o \
	TextView.o \
	ToolBar.o \
	View.o \
	ViewSkin.o \
	Window.o \
	Window_Win32.o 

BackgroundView.o: ../Sources/BackgroundView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ButtonView.o: ../Sources/ButtonView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Codec.o: ../Sources/Codec.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

DialogWindow.o: ../Sources/DialogWindow.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

DragDrop.o: ../Sources/DragDrop.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

DragDrop_Win32.o: ../Sources/DragDrop_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

DropDown.o: ../Sources/DropDown.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI.o: ../Sources/GUI.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI_Carbon.o: ../Sources/GUI_Carbon.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI_Linux.o: ../Sources/GUI_Linux.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI_Test.o: ../Sources/GUI_Test.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI_Win32.o: ../Sources/GUI_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

GUI_XWindows.o: ../Sources/GUI_XWindows.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ImageView.o: ../Sources/ImageView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

LabelView.o: ../Sources/LabelView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ListBox.o: ../Sources/ListBox.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

MouseCursor.o: ../Sources/MouseCursor.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

MView.o: ../Sources/MView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ScrollView.o: ../Sources/ScrollView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TabView.o: ../Sources/TabView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

TextView.o: ../Sources/TextView.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ToolBar.o: ../Sources/ToolBar.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

View.o: ../Sources/View.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

ViewSkin.o: ../Sources/ViewSkin.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Window.o: ../Sources/Window.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

Window_Win32.o: ../Sources/Window_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

XSP_GUI.lib: $(ALL_OBJ)
	ar rc $@ $(ALL_OBJ)
	ranlib $@
