/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{


ViewSkin::ViewSkin()
{
}
ViewSkin::~ViewSkin()
{
}
ViewSkin::Element::Element()
: stateMask(0), stateCode(0)
{
}
ViewSkin::Element::~Element()
{
}
ViewSkin::Element::Element(const Element& e)
: stateMask(e.stateMask), stateCode(e.stateCode), stateSkin(e.stateSkin)
{
}
StateSkin::owner& ViewSkin::GetStateSkin(uint32 stateID)
{
	Elements::iterator b = elements.begin();
	Elements::iterator e = elements.end();
	for(; b!=e; ++b)
	{
		Element& e = *b;
		if ((e.stateMask & stateID) == e.stateCode)
			return e.stateSkin;
	}
	// no such skin
	static StateSkin::owner nullStateSkin(0);
	return nullStateSkin;
//	VERIFY(false);
//	return (*elements.begin()).stateSkin;
}

void ViewSkin::AddStateSkin(uint32 m, uint32 c, const StateSkin::owner& s)
{
	ViewSkin::Element e;
	e.stateMask = m;
	e.stateCode = c;
	e.stateSkin = s;
	elements.push_back(e);
}

void ViewSkin::AddPart(const String& partName, const ViewSkin::owner& partV)
{
	parts.insert(Parts::value_type(partName,partV));
}
void ViewSkin::JoinPartsFrom(const ViewSkin::owner& skin)
{
// MSVC won't compile this
//	Parts::const_iterator b = skin->parts.begin();
//	Parts::const_iterator e = skin->parts.end();
//	parts.insert(b,e);	

	Parts::const_iterator b = skin->parts.begin();
	Parts::const_iterator e = skin->parts.end();
	for (; b!=e; ++b)
		parts.insert(*b);	
}
ViewSkin::owner ViewSkin::GetPart(const String& partName)
{
	Parts::const_iterator w = parts.find(partName);
	Parts::const_iterator e = parts.end();
	if (w != e)
		return w->second;
	// return null if not found
	return ViewSkin::owner();
}

StateSkin::~StateSkin()
{
}

SolidColorSkin::SolidColorSkin()
{
}

SolidColorSkin::SolidColorSkin(const ColorRGB& c)
: bgColr(c)
{
}

SolidColorSkin::~SolidColorSkin()
{
}

void SolidColorSkin::Draw(Graphics& g, const Rect2D& /*bounds*/, const Rect2D& area)
{
    g.FillRect(bgColr,area);
}

Rect2D SolidColorSkin::GetContent(const Rect2D& bounds)
{
	Rect2D c(bounds);
	c.OffsetBy(content.x,content.y);
	c.w-=content.w;
	c.h-=content.h;
	return c;
}
Rect2D SolidColorSkin::GetContent()
{
	return content;
}

ImageSkin::ImageSkin()
{ }

ImageSkin::ImageSkin( const OffscreenImage& img
					, const Rect2D& bounds)
: image(img)
, content(bounds)
{ }

ImageSkin::~ImageSkin()
{ }

void ImageSkin::SetImage(const OffscreenImage& img)
{
	image = img;
}
void ImageSkin::SetContent(const Rect2D& bounds)
{
	content = bounds;
}

void ImageSkin::Draw(Graphics& g, const Rect2D& bounds, const Rect2D& /*area*/)
{
	Rect2D srcBounds(image.GetSize());
	if ((content.w != 0) || (content.h != 0))
	{
		Rect2D sc(srcBounds);	sc.RemoveBorder(content,Rect2D::C);
		Rect2D bc(bounds);		bc.RemoveBorder(content,Rect2D::C);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::N);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::N);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::S);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::S);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::E);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::E);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::W);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::W);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::NE);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::NE);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::SE);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::SE);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::NW);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::NW);
		g.DrawImage(image, sc, bc);

		sc=srcBounds;	sc.RemoveBorder(content,Rect2D::SW);
		bc=bounds;		bc.RemoveBorder(content,Rect2D::SW);
		g.DrawImage(image, sc, bc);
	}
	else
		g.DrawImage(image, srcBounds, bounds);
}

Rect2D ImageSkin::GetContent(const Rect2D& bounds)
{
	Rect2D r(bounds);
	if (r.w >= content.w)
	{
		r.x += content.x;
		r.w -= content.w;
	}
	else
		r.w = 0;
	if (r.h >= content.h)
	{
		r.y += content.y;
		r.h -= content.h;
	}
	else
		r.h = 0;
	return r;
}

Rect2D ImageSkin::GetContent()
{
	return content;
}



SolidButtonSkin::SolidButtonSkin(const ColorRGB& b, const ColorRGB& l, const ColorRGB& d)
: body(b), light(l), dark(d)
{ }

SolidButtonSkin::~SolidButtonSkin()
{ }

void SolidButtonSkin::BuildImage(Size2D b)
{
	image = OffscreenImage(b.w, b.h, OffscreenImage::RGBA32);
	Size2D z(image.GetSize());
	LockOffscreenImage goi(image);
	goi.Fill(body,Rect2D(z));

	if ((b.w > 2) && (b.h > 2))
	{
		Point2D nw(1,1);
		Point2D ne(b.w-2,1);
		Point2D sw(1,b.h-2);
		Size2D  hh(b.w-2,1);
		Size2D  vv(1,b.h-2);
		goi.Fill(light,Rect2D(nw, hh));
		goi.Fill(light,Rect2D(nw, vv));
		goi.Fill(dark,Rect2D(sw, hh));
		goi.Fill(dark,Rect2D(ne, vv));
	}
}
void SolidButtonSkin::Draw(Graphics& g, const Rect2D& bounds, const Rect2D& /*area*/)
{
	Size2D z(image.GetSize());
	if ((z.w != bounds.w) || (z.h != bounds.h))
	{ // need to redo the image cache according to the new size
		BuildImage(bounds.GetSize());
		z = image.GetSize();
	}

//	Rect2D dst(GetLocalBounds());
//	Rect2D clip(g.GetClipRect());
//	g.SetClipRect(area);
	g.DrawImage(image, bounds, bounds);
//	g.SetClipRect(clip);
}

Rect2D SolidButtonSkin::GetContent(const Rect2D& bounds)
{
	Rect2D r(bounds);
	if (r.w > 2)
	{
		r.x += 1;
		r.w -= 2;
	}
	else
		r.w = 0;
	if (r.h > 2)
	{
		r.y += 1;
		r.h -= 2;
	}
	else
		r.h = 0;
	return r;
}
Rect2D SolidButtonSkin::GetContent()
{
	return Rect2D(Point2D(1,1),Size2D(2,2));
}


} // namespace XSP
