/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

#if 0
#pragma mark MViewAdmin
#endif

class MViewAdmin : public View::ViewListener
{
	MView* mview;
public:
	MViewAdmin(MView* v)  : mview(v) {}
	~MViewAdmin()	      { CancelListener(); }
	void CancelListener() {	mview = 0;	super::CancelListener(); }
protected:
//	virtual void ViewClosed(View* view);
	virtual void ChildAddRemove(bool added, const View::owner& child, View* view)
	{
	    if (!(mview != 0 && view == mview)) return;
	    if (added)
	    {
			Rect2D bounds = mview->GetSkinContentBounds();
			child->SetBounds(bounds);
			if (!child->IsHidden())
				child->Hide(true);
			if (mview->GetCurrentView() == 0)
				child->Hide(false); // first addition is automatically shown
	    }
	    else if (!child->IsHidden()) 
	    {   //  this was the selected one, must select another
	    	mview->GoToFirstView();
	    }
	}
//	virtual void ViewShowHide(bool hide, View* view);
//	virtual void ViewStateChange(uint32 oldState, uint32 newState, View* view);
//	virtual void ViewBoundsChange(const Rect2D& oldBounds, const Rect2D& newBounds, View* view)
}; // MViewAdmin

MView::MView()
{
	 vlistener = new MViewAdmin(this);
	 AddListener(vlistener);
}

MView::~MView()
{
	vlistener = 0;
}

void MView::SetBounds(const Rect2D& bounds)
{
	View::SetBounds(bounds);
	Rect2D cont = GetSkinContentBounds();

	const Children& children = GetChildren();
	Children::const_iterator b = children.begin();
	Children::const_iterator e = children.end();
	for(; b!=e; ++b) 
		if (!(*b)->IsHidden()) 
			(*b)->SetBounds(cont);
}

View::owner MView::GetCurrentView()
{
	const Children& children = GetChildren();
	Children::const_iterator b = children.begin();
	Children::const_iterator e = children.end();
	// find the child currently showing
	Children::const_iterator c = b;
	for(; c!=e; ++c) 
	{ 
		if (!(*c)->IsHidden()) 
			return *c; 
	}
	return 0;
}

void MView::GoToFirstView()
{
	const Children& children = GetChildren();
	Children::const_iterator b = children.begin();
	Children::const_iterator e = children.end();
	if (b != e)
		GoToView(*b);
}

void MView::GoToView(const owner& view)
{
	if (view != 0)
	{
		const owner& parent = view->GetParent();
		if (parent != this)
		{
			ASSERT(false);
			return;
		}

		if (!view->IsHidden()) // that view already is the one showing
			return;
	}
	bool rfsh = false;
	// we need to hide the old one
    owner current = GetCurrentView();
	if (current != 0)
	{
		current->Hide(true);
		rfsh = true;
	}	
	if (view != 0)
	{
		Rect2D cont = GetSkinContentBounds();
		if (cont != view->GetBounds())
			view->SetBounds(cont);
		view->Hide(false);
		view->SetFocused();
		rfsh = true;
	}	
	if(rfsh)
		Refresh();	
}


} // namespace XSP
