/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{
#if TARGET_API_Darwin || TARGET_API_Linux

ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b)
{
	0[(uint8*)&rgba] = b;
	1[(uint8*)&rgba] = g;
	2[(uint8*)&rgba] = r;
	3[(uint8*)&rgba] = 0xff;
}
ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b, uint8 a)
{
	uint64 n = 0;
	0[(uint8*)&n] = b;
	2[(uint8*)&n] = g;
	4[(uint8*)&n] = r;
	n *= 1U+a;
	0[(uint8*)&rgba] = 1[(uint8*)&n];
	1[(uint8*)&rgba] = 3[(uint8*)&n];
	2[(uint8*)&rgba] = 5[(uint8*)&n];
	3[(uint8*)&rgba] = a;
}

uint8 ColorRGB::Red() const
{
	return 2[(uint8*)&rgba];
}
uint8 ColorRGB::Green() const
{
	return 1[(uint8*)&rgba];
}
uint8 ColorRGB::Blue() const
{
	return 0[(uint8*)&rgba];
}
uint8 ColorRGB::Alpha() const
{
	return 3[(uint8*)&rgba];
}

#endif
} // namespace XSP
