/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#if TARGET_API_Win32 || TARGET_API_Win32_Console
#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

#if 0
#pragma mark class DialogButtonListener
#endif

class DialogButtonListener : public ButtonView::ActionListener
{
	DialogWindow* dw;
public:
	DialogButtonListener(DialogWindow* dwnd) : dw(dwnd)	{ }
	~DialogButtonListener() { CancelListener(); }
	void CancelListener()   { dw=0; super::CancelListener(); }
protected:
	virtual void ActionPerform(ButtonView* button)
	{
		if (dw == 0)
			return;
		if (dw->buttonOk == button)
			dw->DialogEventOk();
		else if (dw->buttonCancel == button)
			dw->DialogEventCancel();
		else if (dw->buttonApply == button)
			dw->DialogEventApply();
	}
}; // class DialogButtonListener

#if 0
#pragma mark class DialogWindowListener
#endif

class DialogWindowListener : public Window::WindowListener
{
	refc<DialogWindow> dw; // keeps the dialog alive while the window exists
public:
	DialogWindowListener(DialogWindow* dwnd) : dw(dwnd)	{ }
	~DialogWindowListener() { CancelListener(); }
	void CancelListener()   { dw=0; super::CancelListener(); }
protected:
	virtual void Closed(Window& w)
	{
		if (dw == 0)
			return;
		if (dw->dialogW == w)
		{
			dw->DialogEventCancel();
			dw = 0; // kill the dialog too
		}
	}
	virtual void BoundsChanged(Window& w)
	{
		if (dw == 0)
			return;
		if (dw->dialogW == w)
		{
			dw->DoLayout();
		}
	}
	//virtual void Activated(Window& w, bool on);
}; // class DialogWindowListener

DialogWindow::DialogWindow()
{
}

DialogWindow::~DialogWindow()
{
}

void DialogWindow::CreateFrame(Window& pW)
{
	parentW = pW;
	dialogW = parentW.PopupDialog();
	dialogW.AddListener(new DialogWindowListener(this));
	dialogW.GetContent()->SetFocusable(true);
}

void DialogWindow::CreateFrame(WinMgr& mgr)
{
	dialogW = Window(mgr);
	dialogW.AddListener(new DialogWindowListener(this));
	dialogW.GetContent()->SetFocusable(true);
}

void DialogWindow::Populate( DialogStyle ds )
{
	ButtonView::ActionListener::owner dbl(new DialogButtonListener(this));
	if (0 != (ds & DialogOk))
	{
	    AddDlgButton(buttonOk = new ButtonView(),dbl,String::From_c_str("Ok"));
	    buttonOk->SetDefaultButton(true);
	}
	if (0 != (ds & DialogCancel))
	    AddDlgButton(buttonCancel = new ButtonView(),dbl,String::From_c_str("Cancel"));
	if (0 != (ds & DialogApply))
	    AddDlgButton(buttonApply = new ButtonView(),dbl,String::From_c_str("Apply"));
}

void DialogWindow::AddDlgButton(const refc<ButtonView>& bt, 
								const ButtonView::ActionListener::owner& dbl,
								const String& text )
{
	dialogW.AddView(bt.operator->());
	bt->AddActionListener(dbl);

	bt->SetText(text);
	bt->SetFont(dlgFont);
	bt->SetTextAlign(Rect2D::C, Rect2D::C);
	if (bt->GetSkin() == 0)
		bt->SetSkin(dlgSkin->GetPart(String::From_c_str("Button")) ); 
	bt->SetFocusable(true);
}

void DialogWindow::AddToolButton(const refc<ButtonView>& bt, 
								const ButtonView::ActionListener::owner& dbl,
								const String& text )
{
	dialogW.AddView(bt.operator->());
	bt->AddActionListener(dbl);

	bt->SetFont(dlgFont);
	bt->SetTextAlign(Rect2D::C, Rect2D::C);
	if (bt->GetSkin() == 0)
		bt->SetSkin(dlgSkin->GetPart(text) ); 
	bt->SetFocusable(true);
}


void DialogWindow::DoLayout()
{
	if (dialogW == 0) return;
 	Rect2D cb(dialogW.GetContentSize());
	if (cb.isEmpty()) 	return;

	Rect2D br;  
	br.x=cb.w-4; br.w=64; br.h=24; br.y=cb.h-br.h-12;  
	
	if (buttonCancel != 0)
	{
		br.x-=br.w+4;
		buttonCancel->SetBounds(br);
	}
	if (buttonOk != 0)
	{
		br.x-=br.w+4;
		buttonOk->SetBounds(br);
	}
	if (buttonApply != 0)
	{
		br.x-=br.w+4;
		buttonApply->SetBounds(br);
	}
}

void DialogWindow::SetTitle(const String& title)
{
	dialogW.SetTitle(title);
}
void DialogWindow::SetContentBoundsOnScreen(const Rect2D& lr)
{
	dialogW.SetContentBoundsOnScreen(lr);
}
void DialogWindow::SetSkin(	const ViewSkin::owner& skin,
							const TextFont& font )
{
	dlgSkin = skin;
	dlgFont = font;
}
void DialogWindow::Show()
{
	DoLayout();
	dialogW.GetContent()->ActionFocusFirstChild();	
	dialogW.Show(true);
}

void DialogWindow::DialogEventApply()
{
}
void DialogWindow::DialogEventOk()
{
	dialogW.Close();
}
void DialogWindow::DialogEventCancel()
{
	dialogW.Close();
}


} // namespace XSP
#endif
