/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

Codec::~Codec()
{
}

void Codec::ReportCompleted(const OffscreenImage& image)
{
	for (Listener::each e(progressListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->Completed(image);
}	

void Codec::ReportError(const Exception& err)
{
	for (Listener::each e(progressListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->Failed(err);
}	



#if 0
#pragma mark class ImagePool::OnCodecNotification
#endif

class ImagePool::OnCodecNotification : public Codec::Listener
{
	ImagePool* imgPool;
protected:
	virtual void Completed(const OffscreenImage& image)
	{
		if (imgPool != 0)
			imgPool->ImageLoadedCallback(image);
	}
	virtual void Failed(const Exception& err)
	{
		if (imgPool != 0)
			imgPool->ImageFailedCallback(err);
	}
	virtual void CancelListener() 
	{ 
		imgPool = 0; 
		super::CancelListener(); 
	}

public:
	OnCodecNotification(ImagePool& pool)
	: imgPool(&pool)
	{
	}
	
	~OnCodecNotification() 
	{ 
		CancelListener(); 
	}
}; // class ImagePool::OnCodecNotification

#if 0
#pragma mark class ImagePool::LoadMoreImage
#endif

class ImagePool::LoadMoreImage : public Event_Abstract
{
	ImagePool* imgPool;
public:
	Codec::owner codec;
	OpenedFile ofile;
	OpenedFile::file_size ofpos;
	String	theBuf; // read here 
public:
	LoadMoreImage(ImagePool& pool)
	: imgPool(&pool)
	{
		theBuf.resize(16000);
	}
	void AskForMore()
	{
		XSP::CoreModule::_instance->mainLoop->PostEvent(this, true);
	}
	
protected:
	virtual ~LoadMoreImage()
	{
		imgPool = 0;
	}
	virtual void Run()
	{
		if (imgPool != 0)
		{
			refc<ImagePool> keepAlive(imgPool);
			imgPool->LoadMoreImageCallback();
		}
	}
public:
	virtual void Cancel()
	{
		imgPool = 0;
		Event_Abstract::Cancel();
	}
};  // class LoadMoreImage


ImagePool::ImagePool()
: imageID(0)
{}

ImagePool::~ImagePool()
{
	toLoad.clear();
	images.clear();
	imageFiles.clear();
}

void ImagePool::Load(const FileName& fname)
{
	ImageFiles::iterator where = imageFiles.find(fname);
	if (where != imageFiles.end())
		return; // we already have that image
	
	toLoad.insert(ImageFiles::value_type(fname, imageID++));

	if (loadMoreImage == 0)
	{   // start loading
		loadMoreImage = new LoadMoreImage(*this);
		LoadNextImage();
	}
}

void ImagePool::LoadNextImage()
{
	if (toLoad.empty())
	{   // we're done loading, lay down for a while 
		if (loadMoreImage != 0)
			loadMoreImage->Cancel();
		loadMoreImage = 0;
		NotifyCompleted();
		return;
	}			  

	const ImageFiles::value_type& fi = *toLoad.begin();
	const FileName& fname = fi.first;

	// ToDo add a way to decode more than just PNGs
	VERIFY(loadMoreImage->codec == 0);

	// a new image requires a new codec , the factory must be initialized at app level
	VERIFY(GUI_Module::_instance != 0);
	loadMoreImage->codec = GUI_Module::_instance->codecFactory->CreateCodec(fname);

	loadMoreImage->codec->progressListeners.Add(
		new OnCodecNotification(*this));

	try
	{
		loadMoreImage->ofile = OpenedFile(fname);
		loadMoreImage->ofpos = 0;
	}
	catch(const Exception& err)
	{   // failed to open the file
		ImageFailedCallback(err);
		// this has set the codec to null, next file to follow
	}
	// next iteration we try to do the reading and decoding
	loadMoreImage->AskForMore();
}
					 
void ImagePool::LoadMoreImageCallback()
{
	if (loadMoreImage->codec != 0)
	{
		OpenedFile::block_size z = loadMoreImage->ofile.Read(
			loadMoreImage->ofpos, 
			loadMoreImage->theBuf.begin(), 
			loadMoreImage->theBuf.length() );	
		loadMoreImage->codec->Decode(
			loadMoreImage->theBuf.begin(), 
			z );	
		loadMoreImage->ofpos += z;
		if (z == 0)
			loadMoreImage->codec = 0;
	}
    // end of file or codec reported something and was therefore removed
	if (loadMoreImage->codec == 0)
	{
		toLoad.erase(toLoad.begin());	 // done with this
		LoadNextImage();
	}
	if (loadMoreImage != 0) // need to read some more
		loadMoreImage->AskForMore();
}

void ImagePool::ImageLoadedCallback(const OffscreenImage& image)
{
	const ImageFiles::value_type& fi = *toLoad.begin();
	const FileName& fname = fi.first;
	imageFiles.insert(fi);
	if (images.size() <= fi.second)
		images.resize(fi.second+1);
//	images.insert(images.begin()+fi.second,image);
	images[fi.second] = image;
	loadMoreImage->codec = 0;
	NotifyCompleted(fname, image);
}

void ImagePool::ImageFailedCallback(const Exception& err)
{
	const ImageFiles::value_type& fi = *toLoad.begin();
	const FileName& fname = fi.first;
	loadMoreImage->codec = 0;
	// build our more explicit error
	Exception err2(XSPMSG(0,"Cannot load image $1;"));
	err2.Param(fname.GetFullPathNameOS());
	err2.Because(err);
	// report our failure to the listeners
	NotifyFailed(fname, err2);
}

void ImagePool::NotifyCompleted()
{
	for (Listener::each e(progressListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->Completed();
}
void ImagePool::NotifyCompleted( const FileName& fname
							   , const OffscreenImage& image )
{
	for (Listener::each e(progressListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->Completed(fname,image);
}
void ImagePool::NotifyFailed( const FileName& fname
							, const Exception& err )
{
	for (Listener::each e(progressListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->Failed(fname,err);
}
void ImagePool::CancelAllDownloads()
{
	toLoad.clear();
	if (loadMoreImage != 0)
		loadMoreImage->Cancel();
	loadMoreImage = 0;
}

uint32 ImagePool::ImageCount() const
{
	return images.size();
}

const OffscreenImage& ImagePool::GetImage(uint32 n) const
{
	VERIFY(n < images.size());
	return images[n];
}


} // namespace XSP
