/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

#if 0
#pragma mark OsIcon
#endif
/*  
	OsIcon uses platform specific code to draw, meaning that a windows Icon
	can only be drawn on a windows machine. What we would like is to have 
	routines capable of manipulating windows icons on mac and linux too, but 
	we do not have platform independent code to manipulate icons at this time. 
*/
#if TARGET_API_Win32 || TARGET_API_Win32_Console

	class OsIcon
	{
	private:
		HICON	hIcon;
		bool toBeDeleted; // If true, I'm responsible for destroying this HICON.
	public:
		OsIcon()
		: hIcon(NULL) , toBeDeleted(false)
		{
		}
		~OsIcon()
		{
			if (toBeDeleted && hIcon != NULL)
				::DestroyIcon(hIcon);
		}
		Size2D GetSize() const
		{
			ICONINFO info;
			if ( ! ::GetIconInfo(hIcon, &info) )
				return Size2D(); 
	        BITMAP bmp;
    		::GetObject( info.hbmMask, sizeof(bmp), &bmp );
			return Size2D(bmp.bmWidth, bmp.bmHeight/2); // half the height is for the mask
		}
//		void DrawTo(Graphics& g, const Point2D& where)
	}; // class OsIcon

#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0

	class OsIcon
	{
	private:
		IconRef	rIcon;
		bool toBeDeleted; // If true, I'm responsible for destroying this HICON.
	public:
		OsIcon()
		: rIcon(NULL) , toBeDeleted(false)
		{
		}
		~OsIcon()
		{
			if (toBeDeleted && rIcon != NULL)
				::ReleaseIconRef(rIcon);
		}
		Size2D GetSize() const
		{
			if (rIcon == NULL)
				return Size2D();
			return Size2D(48,48); // from old HL20 code ...  ToDo 
		}
//		void DrawTo(Graphics& g, const Point2D& where)
	}; // class OsIcon

#elif TARGET_API_Darwin || TARGET_API_Linux

	// no OSIcon yet

#endif
} // namespace XSP
