/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr14-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"

namespace XSP
{
#if TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon 

static void _MacFS_Fail(OSErr err, const FileName& fn)
{
	if (err == noErr)
		return;

	uint32 ern = 0;
	switch(err)
	{
	case dirFulErr: ern=XSPMSG(1,"File directory full"); break;
	case dskFulErr: ern=XSPMSG(2,"Disk or volume full"); break;
	case nsvErr: ern=XSPMSG(3,"Volume not found"); break;
	case ioErr: ern=XSPMSG(4,"I/O error."); break;
	case bdNamErr: ern=XSPMSG(5,"Bad filename or volume name"); break;
	case fnOpnErr: ern=XSPMSG(6,"File not open."); break;
	case eofErr: ern=XSPMSG(7,"Logical end-of-file reached."); break;
	case posErr: ern=XSPMSG(8,"Attempt to position mark before the start of the file."); break;
	case mFulErr: ern=XSPMSG(9,"Memory full (open) or file won't fit (load)"); break;
	case tmfoErr: ern=XSPMSG(10,"Too many files open"); break;
	case fnfErr: ern=XSPMSG(11,"File or directory not found; incomplete pathname"); break;
	case wPrErr: ern=XSPMSG(12,"Volume is locked through hardware"); break;
	case fLckdErr: ern=XSPMSG(13,"File is locked. "); break;
	case vLckdErr: ern=XSPMSG(14,"Volume is locked through software"); break;
	case fBsyErr: ern=XSPMSG(15,"One or more files are open, File is busy, Directory is not empty."); break;
	case dupFNErr: ern=XSPMSG(16,"Duplicate filename and version, Destination file already exists, File found instead of folder"); break;
	case opWrErr: ern=XSPMSG(17,"File already open for writing"); break;
	case volOffLinErr: ern=XSPMSG(18,"Volume is offline"); break;
	case permErr: ern=XSPMSG(19,"Attempt to open locked file for writing"); break;
	case volOnLinErr: ern=XSPMSG(20,"Volume already online"); break;
	case nsDrvErr: ern=XSPMSG(21,"No such drive"); break;
	case noMacDskErr: ern=XSPMSG(22,"Not a Macintosh disk"); break;
	case extFSErr: ern=XSPMSG(23,"Volume belongs to an external file system"); break;
	case fsRnErr: ern=XSPMSG(24,"Problem during rename"); break;
	case badMDBErr: ern=XSPMSG(25,"Bad master directory block"); break;
	case wrPermErr: ern=XSPMSG(26,"Read/ write permission doesnt allow writing."); break;
	case noDriveErr: ern=XSPMSG(27,"Drive not installed"); break;
	case dirNFErr: ern=XSPMSG(28,"Directory not found or incomplete pathname"); break;
	case tmwdoErr: ern=XSPMSG(29,"Too many working directories open"); break;
	case badMovErr: ern=XSPMSG(30,"Attempt to move"); break;
	case wrgVolTypErr: ern=XSPMSG(31,"Volume does not support Desktop Manager"); break;
	case volGoneErr: ern=XSPMSG(32,"Server volume has been disconnected"); break;
	case fsmFFSNotFoundErr: ern=XSPMSG(33,"Foreign File system does not exist"); break;
	case fsmBusyFFSErr: ern=XSPMSG(34,"File system is busy, cannot be removed"); break;
	case fsmBadFFSNameErr: ern=XSPMSG(35,"Name length not 1 <= length <= 31"); break;
	case fsmBadFSDLenErr: ern=XSPMSG(36,"FSD size incompatible with current FSM vers"); break;
	case fsmDuplicateFSIDErr: ern=XSPMSG(37,"FSID already exists on InstallFS"); break;
	case fsmBadFSDVersionErr: ern=XSPMSG(38,"FSM version incompatible with FSD"); break;
	case fsmNoAlternateStackErr: ern=XSPMSG(39,"no alternate stack for HFS CI"); break;
	case driverHardwareGoneErr: ern=XSPMSG(40,"disk driver's hardware was disconnected"); break;
	case fidNotFound: ern=XSPMSG(41,"File ID not found"); break;
	case fidExists: ern=XSPMSG(42,"File ID already exists"); break;
	case notAFileErr: ern=XSPMSG(43,"Specified file is a directory"); break;
	case diffVolErr: ern=XSPMSG(44,"Files on different volumes"); break;
	case catChangedErr: ern=XSPMSG(45,"Catalog has changed and catalog position record may be invalid"); break;
	case sameFileErr: ern=XSPMSG(46,"Cant exchange a file with itself"); break;
	case badFidErr: ern=XSPMSG(47,"File ID is dangling or doesnt match with the file number"); break;
	case notARemountErr: ern=XSPMSG(48,"Mount allows only remounts and doesnt get one"); break;
	case fileBoundsErr: ern=XSPMSG(49,"Files EOF, offset, mark or size is too big"); break;
	case fsDataTooBigErr: ern=XSPMSG(50,"File or volume is too big for system"); break;
	case volVMBusyErr: ern=XSPMSG(51,"Cant eject because volume is in use by VM"); break;
	case errFSBadForkName: ern=XSPMSG(52,"A supplied fork name was invalid "); break;
	case errFSNameTooLong: ern=XSPMSG(53,"A file or fork name was too long. This means that the given name could never exist; this is different from a file not found or errFSForkNotFound error."); break;
	case errFSForkExists: ern=XSPMSG(54,"An attempt to create a fork, but that fork already exists."); break;
	case afpAccessDenied: ern=XSPMSG(55,"User does not have the correct access to the file, Directory cannot be shared"); break;
	case afpBadUAM: ern=XSPMSG(56,"User authentication method is unknown"); break;
	case afpBadVersNum: ern=XSPMSG(57,"Workstation is using an AFP version that the server doesnt recognize"); break;
	case afpBitmapErr: ern=XSPMSG(58,"Bitmap contained bits undefined for call"); break;
	case afpCantMove: ern=XSPMSG(59,"Move destination is offspring of source or root was specified"); break;
	case afpDenyConflict: ern=XSPMSG(60,"Requested user permission not possible"); break;
	case afpDirNotEmpty: ern=XSPMSG(61,"Cannot delete non-empty directory"); break;
	case afpDiskFull: ern=XSPMSG(62,"Insufficient free space on volume for operation"); break;
	case afpEofError: ern=XSPMSG(63,"Read beyond logical end-of-file"); break;
	case afpFileBusy: ern=XSPMSG(64,"Cannot delete an open file"); break;
	case afpFlatVol: ern=XSPMSG(65,"Cannot create directory on specified volume"); break;
	case afpItemNotFound: ern=XSPMSG(66,"Unknown user name/ user ID or missing comment / APPL entry"); break;
	case afpLockErr: ern=XSPMSG(67,"Some or all of requested range is locked by another user"); break;
	case afpNoMoreLocks: ern=XSPMSG(68,"No more ranges can be locked"); break;
	case afpNoServer: ern=XSPMSG(69,"Server is not responding"); break;
	case afpObjectExists: ern=XSPMSG(70,"Specified destination file or directory already exists"); break;
	case afpObjectNotFound: ern=XSPMSG(71,"Specified file or directory does not exist"); break;
	case afpParmErr: ern=XSPMSG(72,"A specified parameter was out of allowable range"); break;
	case afpRangeNotLocked: ern=XSPMSG(73,"Specified range was not locked"); break;
	case afpRangeOverlap: ern=XSPMSG(74,"Part of range is already locked"); break;
	case afpSessClosed: ern=XSPMSG(75,"Session closed"); break;
	case afpUserNotAuth: ern=XSPMSG(76,"User authentication failed (usually, password is not correct)"); break;
	case afpObjectTypeErr: ern=XSPMSG(77,"A directory exists with that name, Directory not found, Folder locking not supported by volume, Object was a file, not a directory"); break;
	case afpTooManyFilesOpen: ern=XSPMSG(78,"Maximum open file coun reached"); break;
	case afpServerGoingDown: ern=XSPMSG(79,"Server is shutting down"); break;
	case afpCantRename: ern=XSPMSG(80,"AFPRename cannot rename volume"); break;
	case afpDirNotFound: ern=XSPMSG(81,"Unknown directory specified"); break;
	case afpIconTypeError: ern=XSPMSG(82,"Icon size specified is different from existing icon size"); break;
	case afpVolLocked: ern=XSPMSG(83,"Volume is read-only"); break;
	case afpObjectLocked: ern=XSPMSG(84,"Object is M/R/D/W inhibited"); break;
	case afpContainsSharedErr: ern=XSPMSG(85,"The directory contains a share point"); break;
	case afpIDNotFound: ern=XSPMSG(86,"File ID not found"); break;
	case afpIDExists: ern=XSPMSG(87,"File ID already exists"); break;
	case afpCatalogChanged: ern=XSPMSG(88,"Catalog has changed and search cannot be resumed"); break;
	case afpSameObjectErr: ern=XSPMSG(89,"Source and destination files are the same"); break;
	case afpBadIDErr: ern=XSPMSG(90,"File ID not found"); break;
	case afpPwdSameErr: ern=XSPMSG(91,"Someone tried to change their password to the same password on a mandatory password change"); break;
	case afpPwdTooShortErr: ern=XSPMSG(92,"The password being set is too short: there is a minimum length that must be met or exceeded"); break;
	case afpPwdExpiredErr: ern=XSPMSG(93,"Password has expired on server"); break;
	case afpInsideSharedErr: ern=XSPMSG(94,"The directory is inside a shared directory"); break;
	case afpInsideTrashErr: ern=XSPMSG(95,"The folder being shared is inside the trash folder OR the shared folder is being moved into the trash folder"); break;
	case afpPwdNeedsChangeErr: ern=XSPMSG(96,"The password needs to be changed"); break;
	case afpPwdPolicyErr: ern=XSPMSG(97,"Password does not conform to servers password policy"); break;
	case afpAlreadyLoggedInErr: ern=XSPMSG(98,"User has been authenticated but is already logged in from another machine (and that's not allowed on this server)"); break;
	case afpBadDirIDType: ern=XSPMSG(99,"Not a fixed directory ID volume"); break;
	case afpCantMountMoreSrvre: ern=XSPMSG(100,"Maximum number of volumes has been mounted"); break;
	case afpAlreadyMounted: ern=XSPMSG(101,"Volume already mounted"); break;
	case afpSameNodeErr: ern=XSPMSG(102,"Attempt to log on to a server running on the same machine"); break;
	default: ern=XSPMSG(103,"OS filesystem error ($2;) while accessing file '$1;'"); break;
	};

	Exception(ern)
		.Param(fn.GetFullPathNameMac())
		.Param(static_cast<sint32>(err))
		.Raise();
}
/*
static OSErr _MacLocationFromFullPath(short fullPathLength,
									 const void *fullPath,
									 FSSpec *spec)
{
	AliasHandle	alias;
	OSErr		result;
	Boolean		wasChanged;
	Str32		nullString;
	
	nullString[0] = 0;	
	result = ::NewAliasMinimalFromFullPath(fullPathLength, fullPath, nullString, nullString, &alias);
	if ( result == noErr )
	{
		result = ::ResolveAlias(NULL, alias, spec, &wasChanged);
		if ( spec->vRefNum == 0 )
		{
			spec->parID = 0;
			spec->name[0] =  0;
			result = nsvErr;
		}
		::DisposeHandle((Handle)alias);
	}
	return result;
}
*/

bool FileName::Exists() const
{
    String fnOS(GetFullPathNameMac(false));
	FSSpec spec;
	OSErr err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
	if (err == fnfErr)
	{
		fnOS = GetFullPathNameMac(true);
		err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
		if (err == dirNFErr)
			return false;
	}
	if (err != noErr)
		_MacFS_Fail(err, *this); 
    return true;
}

bool FileName::IsDir() const
{
    String fnOS(GetFullPathNameMac(true));
	FSSpec spec;
	OSErr err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
	return (err == noErr);
}

bool FileName::IsLink() const
{
	return false;  // ToDo 
}

void FileName::Delete() const
{
    String fnOS(GetFullPathNameMac(false));
	FSSpec spec;
	OSErr err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
	if (err == fnfErr)
	{
		fnOS = GetFullPathNameMac(true);
		err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
		if (err == dirNFErr)
			return;
	}
	if (err != noErr)
		_MacFS_Fail(err, *this); 

	err = ::FSpDelete(&spec);
	if (err != noErr)
		_MacFS_Fail(err, *this); 
}

void FileName::CreateDir(bool deep) const
{
	OSErr err = noErr;
	{
	    String fnOS(GetFullPathNameMac(true));
		FSSpec spec;
		err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
		if (err == dirNFErr)
		{   // but to create the folder we need the filename instead of the foldername
			fnOS = GetFullPathNameMac(false);
			err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
			if ((err == noErr) || (err == fnfErr))
			{
		    	long dirID;
				err = ::FSpDirCreate(&spec, smSystemScript, &dirID);
			}
		}
	}
	if (err != noErr)
	{
		if (deep && HasParent())
		{   // recursively deal with the parent
			GetParent().CreateDir(true); 
			CreateDir(false); // try again
		}
		else
		{
			_MacFS_Fail(err, *this); 
	    }
	}
}


#pragma mark -

FileList::FileList(const FileName& fname)
: ref(new _Data())
{
    String fnOS(fname.GetFullPathNameMac(true));
	FSSpec spec;
	OSErr err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec); 
	if (err != noErr)
		_MacFS_Fail(err, fname); 

	Str255 theNameBuf;
	CInfoPBRec pb;
	if ((spec.name==0) || (spec.name[0]==0))
	{
	    theNameBuf[0] = 0;
		pb.dirInfo.ioNamePtr = theNameBuf;
		pb.dirInfo.ioFDirIndex = -1;	/* use ioDirID */
	}
	else
	{
		pb.dirInfo.ioNamePtr = (StringPtr)spec.name;
		pb.dirInfo.ioFDirIndex = 0;	/* use ioNamePtr and ioDirID */
	}
	pb.dirInfo.ioVRefNum = spec.vRefNum;
	pb.dirInfo.ioDrDirID = spec.parID;
	err = ::PBGetCatInfoSync( &pb );  
	if (err != noErr)
		_MacFS_Fail(err, fname); 
	bool fIsDir = ((pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0);
    if (!fIsDir)
		_MacFS_Fail(afpDirNotFound, fname); 
	//	pb.hFileInfo.ioDirID = was set to the desired folder
    long dirID = pb.dirInfo.ioDrDirID;
	pb.hFileInfo.ioFDirIndex = 0;  // init file index
    
	for(;;)
	{
		pb.hFileInfo.ioVRefNum = spec.vRefNum;
		theNameBuf[0] = 0;
		pb.hFileInfo.ioNamePtr = (StringPtr)&theNameBuf;
		pb.dirInfo.ioDrDirID = dirID;
		// set the file number within the dir that we are interested in
		pb.hFileInfo.ioFDirIndex++;
		
		// get info about the file
		err = ::PBGetCatInfoSync( &pb );
		if( err != noErr )
			break;
			
		FileProperties props;
		props.SetFileName(FileName::From(fname, String::From_p_str(theNameBuf)));	
	    fIsDir	 = ((pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0);
	    if (fIsDir)
	    {
	        props.SetProperty(FileProperties::IsDir, String::kEmpty);
	    	if (0 != (pb.dirInfo.ioDrUsrWds.frFlags  & kIsInvisible))
	        	props.SetProperty(FileProperties::IsHidden, String::kEmpty);
	        props.SetProperty(FileProperties::Size, String::From_uint32(pb.dirInfo.ioDrNmFls));
	        props.SetProperty( FileProperties::IconLocation
	        	             , String::From_sint32(pb.dirInfo.ioDrUsrWds.frLocation.h)
	        	             + String::From_c_str(":")
	        	             + String::From_sint32(pb.dirInfo.ioDrUsrWds.frLocation.v));

	        LocalTime dt(LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrCrDat));
	        props.SetProperty( FileProperties::CreationTime, dt.ToString());
	        dt = LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrMdDat);
	        props.SetProperty( FileProperties::ModifyTime, dt.ToString());
	        dt = LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrBkDat);
	        props.SetProperty( FileProperties::BackupTime, dt.ToString());
	        // pb.dirInfo.ioDrUsrWds.frView; view mode (list, icon, small icon....)
	    }
	    else
	    {
			if (0 != (pb.hFileInfo.ioFlFndrInfo.fdFlags & kIsInvisible))
	        	props.SetProperty(FileProperties::IsHidden, String::kEmpty);
			//    kHasCustomIcon, kHasBundle, kIsInvisible, kIsAlias
	        props.SetProperty(FileProperties::Size, String::From_uint32(pb.hFileInfo.ioFlLgLen));
	        props.SetProperty(FileProperties::ResourceForkSize, String::From_uint32(pb.hFileInfo.ioFlRLgLen));
			if (pb.hFileInfo.ioFlFndrInfo.fdType != 0)
		        props.SetProperty(FileProperties::MacType,
		        	String(reinterpret_cast<const char*>(&pb.hFileInfo.ioFlFndrInfo.fdType)
		        		  ,sizeof(pb.hFileInfo.ioFlFndrInfo.fdType)));
			if (pb.hFileInfo.ioFlFndrInfo.fdCreator != 0)
		        props.SetProperty(FileProperties::MacCreator,
		        	String(reinterpret_cast<const char*>(&pb.hFileInfo.ioFlFndrInfo.fdCreator)
		        		  ,sizeof(pb.hFileInfo.ioFlFndrInfo.fdCreator)));
	        props.SetProperty( FileProperties::IconLocation
	        	             , String::From_sint32(pb.hFileInfo.ioFlFndrInfo.fdLocation.h)
	        	             + String::From_c_str(":")
	        	             + String::From_sint32(pb.hFileInfo.ioFlFndrInfo.fdLocation.v));
			
	        LocalTime ft(LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlCrDat));
	        props.SetProperty( FileProperties::CreationTime, ft.ToString());
	        ft = LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlMdDat);
	        props.SetProperty( FileProperties::ModifyTime, ft.ToString());
	        ft = LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlBkDat);
	        props.SetProperty( FileProperties::BackupTime, ft.ToString());
	    }
	    ref->items.push_back(props);
	}
}

FileProperties::FileProperties(const FileName& fname)
: ref(new _Data())
{
	bool fIsDir = false;
    String fnOS(fname.GetFullPathNameMac(false));
	FSSpec spec;
	OSErr err = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
	if (err == fnfErr)
	{
		fnOS = fname.GetFullPathNameMac(true);
		OSErr err2 = ::FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
		if (err2 == noErr)
		{
			err = noErr;
			fIsDir = true;
		} 
	}
	if (err != noErr)
		_MacFS_Fail(err, fname); 

	CInfoPBRec pb;
	pb.dirInfo.ioNamePtr = (StringPtr)spec.name;
	pb.dirInfo.ioFDirIndex = 0;	/* use ioNamePtr and ioDirID */
	pb.dirInfo.ioVRefNum = spec.vRefNum;
	pb.dirInfo.ioDrDirID = spec.parID;

	err = ::PBGetCatInfoSync( &pb );  
	if (err != noErr)
		_MacFS_Fail(err, fname); 

	VERIFY(fIsDir == ((pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0));

	SetFileName(fname);	
    if (fIsDir)
    {
        SetProperty(FileProperties::IsDir, String::kEmpty);
    	if (0 != (pb.dirInfo.ioDrUsrWds.frFlags  & kIsInvisible))
        	SetProperty(FileProperties::IsHidden, String::kEmpty);
        SetProperty(FileProperties::Size, String::From_uint32(pb.dirInfo.ioDrNmFls));
        SetProperty( FileProperties::IconLocation
        	             , String::From_sint32(pb.dirInfo.ioDrUsrWds.frLocation.h)
        	             + String::From_c_str(":")
        	             + String::From_sint32(pb.dirInfo.ioDrUsrWds.frLocation.v));

        LocalTime dt(LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrCrDat));
        SetProperty( FileProperties::CreationTime, dt.ToString());
        dt = LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrMdDat);
        SetProperty( FileProperties::ModifyTime, dt.ToString());
        dt = LocalTime::FromSecondsSince_1904Jan1(pb.dirInfo.ioDrBkDat);
        SetProperty( FileProperties::BackupTime, dt.ToString());
        // pb.dirInfo.ioDrUsrWds.frView; view mode (list, icon, small icon....)
    }
    else
    {
		if (0 != (pb.hFileInfo.ioFlFndrInfo.fdFlags & kIsInvisible))
        	SetProperty(FileProperties::IsHidden, String::kEmpty);
		//    kHasCustomIcon, kHasBundle, kIsInvisible, kIsAlias
        SetProperty(FileProperties::Size, String::From_uint32(pb.hFileInfo.ioFlLgLen));
        SetProperty(FileProperties::ResourceForkSize, String::From_uint32(pb.hFileInfo.ioFlRLgLen));
		if (pb.hFileInfo.ioFlFndrInfo.fdType != 0)
	        SetProperty(FileProperties::MacType,
	        	String(reinterpret_cast<const char*>(&pb.hFileInfo.ioFlFndrInfo.fdType)
	        		  ,sizeof(pb.hFileInfo.ioFlFndrInfo.fdType)));
		if (pb.hFileInfo.ioFlFndrInfo.fdCreator != 0)
	        SetProperty(FileProperties::MacCreator,
	        	String(reinterpret_cast<const char*>(&pb.hFileInfo.ioFlFndrInfo.fdCreator)
	        		  ,sizeof(pb.hFileInfo.ioFlFndrInfo.fdCreator)));
        SetProperty( FileProperties::IconLocation
        	             , String::From_sint32(pb.hFileInfo.ioFlFndrInfo.fdLocation.h)
        	             + String::From_c_str(":")
        	             + String::From_sint32(pb.hFileInfo.ioFlFndrInfo.fdLocation.v));
		
        LocalTime ft(LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlCrDat));
        SetProperty( FileProperties::CreationTime, ft.ToString());
        ft = LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlMdDat);
        SetProperty( FileProperties::ModifyTime, ft.ToString());
        ft = LocalTime::FromSecondsSince_1904Jan1(pb.hFileInfo.ioFlBkDat);
        SetProperty( FileProperties::BackupTime, ft.ToString());
    }
}

FileForkList::FileForkList(const FileName& fname)
: ref(new _Data())
{
	ref->filename = fname;
	if (fname.Exists())
	{
		ref->items.push_back(String::kEmpty);
		if (!fname.IsDir())
			ref->items.push_back(String::From_c_str("RESOURCE_FORK"));
	}
}



#pragma mark -

static String _GetAppName()
{
	OSErr err = noErr;
	ProcessSerialNumber	psn = {0};
    err = ::GetCurrentProcess(&psn);
    VERIFY(err == noErr);

	ProcessInfoRec	info = {0};
	FSSpec			theSpec = {0};

	info.processInfoLength	= sizeof(info);
	info.processAppSpec		= &theSpec;
	
	err = ::GetProcessInformation(&psn, &info);
    VERIFY(err == noErr);
	
	short	pathlen = 0;
	Handle	pathHandle = 0;

    err = ::GetFullPath(theSpec.vRefNum, theSpec.parID,
					theSpec.name, &pathlen, &pathHandle);
    VERIFY((err == noErr) && (0 != pathlen) && (0 != pathHandle));

	::HLock(pathHandle);

    String s(*pathHandle, (uint32)pathlen);

	::HUnlock(pathHandle);
	::DisposeHandle(pathHandle);

    return s;
}

static String _GetFolderName(OSType inFolderType)
{   
	// kOnSystemDisk kOnAppropriateDisk
	OSErr	err = noErr;
	short	volume = 0;
	long	dirID = 0;
	short   inVRefNum = kOnAppropriateDisk;

	err = ::FindFolder(inVRefNum, inFolderType, true, &volume, &dirID);
    VERIFY(err == noErr);
    
	short	fullPathLength = 0;
	Handle	fullPath = nil;

	err = ::GetFullPath(volume, dirID, "\p", &fullPathLength, &fullPath);
    VERIFY(err == noErr || err == fnfErr);
    VERIFY(fullPathLength != 0 && fullPath != 0);

	::HLock(fullPath);

    String s(*fullPath, (uint32)fullPathLength);

	::HUnlock(fullPath);
	::DisposeHandle(fullPath);

    return s;
}
	
SpecialFileNames::SpecialFileNames()
: ref(new _Data())
{
	{ SetFileName(TempDir, FileName::FromPathNameMac(_GetFolderName(kTemporaryFolderType))); }
	{ 
		FileName fn(FileName::FromPathNameMac(_GetFolderName(kSystemFolderType)));
		SetFileName(SystemDir, fn); 
		while (fn.HasParent())
			fn = fn.GetParent();
		SetFileName(MachineRoot, fn);
	}
	{ 
		FileName fn(FileName::FromPathNameMac(_GetFolderName(kDesktopFolderType)));
		SetFileName(UserDesktopDir, fn); 
		if (fn.HasParent())
			fn = fn.GetParent();
		SetFileName(UserHomeDir, fn); 
	}
	{
		FileName fn(FileName::FromPathNameMac(_GetAppName()));
		SetFileName(AppName, fn);
		if (fn.HasParent())
		{
			fn = fn.GetParent();
			SetFileName(AppDir, fn);
			SetFileName(ProcessWorkingDir, fn);
		}
	}	
	{ SetFileName(UserPreferencesDir, FileName::FromPathNameMac(_GetFolderName(kPreferencesFolderType))); }
	{ SetFileName(MachinePreferencesDir, FileName::FromPathNameMac(_GetFolderName(kSystemPreferencesFolderType))); }

	{ SetFileName(RecycleBinDir, FileName::FromPathNameMac(_GetFolderName(kTrashFolderType))); }
//	{ SetFileName(StartupDir, FileName::FromPathNameMac(_GetFolderName(kStartupFolderType))); }
//	{ SetFileName(ShutdownDir, FileName::FromPathNameMac(_GetFolderName(kShutdownFolderType))); }
//	{ SetFileName(MenuDir, FileName::FromPathNameMac(_GetFolderName(kAppleMenuFolderType))); }
//	{ SetFileName(ControlPanelDir, FileName::FromPathNameMac(_GetFolderName(kControlPanelFolderType))); }
}

#pragma mark -
// dmRdDenyWr=read_shared  dmRdWrDenyRdWr=exclusive   dmRdWr=shared

class OpenedFile::_Data : public ref_obj
{
public:
	 short fRef;
	 FileName filename;
	 
	 ~_Data()
	 {
	    ::FSClose( fRef );
	 }
};

OpenedFile::OpenedFile()
{
}

OpenedFile::OpenedFile(const OpenedFile& of)
: ref(of.ref)
{
}

OpenedFile& OpenedFile::operator= (const OpenedFile& of)
{
	ref = of.ref;
	return *this;
}

OpenedFile::~OpenedFile()
{
}
OpenedFile::OpenedFile( const FileName& fn, 
						const AccessType& acc, 
						const String& fork  )
{
    SInt8 perm = (&acc==&ReadOnlyShared) ? fsRdPerm 
    		   : (&acc==&ReadWriteExclusive) ? fsRdWrPerm
    		   : (&acc==&ReadWriteShared) ? fsRdWrShPerm
    		   : 0;
    
    String fnOS(fn.GetFullPathNameMac(false));
	FSSpec spec;
	OSErr err = :: FSpLocationFromFullPath(fnOS.length(), fnOS.c_str(), &spec);
	if (err == fnfErr && ((perm == fsRdWrPerm)||(perm == fsRdWrShPerm)))
	{  // must create the file first (no mac type or mac creator yet)
	   err = ::FSpCreate(&spec, FOUR_CHAR_CODE('????'),FOUR_CHAR_CODE('????'), smSystemScript);
	}
	if (err != noErr)
		_MacFS_Fail(err, fn); 

	short fRef;
    if (fork == String::kEmpty)
    	err = ::FSpOpenDF( &spec, perm, &fRef );
    else
    	err = ::FSpOpenRF( &spec, perm, &fRef );
	if (err != noErr)
		_MacFS_Fail(err, fn); 

    ref = new _Data();
    ref->fRef = fRef;
    ref->filename = fn;
}

OpenedFile::file_size OpenedFile::GetSize() const
{
    sint32 z = 0;
    OSErr err = ::GetEOF(ref->fRef, &z);
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 
    return static_cast<uint32>(z);
}

void OpenedFile::SetSize(OpenedFile::file_size fsz) const
{
    sint32 z = static_cast<sint32>(fsz);
	VERIFY((z == fsz) && (z >= 0));
    OSErr err = ::SetEOF(ref->fRef, z);
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 
}

OpenedFile::block_size 
	OpenedFile::Read(OpenedFile::file_size pos, 
					  void* bf, 
					  OpenedFile::block_size z) const
{
    sint32 fp = static_cast<sint32>(pos);
    sint32 bz = static_cast<sint32>(z);
	VERIFY((fp == pos) && (fp >= 0) && (bz >= 0));
	if (bz == 0)
		return 0;

    OSErr err = ::SetFPos(ref->fRef, fsFromStart, fp);
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 

	err = ::FSRead(ref->fRef, &bz, bf);		
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 

    return static_cast<uint32>(bz);
}

OpenedFile::block_size 
	OpenedFile::Write( OpenedFile::file_size pos, 
					   const void* bf, 
					   OpenedFile::block_size z) const
{
    sint32 fp = static_cast<sint32>(pos);
    sint32 bz = static_cast<sint32>(z);
	VERIFY((fp == pos) && (fp >= 0) && (bz >= 0));
	if (bz == 0)
		return 0;

    OSErr err = ::SetFPos(ref->fRef, fsFromStart, fp);
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 

	err = ::FSWrite(ref->fRef, &bz, bf);		
	if (err != noErr)
		_MacFS_Fail(err, ref->filename); 

    return static_cast<uint32>(bz);
}

#endif
} // namespace XSP
