/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

#if TARGET_API_Darwin

RuntimeVersion::RuntimeVersion()
{
    {
    	int mib[2] = {CTL_KERN, KERN_VERSION};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   //... blah blah blah
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	fullName = s;
	    	}
	    }
	}
    {
    	int mib[2] = {CTL_KERN, KERN_OSTYPE};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   // Darwin
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	productName = s;
	    	}
	    }
	}
    {
    	int mib[2] = {CTL_KERN, KERN_OSRELEASE};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   // 6.2
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	fullVersion = s;
	        	String::const_iterator p = std::find(s.begin(), s.end(), '.');
	        	majorVersion = String(s.begin(), p).To_uint32();
	        	if (p != s.end())
	        		minorVersion = String(p+1, s.end()).To_uint32();
	        	else
	        		minorVersion = 0;
	    	}
	    }
	}
	{
    	int mib[2] = {CTL_KERN, KERN_OSREV};
    	uint32 n = 0;
    	size_t z = sizeof(n);
    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
    					   &n, &z, 
    					   NULL, 0))
    	{
        	buildNumber = n;
    	}
    }
    {
    	int mib[2] = {CTL_HW, HW_MACHINE};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   // 
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	editionName = s;
	    	}
	    }
	}
    {
    	int mib[2] = {CTL_HW, HW_MODEL};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   // 
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	editionName.append(String::From_c_str("-"));
	        	editionName.append(s);
	    	}
	    }
	}
    {
    	int mib[2] = {CTL_HW, HW_MACHINE_ARCH};
    	size_t z = 0;
	    if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 0, &z, NULL, 0))
	    {
	    	String s;
	    	s.resize(z);
	    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
	    					   s.begin(), &z, 
	    					   NULL, 0))
	    	{   // 
		    	s.resize(std::string::traits_type::length(s.begin()));
	        	editionName.append(String::From_c_str("-"));
	        	editionName.append(s);
	    	}
	    }
	}
    
    productCategory = String::From_c_str("MAC");
//	majorVersion = ver;
//	minorVersion = rel;
//	buildNumber  = rev;
//	productName = String::From_c_str("OSX-Darwin");
//	editionName = String::From_c_str("standard");
//  fullVersion	 = String::From_uint32(majorVersion) 
//    			 + String::From_c_str(".")
//    			 + String::From_uint32(minorVersion);
	fullName = productCategory 
			 + String::From_c_str(" ") 
			 + productName 
			 + String::From_c_str(" kernel version ") + fullVersion 
			 + String::From_c_str(" (") + editionName 
			 + String::From_c_str(" edition, build ")
			 + String::From_uint32( buildNumber )
			 + String::From_c_str(")");
}


#endif

} // namespace XSP
