/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{
#if TARGET_API_Win32 || TARGET_API_Win32_Console   
   class AllocDebug
   {
   public:	
   	  int count;

   	  AllocDebug()
   	  : count(0)
   	  {}	

   	  ~AllocDebug()
   	  {
   	  	char buf[1000];
   	  	::sprintf(buf, "Static destruct time AllocCount=%d\n", count);
   	  	::OutputDebugString(buf);
   	  }
   }; // class AllocDebug
   static inline AllocDebug& _allocDebug() 
   { 
   		static AllocDebug _ad; 
   		return _ad; 
   }
#endif	
// make it a low fragmentation MM
} // namespace XSP


#if TARGET_API_Win32 || TARGET_API_Win32_Console   

static HANDLE pheap = 0;
void* operator new( unsigned int z )
{
	if (pheap == 0)
		pheap = ::GetProcessHeap();
	void *p = ::HeapAlloc(pheap, 0, z);
	VERIFY(p != 0);
//	++ XSP::_allocDebug().count;
	return p;
}

void* operator new[] ( unsigned int z )
{
	if (pheap == 0)
		pheap = ::GetProcessHeap();
	void *p = ::HeapAlloc(pheap, 0, z);
	VERIFY(p != 0);
//	++ XSP::_allocDebug().count;
	return p;
}

void  operator delete ( void *p )
{
	if (p != 0)
	{
		if (pheap == 0)
			pheap = ::GetProcessHeap();
		ASSERT(0 != ::HeapValidate(pheap, 0, p));
	//	-- XSP::_allocDebug().count;
		::HeapFree(pheap, 0, p);
	}
}

void  operator delete[] ( void *p )
{
	if (p != 0)
	{
		if (pheap == 0)
			pheap = ::GetProcessHeap();
		ASSERT(0 != ::HeapValidate(pheap, 0, p));
	//	-- XSP::_allocDebug().count;
		::HeapFree(pheap, 0, p);
	}
}

#endif
