/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/
namespace XSP
{

#if 0
#pragma mark EventLoop
#endif

class Event_Abstract;
class EventLoop : public ref_obj
{
public: 
	// must be list so that iterators within are persistent
	typedef std::list< refc<Event_Abstract> > Q;
private:
	// the sink used to report caught errors
	refc<ErrorSink> errorSink;
private:
	bool quit;
    Q eventQueue;
    Q secondQueue;
    friend class Event_Abstract;
protected:
	~EventLoop();

public:
	EventLoop();
	
	void Run();
	//void Step(bool toRun);
	
	void SetErrorSink(const refc<ErrorSink>& sink);
	void ReportError(const Exception& err);	

	void PostEvent(const refc<Event_Abstract>& event, bool imediate=true);
	void QuitLoop();
    refc<Event_Abstract> CreateQuitEvent();

private:
	void Close(bool notify);
}; // EventLoop

#if 0
#pragma mark Event_Abstract
#endif

class Event_Abstract : public ref_obj
{
protected:
	EventLoop::Q *currentQueue;
	EventLoop::Q::iterator whereInQueue;

protected:
	Event_Abstract();
	virtual ~Event_Abstract();

public:
	// override this to do something usefull
	virtual void Run() = 0;
    // any event is cancelable (will remove itself from the queue)
    virtual void Cancel();
    // any event can be canceled by app exit
    virtual void Terminated();
    // called by the queue when the event is added to the event queue
    void Enqueue(EventLoop::Q *q, EventLoop::Q::iterator where);
}; // Event_Abstract


#if 0
#pragma mark Event_Quit
#endif

class Event_Quit : public Event_Abstract
{
public:
	Event_Quit(EventLoop& loop);

private:
    EventLoop& loopToQuit;
	void Run();
}; // Event_Quit


/* ListenerOf<_T> Sinopsys ===========================================
class NoiseSource
{
private:
	class _Sound
	{
		virtual void Notification1();
		virtual void Notification2();
	};
public:	
	typedef ListenerOf<_Sound> Listener;
	typedef Listener::Container SoundListeners;
	SoundListeners soundListeners;
private:
	void Play()
	{
		for (Listener::each e(soundListeners); !e.empty(); e.pop()) 
			if (! e->IsCanceled())
				e->Notification1();
	}	
};

class SoundRecorder
{
private:
	class OnSound : public NoiseSource::Listener
	{
		SoundRecorder* recorder;
		void CancelListener() { recorder=0; super::CancelListener(); }
		// if trust caller to check IsCanceled()
		void Notification1() { recorder->DoSome1(); } 
		void Notification2() { recorder->DoSome2(); }
	public:
		OnSound(SoundRecorder& r) : recorder(r){}
		~OnSound() { CancelListener(); } // MUST
	};
	OnSound::owner onSound;
public:
	void Listen() 
	{ 
		onSound = new OnSound(*this);  
		someNoiseSource.soundListeners.Add(onSound);
	}
};
// =================================================================== */

#if 0
#pragma mark ListenerOf<T>
#endif

template <typename T>
class ListenerOf : public T
{
public:
	typedef ListenerOf    super;
	typedef refc< super > owner;
	class each; // forward decl
	
	class Container 
	{
	public:
		std::list<owner> data;
		bool withinNotify; // helper for notify functions (can set this to true while notifying)
	public:
		Container()  : withinNotify(false){}
		~Container() { CancelAllListeners(); }
		void CancelAllListeners()
		{
			typename std::list<owner>::iterator b=data.begin();
			typename std::list<owner>::iterator e=data.end();
			for(; b!=e; ++b)
			{
				(*b)->container = 0; // disable
				(*b)->CancelListener(); // close derivative 
				*b = 0; // delete
			}
			data.clear();
		}
		bool empty() const { return data.empty(); }
		unsigned size() const { return data.size(); }
		void Add(const owner& t) { data.push_back(t); t->container = this; }
		friend class ListenerOf;
		friend class each;
	};
	friend class Container;
	
	class each
	{
		std::vector<owner> data;
		typename std::vector<owner>::iterator p;
		typename std::vector<owner>::iterator e;
	public:
		each(const Container& c)
		{
			uint32 z = c.size();
			data.reserve(z);
			typename std::list<owner>::const_iterator b=c.data.begin();
			typename std::list<owner>::const_iterator e=c.data.end();
			for( ;b!=e; ++b)
				data.push_back(*b);
			restart();
		}
		void restart()
		{
			p = data.begin();
			e = data.end();
		}
		bool empty() const { return p==e; }
		void pop() { ++p; }
		ListenerOf* operator-> () const { return (*p).operator-> (); }
	};
	
private:
	uint32 refcount;
	Container* container;
protected:	
	// this is a non virtual call, derivatives should call their
	// derivate CancelListener() if they have one
	//?? virtual destructor
	virtual ~ListenerOf() { ListenerOf::CancelListener(); } 
public:
	ListenerOf() : refcount(0),container(0) {}
	void addref() { ++refcount; }
	void release() { if (--refcount == 0) delete this; }
public:
	bool IsCanceled() const {	return container==0; }
	virtual void CancelListener() 
	{ 
		Container* c = container;
		if (c != 0)
		{
			container=0;
			c->data.remove(this);
		}
	}
}; // class ListenerOf

} // namespace XSP
