
CFLAGS=-O2 -Wno-deprecated -Wno-ctor-dtor-privacy
LFLAGS=

all:  XSP_Codecs.lib

clean:
	rm *.o *.lib

INCDIR=-I ../Includes -I ../../Core/Includes -I ../../File/Includes -I ../../GUI/Includes -I ../../../Libs/regexpp2/include -I ../../../Libs/ZLIB -I ../../../Libs/LIBPNG

HEADER=-include ../../Targets/Includes/TargetAPI_Win32.h

ALL_HEADER= ../../Targets/Includes/TargetAPI_Win32.h \
	../Includes/XSP_Codecs.h \
	../Includes/XSP_CodecPNG.h \
	../Includes/XSP_SmartCodecFactory.h

ALL_OBJ= CodecPNG.o \
	SmartCodecFactory.o

ALL_LIB= ../../../Libs/ZLIB/libz.a \
	../../../Libs/LIBPNG/libpng.a

CodecPNG.o: ../Sources/CodecPNG.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

SmartCodecFactory.o: ../Sources/SmartCodecFactory.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

XSP_Codecs.lib: $(ALL_OBJ) $(ALL_LIB)
	ar rc $@ $(ALL_OBJ) $(ALL_LIB)
	ranlib $@
