/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug21-GiuseppeG: code write

Description:
	This module is a collection of encoders/decoders for various file fomrmats.
	If you write any new codecs please add their code as an extension to this module.
	
	SmartCodecFactory: this interface allows the creation of a codec that is capable of 
	encoding/decoding a specific file. It is smart because it does not simply rely on 
	the file extension or the MAC creator code/type to determine the kind of factory 
	to return. It can use any method above or all of them or it can even go into the 
	file and sample the signature. The specific method to use is of course 
	implementation dependant. 
	To allow your application to use codecs create an implementation for this interface 
	and plug it into the "GUI_Module::codecFactory". From there it will be used by all
	the image loaders.
	
	At the time of this writing only the PNG codec is available and it is based on the 
	open source PNG library. We desperately need to add some more ...
	
*/

#include "XSP_CodecPNG.h"

#include "XSP_SmartCodecFactory.h"
