/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug21-GiuseppeG: code write
*/

// forward definitions from png lib
typedef struct png_struct_def png_struct;
typedef struct png_info_struct png_info;
typedef struct png_row_info_struct png_row_info;

namespace XSP
{
#if TARGET_API_Win32 || TARGET_API_Win32_Console
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
#elif TARGET_API_Darwin || TARGET_API_Linux
#endif

class CodecPNG : public Codec
{
	class _Data;
	ptr<_Data> data;
protected:
	virtual ~CodecPNG();
public:
	CodecPNG();
	virtual void Decode(void* dataBuf, uint32 dataSize);
private:
	static void	ErrorCallback( png_struct* pngs, const char* inMsg);
	static void WarningCallback( png_struct* pngs, const char* inMsg);
	static void*MallocCallback( png_struct* pngs, std::size_t inSize);
	static void	FreeCallback( png_struct* pngs, void* inPtr);
	static void InfoCallback( png_struct* pngs, png_info* pngi);
	static void EndCallback( png_struct* pngs, png_info* pngi);
	static void	RowCallback( png_struct* pngs, 
							 uint8* inRow, uint32 inRowNo,
							 int pass );
	static void	ReadTransformCallback( png_struct* pngs
							,png_row_info* inRow
							,uint8* inData);
}; // class CodecPNG


	
} // namespace XSP
