package com.objectplanet.chart.examples;
import com.objectplanet.chart.*;

import java.awt.*;


/**
 * This example prints a bar chart.
 * @author Bjorn J. Kvande.
 */
public class PrintChart {

	public static void main(String[] argv) {
		// create the chart
		double[] values = new double[20];
		for (int i = 0; i < values.length; i++) {
			values[i] = Math.round(Math.random()*100);
		}
		BarChart chart = new BarChart();
		chart.setSampleCount(values.length);
		chart.setSampleValues(0, values);
		chart.setValueLinesOn(true);
		chart.setTitle("this chart will be printed");
		chart.setTitleOn(true);
		
		// display the chart
		Frame f = new Frame();
		f.add("Center", chart);
		f.setSize(400,300);
		f.show();
		
		// try to print the chart
		Toolkit kit = Toolkit.getDefaultToolkit();
		PrintJob job = kit.getPrintJob(f, "barchart", null);
		if (job != null) {
			Graphics g = job.getGraphics();
			// normally you should call the chart.print(Graphics) method
			chart.print(g);
			// but some java VMs and printers have problems printing applets
			// and you can call the paint(Graphics) method to print the 
			// applet as a bitmap and work around this problem. However,
			// the resolution of the printed bitmap chart will be poor
			// chart.paint(g);
			job.end();
		} else {
			System.out.println("Could not get a print job");
		}
	}
}