/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int VALUE_LABELS_OUTSIDE_POINT = 1;
    public static final int VALUE_LABELS_AT_POINT = 0;
    private int bV;
    private boolean bZ;
    private int[] bS;
    private boolean bR;
    private boolean[][] bY;
    private boolean[] bU;
    private int[] b2;
    private int[] b4;
    private boolean[] b0;
    private boolean[] bW;
    private String[] b3;
    private int[][][] bX;
    private int[] bT;
    private int b1;

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.setAutomaticRepaintOn(false);
        this.S = "line";
        this.bY = new boolean[n][n2];
        this.bU = new boolean[n];
        this.b2 = new int[n];
        this.b4 = new int[n];
        this.b0 = new boolean[n];
        this.bS = new int[n];
        int n3 = 0;
        while (n3 < this.b4.length) {
            this.b4[n3] = 6;
            this.b0[n3] = true;
            this.bS[n3] = 2;
            ++n3;
        }
        this.bW = new boolean[n];
        this.bT = new int[n2];
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.b1 = -1;
        this.bV = 1;
        this.a1 = 2;
        this.ai = 3;
        this.bZ = false;
        this.aX = true;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.bV = 1;
        this.a1 = 2;
        this.ai = 3;
        this.bZ = false;
        this.aX = true;
    }

    public String[] getLegendLabels() {
        if (this.aF != null) {
            return this.aF;
        }
        return this.getSeriesLabels();
    }

    double a(int n) {
        if (this.bR) {
            return Math.max(super.a(n), this.getMaxValue(-2));
        }
        return super.a(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.bR) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public int getValuePosition(double d) {
        return this.a(0, d, this.getGraphBounds());
    }

    public void setValueLabelStyle(int n) {
        if (this.bV != n) {
            this.bV = n;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getValueLabelStyle() {
        return this.bV;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (this.bZ != bl) {
            this.bZ = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.bZ;
    }

    public void setStackedOn(boolean bl) {
        if (this.bR != bl) {
            this.bR = bl;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public boolean isStackedOn() {
        return this.bR;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.bS.length) {
            this.bS[n] = n2;
        } else if (n < 0) {
            int n3 = 0;
            while (n3 < this.bS.length) {
                this.bS[n3] = n2;
                ++n3;
            }
        }
        this.goto = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.bS.length) {
            return this.bS[n];
        }
        return this.bS[0];
    }

    public void setSampleHighlightOn(boolean bl) {
        int n = 0;
        while (n < this.bY.length) {
            this.bU[n] = bl;
            int n2 = 0;
            while (n2 < this.bY[n].length) {
                this.bY[n][n2] = bl;
                ++n2;
            }
            ++n;
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            this.bU[n] = bl;
            int n2 = 0;
            while (n2 < this.bY[n].length) {
                this.bY[n][n2] = bl;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.bY[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        try {
            return this.bU[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
    }

    public void setSampleHighlightStyle(int n, int n2) {
        int n3 = 0;
        while (n3 < this.b2.length) {
            this.setSampleHighlightStyle(n3, n, n2);
            ++n3;
        }
    }

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.b4[n] = Math.max(0, n3);
        this.b2[n] = n2;
        this.goto = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.b2[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.b4[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setLegendImage(int n, String string) {
        if (n >= 0 && n < 1000) {
            super.setLegendImage(n, string);
            if (this.b3 == null) {
                this.b3 = new String[n + 1];
            }
            if (n >= this.b3.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.b3, 0, stringArray, 0, this.b3.length);
                this.b3 = stringArray;
            }
            this.b3[n] = string;
            this.goto = true;
            this.Z = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public void setSeriesLineOn(boolean bl) {
        int n = 0;
        while (n < this.b0.length) {
            this.b0[n] = bl;
            ++n;
        }
        this.goto = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        if (this.b0[n] != bl) {
            this.b0[n] = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLineOn(int n) {
        return this.b0[n];
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.bW.length) {
            this.bW[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.bW.length) {
                this.bW[n2] = bl;
                ++n2;
            }
        }
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.bW.length) {
            return this.bW[n];
        }
        if (n == -1) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.bW.length) {
                if (this.bW[n2]) {
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public void setRightToLeftScrollingOn(boolean bl) {
        this.A = bl;
        this.setVisibleSamples(this.visibleSamples[0], this.visibleSamples[1]);
        this.al = true;
        this.goto = true;
        this.autoRepaint();
    }

    public boolean isRightToLeftScrollingOn() {
        return this.A;
    }

    public ChartSample checkSelection(Point point) {
        Serializable serializable;
        int n;
        int n2;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = null;
        if (this.overlayCharts != null) {
            n2 = this.overlayCharts.size();
            n = n2 - 1;
            while (n >= 0 && chartSample == null) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n);
                if (chart != null) {
                    chartSample = chart.checkSelection(point);
                }
                --n;
            }
        }
        if (chartSample != null) {
            this.R = -1;
            this.bm = -1;
            return chartSample;
        }
        if (this.isLegendOn() && this.L != null) {
            n2 = 0;
            while (n2 < this.L.length) {
                if (this.L[n2] != null && this.L[n2].contains(point)) {
                    chartSample = new ChartSample(-1);
                    chartSample.if(n2);
                    break;
                }
                ++n2;
            }
            if (chartSample != null && this.overlayCharts != null) {
                n = this.overlayCharts.size();
                int n3 = n - 1;
                while (n3 >= 0) {
                    serializable = (Chart)this.overlayCharts.elementAt(n3);
                    if (serializable != null) {
                        serializable.R = chartSample.getIndex();
                        serializable.bm = chartSample.getSeries();
                        if (this.aj == 1) {
                            serializable.ay.x = this.ay.x;
                            serializable.ay.y = -1;
                        } else {
                            serializable.ay.x = -1;
                            serializable.ay.y = this.ay.y;
                        }
                    }
                    --n3;
                }
            }
        }
        if (chartSample == null && this.bX != null) {
            n2 = 3;
            n = 0;
            while (chartSample == null && n < this.bX.length) {
                int n4 = 0;
                while (chartSample == null && n4 < this.bX[n].length) {
                    serializable = new Point(this.bX[n][n4][0], this.bX[n][n4][1]);
                    if (this.is3DModeOn()) {
                        ((Point)serializable).x -= this.m.x;
                        if (!this.bR) {
                            double d = (double)this.m.x / (double)this.getSeriesCount();
                            int n5 = (int)Math.round(d * (double)n);
                            ((Point)serializable).x += n5;
                        }
                    }
                    boolean bl = point.x >= ((Point)serializable).x - n2 && point.x <= ((Point)serializable).x + n2;
                    if (bl &= point.y >= ((Point)serializable).y - n2 && point.y <= ((Point)serializable).y + n2) {
                        chartSample = this.getSample(n, n4);
                    }
                    ++n4;
                }
                ++n;
            }
        }
        if (chartSample != null) {
            this.R = chartSample.getIndex();
            this.bm = chartSample.getSeries();
            this.ay = point;
        } else {
            this.R = -1;
            this.bm = -1;
        }
        return chartSample;
    }

    public void render(Graphics graphics) {
        this.a(graphics, !this.isServletModeOn());
    }

    void a(Graphics graphics, boolean bl) {
        Serializable serializable;
        Object object;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getGraphBounds();
        Rectangle rectangle2 = this.getDataBounds(rectangle);
        this.calculateChartData(rectangle, rectangle2);
        int n = 0;
        while (n < this.overlayCharts.size()) {
            object = (Chart)this.overlayCharts.elementAt(n);
            if (object != null) {
                Rectangle rectangle3 = new Rectangle(rectangle);
                serializable = new Rectangle(rectangle2);
                if (this.is3DModeOn()) {
                    rectangle3.x -= this.m.x;
                    rectangle3.y -= this.m.y;
                    ((Rectangle)serializable).x -= this.m.x;
                    ((Rectangle)serializable).y -= this.m.y;
                }
                ((Chart)object).calculateChartData(rectangle3, (Rectangle)serializable);
            }
            ++n;
        }
        if (bl && this.else == null) {
            try {
                this.else = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            }
            catch (Throwable throwable) {
                Chart.do();
            }
            this.goto = true;
        }
        if (!bl || this.goto || this.else == null) {
            object = graphics;
            if (this.else != null && bl && !this.aZ) {
                object = this.else.getGraphics();
                ((Graphics)object).setColor(this.getBackground());
                ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
            } else if (this.aZ && this.aU != null && this.else != null) {
                object = this.aU;
                ((Graphics)object).setColor(this.getBackground());
                ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
            }
            this.do((Graphics)object, rectangle);
            this.a((Graphics)object, rectangle, rectangle2);
            this.a((Graphics)object, dimension);
            if (this.isLegendOn()) {
                this.a((Graphics)object, rectangle, this.getLegendLabels());
            }
            this.renderData((Graphics)object, rectangle, rectangle2);
            int n2 = 0;
            while (n2 < this.overlayCharts.size()) {
                serializable = (Chart)this.overlayCharts.elementAt(n2);
                if (serializable != null && this.isOverlayChartOn(n2)) {
                    Rectangle rectangle4 = new Rectangle(rectangle);
                    Rectangle rectangle5 = new Rectangle(rectangle2);
                    rectangle4.x -= this.m.x;
                    rectangle4.y -= this.m.y;
                    rectangle5.x -= this.m.x;
                    rectangle5.y -= this.m.y;
                    if (serializable instanceof LineChart || serializable instanceof PieChart) {
                        ((Chart)serializable).renderData((Graphics)object, rectangle4, rectangle5);
                    } else {
                        ((Chart)serializable).renderData((Graphics)object, rectangle, rectangle2);
                    }
                }
                ++n2;
            }
            if (this.is3DModeOn()) {
                int n3 = this.aD.length - 1;
                while (n3 >= 0) {
                    this.for((Graphics)object, rectangle, n3);
                    --n3;
                }
            }
            if (!this.aZ && object != graphics) {
                ((Graphics)object).dispose();
            }
            this.goto = false;
        }
        if ((bl || this.aZ) && this.else != null) {
            graphics.drawImage(this.else, 0, 0, this);
        }
        this.a(graphics, rectangle);
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        int n2;
        double d;
        if (!this.al && !this.isServletModeOn()) {
            return;
        }
        int n3 = this.getSampleCount();
        int n4 = this.getSeriesCount();
        this.a(rectangle);
        boolean bl = this.is3DModeOn();
        if (bl) {
            if (this.a > -1) {
                this.m.x = this.a;
                this.m.y = -this.a;
            } else {
                int n5 = Math.max(n3, 20);
                if (n4 > 1 && !this.bR) {
                    n5 /= n4;
                    n5 = Math.max(n5, 4);
                }
                d = (double)rectangle.width / (double)n5;
                this.m.x = (int)Math.round(d * 1.25);
                this.m.y = (int)Math.round(-d / 1.25);
            }
        }
        if (this.bX == null || this.bX.length != n4 || this.bX.length == 0 || this.bX[0] == null || this.bX[0].length != n3) {
            this.bX = new int[n4][n3][2];
        }
        int[] nArray = new int[n4];
        if (this.A) {
            int n6 = 0;
            while (n6 < n4) {
                ChartSample[] chartSampleArray = this.getSamples(n6);
                if (chartSampleArray != null) {
                    int n7 = chartSampleArray.length - 1;
                    while (n7 >= 0) {
                        if (chartSampleArray[n7] != null && chartSampleArray[n7].hasValue()) {
                            nArray[n6] = Math.max(nArray[n6], n7);
                            break;
                        }
                        --n7;
                    }
                }
                ++n6;
            }
        }
        d = rectangle2.width;
        double d2 = this.m.x;
        if (n3 > 2) {
            d = (double)rectangle2.width / (double)(n3 - 1);
        }
        if (this.bT == null || this.bT.length < n3) {
            int[] nArray2 = new int[n3];
            if (this.bT != null) {
                System.arraycopy(this.bT, 0, nArray2, 0, this.bT.length);
            }
            this.bT = nArray2;
        }
        double d3 = rectangle2.x;
        if (this.A) {
            n2 = 0;
            String[] stringArray = this.getSampleLabels();
            if (stringArray != null) {
                n = stringArray.length - 1;
                while (n >= 0) {
                    if (stringArray[n] != null) {
                        n2 = Math.max(n2, n);
                        break;
                    }
                    --n;
                }
            }
            d3 = d3 + (double)rectangle2.width - d * (double)n2;
        }
        n2 = 0;
        while (n2 < n3) {
            int n8 = 0;
            n8 = d3 >= 0.0 ? (int)(d3 + 0.5) : (int)(d3 - 0.5);
            this.bT[n2] = n8;
            d3 += d;
            ++n2;
        }
        int n9 = 0;
        while (n9 < n4) {
            d3 = rectangle2.x;
            if (this.A) {
                d3 = d3 + (double)rectangle2.width - d * (double)nArray[n9];
            }
            n = 0;
            while (n < n3) {
                int n10;
                int n11 = 0;
                n11 = d3 >= 0.0 ? (int)(d3 + 0.5) : (int)(d3 - 0.5);
                this.bX[n9][n][0] = n11;
                if (bl && !this.bR) {
                    d2 = (double)this.m.x / (double)n4 * (double)n9;
                    int[] nArray3 = this.bX[n9][n];
                    nArray3[0] = (int)((double)nArray3[0] + d2);
                }
                double d4 = 0.0;
                if (n9 >= 0 && this.bR) {
                    n10 = 0;
                    while (n10 <= n9) {
                        d4 += this.getSampleValue(n10, n);
                        ++n10;
                    }
                } else if (n9 >= 0) {
                    d4 = this.getSampleValue(n9, n);
                }
                n10 = this.getSeriesRange(n9);
                double d5 = 0.0;
                try {
                    d5 = (d4 - this.au[n10]) / (this.aN[n10] - this.au[n10]);
                }
                catch (ArithmeticException arithmeticException) {
                    d5 = Double.NaN;
                }
                double d6 = (double)(rectangle.y + rectangle.height) - d5 * (double)rectangle.height;
                this.bX[n9][n][1] = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                if (bl && this.bR) {
                    int[] nArray4 = this.bX[n9][n];
                    nArray4[1] = nArray4[1] - this.m.y;
                } else if (bl) {
                    int[] nArray5 = this.bX[n9][n];
                    nArray5[1] = nArray5[1] - this.m.y;
                    double d7 = (double)this.m.y / (double)this.getSeriesCount() * (double)n9;
                    int[] nArray6 = this.bX[n9][n];
                    nArray6[1] = nArray6[1] + (int)Math.round(d7);
                }
                d3 += d;
                ++n;
            }
            ++n9;
        }
        this.al = false;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.do(graphics, rectangle, rectangle2);
    }

    protected void checkDataIntegrity() {
        int n;
        super.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.bY != null ? this.bY.length : 1;
        int n5 = n = n4 > 0 && this.bY != null ? this.bY[0].length : 0;
        if (n2 != n4 || n3 != n) {
            boolean[][] blArray = new boolean[n2][n3];
            boolean[] blArray2 = new boolean[n2];
            int n6 = 0;
            while (n6 < n2) {
                if (n6 < n4 && this.bU != null) {
                    blArray2[n6] = this.bU[n6];
                    int n7 = 0;
                    while (n7 < n3) {
                        blArray[n6][n7] = n7 < n ? this.bY[n6][n7] : this.bU[n6];
                        ++n7;
                    }
                }
                ++n6;
            }
            this.bY = blArray;
            this.bU = blArray2;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray3 = new boolean[n2];
            boolean[] blArray4 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int n8 = 0;
            while (n8 < n2) {
                if (n8 < n4 && this.b2 != null && this.b4 != null && this.b0 != null && this.bW != null && this.bS != null) {
                    nArray[n8] = this.b2[n8];
                    nArray2[n8] = this.b4[n8];
                    blArray3[n8] = this.b0[n8];
                    blArray4[n8] = this.bW[n8];
                    nArray3[n8] = this.bS[n8];
                } else {
                    nArray2[n8] = 6;
                    blArray3[n8] = true;
                    nArray3[n8] = 2;
                }
                ++n8;
            }
            this.b2 = nArray;
            this.b4 = nArray2;
            this.b0 = blArray3;
            this.bW = blArray4;
            this.bS = nArray3;
        }
        if (this.b1 >= n2) {
            this.b1 = -1;
        }
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        String string;
        Object object;
        int n;
        Object object2;
        int n2;
        if (!this.Z && this.aW != null) {
            return this.aW;
        }
        Rectangle rectangle = super.a(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int n3 = rectangle.x;
        int n4 = dimension.width - rectangle.width - rectangle.x;
        int n5 = rectangle.y;
        int n6 = dimension.height - rectangle.height - rectangle.y;
        int n7 = 0;
        while (n7 < this.aB.length) {
            if (this.aB[n7]) {
                if (this.aR[n7] == 0) {
                    n3 += 6;
                } else {
                    n4 += 6;
                }
            }
            ++n7;
        }
        if (this.s && this.getSampleCount() > 0 && (this.a1 == 2 || this.a1 == 4)) {
            Object object3;
            Font font = this.getFont("sampleLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n8 = 0;
            n2 = this.getLabelAngle("sampleLabelAngle");
            object2 = this.getSampleLabels();
            n = 0;
            while (n < ((String[])object2).length) {
                object3 = this.a(object2[n], fontMetrics);
                Dimension dimension2 = this.a((Dimension)object3, n2);
                n8 = Math.max(dimension2.height, n8);
                ++n;
            }
            n6 += n8 + 6;
            if (n2 % 180 == 0) {
                n6 -= fontMetrics.getMaxDescent();
            }
            object3 = this.getSampleLabel(this.getSampleCount() - 1);
            int n9 = 0;
            if (object3 != null) {
                Dimension dimension3 = this.a((String)object3, fontMetrics);
                object = this.a(dimension3, n2);
                n9 = ((Dimension)object).width / 2 - 5;
            }
            int n10 = 0;
            if (this.isLegendOn() && this.getLegendPosition() == 1) {
                n10 = this.b.width;
            }
            if (n9 > n10) {
                n4 += n9 - n10;
            }
        }
        boolean bl = false;
        int n11 = 0;
        while (n11 < this.aD.length) {
            bl = this.aD[n11] ? true : bl;
            ++n11;
        }
        if (bl || this.int.size() > 0) {
            String string2;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String string3 = this.getLabel("rangeLabelPrefix");
            object2 = this.getLabel("rangeLabelPostfix");
            n = 0;
            int n12 = 0;
            Enumeration enumeration = this.int.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                object = this.for(string4);
                if (object == null || ((String)object).length() <= 0) continue;
                if (this.aY[0] == 0) {
                    n = Math.max(n, fontMetrics.stringWidth((String)object));
                    continue;
                }
                n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
            }
            if (this.an[0] && this.aD[0]) {
                int n13 = this.getRangeDecimalCount(0);
                object = this.formatNumber(this.r[0], n13);
                string2 = this.formatNumber(this.void[0], n13);
                object = string3 != null ? string3 + (String)object : object;
                string2 = string3 != null ? string3 + string2 : string2;
                object = object2 != null ? (String)object + (String)object2 : object;
                String string5 = string2 = object2 != null ? string2 + (String)object2 : string2;
                if (this.aY[0] == 0) {
                    n = Math.max(n, fontMetrics.stringWidth((String)object));
                    n = Math.max(n, fontMetrics.stringWidth(string2));
                } else {
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                    n12 = Math.max(n12, fontMetrics.stringWidth(string2));
                }
            }
            if (this.an[1] && this.aD[1]) {
                int n14 = this.getRangeDecimalCount(1);
                object = this.formatNumber(this.r[1], n14);
                string2 = this.formatNumber(this.void[1], n14);
                if (this.aY[1] == 0) {
                    n = Math.max(n, fontMetrics.stringWidth((String)object));
                    n = Math.max(n, fontMetrics.stringWidth(string2));
                } else {
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                    n12 = Math.max(n12, fontMetrics.stringWidth(string2));
                }
            }
            n3 += n + 2;
            n4 += n12 > 0 ? n12 + 2 : 0;
        }
        if ((string = this.getLabel("sampleAxisLabel")) != null) {
            Font font = this.getFont("sampleAxisLabelFont");
            object2 = this.getFontMetrics(font);
            n = this.getLabelAngle("sampleAxisLabelAngle");
            Dimension dimension4 = this.a(string, (FontMetrics)object2);
            Dimension dimension5 = this.a(dimension4, n);
            n6 += dimension5.height + 3;
            if (n % 180 == 0) {
                n6 -= ((FontMetrics)object2).getDescent();
            }
        }
        n2 = 0;
        while (n2 < 2) {
            Object object4 = object2 = n2 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (object2 != null) {
                Font font = this.getFont("rangeAxisLabelFont");
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n15 = n2 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
                Dimension dimension6 = this.a((String)object2, fontMetrics);
                object = this.a(dimension6, n15);
                if (this.aY[n2] == 0) {
                    n3 += ((Dimension)object).width + 20;
                } else {
                    n4 += ((Dimension)object).width + 20;
                }
            }
            ++n2;
        }
        if (this.is3DModeOn()) {
            if (this.a > -1) {
                n3 += this.m.x;
                n6 -= this.m.y;
            } else {
                int n16 = Math.max(20, this.getSampleCount());
                int n17 = this.getSeriesCount();
                if (n17 > 1 && !this.bR) {
                    n16 /= n17;
                    n16 = Math.max(n16, 4);
                }
                int n18 = (int)((float)rectangle.width * 1.25f / ((float)n16 + 1.25f));
                rectangle.width = dimension.width - (n3 += n18) - n4;
                double d = rectangle.width / n16;
                n6 += (int)Math.round(d / 1.25);
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n5 = insets.top == -1 ? n5 : insets.top;
            n3 = insets.left == -1 ? n3 : insets.left;
            n6 = insets.bottom == -1 ? n6 : insets.bottom;
            n4 = insets.right == -1 ? n4 : insets.right;
        }
        rectangle.x = n3;
        rectangle.width = dimension.width - n3 - n4 - 1;
        rectangle.y = n5;
        rectangle.height = dimension.height - n5 - n6 - 1;
        this.Z = false;
        this.aW = rectangle;
        return rectangle;
    }

    private void do(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSeriesCount();
        if (n > 0) {
            int n2;
            int n3 = n - 1;
            while (n3 >= 0) {
                n2 = this.getSeriesRange(n3);
                if (this.aN[n2] != this.au[n2]) {
                    this.a(graphics, n3, rectangle, rectangle2, this.getSampleColor(n3), this.isSelected(n3, -1));
                }
                --n3;
            }
            if (!this.is3DModeOn() && this.b1 >= 0) {
                n2 = this.b1;
                this.a(graphics, n2, rectangle, rectangle2, this.getSampleColor(n2), this.isSelected(n2, -1));
            }
            if (this.isValueLabelsOn(-1) || this.s || this.aJ) {
                this.if(graphics, rectangle, rectangle2);
            }
        }
    }

    private void a(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        int n2;
        ChartSample[] chartSampleArray;
        int n3 = this.getSeriesCount();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (bl) {
            this.b1 = n;
        }
        if ((chartSampleArray = this.getSamples(n)) == null || chartSampleArray.length == 0) {
            return;
        }
        Color color2 = this.bR || bl ? color.darker() : color;
        boolean bl2 = this.is3DModeOn();
        Graphics graphics2 = graphics;
        if (bl2) {
            graphics2.setClip(rectangle.x - this.m.x + 1, rectangle.y + 1, rectangle.width + this.m.x - 1, rectangle.height - this.m.y - 1);
        } else {
            graphics2.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            n5 = this.bX[n][0][0];
            n6 = this.bX[n][0][1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int n7 = 0;
        while (n7 < chartSampleArray.length - 1) {
            boolean bl3 = chartSampleArray[n7] != null && chartSampleArray[n7].value != null && !chartSampleArray[n7].value.isNaN();
            boolean bl4 = chartSampleArray[n7 + 1] != null && chartSampleArray[n7 + 1].value != null && !chartSampleArray[n7 + 1].value.isNaN();
            n2 = bl3 && bl4 ? 1 : 0;
            n2 |= bl4 && this.bW[n] ? 1 : 0;
            n2 &= this.getLineWidth(n) > 0 ? 1 : 0;
            try {
                if (n2 != 0 && n7 > 0 && n7 < this.bX[n].length - 1) {
                    n2 = this.bX[n][n7][0] != n5 ? 1 : 0;
                    n2 |= this.bX[n][n7 + 1][1] != n6 ? 1 : 0;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bl3) {
                try {
                    n5 = this.bX[n][n7][0];
                    n6 = this.bX[n][n7][1];
                    n4 = 1;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if ((n2 &= n4) != 0) {
                if (this.bW[n]) {
                    nArray[0] = n5;
                    nArray2[0] = n6;
                } else {
                    nArray[0] = this.bX[n][n7][0];
                    nArray2[0] = this.bX[n][n7][1];
                }
                if (n7 + 1 < this.bX[n].length) {
                    nArray[1] = this.bX[n][n7 + 1][0];
                    nArray2[1] = this.bX[n][n7 + 1][1];
                }
                if (bl2) {
                    nArray[0] = nArray[0] - this.m.x;
                    nArray[1] = nArray[1] - this.m.x;
                    nArray[2] = nArray[2] - this.m.x;
                    nArray[3] = nArray[3] - this.m.x;
                }
                if (this.bR) {
                    nArray[2] = nArray[1];
                    nArray2[2] = n > 0 ? this.bX[n - 1][n7 + 1][1] : rectangle.y + rectangle.height;
                    if (bl2) {
                        nArray2[2] = nArray2[2] - this.m.y;
                    }
                    nArray[3] = nArray[0];
                    nArray2[3] = n > 0 ? this.bX[n - 1][n7][1] : rectangle.y + rectangle.height;
                    if (bl2) {
                        nArray2[3] = nArray2[3] - this.m.y;
                    }
                }
                boolean bl5 = false;
                int n8 = rectangle.x - (bl2 ? this.m.x * 2 : 0);
                int n9 = rectangle.x + rectangle.width;
                bl5 |= nArray[0] >= n8 && nArray[0] <= n9;
                bl5 |= nArray[1] >= n8 && nArray[1] <= n9;
                if (bl5 |= nArray[0] <= n8 && nArray[1] >= n9) {
                    int n10;
                    nArray[0] = Math.max(nArray[0], -10000);
                    nArray[1] = Math.max(nArray[1], -10000);
                    nArray[0] = Math.min(nArray[0], 11000);
                    nArray[1] = Math.min(nArray[1], 11000);
                    nArray2[0] = Math.max(nArray2[0], -10000);
                    nArray2[1] = Math.max(nArray2[1], -10000);
                    nArray2[0] = Math.min(nArray2[0], 11000);
                    nArray2[1] = Math.min(nArray2[1], 11000);
                    if (this.b0[n]) {
                        if (bl2 && this.bR) {
                            boolean bl6;
                            boolean bl7 = n == n3 - 1;
                            boolean bl8 = bl6 = n7 == chartSampleArray.length - 2;
                            if (n7 < chartSampleArray.length - 2) {
                                bl6 |= chartSampleArray[n7 + 2] == null || chartSampleArray[n7 + 2].value == null || chartSampleArray[n7 + 2].value.isNaN();
                                bl6 &= !this.bW[n];
                            }
                            this.a(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, bl7, bl6);
                        } else if (bl2) {
                            this.a(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, true, false);
                        }
                    }
                    if (this.bR && this.b0[n]) {
                        graphics2.setColor(bl ? color.darker() : color);
                        graphics2.fillPolygon(nArray, nArray2, 4);
                        graphics2.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    }
                    graphics2.setColor(color);
                    if (bl2 && this.bR) {
                        graphics2.setColor(color.darker().darker());
                    } else if (bl2 || this.bR) {
                        graphics2.setColor(color.darker());
                    }
                    if (this.b0[n] || bl) {
                        graphics2.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        if (!bl2 && !this.bR && this.bS[n] > 1 && (this.b0[n] || bl)) {
                            double d = 0.0;
                            if (nArray[1] - nArray[0] != 0) {
                                d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                            }
                            n10 = 1;
                            int n11 = 2;
                            while (n11 <= this.bS[n]) {
                                int n12 = n11 / 2 * n10;
                                if (d <= 1.0) {
                                    graphics2.drawLine(nArray[0], nArray2[0] + n12, nArray[1], nArray2[1] + n12);
                                } else {
                                    graphics2.drawLine(nArray[0] - n12, nArray2[0], nArray[1] - n12, nArray2[1]);
                                }
                                n10 = -n10;
                                ++n11;
                            }
                        }
                    }
                    if (bl && this.b0[n] && !bl2 && !this.bR) {
                        double d = 0.0;
                        if (nArray[1] - nArray[0] != 0) {
                            d = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                        }
                        n10 = this.bS[n] / 2 + 1;
                        graphics2.setColor(color.darker().darker());
                        if (d <= 1.0) {
                            graphics2.drawLine(nArray[0], nArray2[0] + n10, nArray[1], nArray2[1] + n10);
                        } else {
                            graphics2.drawLine(nArray[0] - n10, nArray2[0], nArray[1] - n10, nArray2[1]);
                        }
                    }
                }
            }
            ++n7;
        }
        if (!bl2) {
            int n13 = 0;
            while (n13 < chartSampleArray.length) {
                ChartSample chartSample = chartSampleArray[n13];
                if (this.bY[n][n13] && chartSample != null && chartSample.hasValue()) {
                    n2 = this.bX[n][n13][0];
                    int n14 = this.bX[n][n13][1];
                    if (n14 >= rectangle.y && n14 <= rectangle.y + rectangle.height && n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width + 1) {
                        this.a(graphics, n, Math.round(n2), n14, color);
                    }
                }
                ++n13;
            }
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n6 = this.bR ? 1 : Math.max(1, this.getSeriesCount());
        int n7 = (int)Math.round((double)this.m.x / (double)n6);
        int n8 = (int)Math.round((double)this.m.y / (double)n6);
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n + n7;
        nArray2[1] = n2 + n8;
        nArray[2] = nArray[1] + (n3 - n);
        nArray2[2] = n4 + n8;
        nArray[3] = n3;
        nArray2[3] = n4;
        Color color2 = color.darker();
        if (bl) {
            double d = 0.0;
            if (nArray[1] - nArray[0] != 0) {
                d = (double)(n2 - n4) / (double)(n3 - n);
            }
            if (d > 0.69) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
        }
        if (bl2) {
            nArray[0] = nArray[3];
            nArray2[0] = nArray2[3];
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
            nArray[2] = nArray[2];
            nArray2[2] = n5 + n8;
            nArray[3] = nArray[0];
            nArray2[3] = n5;
            graphics.setColor(color);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            graphics.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
        }
    }

    private boolean a(double d, double d2, double d3, Rectangle rectangle) {
        boolean bl = true;
        if (this.is3DModeOn()) {
            if (d2 <= d3) {
                bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2 - this.m.y) && d >= (double)(rectangle.x - 2) && d <= (double)(rectangle.x + rectangle.width + this.m.x + 2);
            } else {
                double d4 = (double)this.m.x / (double)this.getSeriesCount();
                double d5 = (double)this.m.y / (double)this.getSeriesCount();
                bl = d2 >= (double)rectangle.y - d5 - 2.0 && d2 <= (double)(rectangle.y + rectangle.height - this.m.y) - d5 && d >= (double)rectangle.x - d4 - 2.0 && d <= (double)(rectangle.x + rectangle.width) - d4 + (double)this.m.x + 2.0;
            }
        } else {
            bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2) && d >= (double)(rectangle.x - 4) && d <= (double)(rectangle.x + rectangle.width + 2);
        }
        return bl;
    }

    private void if(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        boolean bl = this.is3DModeOn();
        double d = rectangle2.width;
        if (n > 2) {
            d = (double)rectangle2.width / (double)(n - 1);
        }
        Font font = this.getFont("valueLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n3 = this.getLabelAngle("valueLabelAngle");
        Font font2 = this.getFont("sampleLabelFont");
        FontMetrics fontMetrics2 = this.getFontMetrics(font2);
        int n4 = this.getLabelAngle("sampleLabelAngle");
        int n5 = 0;
        while (n5 < n2) {
            String string;
            String string2;
            if (this.bR) {
                if (n5 != 0) break;
                n5 = n2 - 1;
            }
            if ((string2 = this.getLabel("valueLabelPrefix_" + n5)) == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string = this.getLabel("valueLabelPostfix_" + n5)) == null) {
                string = this.getLabel("valueLabelPostfix");
            }
            int n6 = this.getSampleDecimalCount(n5);
            ChartSample[] chartSampleArray = this.getSamples(n5);
            int n7 = Math.max(this.visibleSamples[0] - 1, 0);
            int n8 = Math.min(n7 + this.visibleSamples[1] + 1, n);
            if (this.A) {
                n7 = 0;
                n8 = this.getSampleCount();
            }
            int n9 = n7;
            while (n9 < n8) {
                block35: {
                    double d2;
                    block37: {
                        block36: {
                            if (!this.bR && (chartSampleArray[n9] == null || chartSampleArray[n9].value == null || chartSampleArray[n9].value.isNaN())) break block35;
                            d2 = 0.0;
                            if (!this.bR) break block36;
                            boolean bl2 = false;
                            int n10 = 0;
                            while (n10 < n2) {
                                ChartSample chartSample = this.getSample(n10, n9);
                                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                                    d2 += chartSample.value.doubleValue();
                                    bl2 = true;
                                }
                                ++n10;
                            }
                            if (bl2) break block37;
                            break block35;
                        }
                        ChartSample chartSample = this.getSample(n5, n9);
                        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) break block35;
                        d2 = chartSampleArray[n9].getFloatValue();
                    }
                    double d3 = d2;
                    if (n9 >= 1 && chartSampleArray[n9 - 1] != null) {
                        d3 = chartSampleArray[n9 - 1].getFloatValue();
                    }
                    double d4 = d2;
                    if (n9 < chartSampleArray.length - 1 && chartSampleArray[n9 + 1] != null) {
                        d4 = chartSampleArray[n9 + 1].getFloatValue();
                    }
                    double d5 = (d2 - d3) / d;
                    double d6 = (d4 - d2) / d;
                    Dimension dimension = new Dimension();
                    int n11 = Integer.MIN_VALUE;
                    int n12 = Integer.MIN_VALUE;
                    if (n9 < this.bX[n5].length) {
                        n11 = this.bX[n5][n9][0];
                        n12 = this.bX[n5][n9][1] - 1;
                    }
                    if (this.bV == 0 && this.isValueLabelsOn(n5)) {
                        String string3 = this.formatNumber(d2, n6);
                        string3 = string2 != null ? string2 + string3 : string3;
                        string3 = string != null ? string3 + string : string3;
                        Dimension dimension2 = this.a(string3, fontMetrics);
                        dimension = this.a(dimension2, n3);
                        int n13 = Math.round(n11 - dimension.width / 2) + 1;
                        int n14 = n12;
                        n14 = n3 % 180 == 0 ? (n14 += fontMetrics.getAscent() / 2) : n12 - dimension.height / 2;
                        if (bl && !this.bR) {
                            n13 -= this.m.x;
                            if (d5 >= d6) {
                                n14 = (int)((double)n14 + (double)this.m.y / (double)n2);
                                n13 = (int)((double)n13 + (double)this.m.x / (double)n2);
                            }
                        }
                        graphics.setColor(this.getChartForeground());
                        if (this.a((double)n11, (double)n12, n14 + dimension.height, rectangle)) {
                            graphics.setFont(font);
                            this.a(graphics, string3, n13, n14, dimension2, 0, n3);
                        }
                    }
                    if (this.bV == 1 && this.isValueLabelsOn(n5) || this.a1 == 1 && this.s || this.ai == 1 && this.aJ) {
                        int n15 = 0;
                        int n16 = fontMetrics2.getAscent();
                        Color color = null;
                        if (this.a1 == 1 && this.s) {
                            graphics.setFont(font2);
                            color = this.getSampleLabelColor(n9);
                            n15 = n4;
                            n16 = fontMetrics2.getAscent();
                        } else if (this.bV == 1 && this.isValueLabelsOn(n5)) {
                            graphics.setFont(font);
                            n15 = n3;
                            n16 = fontMetrics.getAscent();
                        } else if (this.ai == 1 && this.aJ) {
                            graphics.setFont(font2);
                            color = this.getSeriesLabelColor(n5);
                        }
                        if (color == null) {
                            color = this.getChartForeground();
                        }
                        String string4 = this.a(n5, n9, this.aJ, 5);
                        Dimension dimension3 = this.a(string4, graphics.getFontMetrics());
                        Dimension dimension4 = this.a(dimension3, n15);
                        int n17 = Math.round(n11 - dimension4.width / 2) + 1;
                        if (bl && !this.bR) {
                            n17 -= this.m.x;
                        }
                        int n18 = n12;
                        if (bl && d5 >= d6) {
                            n18 = (int)((double)n18 + (double)this.m.y / (double)n2);
                        }
                        int n19 = n18;
                        n19 = n15 % 180 == 0 ? (n19 += n16) : (n19 += 6);
                        int n20 = n18;
                        if (n15 % 180 != 0) {
                            n20 -= dimension4.height;
                        }
                        boolean bl3 = false;
                        int n21 = 0;
                        try {
                            bl3 = this.bY[n5][n9];
                            n21 = this.b4[n5];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            System.out.println("Internal error with value labels");
                            indexOutOfBoundsException.printStackTrace();
                        }
                        if (bl3 || this.bV == 0 && this.isValueLabelsOn(n5)) {
                            if (n21 >= dimension.height) {
                                n19 += n21 / 2;
                                n20 -= n21 / 2;
                            } else {
                                n19 += dimension.height / 2 - 3;
                                n20 -= dimension.height / 2 - 1;
                            }
                        }
                        if ((n18 = d5 < d6 ? n19 : n20) != n19 && bl && !this.bR) {
                            double d7 = (double)this.m.x / (double)n2;
                            n17 = (int)((double)n17 + d7);
                        }
                        n17 = bl ? Math.max(rectangle.x - this.m.x + 2, n17) : Math.max(rectangle.x + 2, n17);
                        n17 = Math.min(n17, rectangle.x + rectangle.width - dimension4.width - 1);
                        if (this.a((double)n11, (double)n12, n18 + dimension4.height, rectangle)) {
                            graphics.setColor(color);
                            this.a(graphics, string4, n17, n18, dimension3, 0, n15);
                        }
                    }
                }
                ++n9;
            }
            ++n5;
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        String[] stringArray = this.getSampleLabels();
        Font font = this.getFont("sampleLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getLabelAngle("sampleLabelAngle");
        int n2 = Math.max(this.visibleSamples[0] - 1, 0);
        int n3 = Math.min(n2 + this.visibleSamples[1] + 1, this.getSampleCount());
        if (this.A) {
            n2 = 0;
            n3 = this.getSampleCount();
        }
        double d = 0.0;
        int n4 = n2;
        while (n4 < n3) {
            String string = null;
            if (stringArray != null) {
                string = stringArray[n4];
            }
            Dimension dimension = this.a(string, fontMetrics);
            Dimension dimension2 = this.a(dimension, n);
            if (this.s && (this.a1 == 2 || this.a1 == 4)) {
                int n5 = rectangle.y + rectangle.height;
                int n6 = rectangle.x;
                int n7 = rectangle.x + rectangle.width;
                if (this.is3DModeOn()) {
                    n5 -= this.m.y;
                    n7 -= this.m.x;
                    n6 -= this.m.x;
                }
                if (this.T) {
                    n5 += 10;
                }
                int n8 = 0;
                if (this.bT != null && n4 < this.bT.length) {
                    n8 = this.bT[n4];
                }
                if (string != null && string.length() > 0 && (n8 -= this.is3DModeOn() ? this.m.x : 0) >= n6 && n8 <= n7 + 1) {
                    int n9 = n5 + 8;
                    if (n % 180 == 0) {
                        n9 += fontMetrics.getMaxAscent() - 4;
                    }
                    int n10 = 0;
                    n10 = n % 180 == 0 ? n8 - dimension2.width / 2 : (n % 360 > 90 && n % 360 < 180 || n % 360 > 270 ? n8 - dimension2.width + fontMetrics.getAscent() / 2 : n8 - fontMetrics.getAscent() / 2);
                    graphics.setFont(font);
                    Color color = this.getForeground();
                    Color color2 = this.getSampleLabelColor(n4);
                    if (color2 == null) {
                        color2 = color;
                    }
                    graphics.setColor(color);
                    if (this.bZ) {
                        if (string != null && string.trim().length() > 0 && ((double)n10 > d || n4 == 0)) {
                            graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                            graphics.setColor(color2);
                            this.a(graphics, string, n10, n9, dimension, 0, n);
                            d = n10 + dimension2.width;
                        }
                    } else if (string != null && string.trim().length() > 0) {
                        graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                        graphics.setColor(color2);
                        this.a(graphics, string, n10, n9, dimension, 0, n);
                    }
                }
            }
            ++n4;
        }
    }

    boolean a(Graphics graphics, Rectangle rectangle) {
        int n = this.overlayCharts.size();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n2);
            if (chart != null && this.isOverlayChartOn(n2) && !bl) {
                bl = chart.a(graphics, rectangle);
            }
            --n2;
        }
        boolean bl2 = this.isValueLabelsOn(-1) && this.bV == 3;
        bl2 |= this.s && (this.a1 == 3 || this.a1 == 4);
        if (bl2 |= this.aJ && this.ai == 3) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.R >= 0 && this.bm >= 0) {
                ChartSample chartSample = this.getSample(this.bm, this.R);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    String string = this.a(this.bm, this.R, this.aJ, 3);
                    this.if(graphics, rectangle, this.bm, this.R, string, font, fontMetrics);
                }
                return true;
            }
            if (this.bm >= 0 && this.bm < this.getSeriesCount() && this.isFloatingOnLegendOn()) {
                int n3 = this.getSampleCount();
                int n4 = 0;
                while (n4 < n3) {
                    ChartSample chartSample = this.getSample(this.bm, n4);
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        String string = this.a(this.bm, n4, false, 3);
                        this.if(graphics, rectangle, this.bm, n4, string, font, fontMetrics);
                    }
                    ++n4;
                }
                return true;
            }
        }
        return false;
    }

    private String a(int n, int n2, boolean bl, int n3) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String string2 = "";
        boolean bl2 = n3 == 5 && this.ai == 1;
        bl2 |= n3 == 3 && this.ai == 3;
        boolean bl3 = n3 == 5 && this.a1 == 1;
        bl3 |= n3 == 3 && (this.a1 == 3 || this.a1 == 4);
        boolean bl4 = n3 == 5 && this.bV == 1;
        bl4 |= n3 == 3 && this.bV == 3;
        if (bl && bl2 && (string = this.getSeriesLabel(n)) != null) {
            string2 = string2 + string;
            if (!string.endsWith("\n") && this.s && bl3 && this.getSampleLabel(n2) != null) {
                string2 = n3 == 3 ? string2 + " : " : string2 + ":";
            }
        }
        if (this.s && bl3 && this.getSampleLabel(n2) != null) {
            string2 = string2 + this.getSampleLabel(n2);
        }
        if (this.isValueLabelsOn(n) && bl4) {
            String string3;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            if (string2.length() > 0) {
                String string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string != null ? string + string4 : string4;
                String string5 = string4 = string3 != null ? string4 + string3 : string4;
                string2 = string2.endsWith("\n") ? string2 + string4 : (n3 == 3 ? string2 + " : " + string4 : string2 + ":" + string4);
            } else {
                string2 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string2 = string != null ? string + string2 : string2;
                string2 = string3 != null ? string2 + string3 : string2;
            }
        }
        return string2;
    }

    private void if(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        int n3 = 0;
        if (this.is3DModeOn()) {
            if (this.bR) {
                n3 = -this.a;
            } else {
                double d = (double)this.m.x / (double)this.getSeriesCount();
                n3 = (int)Math.round(d * (double)n) - this.m.x;
            }
        }
        int n4 = this.bX[n][n2][0];
        int n5 = this.bX[n][n2][1];
        if (n4 < rectangle.x || n4 > rectangle.x + rectangle.width - n3) {
            return;
        }
        if (n5 < rectangle.y || n5 > (this.is3DModeOn() ? rectangle.y + rectangle.height - this.m.y : rectangle.y + rectangle.height)) {
            return;
        }
        Dimension dimension = this.a(string, fontMetrics);
        int n6 = n4 - dimension.width / 2 + n3;
        int n7 = n5 - dimension.height + fontMetrics.getAscent() - 3;
        Dimension dimension2 = this.getSize();
        n6 = Math.max(n6, 3);
        n6 = Math.min(n6, dimension2.width - dimension.width - 3);
        n7 = Math.max(n7, fontMetrics.getAscent());
        n7 = Math.min(n7, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n6 - 2, n7 - n8 + n9 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        graphics.setColor(this.getSampleColor(n).darker());
        graphics.drawRect(n6 - 3, n7 - n8 + n9 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.a(graphics, string, n6, n7, dimension, 0, 0);
    }

    private void a(Graphics graphics, int n, int n2, int n3, Color color) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        String string = this.getLegendImage(n);
        Dimension dimension = this.a(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = (Image)this.ah.get(string);
            if (image != null) {
                graphics.drawImage(image, n2 - dimension.width / 2, n3 - dimension.height / 2, this);
            }
        } else {
            int n4 = 6;
            if (n >= 0 && n < this.b4.length) {
                n4 = this.b4[n];
            }
            int n5 = 0;
            if (n >= 0 && n < this.b2.length) {
                n5 = this.b2[n];
            }
            Color color2 = this.getChartBackground();
            graphics.setColor(color);
            switch (n5) {
                case 0: {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 2: {
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 1: {
                    graphics.setColor(color2);
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 3: {
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 5: {
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 4: {
                    graphics.setColor(color2);
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] nArray = new int[4];
                    nArray[0] = nArray[2] = n2;
                    nArray[1] = n2 + n4 / 2;
                    nArray[3] = n2 - n4 / 2;
                    int[] nArray2 = new int[4];
                    nArray2[0] = n3 - n4 / 2;
                    nArray2[2] = n3 + n4 / 2;
                    nArray2[1] = nArray2[3] = n3;
                    if (n5 == 7) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    } else if (n5 == 8) {
                        graphics.setColor(color);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color);
                    graphics.drawPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setClip(shape);
    }

    private void for(Graphics graphics, Rectangle rectangle, int n) {
        if (this.aD[n = Math.min(this.aD.length - 1, Math.max(0, n))]) {
            int n2 = Math.max(this.W[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.m.x;
            int n4 = n2 - this.m.y;
            graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        }
    }

    boolean a() {
        return this.isValueLabelsOn() && this.bV == 3 || this.s && (this.a1 == 3 || this.a1 == 4) || this.aJ;
    }
}

