package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Suppliers<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class SuppliersBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int SupplierID;
    protected int old_SupplierID; // Old value of the key is kept too
    protected String CompanyName;
    protected String ContactName;
    protected String ContactTitle;
    protected String Address;
    protected String City;
    protected String Region;
    protected String PostalCode;
    protected String Country;
    protected String Phone;
    protected String Fax;
    protected String HomePage;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected SuppliersBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public SuppliersBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public SuppliersBase(CS cs, int SupplierID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_SuppliersBase");

            cc.setInt(1, SupplierID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public SuppliersBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        SupplierID = old_SupplierID = rs.getInt("SupplierID");
        CompanyName = rs.getString("CompanyName");
        ContactName = rs.getString("ContactName");
        ContactTitle = rs.getString("ContactTitle");
        Address = rs.getString("Address");
        City = rs.getString("City");
        Region = rs.getString("Region");
        PostalCode = rs.getString("PostalCode");
        Country = rs.getString("Country");
        Phone = rs.getString("Phone");
        Fax = rs.getString("Fax");
        HomePage = rs.getString("HomePage");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for SupplierID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getSupplierID() {
        return SupplierID;
    }

    /**
     * Setter for SupplierID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setSupplierID(int value) {
        this.SupplierID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field SupplierID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfSupplierID(
        int maxResults) throws SQLException {
        return getResultSetWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field SupplierID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithSupplierIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_SupplierID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, getSupplierID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field SupplierID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSupplierIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSupplierIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public Iterator getIteratorWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getIteratorWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field SupplierID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSupplierIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ContactName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getContactName() {
        return ContactName;
    }

    /**
     * Setter for ContactName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setContactName(String value) {
        this.ContactName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field ContactName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfContactName(
        int maxResults) throws SQLException {
        return getResultSetWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field ContactName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_ContactName");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field ContactName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithContactNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public Iterator getIteratorWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getIteratorWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field ContactName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ContactTitle.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getContactTitle() {
        return ContactTitle;
    }

    /**
     * Setter for ContactTitle.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setContactTitle(String value) {
        this.ContactTitle = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field ContactTitle
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfContactTitle(
        int maxResults) throws SQLException {
        return getResultSetWithContactTitleValueOf(cs, getContactTitle(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field ContactTitle
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithContactTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_ContactTitle");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field ContactTitle
     * for equality with the same ContactTitle as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfContactTitle(int maxResults)
        throws SQLException {
        return getLinkedListWithContactTitleValueOf(cs, getContactTitle(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field ContactTitle
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithContactTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithContactTitleValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field ContactTitle
     * for equality with the same ContactTitle as this instance.
     */
    public Iterator getIteratorWithSameValueOfContactTitle(int maxResults)
        throws SQLException {
        return getIteratorWithContactTitleValueOf(cs, getContactTitle(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field ContactTitle
     * for equality with the "value".
     */
    public static Iterator getIteratorWithContactTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithContactTitleValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getAddress() {
        return Address;
    }

    /**
     * Setter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setAddress(String value) {
        this.Address = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getResultSetWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_Address");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Address
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public Iterator getIteratorWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getIteratorWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Address
     * for equality with the "value".
     */
    public static Iterator getIteratorWithAddressValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithAddressValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCity() {
        return City;
    }

    /**
     * Setter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCity(String value) {
        this.City = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field City
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getResultSetWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field City
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_City");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getRegion() {
        return Region;
    }

    /**
     * Setter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegion(String value) {
        this.Region = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getResultSetWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_Region");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Region
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getIteratorWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Region
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPostalCode() {
        return PostalCode;
    }

    /**
     * Setter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPostalCode(String value) {
        this.PostalCode = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPostalCode(
        int maxResults) throws SQLException {
        return getResultSetWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_PostalCode");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, getPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCountry() {
        return Country;
    }

    /**
     * Setter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCountry(String value) {
        this.Country = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getResultSetWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_Country");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Phone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPhone() {
        return Phone;
    }

    /**
     * Setter for Phone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPhone(String value) {
        this.Phone = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Phone
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getResultSetWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Phone
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPhoneValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_Phone");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Phone
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPhoneValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public Iterator getIteratorWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getIteratorWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Phone
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Fax.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getFax() {
        return Fax;
    }

    /**
     * Setter for Fax.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setFax(String value) {
        this.Fax = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Fax
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfFax(int maxResults)
        throws SQLException {
        return getResultSetWithFaxValueOf(cs, getFax(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of SuppliersBase's by querying table field Fax
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithFaxValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_SuppliersBase_Fax");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Fax
     * for equality with the same Fax as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFax(int maxResults)
        throws SQLException {
        return getLinkedListWithFaxValueOf(cs, getFax(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersBase's by querying table field Fax
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFaxValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFaxValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Fax
     * for equality with the same Fax as this instance.
     */
    public Iterator getIteratorWithSameValueOfFax(int maxResults)
        throws SQLException {
        return getIteratorWithFaxValueOf(cs, getFax(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersBase's by querying table field Fax
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFaxValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithFaxValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for HomePage.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getHomePage() {
        return HomePage;
    }

    /**
     * Setter for HomePage.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setHomePage(String value) {
        this.HomePage = value;
        isDirty = true;
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return SuppliersBase.delete(cs, SupplierID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int SupplierID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_SuppliersBase");

            cc.setInt(1, SupplierID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_SuppliersBase");

                cc.setString(1, getCompanyName());

                cc.setString(2, getContactName());

                cc.setString(3, getContactTitle());

                cc.setString(4, getAddress());

                cc.setString(5, getCity());

                cc.setString(6, getRegion());

                cc.setString(7, getPostalCode());

                cc.setString(8, getCountry());

                cc.setString(9, getPhone());

                cc.setString(10, getFax());

                cc.setString(11, getHomePage());

                cc.setInt(12, getSupplierID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_SupplierID = SupplierID;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_SuppliersBase");

            cc.setString(1, getCompanyName());

            cc.setString(2, getContactName());

            cc.setString(3, getContactTitle());

            cc.setString(4, getAddress());

            cc.setString(5, getCity());

            cc.setString(6, getRegion());

            cc.setString(7, getPostalCode());

            cc.setString(8, getCountry());

            cc.setString(9, getPhone());

            cc.setString(10, getFax());

            cc.setString(11, getHomePage());

            rs = cc.executeQuery();
            rs.next();

            setSupplierID(rs.getInt(1));

            updateOldKeys();

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "SupplierID:" + getSupplierID());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "ContactName:" + getContactName());

        System.out.println(prefix + "ContactTitle:" + getContactTitle());

        System.out.println(prefix + "Address:" + getAddress());

        System.out.println(prefix + "City:" + getCity());

        System.out.println(prefix + "Region:" + getRegion());

        System.out.println(prefix + "PostalCode:" + getPostalCode());

        System.out.println(prefix + "Country:" + getCountry());

        System.out.println(prefix + "Phone:" + getPhone());

        System.out.println(prefix + "Fax:" + getFax());

        System.out.println(prefix + "HomePage:" + getHomePage());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(SupplierID);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(ContactName);
        sb.append(",");
        sb.append(ContactTitle);
        sb.append(",");
        sb.append(Address);
        sb.append(",");
        sb.append(City);
        sb.append(",");
        sb.append(Region);
        sb.append(",");
        sb.append(PostalCode);
        sb.append(",");
        sb.append(Country);
        sb.append(",");
        sb.append(Phone);
        sb.append(",");
        sb.append(Fax);
        sb.append(",");
        sb.append(HomePage);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
