package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Order Subtotals<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Order_SubtotalsBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int OrderID;
    protected Double Subtotal;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Order_SubtotalsBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Order_SubtotalsBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Order_SubtotalsBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        OrderID = rs.getInt("OrderID");
        Subtotal = new Double(rs.getDouble("Subtotal"));

        if (rs.wasNull()) {
            Subtotal = null;
        }

        ;
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getOrderID() {
        return OrderID;
    }

    /**
     * Setter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setOrderID(int value) {
        this.OrderID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getResultSetWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithOrderIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_SubtotalsBase_OrderID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_SubtotalsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of Order_SubtotalsBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Subtotal.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getSubtotal() {
        return Subtotal;
    }

    /**
     * Setter for Subtotal.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setSubtotal(Double value) {
        this.Subtotal = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfSubtotal(int maxResults)
        throws SQLException {
        return getResultSetWithSubtotalValueOf(cs, getSubtotal(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithSubtotalValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_SubtotalsBase_Subtotal");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the same Subtotal as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSubtotal(int maxResults)
        throws SQLException {
        return getLinkedListWithSubtotalValueOf(cs, getSubtotal(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSubtotalValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSubtotalValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_SubtotalsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the same Subtotal as this instance.
     */
    public Iterator getIteratorWithSameValueOfSubtotal(int maxResults)
        throws SQLException {
        return getIteratorWithSubtotalValueOf(cs, getSubtotal(), maxResults);
    }

    /**
     * Gets an Iterator of Order_SubtotalsBase's by querying table field Subtotal
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSubtotalValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithSubtotalValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Order_SubtotalsBase");

            cc.setInt(1, getOrderID());

            if (Subtotal == null) {
                cc.setNull(2, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(2, getSubtotal().doubleValue());
            }

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "OrderID:" + getOrderID());

        System.out.println(prefix + "Subtotal:" + getSubtotal());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(OrderID);
        sb.append(",");
        sb.append(Subtotal);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
