package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Categories <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class CategoriesCached extends CategoriesBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public CategoriesCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected CategoriesCached(CS cs, int CategoryID) throws SQLException {
        super(cs, CategoryID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public CategoriesCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Gets a LinkedList of CategoriesCached's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, getCategoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CategoriesCached's by querying table field CategoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CategoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CategoriesCached's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets an Iterator of CategoriesCached's by querying table field CategoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of CategoriesCached's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CategoriesCached's by querying table field CategoryName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CategoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CategoriesCached's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets an Iterator of CategoriesCached's by querying table field CategoryName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return CategoriesCached.delete(cs, CategoryID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int CategoryID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                CategoriesCached.class,
                
            new Integer(CategoryID)
            });

        return CategoriesBase.delete(cs, CategoryID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { CategoriesCached.class, new Integer(CategoryID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached CategoriesCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { CategoriesCached.class });
    }

    /**
     * Flush a cached CategoriesCached item.
     */
    public static void flushCache(int CategoryID) {
        Cache.getCache().removeSynchronized(new Object[] {
                CategoriesCached.class,
                
            new Integer(CategoryID)
            });
    }

    private static CategoriesCached cacheLookup(int CategoryID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (CategoriesCached.class) {
            CategoriesCached t = (CategoriesCached) c.get(new Object[] {
                        CategoriesCached.class,
                        
                    new Integer(CategoryID)
                    });

            if (t != null) {
                return (CategoriesCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static CategoriesCached instance(CS cs, int CategoryID)
        throws SQLException, CloneNotSupportedException {
        CategoriesCached t = cacheLookup(CategoryID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new CategoriesCached(cs, CategoryID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth) {
        Element root = new Element("CategoriesCached");

        root.setAttribute("CategoryID", String.valueOf(getCategoryID()));

        root.addContent(new Element("CategoryName").setText(getCategoryName()));

        root.addContent(new Element("Description").setText(getDescription()));

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
