/*
 * Decompiled with CFR 0.152.
 */
package org.aris.cache.universalcache;

import java.util.Iterator;
import org.aris.cache.universalcache.UniversalCacheStore;
import org.aris.maps.ObjectArrayMapStore;
import org.aris.maps.lists.LinkedListEx;

public class UniversalCache {
    private int cacheObjectCurrentMaximum = 0;
    private int cacheObjectsMin = 0;
    private int cacheObjectsMax = 0;
    private ObjectArrayMapStore cache = new ObjectArrayMapStore();
    private LinkedListEx useful = new LinkedListEx();
    private volatile int hits = 0;
    private volatile int misses = 0;
    private float adjustFactor = 0.0f;
    private int dSize = 0;
    private float adjustFactorUnchanged = 0.0f;
    private boolean allowResize = false;
    static /* synthetic */ Class class$0;

    public void clear() {
        this.cache = new ObjectArrayMapStore();
        this.useful = new LinkedListEx();
        this.hits = 0;
        this.misses = 0;
    }

    protected void adjustMaxSize(int dSize) {
        int t = this.cacheObjectCurrentMaximum + dSize;
        if (t >= this.cacheObjectsMin && t <= this.cacheObjectsMax) {
            this.cacheObjectCurrentMaximum += dSize;
            if (dSize < 0) {
                LinkedListEx linkedListEx = this.useful;
                synchronized (linkedListEx) {
                    while (this.useful.size() > this.cacheObjectCurrentMaximum) {
                        Object[] key = (Object[])this.useful.getLast();
                        this.removeSynchronized(key);
                    }
                }
            }
        }
    }

    private synchronized void checkForSizeAdjustation() {
        if (this.misses > 0) {
            float f = (float)this.hits / (float)this.misses;
            if (f < this.adjustFactor - this.adjustFactorUnchanged) {
                this.adjustMaxSize(this.dSize);
            } else if (f > this.adjustFactor + this.adjustFactorUnchanged) {
                this.adjustMaxSize(-this.dSize);
            }
        }
    }

    protected void incHits() {
        ++this.hits;
        if (this.allowResize) {
            this.checkForSizeAdjustation();
        }
    }

    protected void incMisses() {
        ++this.misses;
        if (this.allowResize) {
            this.checkForSizeAdjustation();
        }
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public UniversalCache(int cacheObjectsMin, int cacheObjectsMax, float adjustFactor, float adjustFactorUnchanged, int dSize, boolean allowResize) {
        this.initializeCacheParams(cacheObjectsMin, cacheObjectsMax, adjustFactor, adjustFactorUnchanged, dSize, allowResize);
    }

    protected void initializeCacheParams(int cacheObjectsMin, int cacheObjectsMax, float adjustFactor, float adjustFactorUnchanged, int dSize, boolean allowResize) {
        this.cacheObjectCurrentMaximum = cacheObjectsMax;
        this.cacheObjectsMin = cacheObjectsMin;
        this.cacheObjectsMax = cacheObjectsMax;
        this.adjustFactor = adjustFactor;
        this.dSize = dSize;
        this.adjustFactorUnchanged = adjustFactorUnchanged;
        this.allowResize = allowResize;
    }

    public UniversalCache(int cacheObjectsAverage) {
        int minmaxf = cacheObjectsAverage / 2;
        this.initializeCacheParams(cacheObjectsAverage - minmaxf, cacheObjectsAverage + minmaxf, 1.0f, 0.5f, minmaxf / 10, false);
    }

    public void putSynchronized(Object[] key, Object value) {
        Object object = key[0];
        synchronized (object) {
            this.put(key, value);
        }
    }

    public void put(Object[] key, Object value) {
        UniversalCacheStore ucs = (UniversalCacheStore)this.cache.get(key);
        if (ucs != null) {
            ucs.value = value;
            this.makeUseful(key, ucs);
        } else {
            LinkedListEx linkedListEx = this.useful;
            synchronized (linkedListEx) {
                if (this.useful.size() >= this.cacheObjectCurrentMaximum) {
                    Object[] lkey = (Object[])this.useful.removeLast();
                    this.cache.remove(lkey);
                }
                ucs = new UniversalCacheStore(value);
                ucs.linkedListExEntry = this.useful.addFirst(key);
            }
            this.cache.put(key, ucs);
        }
    }

    public Object getSynchronized(Object[] key) {
        Object object = key[0];
        synchronized (object) {
            return this.get(key);
        }
    }

    public Object get(Object[] key) {
        UniversalCacheStore ucs = (UniversalCacheStore)this.cache.get(key);
        if (ucs == null) {
            this.incMisses();
            return null;
        }
        this.incHits();
        this.makeUseful(key, ucs);
        return ucs.value;
    }

    private void makeUseful(Object[] key, UniversalCacheStore ucs) {
        LinkedListEx linkedListEx = this.useful;
        synchronized (linkedListEx) {
            this.useful.remove(ucs.linkedListExEntry);
            ucs.linkedListExEntry = this.useful.addFirst(key);
        }
    }

    private void removeFromUseful(UniversalCacheStore ucs) {
        LinkedListEx linkedListEx = this.useful;
        synchronized (linkedListEx) {
            this.useful.remove(ucs.linkedListExEntry);
        }
    }

    public Object removeSynchronized(Object[] key) {
        Object object = key[0];
        synchronized (object) {
            return this.remove(key);
        }
    }

    public Object remove(Object[] key) {
        UniversalCacheStore ucs = (UniversalCacheStore)this.cache.remove(key);
        if (ucs != null) {
            this.removeFromUseful(ucs);
            return ucs.value;
        }
        return null;
    }

    public void flushSynchronized(Object[] startKey) {
        Object object = startKey[0];
        synchronized (object) {
            this.flush(startKey);
        }
    }

    public void flush(Object[] startKey) {
        Object node = this.cache.remove(startKey);
        if (node != null) {
            Class<?> clazz = node.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.aris.maps.ObjectArrayMapStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                this.flush0((ObjectArrayMapStore)node);
            } else {
                this.removeFromUseful((UniversalCacheStore)node);
            }
        }
    }

    private void flush0(ObjectArrayMapStore m) {
        Iterator it = m.getStore().values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            Class<?> clazz = o.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.aris.maps.ObjectArrayMapStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                this.flush0((ObjectArrayMapStore)o);
                continue;
            }
            this.removeFromUseful((UniversalCacheStore)o);
        }
    }

    public void dump(boolean printvalues) {
        System.out.print("=== Cache dump ==========================================\n");
        this.cache.dump("NODES==>");
        System.out.print("\n\nUseful LinkedList keys :\n[");
        Iterator it = this.useful.iterator();
        while (it.hasNext()) {
            Object[] me = (Object[])it.next();
            int i = 0;
            while (i < me.length) {
                if (i > 0) {
                    System.out.print("/");
                }
                System.out.print(me[i].toString());
                ++i;
            }
            if (!it.hasNext()) continue;
            System.out.print(" , ");
        }
        System.out.println("]\n========================================");
        System.out.println("Cache stats: size: " + this.useful.size() + " Hits:" + this.getHits() + " Misses:" + this.getMisses());
        System.out.println("========================================");
        System.out.print("===/Cache dump ==========================================\n");
    }

    public boolean isAllowResize() {
        return this.allowResize;
    }

    public void setAllowResize(boolean allowResize) {
        this.allowResize = allowResize;
    }
}

