#ifndef __nova__
#define __nova__

#include <CWindow.h>
#include <CError.h>
#include <CInput.h>
#include <CSound.h>
#include <CMovie.h>
#include <CGraph2D.h>

using namespace std;

#ifdef DEBUG_NOVA
#pragma comment(lib,"CNovaD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CNova.lib")
#endif

class CNova
{
public:
	CNova();
	CNova(const char *file);
	~CNova();
	int Setup(HINSTANCE hinstance,char title[],int icon);
	int Destroy();
	int Loop();
	MSG Get_Message();
	bool Key_Down(int key);
	int Get_XAxis();
	int Get_YAxis();
	int Get_ZAxis();
	HWND Get_Hwnd();
	CMovie *Create_Movie(WCHAR *file);
	int Destroy_Movie(CMovie *movie);
	CError *error;
	CSound *sound;
	CGraph2D *Graphic;
private:
	CWindow *window;
	CInput *input;
	int destroyed;
	int num_frames;
	DWORD start_time;
	DWORD finish_time;
	MSG message;
};
#endif
