#ifndef __midi__
#define __midi__

#include <globals.h>

#ifdef DEBUG_NOVA
#pragma comment(lib,"CMidiD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CMidi.lib")
#endif

class CMidi
{
private:
	IDirectMusicSegment8 *Segment;
	IDirectMusicPerformance8 *Perf;
	IDirectMusicAudioPath8 *Path;
	int volume;
public:
	CMidi();
	~CMidi();
	int Create(WCHAR *file,IDirectMusicLoader8 *Loader,IDirectMusicPerformance8 *Perf2,int channel);
	int Play();
	int Destroy();
	int Set_Volume(int volume);
	int Pan(float x);
	bool Is_Playing();
	int Stop();
};

#endif