#include <CSurface.h>

CSurface::~CSurface()
{
	if(lpddoff!=NULL)
	{
		lpddoff->Release();
		lpddoff=NULL;
	}
}

CSurface::CSurface()
{
	lpddoff=NULL;
}

int CSurface::Create(int W, int H,LPDIRECTDRAW7 &lpdd)
{
	Width=W;
	Height=H;
	DD_INIT_STRUCT(ddsd);
	ddsd.dwFlags=DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT;
	ddsd.dwWidth=W;
	ddsd.dwHeight=H;
	ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_VIDEOMEMORY;
	if(FAILED(lpdd->CreateSurface(&ddsd,&lpddoff,NULL)))
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
		if(FAILED(lpdd->CreateSurface(&ddsd,&lpddoff,NULL)))
			return D_ERROR;
	}
	return D_FINE;
}

int CSurface::Bitmap(CBitmap *file,int bpp,LPDIRECTDRAW7 &lpdd)
{
	bpp2=bpp;
	int widt, heigh;
	widt=file->width;
	heigh=file->height;
	this->Create(widt,heigh,lpdd);
	DDCOLORKEY	color_key2;
	if(bpp==32)
	{
		RECT dest_rect;
		DDBLTFX ddbltfx;
		DD_INIT_STRUCT(ddbltfx);
		ddbltfx.dwFillColor = _RGB32BIT(0,file->buffer[2],file->buffer[1],file->buffer[0]);
		dest_rect.left=0;
		dest_rect.top=0;
		dest_rect.right=Width;
		dest_rect.bottom=Height;
		if(FAILED(lpddoff->Blt(&dest_rect,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx)))
			return D_ERROR;
		color_key2.dwColorSpaceLowValue=_RGB32BIT(0,file->buffer[2],file->buffer[1],file->buffer[0]);
		color_key2.dwColorSpaceHighValue=_RGB32BIT(0,file->buffer[2],file->buffer[1],file->buffer[0]);
	}
	if(bpp==16)
	{
		RECT dest_rect;
		DDBLTFX ddbltfx;
		DD_INIT_STRUCT(ddbltfx);
		ddbltfx.dwFillColor = _RGB16BIT565(file->buffer[2]>>3,file->buffer[1]>>2,file->buffer[0]>>3);
		dest_rect.left=0;
		dest_rect.top=0;
		dest_rect.right=Width;
		dest_rect.bottom=Height;
		if(FAILED(lpddoff->Blt(&dest_rect,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx)))
			return D_ERROR;
		color_key2.dwColorSpaceLowValue=_RGB16BIT565(file->buffer[2]>>3,file->buffer[1]>>2,file->buffer[0]>>3);
		color_key2.dwColorSpaceHighValue=_RGB16BIT565(file->buffer[2]>>3,file->buffer[1]>>2,file->buffer[0]>>3);
	}

	if(FAILED(lpddoff->SetColorKey(DDCKEY_SRCBLT,&color_key2)))
			return D_ERROR;
	this->Lock();
	for(int y=0;y<file->height;y++)
		for(int x=0;x<file->width;x++)
		{
			UCHAR blue  = (file->buffer[y*file->width*3 + x*3 + 0]),
				green = (file->buffer[y*file->width*3 + x*3 + 1]),
				red   = (file->buffer[y*file->width*3 + x*3 + 2]);
			if(bpp==32)
			{
			unsigned int pixel;
				pixel = _RGB32BIT(0,red,green,blue);
			primary_buffer[x + (y*ddsd.lPitch >> 2)] = pixel;
			}
			if(bpp==16)
			{
				blue=blue>>3;
				green=green>>2;
				red=red>>3;
				unsigned short pixel;
				pixel = _RGB16BIT565(red,green,blue);
				back_buffer[x + (y*ddsd.lPitch >> 1)] = pixel;
			}
		}
	this->Unlock();
	return D_FINE;
}

void CSurface::Lock()
{
	DD_INIT_STRUCT(ddsd);
	lpddoff->Lock(NULL,&ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT,NULL);
	if(this->bpp2==16)
		back_buffer=(unsigned short *)ddsd.lpSurface;
	if(this->bpp2==32)
		primary_buffer=(unsigned int *)ddsd.lpSurface;
}
	
void CSurface::Unlock()
{
	lpddoff->Unlock(NULL);
}
