#include <CMidi.h>

//creates the midi, path, and performance
int CMidi::Create(WCHAR *file,IDirectMusicLoader8 *Loader,IDirectMusicPerformance8 *Perf2,int channel)
{
	this->Destroy();
	this->Perf=Perf2;
	if(FAILED(Loader->LoadObjectFromFile(CLSID_DirectMusicSegment,IID_IDirectMusicSegment8,file,(LPVOID*) &Segment)))
		return D_ERROR;
	if(FAILED(Perf->CreateStandardAudioPath(DMUS_APATH_DYNAMIC_3D,(DWORD)channel,TRUE,&Path)))
		return D_ERROR;
	if(FAILED(Segment->Download(Path)))
		return D_ERROR;
	this->Set_Volume(100);
	IDirectSound3DListener *Listen=NULL;
    if(FAILED(Path->GetObjectInPath(0,DMUS_PATH_PRIMARY_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DListener,(LPVOID*) &Listen)))
		return D_ERROR;
	if(FAILED(Listen->SetRolloffFactor(0.25f,DS3D_IMMEDIATE)))
        return D_ERROR;
    Listen->Release();
	Listen=NULL;
	return D_FINE;
}

//0 to 100
int CMidi::Set_Volume(int volume)
{
	if(volume>100)
		volume=100;
	if(volume<0)
		volume=0;
	long total;
	this->volume=volume;
	if(volume!=0)
		total=(volume*20)-2000;
	if(volume==0)
		total=-9600;
	if(FAILED(Path->SetVolume(total,0)))
		return D_ERROR;
	return D_FINE;
}

//returns true if playing, false if not playing
bool CMidi::Is_Playing()
{
	if(Perf->IsPlaying(Segment,NULL)==S_OK)
		return TRUE;
	return FALSE;
}

//sets the new position of the sound
int CMidi::Pan(float x)
{
	IDirectSound3DBuffer8 *Buffer3D;
	if(FAILED(Path->GetObjectInPath(DMUS_PCHANNEL_ALL,DMUS_PATH_BUFFER,0,GUID_NULL,0,IID_IDirectSound3DBuffer,(LPVOID*)&Buffer3D)))
		return D_ERROR;
	if(FAILED(Buffer3D->SetPosition(x,0.0f,0.0f,DS3D_IMMEDIATE)))
		return D_ERROR;
	Buffer3D->Release();
	Buffer3D=NULL;
	return D_FINE;
}

//plays a sound
int CMidi::Play()
{
	if(this->volume==0)
		return D_FINE;
	if(FAILED(Perf->PlaySegmentEx(Segment,NULL,NULL,DMUS_SEGF_SECONDARY,0,NULL,NULL,Path)))
		return D_ERROR;
	return D_FINE;
}

int CMidi::Stop()
{
	if(this->Is_Playing())
	{
		if(FAILED(Perf->Stop(Segment,NULL,0,0)))
			return D_ERROR;
	}
	return D_FINE;
}


//destroys the class
int CMidi::Destroy()
{
	if(Segment!=NULL)
	{
		Segment->Unload(Path);
		Segment->Release();
		Segment=NULL;
	}
	if(Path!=NULL)
	{
		Path->Activate(FALSE);
		Path->Release();
		Path=NULL;
	}
	return D_FINE;
}

CMidi::CMidi()
{
	Segment=NULL;
	Perf=NULL;
	Path=NULL;
}

CMidi::~CMidi()
{
	this->Destroy();
}