#include <CGraph2D.h>

CGraph2D::CGraph2D()
{
	
}

CGraph2D::CGraph2D(HWND main_win,CError *err)
{
	this->error=err;
	lpdd=NULL;
	front=NULL;
	back=NULL;
	gamma=NULL;
	this->width=0;
	this->height=0;
	this->Locked=false;
	this->Restored=false;
	this->primary_buffer=NULL;
	this->back_buffer=NULL;
	int spot=0;
	for(double ang=0;ang<360;ang++)
	{
		double theta=(double)ang*3.14159/180;
		lcos[spot]=cos(theta);
		lsin[spot]=sin(theta);
		spot++;
	}
	this->main_window=main_win;
	error->write("Creating Graphics...");
	erro=0;
	if(D_ERROR==this->Set_Mode(640,480,16))
	{
		error->write("ERROR\n");
		erro=1;
	}
	else
		error->write("OK\n");
}

CGraph2D::~CGraph2D()
{
	error->write("Destroying Graphics...OK\n");
	if(lpdd!=NULL)
	{
		if(gamma!=NULL)
		{
			gamma->Release();
			gamma=NULL;
		}
		if(lpddclipper!=NULL)
		{
			lpddclipper->Release();
			lpddclipper=NULL;
		}
		if(back!=NULL)
		{
			back->Release();
			back=NULL;
		}
		if(front!=NULL)
		{
			front->Release();
			front=NULL;
		}
		lpdd->Release();
		lpdd=NULL;
	}
}

int CGraph2D::Loop()
{
	if(front->IsLost()||back->IsLost())
	{
		front->Restore();
		this->Restored=true;
		if(back->IsLost())
		{
			back->Restore();
			this->Restored=true;
		}
		Sleep(100);
		Circle(200,200,20,100,100,100);
	}
	else
	{
	if(this->Locked)
		this->Unlock();

	if(FAILED(front->Flip(NULL,DDFLIP_WAIT)))
		return D_ERROR;

	DD_INIT_STRUCT(fx);
	fx.dwFillColor=0;
	dest.left=0;
	dest.top=0;
	dest.right=this->width;
	dest.bottom=this->height;
	if(FAILED(back->Blt(&dest,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx)))
		return D_ERROR;
	this->Restored=false;
	}
	return D_FINE;
}

int CGraph2D::Fade()
{
	if(this->Locked)
		this->Unlock();
	DDGAMMARAMP gammaRamp; 
	DDGAMMARAMP gammaOld; 
	gamma->GetGammaRamp(0, &gammaOld);
	gamma->GetGammaRamp(0, &gammaRamp);
	for(int blackloop=255;blackloop>=0;blackloop--)
	{
		gammaRamp.red[blackloop]=0;
		gammaRamp.green[blackloop]=0;
		gammaRamp. blue [blackloop]=0;
		gamma->SetGammaRamp(0, &gammaRamp);
	}
	gamma->SetGammaRamp(0, &gammaOld);

	return D_FINE;
}

int CGraph2D::Text(char *text,int x,int y,int red,int green,int blue)
{
	if(this->Locked)
		this->Unlock();
	HDC dc;
	if(FAILED(back->GetDC(&dc)))
		return D_ERROR;
	SetTextColor(dc, RGB(red,green,blue));
	SetBkMode(dc, TRANSPARENT);
	TextOut(dc,x,y,text,strlen(text));
	if(FAILED(back->ReleaseDC(dc)))
		return D_ERROR;
	return D_FINE;
}

int CGraph2D::Text(int text,int x,int y,int red,int green,int blue)
{
	if(this->Locked)
		this->Unlock();
	char buff[80];
	sprintf(buff,"%d",text);
	HDC dc;
	if(FAILED(back->GetDC(&dc)))
		return D_ERROR;
	SetTextColor(dc, RGB(red,green,blue));
	SetBkMode(dc, TRANSPARENT);
	TextOut(dc,x,y,buff,strlen(buff));
	if(FAILED(back->ReleaseDC(dc)))
		return D_ERROR;
	return D_FINE;
}

int CGraph2D::Fill(RECT dest,int red,int green,int blue)
{
	if(this->Locked)
		this->Unlock();
	DD_INIT_STRUCT(fx);
	if(pixel.dwRGBBitCount==16)
		fx.dwFillColor=_RGB16BIT565(red,green,blue);
	if(pixel.dwRGBBitCount==15)
		fx.dwFillColor=_RGB16BIT555(red,green,blue);
	if(pixel.dwRGBBitCount==32)
		fx.dwFillColor=_RGB32BIT(0,red,green,blue);
	if(FAILED(back->Blt(&dest,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx)))
		return D_ERROR;
	return D_FINE;
}

int CGraph2D::Plot(int x,int y,int red,int green,int blue)
{
	if(x>=width||x<0||y>=height||y<0)
			return D_FINE;
	if(!this->Locked)
		if(D_ERROR==this->Lock())
			return D_ERROR;
	if(this->bpp==16)
	{
		int pit=(int)(ddsd.lPitch>>1);
		if(pit==640)
			y=(y<<9)+(y<<7);
		else if(pit==800)
			y=(y<<9)+(y<<8)+(y<<5);
		else if(pit==960)
			y=(y<<9)+(y<<8)+(y<<7)+(y<<6);
		else if(pit==1152)
			y=(y<<10)+(y<<7);
		else if(pit==1280)
			y=(y<<10)+(y<<8);
		else if(pit==1024)
			y=(y<<10);
		else
			y*=pit;
		pit=x+y;
		if(pixel.dwRGBBitCount==15)
			back_buffer[pit]=_RGB16BIT555(red,green,blue);
		if(pixel.dwRGBBitCount==16)
			back_buffer[pit]=_RGB16BIT565(red,green,blue);
	}
	if(this->bpp==32)
	{
		int pit=(int)(ddsd.lPitch>>2);
		if(pit==640)
			y=(y<<9)+(y<<7);
		else if(pit==800)
			y=(y<<9)+(y<<8)+(y<<5);
		else if(pit==1024)
			y=(y<<10);
		else if(pit==960)
			y=(y<<9)+(y<<8)+(y<<7)+(y<<6);
		else if(pit==1152)
			y=(y<<10)+(y<<7);
		else if(pit==1280)
			y=(y<<10)+(y<<8);
		else
			y*=pit;
		pit=x+y;
		primary_buffer[pit]=_RGB32BIT(0,red,green,blue);
	}
	this->Unlock();
	return D_FINE;
}

int CGraph2D::Lock()
{
	DD_INIT_STRUCT(ddsd);
	if(FAILED(back->Lock(NULL,&ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT,NULL)))
		return D_ERROR;
	this->Locked=true;
	if(this->bpp==16)
		back_buffer=(unsigned short *)ddsd.lpSurface;
	if(this->bpp==32)
		primary_buffer=(unsigned int *)ddsd.lpSurface;
	return D_FINE;
}

int CGraph2D::Unlock()
{
	if(FAILED(back->Unlock(NULL)))
		return D_ERROR;
	this->Locked=false;
	return D_FINE;
}

int CGraph2D::Line(int x1,int y1,int x2,int y2,int red,int green,int blue)
{
	if(x1>x2)
	{
		int x3=x1;
		x1=x2;
		x2=x3;
		int y3=y1;
		y1=y2;
		y2=y3;
	}
	if(x1==x2)
	{
		if(y1>y2)
		{
			int y3=y1;
			y1=y2;
			y2=y3;
		}
		for(int zq=y1;zq<=y2;zq++)
			Plot(x1,zq,red,green,blue);
		return D_FINE;
	}
	if(y1==y2)
	{
		for(int zq=x1;zq<=x2;zq++)
			Plot(zq,y1,red,green,blue);
		return D_FINE;
	}

	int dx, dy, dx2, dy2, y_inc,error;
	dx=x2-x1;
	dy=y2-y1;
	if(dy>=0)
		y_inc=1;
	else
	{
		y_inc=-1;
		dy=-dy;
	}
	dx2=dx<<1;
	dy2=dy<<1;
	if(dx>dy)
	{
		error=dy2-dx;
		for(int index=0;index<=dx;index++)
		{
			Plot(x1,y1,red,green,blue);
			if(error>=0)
			{
				error-=dx2;
				y1=y1+y_inc;
			}
			error+=dy2;
			x1++;
		}
		return D_FINE;
	}
	else
	{
		error=dx2-dy;
		for(int index=0;index<=dy;index++)
		{
			Plot(x1,y1,red,green,blue);
			if(error>=0)
			{
				error-=dy2;
				x1++;
			}
			error+=dx2;
			y1+=y_inc;
		}
		return D_FINE;
	}
	return D_FINE;
}

int CGraph2D::Circle(int x,int y,int radius,int red,int green,int blue)
{
	if(((x-radius)>this->width)||((x+radius)<0)||((y-radius)>this->height)||((y+radius)<0))
		return D_FINE;
	int lastx=0,lasty=0,x2=0,y2=0;
	int x3=(int)(x+(radius*lcos[1]));
	int y3=(int)(y+(radius*lsin[1]));
	int x5=x3;
	int y5=y3;
	for(int k=2;k<360;k++)
	{
		double temp1=lcos[k];
		double temp2=lsin[k];
		temp1*=radius;
		temp2*=radius;
		x2=(int)(x+temp1);
		y2=(int)(y+temp2);
		if(Line(x2,y2,x3,y3,red,green,blue)==D_ERROR)
			return D_ERROR;
		x3=x2;
		y3=y2;
	}
	if(Line(x3,y3,x5,y5,red,green,blue)==D_ERROR)
		return D_ERROR;
	return D_FINE;
}

int CGraph2D::Set_Mode(int Width,int Height,int BPP)
{
	if(this->Locked)
		this->Unlock();
	//destroy
	if(lpdd!=NULL)
	{
		if(gamma!=NULL)
		{
			gamma->Release();
			gamma=NULL;
		}
		if(lpddclipper!=NULL)
		{
			lpddclipper->Release();
			lpddclipper=NULL;
		}
		if(back!=NULL)
		{
			back->Release();
			back=NULL;
		}
		if(front!=NULL)
		{
			front->Release();
			front=NULL;
		}
		lpdd->Release();
		lpdd=NULL;
	}
	//set new mode
	if(FAILED(DirectDrawCreateEx(NULL,(VOID **)&lpdd, IID_IDirectDraw7,NULL)))
		return D_ERROR;

	if(FAILED(lpdd->SetCooperativeLevel(main_window, DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE|DDSCL_ALLOWREBOOT)))
		return D_ERROR;

	if(FAILED(lpdd->SetDisplayMode(Width,Height,BPP,0,0)))
		return D_ERROR;
	this->width=Width;
	this->height=Height;
	this->bpp=BPP;

	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
	ddsd.dwBackBufferCount=1;
	ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_COMPLEX|DDSCAPS_FLIP;

	if(FAILED(lpdd->CreateSurface(&ddsd,&front,NULL)))
		return D_ERROR;

	ddsd.ddsCaps.dwCaps=DDSCAPS_BACKBUFFER;
	if(FAILED(front->GetAttachedSurface(&ddsd.ddsCaps,&back)))
		return D_ERROR;

	memset(&pixel,0,sizeof(pixel));
	pixel.dwSize=sizeof(pixel);
	if(FAILED(front->GetPixelFormat(&pixel)))
		return D_ERROR;
	
	if(FAILED(front->QueryInterface(IID_IDirectDrawGammaControl,(void **)&gamma)))
		return D_ERROR;
	LPRGNDATA region_data;

	if (FAILED(lpdd->CreateClipper(0,&lpddclipper,NULL)))
		return D_ERROR;

	region_data = (LPRGNDATA)malloc(sizeof(RGNDATAHEADER)+sizeof(RECT));
	RECT clip_list={0,0,width,height};
	memcpy(region_data->Buffer,(void *)&clip_list, sizeof(RECT));
	region_data->rdh.dwSize          = sizeof(RGNDATAHEADER);
	region_data->rdh.iType           = RDH_RECTANGLES;
	region_data->rdh.nCount          = 1;
	region_data->rdh.nRgnSize        = sizeof(RECT);
	region_data->rdh.rcBound.left    =  0;
	region_data->rdh.rcBound.top     =  0;
	region_data->rdh.rcBound.right   = width;
	region_data->rdh.rcBound.bottom  = height;

	if (FAILED(lpddclipper->SetClipList(region_data, 0)))
	{
		free(region_data);
		return D_ERROR;
	}

	if (FAILED(back->SetClipper(lpddclipper)))
	{
		free(region_data);
		return D_ERROR;
	}
	free(region_data);
	return D_FINE;
}

int CGraph2D::Restore()
{
	if((lpdd->RestoreAllSurfaces())!=DD_OK)
		return D_ERROR;
	this->Restored=true;
	return D_FINE;
}

CSurface *CGraph2D::Create_Surface(const char *file,int type_flag)
{
	if(this->Locked)
		this->Unlock();
	error->write("Creating Surface...");
	CSurface *temp=new CSurface();
	if(type_flag==BITMAP_FILE)
	{
		CBitmap *temp2=new CBitmap(file);
		if(D_ERROR==temp->Bitmap(temp2,bpp,lpdd))
		{
			error->write("ERROR\n");
			return NULL;
		}
	}
	error->write("OK\n");
	return temp;
}

int CGraph2D::Destroy_Surface(CSurface *surf)
{
	if(this->Locked)
		this->Unlock();
	if(surf==NULL)
		return D_FINE;
	error->write("Destroying Surface...");
	delete surf;
	error->write("OK\n");
	return D_FINE;
}

int CGraph2D::Blit(CSurface *surf,RECT destination, RECT source)
{
	if(this->Locked)
		this->Unlock();
	if(surf->lpddoff->IsLost())
	{
		surf->lpddoff->Restore();
		return D_ERROR;
	}
	if(FAILED(back->Blt(&destination,surf->lpddoff,&source,DDBLT_KEYSRC|DDBLT_WAIT,NULL)))
		return D_ERROR;
	return D_FINE;
}
