#include <CNova.h>

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	CNova *Engine=new CNova();
	Engine->Setup(hInstance,"Example1",NO_ICON);
	CSurface *sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
	RECT source_rect,dest_rect;
	source_rect.left=0;
	source_rect.top=0;
	source_rect.right=sprite->Width;
	source_rect.bottom=sprite->Height;
	dest_rect.left=320;
	dest_rect.top=120;
	dest_rect.right=sprite->Width+320;
	dest_rect.bottom=sprite->Height+120;
	RECT line;
	line.left=200;
	line.top=260;
	line.right=460;
	line.bottom=261;

	//creating wav
	CWav *wav=Engine->sound->Create_Wav(L"C:\\DXSDK\\samples\\multimedia\\media\\s1.wav");
	//creating midi
	CMidi *midi=Engine->sound->Create_Midi(L"C:\\DXSDK\\samples\\multimedia\\media\\canyon.mid");
	//creating mp3
	CMP3 *mp3=Engine->sound->Create_MP3(L"C:\\DXSDK\\samples\\multimedia\\media\\piano.mp3");
	//set volume to 80 percent of max
	wav->Set_Volume(80);
	//set the position of the wav to the left and up
	wav->Set_Position(-1,1,0);
	//set speed of MP3 to 200% the speed of normal
	mp3->Set_Speed(200);

	if(midi!=NULL)//play the midi file
		if(!midi->Is_Playing())
			midi->Play();

	while(Engine->Loop()!=D_ERROR)
	{
		if(Engine->Key_Down(DIK_I))
		{
			if(midi!=NULL)//play the midi file
				if(!midi->Is_Playing())
					midi->Play();
				mp3->Stop();
		}
		//play the wav if P is pressed
		if(Engine->Key_Down(DIK_P)==true)
		{
			if(wav!=NULL)
				if(!wav->Is_Playing())  //check if playing, if it is, don't play the wav
					wav->Play();
		}

		//if M is pressed, stop the midi and play the mp3
		if(Engine->Key_Down(DIK_M))
		{
			if(midi!=NULL)
				if(midi->Is_Playing())
				{
					midi->Stop();
					if(mp3!=NULL)
						mp3->PlayFile();
				}
		}

		Engine->Graphic->Fill(dest_rect,0,0,255);
		if(Engine->Graphic->Blit(sprite,dest_rect,source_rect)==D_ERROR)
		{
			Engine->Graphic->Destroy_Surface(sprite);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}
		Engine->Graphic->Text("Hey I can write text on the screen, YAY!",200,240,255,255,255);
		Engine->Graphic->Fill(line,0,255,0); 
		if(Engine->Key_Down(DIK_ESCAPE))
			break;
		if(Engine->Key_Down(DIK_F1))
		{
			Engine->Graphic->Destroy_Surface(sprite);
			Engine->Graphic->Set_Mode(1024,768,16);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}
	}
	//destroying the wav
	Engine->sound->Destroy_Wav(wav);
	//destroying the midi
	Engine->sound->Destroy_Midi(midi);
	//destroy the mp3
	Engine->sound->Destroy_MP3(mp3);

	Engine->Graphic->Destroy_Surface(sprite);
	MSG temp=Engine->Get_Message();
	delete Engine;
	return temp.wParam;
}