// FolderTreeDlg.h : header file
//

#if !defined(AFX_FOLDERTREEDLG_H__31CA2186_2D12_11D6_9DD3_96F83D744632__INCLUDED_)
#define AFX_FOLDERTREEDLG_H__31CA2186_2D12_11D6_9DD3_96F83D744632__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include <afxtempl.h>     // cause templates used



/////////////////////////////////////////////////////////////////////////////
// CFolderTreeDlg dialog

class  AFX_EXT_CLASS CFolderTreeDlg : public CDialog
{
// Construction
public:
	CString m_CStrFolder;   //Selected Folder with Path from Picker, type CString

	CFolderTreeDlg(LPCTSTR InputPath=NULL, CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CFolderTreeDlg)
	enum { IDD = IDD_FOLDERTREE_DIALOG };
	CEdit	m_ED_ErrMessage;
	CEdit	m_ED_ShowSelectedPath;
	CButton	m_BN_OK;
	CButton	m_BN_ExpandNode;
	CStatic	m_ST_MakeFolder;
	CStatic	m_ST_DeleteFolder;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFolderTreeDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation

public:
      CToolTipCtrl*   m_pToolTip;  //Pointer for Tool Tip, type CToolTipCtrl


public:
	virtual ~CFolderTreeDlg();



protected:
	HICON m_hIcon;



protected:
  typedef CArray <CString, CString&> T_CStrArray; //Array of CString

  T_CStrArray g_aDrives; //Global Array with Drive Names, type: CArray <CString, CString&> T_CStrArray


  CImageList    g_ImgListDrv;   //Global Image List Object for Drive Names, type CImageList
  CImageList    *g_pImgListDrv; //Global Pointer to Image List for Drive Names, type CImageList

protected:
  CImageList    ImgListFTree;  //Global Image List Object for Folder Tree, type CImageList
  CImageList    *pImgLstFTree; //Global Pointer to Image List for Folder Tree, type CImageList



/////////////////////////////////////////////////////////////////////////////////////////
// Static Public Member Function: GetRecursiveDir(LPVOID p)
//
// Controlling Function for Thread Procedure 
/////////////////////////////////////////////////////////////////////////////////////////
//
public:
  static UINT GetRecursiveDir(LPVOID p);


protected:
  CWinThread    *m_pRecDirThread;   // Pointer to GetRecursiveDir thread, type CWinThread
  volatile BOOL  m_bThreadRunning;  // For stopping GetRecursiveDir thread, type volatile BOOL

  HTREEITEM      m_hSelItem;     // Selected Item from "Expand Selected Node", type HTREEITEM


public:
	T_CStrArray   m_aDirs;        // Global Array with folders found with GetRecursiveDir, type T_CStrArray
	CString       m_CStrTopNode;  // Node for recursive searching start, type CString




/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function DisplayDrives
//
// Displays all drives on current system on combo box
//
// Parameters: None
// Globals:    g_aDrives (Array with Drive Names)
//
// Returns:    None
/////////////////////////////////////////////////////////////////////////////////////////
protected:
  void DisplayDrives();



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: CreateTopNode
//
// Creates a top node of folder tree eg. C:\
// Parameters:
// LPCTSTR    lpszTopNode [in]  = Top Node to display eg. "C:\\"
// HTREEITEM &hTopNode    [out] = Handle to top node, for following child nodes
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void CreateTopNode( LPCTSTR lpszTopNode, HTREEITEM &hTopNode );



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: GetOneLevelDir
//
// Gets one child level of a parent node. Gets all sibling of one level.
//
// Parameters:
// CString     Parent  [in]  = Parent node of one level Children eg. C:\Windows
// T_CStrArray &Dirs   [out] = Array with directories
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void GetOneLevelDir ( CString Parent, T_CStrArray &Dirs );



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: GetRecursiveDir
//
// Gets recursively all directories from a top node. This Routine runs in a separate
// Thread. Called by Controlling Function: GetRecursiveDir(LPVOID p).
// The Function use global variables:
// T_CStrArray m_aDirs [out]      = All extracted Folders from m_CStrTopNode
// CString     m_CStrTopNode [in] = Node for recursive searching start
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
   void CFolderTreeDlg::GetRecursiveDir();



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: CreateRootSubNodes
//
// Creates Folder Nodes under the Root Node
// Parameters:
// LPCTSTR     lpszTopNode [in] = Top Node Name e.g. C:
// T_CStrArray &Dirs       [in] = Array with Directory Names (folder nodes to create)
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void CreateRootSubNodes( LPCTSTR lpszTopNode, T_CStrArray &Dirs );

  
  
/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: CreateSubNodes
//
// Creates Sub Directory Node according input string
// Parameters:
// LPCTSTR     lpszParent  [in] = Parent Node Name eg. c:\tmp
// T_CStrArray &SubDirs    [in] = Array with Sub Directory Names (nodes to create)
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
	HTREEITEM m_hTopNode;  // Top Node of Folder Tree, e.g. C:\, type HTREEITEM
  void CreateSubNodes( LPCTSTR lpszParent, T_CStrArray &SubDirs );



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: CreaRecursiveSubNodes
//
// Creates Folder Nodes under a Parent Node.
// Parameters:
// HTREEITEM   hSelItem   [in] = Selected Item from Folder Tree
// LPCTSTR     lpszParent [in] = Parent Node Name e.g. C:\tmp under this name creates
//                               all folder according the input array.
// T_CStrArray &Dirs      [in] = Array with Directory Names (folder nodes to create)
//
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void CreaRecursiveSubNodes( HTREEITEM hSelItem, LPCTSTR lpszParent, T_CStrArray &Dirs );


/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: RecursiveExpandCollapse
//
// Traverse recursive the directory tree and expand the folders
// Parameters:
// HTREEITEM hNode  [in] = Node Handler
// BOOL      Expand [in] = Expands the nodes (default)
//
// Returns: None
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void RecursiveExpandCollapse( HTREEITEM hNode, BOOL Expand=TRUE );



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: DeleteRecursive
//
// Traverse recursive the folder tree and deletes all succeed nodes. The input Node
// (Tree Item) will not be deleted.
// Parameters:
// HTREEITEM hNode [in] = Node Handler
//                                  
// Returns: None
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void DeleteRecursive( HTREEITEM hNode );



/////////////////////////////////////////////////////////////////////////////////////////
// Public Member Function: DelAllFilesDirs
//
// Deletes all Files and Folder from a top node directory recursively, inclusive top node
// Parameters:
// CString &TopDir    [in] = Top Node Directory
//
// Returns: BOOL TRUE if no error
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  BOOL DelAllFilesDirs ( CString &TopDir );



/////////////////////////////////////////////////////////////////////////////////////////
// Protected Member Function: OpenInPath
//
// Opens an input path of the class. On OnInitDialog selects the nodes for opening
// Parameters:
// CString   &PathNode [in] = Path to open
// HTREEITEM &hHook    [in] = On 1st call the top node, and then always the last 
//                            selected path node on tree.
// Returns: void
/////////////////////////////////////////////////////////////////////////////////////////
//
protected:
  void OpenInPath(CString &PathNode, HTREEITEM &hHook);




protected:
	CString m_CStrInputPath; //Input path. Tree shows this path at start, type CString
	int m_nRecursiveCounter; //Counter for recursive delete files, type int
	BOOL m_bDel2All; //Flag for Delete to All, type BOOL
	BOOL m_bNeverRequest; //Flag for never start request window, type BOOL
	BOOL m_bDelFolderIconClicked;
	CString m_CStrLastErr; //Last Error within a thread function, type CString
	HTREEITEM m_hNewFolderItem; //Handler to created new folder item, type HTREEITEM
	CString m_CstrParentNewFoldPath; //Parent of new created folder path, type CString
	BOOL m_bNewFolderIconClicked; //Lock the new folder icon, already clicked, type BOOL
	BOOL m_bFolderClicked;







	// Generated message map functions
	//{{AFX_MSG(CFolderTreeDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSelendok_Cbx_Drives();
	afx_msg void OnSelchangedFolderTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnBn_ExpandSelectedNode();
	afx_msg void OnRightClick_FolderTree(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnClickFolderTree(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnCancel();
	afx_msg void OnStatic_MakeFolder();
	afx_msg void OnEndlabeleditFolderTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnStatic_DeleteFolder();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FOLDERTREEDLG_H__31CA2186_2D12_11D6_9DD3_96F83D744632__INCLUDED_)
