/*
    SimpleAIM
    A miniature console AIM client
    http://simpleaim.sourceforge.net
    Copyright (C) 2002
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  */

/**
 * This class erases characters echoed to the console (used for hiding
 * passwords). There's no replacement; the display should show nothing. Due to
 * threading, effectiveness may depend on amount of system load.
 *
 * @author  simpleaim.sourceforge.net
 */
public class MaskingThread extends Thread {

    private boolean stop = false;
    private String prompt;


    /**
     * Constructor for the MaskingThread object
     *
     * @param prompt The prompt displayed to the user.
     */
    public MaskingThread(String prompt) {
        this.prompt = prompt;
    }


    /**
     * Main processing method for the MaskingThread object. We comtinue to mask
     * until the stopMasking method is called.
     */
    public void run() {

        while (!stop) {

            try {
                this.sleep(1);// attempt masking at this rate; optimal based on system load
            } catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            if (!stop) {
                System.out.print("\r" + prompt + " \r" + prompt);
            }
            System.out.flush();
        }
    }


    /**
     * This method tells this class to stop masking text to the console.
     */
    public void stopMasking() {
        this.stop = true;
    }
}

