/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;

import java.io.IOException;
import java.io.PrintWriter;

import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import stec.iws.Request;
import stec.iws.Response;

public class SessionTesterServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		HttpSession session = _request.getSession(false);

		String action = _request.getParameter("action");
		if(action != null)
		{
			if(action.equalsIgnoreCase("create session"))
			{
				session = _request.getSession(true);
			}
			else if(action.equalsIgnoreCase("remove session"))
			{
				if(session != null)
				{
					try
					{
						session.invalidate();
					}
					catch(Exception ex)
					{
						// ignore
					}

					session = null;
				}
			}
			else if(action.equalsIgnoreCase("set serializable value"))
			{
				String key = _request.getParameter("key");
				if(key == null)
				{
					key = "";
				}

				String value = _request.getParameter("value");
				if(value == null)
				{
					value = "";
				}

				if(key.length() > 0)
				{
					if(session != null)
					{
						try
						{
							session.setAttribute(key, value);
						}
						catch(Exception ex)
						{
							// ignore
						}
					}
				}
			}
			else if(action.equalsIgnoreCase("set non serializable value"))
			{
				String key = _request.getParameter("key");
				if(key == null)
				{
					key = "";
				}

				String value = _request.getParameter("value");
				if(value == null)
				{
					value = "";
				}

				if(key.length() > 0)
				{
					if(session != null)
					{
						try
						{
							session.setAttribute(key, new Resident(value));
						}
						catch(Exception ex)
						{
							// ignore
						}
					}
				}
			}
			else if(action.equalsIgnoreCase("remove value"))
			{
				String key = _request.getParameter("key");
				if(key == null)
				{
					key = "";
				}

				if(key.length() > 0)
				{
					try
					{
						session.removeAttribute(key);
					}
					catch(Exception ex)
					{
						// ignore
					}
				}
			}
			else if(action.equalsIgnoreCase("redirect test"))
			{
				String url = _response.encodeRedirectURL(_response.encodeURL("./sessionredirecttester.html"));
				_response.sendRedirect(url);
				return;
			}
		}

		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Session Tester Servlet</title></head>");
		writer.println("<body>");

		writer.println("<h1>Session Tester Servlet</h1>");

		writer.println("<hr>");

		writer.print("Session Status: ");

		if(session == null)
		{
			writer.println("does not exist<br>");
		}
		else
		{
			try
			{
				if(session.isNew())
				{
					writer.println("is new<br>");
				}
				else if(_request.isRequestedSessionIdValid())
				{
					writer.println("is valid<br>");
				}
				else
				{
					writer.println("is invalid<br>");
				}

				writer.println("Session Id: " + session.getId() + "<br>");
				writer.println("Creation Time: " + new Date(session.getCreationTime()).toString() + "<br>");
				writer.println("Last Accessed Time: " + new Date(session.getLastAccessedTime()).toString() + "<br>");
				writer.println("Maximum Inactive Interval: " + session.getMaxInactiveInterval() + " seconds<br>");

				writer.print("Session From: ");

				if(_request.isRequestedSessionIdFromURL())
				{
					writer.println("URL<br>");
				}
				else if(_request.isRequestedSessionIdFromCookie())
				{
					writer.println("Cookie<br>");
				}
				else
				{
					writer.println("Other<br>");
				}

				writer.println("<hr>");

				writer.println("Session values:<br>");

				int count = 0;

				Enumeration e = session.getAttributeNames();

				String name;

				while(e.hasMoreElements())
				{
					count++;

					name = (String)e.nextElement();

					Object value = session.getAttribute(name);
					if(value instanceof Resident)
					{
						value = ((Resident)value).value;
					}

					writer.println(name + " = " + value + "<br>");
				}

				if(count == 0)
				{
					writer.println("None");
				}
			}
			catch(Exception ex)
			{
				writer.println("is invalid<br>");
			}
		}

		writer.println("<hr>");

		writer.println("<form action=\"" + _response.encodeURL("./sessiontester.html") + "\" method=\"get\">");
		writer.println("Key: ");
		writer.println("<input type=\"text\" name=\"key\" value=\"\">");
		writer.println("<br>");
		writer.println("Value: ");
		writer.println("<input type=\"text\" name=\"value\" value=\"\">");
		writer.println("<p>");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Set Serializable Value\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Set Non Serializable Value\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Remove Value\">");
		writer.println("<br>");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Create Session\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Remove Session\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Redirect Test\">");
		writer.println("</form>");

		writer.println("</body>");
		writer.println("</html>");
	}

	class Resident
	{
		private String value;

		Resident(String _value)
		{
			value = _value;
		}
	}
}
