/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SimpleClassLoader
extends ClassLoader {
    private static final int debug = 0;
    protected URL[] urls;
    protected ClassLoader parent;
    protected String[] reserved;
    SecurityManager sm;

    public SimpleClassLoader(URL[] urls) {
        this.urls = urls;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent) {
        this.urls = urls;
        this.parent = parent;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent, String[] reserved) {
        this.urls = urls;
        this.parent = parent;
        this.reserved = reserved;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    private void checkURLs() {
        boolean cnt = false;
        for (int i = 0; i < this.urls.length; ++i) {
            URL cp = this.urls[i];
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (!file.exists()) {
                this.urls[i] = null;
            }
            if (!file.isDirectory() || fileN.endsWith("/")) continue;
            try {
                this.urls[i] = new URL("file", null, String.valueOf(String.valueOf(fileN)).concat("/"));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    void log(String s) {
        System.out.println("SimpleClassLoader: ".concat(String.valueOf(String.valueOf(s))));
    }

    /*
     * Loose catch block
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classData;
        Class<?> c;
        block40: {
            Resource r;
            block43: {
                int i;
                c = null;
                c = this.findLoadedClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                if (this.parent != null) {
                    try {
                        c = this.parent.loadClass(name);
                        if (c != null) {
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            Class<?> clazz = c;
                            return clazz;
                        }
                    }
                    catch (Exception e) {
                        c = null;
                    }
                }
                try {
                    c = this.findSystemClass(name);
                    if (c != null) {
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        Class<?> e = c;
                        return e;
                    }
                }
                catch (Exception e) {
                    c = null;
                }
                if (this.sm != null && (i = name.lastIndexOf(46)) >= 0) {
                    this.sm.checkPackageAccess(name.substring(0, i));
                    this.sm.checkPackageDefinition(name.substring(0, i));
                }
                if (this.reserved != null) {
                    for (i = 0; i < this.reserved.length; ++i) {
                        if (!name.startsWith(this.reserved[i])) continue;
                        throw new ClassNotFoundException(name);
                    }
                }
                if (this.urls == null) {
                    throw new ClassNotFoundException(name);
                }
                String classFileName = String.valueOf(String.valueOf(name.replace('.', '/'))).concat(".class");
                r = this.doFindResource(classFileName);
                if (r == null) {
                    throw new ClassNotFoundException(name);
                }
                classData = null;
                if (r.file == null) break block43;
                FileInputStream in = null;
                in = new FileInputStream(r.file);
                classData = this.loadBytesFromStream(in, (int)r.file.length());
                Object var11_17 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block40;
                }
                catch (IOException iOException) {}
                break block40;
                {
                    catch (IOException ioex) {
                        Class clazz = null;
                        Object var11_18 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return clazz;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (r.zipEntry != null) {
                classData = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                Object var14_27 = null;
                try {
                    r.zipFile.close();
                }
                catch (IOException iOException) {}
                break block40;
                {
                    catch (IOException ioex) {
                        Class clazz = null;
                        Object var14_28 = null;
                        try {
                            r.zipFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return clazz;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    try {
                        r.zipFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (classData != null) {
            try {
                c = this.defineClass(name, classData, 0, classData.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                Class<?> ioex = c;
                return ioex;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String name) {
        u = null;
        if (this.parent != null && (u = this.parent.getResource(name)) != null) {
            return u;
        }
        u = ClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        r = this.doFindResource(name);
        if (r == null) {
            return null;
        }
        if (r.file != null) {
            try {
                return new URL("file", null, r.file.getAbsolutePath());
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                return null;
            }
        }
        if (r.zipEntry == null) return null;
        try {
            try {
                badurl = new URL(String.valueOf(String.valueOf(new StringBuffer("jar:file:").append(r.repository.getPath()).append("!/").append(name))));
                var7_10 = null;
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                var5_9 = null;
                var7_11 = null;
                try {
                    r.zipFile.close();
                    return var5_9;
                }
                catch (IOException var8_14) {
                    // empty catch block
                }
                return var5_9;
            }
        }
        catch (Throwable var6_16) {
            var7_12 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 171->181)] { 
lbl38:
            // 1 sources

            r.zipFile.close();
            throw var6_16;
lbl40:
            // 1 sources

            catch (IOException var8_15) {
                // empty catch block
            }
            throw var6_16;
        }
        ** try [egrp 3[TRYBLOCK] [3 : 171->181)] { 
lbl45:
        // 1 sources

        r.zipFile.close();
        return badurl;
lbl47:
        // 1 sources

        catch (IOException var8_13) {
            // empty catch block
        }
        return badurl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(String name) {
        block16: {
            s = null;
            if (this.parent != null && (s = this.parent.getResourceAsStream(name)) != null) {
                return s;
            }
            s = ClassLoader.getSystemResourceAsStream(name);
            if (s != null) {
                return s;
            }
            r = this.doFindResource(name);
            if (r == null) {
                return null;
            }
            if (r.file != null) {
                try {
                    res = new FileInputStream(r.file);
                    return res;
                }
                catch (IOException shouldnothappen) {
                    shouldnothappen.printStackTrace();
                    return null;
                }
            }
            if (r.zipEntry == null) return s;
            try {
                try {
                    data = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                    if (data == null) break block16;
                    var6_11 = istream = new ByteArrayInputStream(data);
                    var8_12 = null;
                    if (r.zipFile == null) return var6_11;
                }
                catch (IOException var4_7) {
                    var8_14 = null;
                    if (r.zipFile == null) return s;
                    try {
                        r.zipFile.close();
                        return s;
                    }
                    catch (IOException var9_18) {
                        return s;
                    }
                }
            }
            catch (Throwable var7_20) {
                var8_15 = null;
                if (r.zipFile == null) throw var7_20;
                ** try [egrp 3[TRYBLOCK] [3 : 176->186)] { 
lbl41:
                // 1 sources

                r.zipFile.close();
                throw var7_20;
lbl43:
                // 1 sources

                catch (IOException var9_19) {
                    // empty catch block
                }
                throw var7_20;
            }
            ** try [egrp 3[TRYBLOCK] [3 : 176->186)] { 
lbl48:
            // 1 sources

            r.zipFile.close();
            return var6_11;
lbl50:
            // 1 sources

            catch (IOException var9_16) {
                // empty catch block
            }
            return var6_11;
        }
        var8_13 = null;
        if (r.zipFile == null) return s;
        try {}
        catch (IOException var9_17) {}
        r.zipFile.close();
        return s;
        return s;
    }

    private Resource doFindResource(String name) {
        Resource r = new Resource(this);
        for (int i = 0; i < this.urls.length; ++i) {
            URL cp = this.urls[i];
            if (cp == null) continue;
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (fileN.endsWith("/")) {
                String fileName = name.replace('/', File.separatorChar);
                File resFile = new File(file, fileName);
                if (!resFile.exists()) continue;
                r.file = resFile;
                r.repository = file;
                return r;
            }
            try {
                ZipFile zf = new ZipFile(file.getAbsolutePath());
                ZipEntry ze = zf.getEntry(name);
                if (ze != null) {
                    r.zipEntry = ze;
                    r.zipFile = zf;
                    r.repository = file;
                    Resource resource = r;
                    return resource;
                }
                zf.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Name= ").append(name).append(" ").append(file))));
                Resource resource = null;
                return resource;
            }
        }
        return null;
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    static {
        debug = 0;
    }

    private class Resource {
        File repository;
        File file;
        ZipEntry zipEntry;
        ZipFile zipFile;

        private Resource(SimpleClassLoader this$0) {
        }
    }
}

