/*
 * Decompiled with CFR 0.152.
 */
package smp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import smp.SMPApplet;

public class SearchFile {
    private SMPApplet parent;

    public String getDescription(String fileText) {
        String fText = fileText;
        String fTextlc = fText.toLowerCase();
        int startI = fTextlc.indexOf("<meta name=\"description\" content=\"");
        int endI = fTextlc.indexOf("\"", startI + 34);
        String descriptionText = startI != -1 && endI != -1 ? fText.substring(startI + 34, endI) : this.parent.appletData.phraseForNoDescription;
        return descriptionText;
    }

    private boolean isFileURI(String URI2) {
        String pURI = URI2.toLowerCase();
        boolean isFile = true;
        if (pURI.startsWith("mailto:")) {
            isFile = false;
        }
        if (pURI.startsWith("ftp:")) {
            isFile = false;
        }
        if (pURI.startsWith("javascript:")) {
            isFile = false;
        }
        return isFile;
    }

    public SearchFile(SMPApplet par) {
        this.parent = par;
    }

    public int containsKeyword(String keywords, String fileText) {
        String fText = fileText;
        String fTextlc = fText.toLowerCase();
        String keywordslc = keywords.toLowerCase();
        int count = -1;
        int index = 0;
        while (index != -1) {
            index = fTextlc.indexOf(keywordslc, index + 1);
            ++count;
        }
        return count;
    }

    public String getTitle(String fileText) {
        String fText = fileText;
        String fTextlc = fText.toLowerCase();
        int startI = fTextlc.indexOf("<title>");
        int endI = fTextlc.indexOf("</title>", startI);
        String titleText = startI != -1 && endI != -1 ? fText.substring(startI + 7, endI) : this.parent.appletData.phraseForNoTitle;
        return titleText;
    }

    public Vector getVectorOfLinks(String currentFile, String fileText) {
        String subjectLc = fileText.toLowerCase();
        Vector listOfSubStrings = new Vector();
        Vector<String> links = new Vector<String>();
        String startDelimiter = "href=\"";
        String endDelimiter = "\"";
        this.updateVectorOfRelativeLinks(subjectLc, startDelimiter, endDelimiter, listOfSubStrings);
        startDelimiter = "src=\"";
        endDelimiter = "\"";
        this.updateVectorOfRelativeLinks(fileText, startDelimiter, endDelimiter, listOfSubStrings);
        String link = new String("link : Not initialised");
        try {
            URL urlCurrentFile = new URL(this.parent.getDocumentBase(), currentFile);
            int n = 0;
            while (n < listOfSubStrings.size()) {
                link = (String)listOfSubStrings.elementAt(n);
                URL urlLink = new URL(urlCurrentFile, link);
                links.addElement(urlLink.toString());
                ++n;
            }
        }
        catch (MalformedURLException e) {
            this.parent.sendWarningMessage("Error in the format of the file: " + currentFile + " it should be of the form http://my.site.co.uk/myfile.htm");
            this.parent.logger.addToLog("SearchFile", "getVectorOfLinks", "MalformedURLException: " + link);
        }
        catch (SecurityException e) {
            this.parent.sendWarningMessage("Error reading the following file: " + currentFile + " You have broken Java security rules.  The file to be read must reside on the same server as the Applet");
            this.parent.logger.addToLog("SearchFile", "getVectorOfLinks", "SecurityException: " + link);
        }
        return links;
    }

    private void updateVectorOfRelativeLinks(String fileText, String startDelimiter, String endDelimiter, Vector listOfSubStrings) {
        int sdLength = startDelimiter.length();
        int endLength = endDelimiter.length();
        int progressIndex = -1;
        boolean scanned = false;
        while (!scanned) {
            if ((progressIndex = fileText.indexOf(startDelimiter, progressIndex + 1)) != -1) {
                int start = progressIndex + sdLength;
                int end = fileText.indexOf(endDelimiter, start);
                if (end != -1) {
                    StringBuffer oneStringBuffer = new StringBuffer();
                    int n = start;
                    while (n < end) {
                        oneStringBuffer.append(fileText.charAt(n));
                        ++n;
                    }
                    String oneString = new String(oneStringBuffer);
                    if (!this.isFileURI(oneString) || listOfSubStrings.contains(oneString) || oneString.compareTo("") == 0) continue;
                    listOfSubStrings.addElement(oneString);
                    continue;
                }
                scanned = true;
                continue;
            }
            scanned = true;
        }
    }
}

