import java.sql.*;
import java.lang.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class BarAppletDB extends HttpServlet {
//
// This simple servlet is designed to demonstrate how a servlet can be used
// to retrieve data from a database and return the data in the correct format
// to either the graphing applet or servlet.
//
// You may freely copy and modify this script to suite your own
// requirements.
//
// For further information visit,
// http://www.jpowered.com/bar_graph/shbarchart/
//
//-----------------------------------------------------------------------------

    // Initialise and set variables
	String     url   = "jdbc:MySQL:///TESTDB";  // URL specifying the JDBC connection to a MySQL database TESTDB.
	Connection con   = null;                    // Database connection object
	Statement  stmt  = null;                    // Statement String
	String     query;                           // Query String
	int        datacount;

//-----------------------------------------------------------------------------
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		   throws ServletException, IOException {

        // Set the output characterics for the return data
        res.setContentType("text/html");
		ServletOutputStream out = res.getOutputStream();

        // Establish the database connection
		try {
			// Connect to TESTDB
			Class.forName("org.gjt.mm.mysql.Driver");
			con = DriverManager.getConnection (url,"[DB Username]","[DB Password]");
           	stmt = con.createStatement();

    		// Construct HTML page containing Bar Chart Applet
			out.println("<html>\n");
			out.println("<head>\n");
			out.println("<title>2D / 3D Horizontal Bar Graph</title>\n");
			out.println("</head>\n");
			out.println("<body>\n");
			out.println("<applet code='SHbarchartApplet.class' archive='SHbarchart.jar' codebase='http://www.yourdomain.com/path/' width='500' height='420'>\n");
			out.println("   <!-- Start Up Parameters -->\n");
			out.println("  <PARAM name='LOADINGMESSAGE' value='Bar Graph Loading - Please Wait.'>     <!-- Message to be displayed on Startup -->\n");
			out.println("  <PARAM name='STEXTCOLOR' value='0,0,100'>                                  <!-- Message Text Color-->\n");
			out.println("  <PARAM name='STARTUPCOLOR' value='255,255,255'>                            <!-- Applet Background color -->\n");
			out.println(" \n");
			out.println("  <!-- Property file -->\n");
			out.println("  <PARAM name='chartproperties' value='http://www.yourdomain.com/path/barpropsdb.txt'>\n");
			out.println("  \n");
			out.println("  <!-- Chart Data -->  \n");

			// Performing SQL query for Product X
			query = "Select Value from SalesBar where Year=2003 and Product='X' ORDER BY Month";
			ResultSet srs1 = stmt.executeQuery(query);

            // Write out the data for Series 1
            datacount = 1;
			while (srs1.next()) {
				out.println("<param name='data"+datacount+"series1' value='"+srs1.getString("Value")+"'>\n");
				datacount++;
			}

			// Performing SQL query for Product Y
			query = "Select Value from SalesBar where Year=2003 and Product='Y' ORDER BY Month";
			ResultSet srs2 = stmt.executeQuery(query);

            // Write out the data for Series 2
            datacount = 1;
			while (srs2.next()) {
				out.println("<param name='data"+datacount+"series2' value='"+srs2.getString("Value")+"'>\n");
				datacount++;
			}

            // write out the end of the HTML page
			out.println(" \n");
			out.println("</applet>\n");
			out.println(" \n");
			out.println("</body>\n");
			out.println("</html>\n");

		} // End try


        // Error handling
		catch(ClassNotFoundException e) {out.println("Could not load database driver: " + e.getMessage());}
		catch(SQLException e) {out.println("SQLException caught: " + e.getMessage());}

        // All finished so close the database connection
		finally {
				 try {if (con != null) con.close();}
			     catch (SQLException e) {}
        }




	} // End doGet
//-----------------------------------------------------------------------------
    public void doPost(HttpServletRequest request,HttpServletResponse response)
		        throws ServletException, IOException {doGet(request, response);}
//-----------------------------------------------------------------------------
} // End class