
/*
aChat v 0.0.1 2001/04/05
Author: Lubomir Hristov, mnemo_project@yahoo.com
Compiled with C++Builder v 3.0 (c) Borland International
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <process.h>
#include <time.h>

struct clio //structure for clients data
{
    char nic[16];
    char id[16];
    long ctime;
};

struct conv //structure for conversation
{
    char nic[16];
    char say[80];
};

#define GET "GET"
#define MAXCLIENTS 20
#define MAXROWS 20 //this amount is relate with "IObuff" ( thread_code() ) !

void extractpar( char* parname, char *parstr, char *retpar, int* retparlen )
{
   int maxparlen = *retparlen;

   if( (parstr = strstr(  parstr, parname )) != NULL )
   {
      parstr += strlen( parname );
      *retparlen = 0;

      while( *parstr && maxparlen )
      {

         if( *parstr == '%' )
         {
            *retpar = (*(parstr+1) - ( *(parstr+1) > 64 ? 55 : 48 ) )*16 + *(parstr+2) - ( *(parstr+2) > 64 ? 55 : 48 );
            parstr+=2;
         }
         else if( *parstr == '+' )
         {
            *retpar = ' ';
         }
         else if( *parstr == '&' )
         {
            break;
         }
         else
         {
            *retpar = *parstr;
         }

         retpar++;
         parstr++;
         maxparlen--;
         (*retparlen) ++;
      }
   }
   else //parameter - not exist
   {
      *retparlen = -1;
   }

   *retpar = 0;
}

SOCKADDR_IN saiListen, saiAccept;

char *loginhtml =   "HTTP/1.0 200 OK\nContent-Type: text/html\n\n <html><body><FORM METHOD=\"GET\" ACTION=\"\" >Enter Your Nic <INPUT TYPE=\"text\" NAME=\"nic\" SIZE=\"15\" MAXLENGTH=\"15\" ></FORM>Max number of users is %d";
char *framehtml  = "HTTP/1.0 200 OK\nContent-Type: text/html\n\n <HTML><FRAMESET FRAMESPACING=0 BORDER=\"FALSE\" ROWS=\"85,15\"><FRAME NAME=\"bt\" SRC=\"?nic=%s&id=%s\" SCROLLING=\"yes\" NORESIZE ><FRAME NAME=\"tp\" SRC=\"?nic=%s&id=%s&say=\" SCROLLING=\"no\" NORESIZE ></FRAMESET></HTML>";
char *bottomhtml = "HTTP/1.0 200 OK\nContent-Type: text/html\n\n <html><body><FORM METHOD=\"GET\" ACTION= >Say <INPUT TYPE=\"HIDDEN\" NAME=\"nic\" VALUE=\"%s\"><INPUT TYPE=\"HIDDEN\" NAME=\"id\" VALUE=\"%s\"><INPUT TYPE=\"TEXT\" NAME=\"say\" SIZE=\"79\" MAXLENGTH=\"79\"></FORM></body></html>";
char *tophtmla = "HTTP/1.0 200 OK\nContent-Type: text/html\n\n <html><body><meta http-equiv=\"Refresh\" CONTENT=\"%d; URL=/?nic=%s&id=%s\"><pre>";
char *tophtmlb = "</body></html>";
char *author = "Author: Lubomir Hristov, mnemo_project@yahoo.com";

int threadcount = 0;

//*** clients ****
clio cliobuff[MAXCLIENTS];
int lastclio = -1;
CRITICAL_SECTION CSclio, CSsay;
//
//*** convers ***
conv convbuff[MAXROWS];
int lastsay = -1;
long lastsaytime;
//

void pushonconvers( char *nic, char *say)
{
   EnterCriticalSection( &CSsay );
   lastsay ++;
   if( lastsay >= MAXROWS )
   {
     lastsay = 0;
   }
   strcpy( convbuff[lastsay].nic, nic );
   strcpy( convbuff[lastsay].say, say );
   LeaveCriticalSection( &CSsay );
}


void thread_code(void *threadno)
{

   sockaddr_in guestID;
   int lenguestID = sizeof(sockaddr_in), countc, saycount, sndcount;
   char IObuff[2048], newnic = 0, GETbuff[256];
   long ctime, refreshtime;
   //
   char nic[16], id[16], say[80];
   int niclen = 15, idlen = 15, saylen = 79;
   //
   SOCKET answer = *((SOCKET *) threadno);
   //
   while( 1 )
   {
      if( recv(answer, IObuff, 2048, 0) == SOCKET_ERROR )
      {
         break;
      }

      if( strncmp( IObuff, GET, 3 ) )
      {
         break;
      }
      //extract "GET" string
      countc = 5;
      while( *(IObuff+countc) != ' ' && countc <= 260 )
      {
         *(GETbuff+countc-5) = *(IObuff+countc);
         countc++;
      }
      *(GETbuff+countc-5) = 0;
      //extract parameters
      extractpar( "nic=", GETbuff, nic, &niclen );
      extractpar( "id=", GETbuff, id, &idlen );
      extractpar( "say=", GETbuff, say, &saylen );
      //
      if( niclen == -1 || !*nic )//parameter "nic" does not found - send login screen
      {
         sndcount = sprintf( IObuff, loginhtml, MAXCLIENTS );
         countc = 0;
         while( countc <= lastclio )
         {
            sndcount += sprintf((IObuff + sndcount), ", %s", (cliobuff+countc)->nic );
            countc ++;
         }
         sndcount += sprintf( (IObuff + sndcount), "%s", tophtmlb );

      }
      else
      {
         ctime = time(NULL);
         getpeername( answer, (SOCKADDR *) &guestID, &lenguestID );
         //
         EnterCriticalSection( &CSclio );

         countc = 0;
         while( countc <= lastclio )
         {
            if( !strcmp( nic, (cliobuff+countc)->nic ) )
            {
               if( !strcmp( id, (cliobuff+countc)->id ) )
               {
                  break;
               }
               else
               {
                  countc = -1;
                  break;
               }
            }
            //last accesss time + 60 sec. - The client is left chat room
            if( ( cliobuff[countc].ctime + 60 ) < ctime )
            {
               pushonconvers( cliobuff[countc].nic, "left room" );
               saycount = countc;
               while( saycount < lastclio )
               {
                  cliobuff[saycount].ctime = cliobuff[saycount+1].ctime;
                  strcpy( (cliobuff+saycount)->nic, (cliobuff+saycount+1)->nic);
                  strcpy( (cliobuff+saycount)->id, (cliobuff+saycount+1)->id);
                  saycount++;
               }
               lastclio--;
               countc--;
            }
            //
            countc++;
         }
         if( countc+1 > MAXCLIENTS ) //too many clients
         {
            LeaveCriticalSection( &CSclio ); 
            break;
         }
         if( countc == -1 ) //this "nic" has not autorization
         {
            LeaveCriticalSection( &CSclio ); 
            break;
         }
         if( countc > lastclio ) //new "nic" in list
         {
            strcpy( cliobuff[countc].nic, nic);
            ltoa( ctime, id, 16 );
            strcpy( cliobuff[countc].id, id);
            lastclio ++;
            newnic = 1;
         }

         cliobuff[countc].ctime = ctime;

         LeaveCriticalSection( &CSclio );

         if( saylen > 0 ) //parameter "say" does not empty
         {
            pushonconvers( nic, say );
         }

         countc = lastsay;

         if( newnic )//new "nic" in list
         {
            pushonconvers( nic, "joint room" );
            sprintf( IObuff, framehtml, nic, id, nic, id );
         }
         else
         {
            if( saylen > -1 )
            {
               sprintf( IObuff, bottomhtml, nic, id );
            }
            else
            {

               //REFRESH rate
               refreshtime = (ctime - lastsaytime) > 10 ? 10 : 5;
               //
               sndcount = sprintf( IObuff, tophtmla, refreshtime, nic, id );

               saycount = MAXROWS - 1;
               while( saycount >= 0 )
               {
                  if( countc < 0 )
                  {
                     countc = MAXROWS - 1;
                  }
                  sndcount += sprintf((IObuff + sndcount), "<b>%s:</b> %s\n", convbuff[countc].nic, convbuff[countc].say);
                  countc --;
                  
                  saycount --;
               }

               sndcount += sprintf( (IObuff + sndcount), "%s", tophtmlb );

            }
         }


      }
      printf("%s %s %s\n", inet_ntoa( guestID.sin_addr), nic, say);
      send( answer , IObuff, strlen(IObuff), 0);
      /*
      if( send( answer , IObuff, strlen(IObuff), 0) == SOCKET_ERROR )
      {
         printf( "Send Error %d\n", (int*)  WSAGetLastError ());
      }
      */
      break;
   }

   closesocket( answer );
   delete( threadno );

   threadcount--;
   _endthread();
}

void start_thread( SOCKET hAccept )
{
   SOCKET *r = new SOCKET;
   *r = hAccept;
   _beginthread( thread_code, 4096, (void *) r);
}

int main(int argc, char **argv)
{

   WSADATA WSAData;
   SOCKET hListen=INVALID_SOCKET, hAccept = INVALID_SOCKET;
   int sailen = sizeof(SOCKADDR_IN);

   if( WSAStartup( MAKEWORD(1, 1), &WSAData) )
   {
      return 0;
   }

   printf( "aChat version 0.0.1 started\n");

   InitializeCriticalSection( &CSclio );
   InitializeCriticalSection( &CSsay );

   hListen = socket(AF_INET, SOCK_STREAM, 0);
   if( hListen != INVALID_SOCKET )
   {
      saiListen.sin_family = PF_INET;
      saiListen.sin_port   = (u_short) htons((u_short) 80);
      saiListen.sin_addr.s_addr = INADDR_ANY;
      if( bind(hListen, (SOCKADDR *) &saiListen, sizeof(SOCKADDR_IN)) != SOCKET_ERROR)
      {
         if( listen(hListen, SOMAXCONN) != SOCKET_ERROR )
         {
            while( 1 )
            {
               hAccept = accept( hListen, (SOCKADDR *) &saiAccept, &sailen );
               if( hAccept != INVALID_SOCKET )
               {
                  threadcount++;
                  start_thread( hAccept );
               }
            }
         }
      }
      closesocket(hListen);
   }

   WSACleanup();

   DeleteCriticalSection( &CSclio );
   DeleteCriticalSection( &CSsay );

   return 0;
}


