<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_include/lang/help/help_deutsch.php
#    Beschr./Desc.:  Languagefile 'GERMAN'
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2002 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    $help["RE038a"]  = array("'Weiter'-Target",                                     "Das Setzen des H&auml;kchens gibt das Feld \"'Weiter'-Target\" zur Edition frei.<br><br>Der ConPresso-User kann die Verlinkung der 'Weiter'-Button und einer evtl. verlinkten &Uuml;berschrift w&auml;hlen, ob dieser im selben Browser-Fenster oder in einem neuen Browser-Fenster ge&ouml;ffnet werden soll.");

    // -- Diese sind dazu gekommen!
    $help["RE000"]   = array("Category settings",                                   "Here you adjust all the settings of a specific category. You can decide if you want to use standard category settings or individual settings.<br>In addition, you find here the ouput information for the respective category.");
    $help["RE000a"]  = array("Use standard category settings<br>Use individual category settings",                                     "Mark the option \"Use standard category settings\" for this category in order to adopt the standard category settings. But then you can't edit any further settings for this category.<br>If you want to see and change the standard category settings, please click on \"Edit standard category settings\" in the next field.<br><br>Mark the option \"Use individal category settings\" for this category in order to adopt the individual category settings. You can decide subsequent to your individual settings if they are really only to be stored as individual or as standard category settings .");
    $help["RE001a"]  = array("Show output file",                                    "Click on \"Show output file\", in order to get the two variants for the integration of the category into your online project indicated and clarified. After integrating the output files into your project, contents are totally dynamic generated.");
    $help["RE004a"]  = array("Allocation",                                          "Here you can define into which area of your online project the selected category is to be systematically inserted. This makes the selection of the category easier for you (field \"Selection of category\"), especially in larger projects in which you want to edit an article.<br>The structural tree can be set or modified in the field \"System settings\".<br>If you do not map your online project by means of this structure tree, all sorted categories in the root directory of ConPresso will be released.");
    $help["SE201"]   = array("Edit structure",                                      "Here you have the possibility to map the structure of your website in ConPresso.<br>This makes the selection of the category easier for you (field \"Selection of category\"), especially in larger projects in which you want to edit an article.<br>If you do not map your online project by means of this structure tree, all sorted categories in the root directory of ConPresso will be released.");
    $help["SE202"]   = array("Database cleanup",                                    "Here you can tidy up the data base and remove respective entries. After clicking, you get further choices.");

    // -- -------------------------

    // -- Diese wurden geaendert!
    $help["RA001"]  = array("Category",                                              "This column shows you &ndash; depending on your category rights &ndash; all categories in which you are authorized to edit articles.<br>By clicking on the name of a category, you choose the category in which you want to create or edit an article.<br><br><b>Note:</b><br>The categories are ordered by name. Names in <i>Italic</i> at the beginning of the category list indicate that, in the corresponding category, no settings have been made yet.<br>Click on the category name in <i>Italic</i> and choose in the menu \"Settings --> Category settings\" in order to edit the settings of the category.<br>Afterwards, the category appears in the alphabetical order.<br><br><b>Released</b><br>This column indicates how many articles in the respective category are currently released.<br><br><b>Note:</b><br>If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.<br><br><b>Blocked</b><br>This column indicates how many articles in the respective category are currently blocked.<br><br><b>Waiting</b><br>This column indicates how many articles in the respective category are currently waiting for release.<br><br><b>Rejected</b><br>This column indicates how many articles in the respective category are currently rejected.");
    # $help["RA002"]  = array("Released",                                             "This column indicates how many articles in the respective category are currently released.<br><br><b>Note:</b><br>If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.");
    # $help["RA003"]  = array("Blocked",                                              "This column indicates how many articles in the respective category are currently blocked.");
    # $help["RA004"]  = array("Waiting",                                              "This column indicates how many articles in the respective category are currently waiting for release.");
    # $help["RA005"]  = array("Rejected",                                             "This column indicates how many articles in the respective category are currently rejected.");


    // Artikel bearbeiten
    $help["AB000"]  = array("Article sorting",                                      "All articles are classified by date of creation and, therefore, they appear in the corresponding order of your online-project.<br>If you want to change the article order, please click the up or down arrow.<br>Then the articles will appear inside your project according to the indicated order.<br>The last moved article is indicated by an orange arrow.");
    $help["AB001"]  = array("Status",                                               "This column shows you the status of the respective article. Each of the specifications mean:<br><br><b>Waiting</b><br>\"Waiting\" indicates that the article is waiting to be released by an authorized user.<br><br>\"Waiting\" with a green/grey strip indicates that the article is waiting to be released by an authorized user. Even so, at the moment, an older version of this article is online.<br><br><b>Blocked</b><br>\"Blocked\" indicates that the article was blocked by an authorized user.<br><br><b>Rejected</b><br>The article was rejected by an authorized user. The user who rejects the article is requested to inform the reasons of the rejection (optional). Independently of the release system is active or not, an e-mail is sent to the author of the article.<br><br><b>Released</b><br>The article was released. If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here are displayed all articles with the status \"Waiting\", \"Blocked\" or \"Released\". Rejected articles are not shown.<br>");
    $help["AB002"]  = array("Title/Author",                                         "This column shows, respectively, title and author of the article.<br>By clicking in the title, you get the preview of the article.<br>If the article does not have a title, the subtitle is alternatively indicated here.<br>\"n.t.\" means \"no title\": During the creation of the article neither title nor subtitle was entered.<br><br>By clicking in the info-icon <img src=\"../_images/info.gif\">, you get an overview of the versions of the respective artcle.<br>There you can access old versions of the article or possibly recover them.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here all articles with the status \"Waiting\", \"Blocked\" or \"Released\" are displayed. Rejected articles are not shown.<br>");
    $help["AB003"]  = array("Publication/Expiry date",                              "This column shows, respectively, the publication and expiry date of the article.<br><br>Moreover, the status of the publication is shown (the meaning of the terms you find <a href=\"#stand\">here</a>).<br><br>It is also shown the name of the template that is being used in this article.<br>This might be useful when you want to create a new article, following the model of an already-written article. You see immediately which template you should use.<br><br><a name=\"stand\"></a>The specifications on the status of publication mean:<br><br><b>ONLINE</b><br>The article is within the target date of publication and thus online (as long as it has been released).<br><br><b>OFFLINE</b><br>The article is not within the target date of publication (date is in the future), thus OFFLINE; even after it has been released, it is still not visible in your project-online, until the date of the publication is reached.<br><br><b>EXPIRED</b><br>The publication date of the article already expired.<br>If the archive function is used for a category, this article appears inside the archive.<br><br><b>Example:</b><br><br>In your project, an article about a fair in the category \"News\" is supposed to be published between 1st-03 and 15th-03 of the current year.<br><br><b>24th-02:</b><br>The article is shown as OFFLINE-article.<br>Reason: the date of publication has not been reached yet.<br>The article remains OFFLINE until 01st-03. On 01st-03 its status changes to ONLINE.<br><br><b>02nd-03:</b><br>The article is shown ONLINE, since the date of publication was reached.<br>The article is visible inside your online-project, thus published (as long as it has been released).<br><br><b>16th-03</b><br>The article is indicated as EXPIRED.<br>Reason: The date of expiry is reached or exceeded. If the archive function is activ in the category \"News\" inside your online-project (this can be done in the category settings), the article appears inside your online-archive (if released).");
    $help["AB004"]  = array("Article",                                              "By clicking on \"Edit\", you directly get the view of the editing of the respective article.<br><br>By clicking on \"Copy\", you create a copy of the respective article, as such is shown. A warning note appears requesting you to confirm your decision. For the time being, the copy is marked as blocked and in wait respectively, and can be later edited by the user. This function is useful, for example, if you simply want to copy and modify very similar descriptions of products.<br>The publication date is adjusted automatically in the current date and the expiry date in \"Never\".<br><br>By clicking on \"Delete\", you can directly delete individual articles of the system (depending on your individual user rights). A warning note appears requesting you to confirm your decision.");
    $help["AB005"]  = array("Release",                                              "By clicking on \"Release\", \"Reject\" or \"Block\" you modify the status of the article. You activate the following actions:<br><br><br><b>Release</b><br>You release the article for publication in your online-project. A separate confirmation is not required.<br><br><b>Reject</b><br>You reject the article. A window opens automatically and you are requested to justify/comment the rejection.<br>If you do not want to send any comment, just close the window. The article will be rejected nevertheless, and no e-mail will be sent.<br><br><b>Block</b><br>The article is immediately blocked and does not appear in your online-project anymore.");
    $help["AB071"]  = array("Status",                                               "This column shows you the status of the respective article. Each of the specifications mean:<br><br><b>Waiting</b><br>\"Waiting\" indicates that the article is waiting to be released by an authorized user.<br><br>\"Waiting\" with a green/grey strip indicates that the article is waiting to be released by an authorized user. Even so, at the moment, an older version of this article is online.<br><br><b>Blocked</b><br>\"Blocked\" indicates that the article was blocked by an authorized user.<br><br><b>Rejected</b><br>The article was rejected by an authorized user. The user who rejects the article is requested to inform the reasons of the rejection (optional). Independently of the release system is active or not, an e-mail is sent to the author of the article.<br><br><b>Released</b><br>The article was released. If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here are displayed all articles with the status \"Waiting\", \"Blocked\" or \"Released\". Rejected articles are not shown.<br>");
    $help["AB072"]  = array("Title/Author",                                         "This column shows, respectively, title and author of the article.<br>By clicking in the title, you get the preview of the article.<br>If the article does not have a title, the subtitle is alternatively indicated here.<br>\"n.t.\" means \"no title\": During the creation of the article neither title nor subtitle was entered.<br><br>By clicking in the info-icon <img src=\"../_images/info.gif\">, you get an overview of the versions of the respective artcle.<br>There you can access old versions of the article or possibly recover them.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here all articles with the status \"Waiting\", \"Blocked\" or \"Released\" are displayed. Rejected articles are not shown.<br>");
    $help["AB073"]  = array("Publication/Template",                                 "This column shows the last publication date of the article.<br><br>Moreover, the status of the publication is shown (the meaning of the terms you find <a href=\"#stand\">here</a>).<br><br>It is also shown the name of the template that is being used in this article.<br>This might be useful when you want to create a new article, following the model of an already-written article. You see immediately which template you should use.<br><br><a name=\"stand\"></a>The specifications on the status of publication mean:<br><br><b>ONLINE</b><br>The article is within the target date of publication and thus online (as long as it has been released).<br><br><b>OFFLINE</b><br>The article is not within the target date of publication (date is in the future), thus OFFLINE; even after it has been released, it is still not visible in your project-online, until the date of the publication is reached.<br><br><b>EXPIRED</b><br>The publication date of the article already expired.<br>If the archive function is used for a category, this article appears inside the archive.<br><br><b>Example:</b><br><br>In your project, an article about a fair in the category \"News\" is supposed to be published between 1st-03 and 15th-03 of the current year.<br><br><b>24th-02:</b><br>The article is shown as OFFLINE-article.<br>Reason: the date of publication has not been reached yet.<br>The article remains OFFLINE until 01st-03. On 01st-03 its status changes to ONLINE.<br><br><b>02nd-03:</b><br>The article is shown ONLINE, since the date of publication was reached.<br>The article is visible inside your online-project, thus published (as long as it has been released).<br><br><b>16th-03</b><br>The article is indicated as EXPIRED.<br>Reason: The date of expiry is reached or exceeded. If the archive function is activ in the category \"News\" inside your online-project (this can be done in the category settings), the article appears inside your online-archive (if released).");
    $help["AB074"]  = array("Article",                                              "Two warning options may occur here.<br><br><b>Option 1:<br></b><i>no notice</i> indicates, that no other versions of the article exist.<br><br><b>Option 2:</b><br>\"Version archive\" leads you to an overview of all existing article versions.<br>A version arises every time an article is edited.");
    $help["AB075"]  = array("Article",                                              "Click on \"Restore\" in order to restore an older article version.<br>Choose \"Delete\", if you want to erase an older version definitively. A warning note appears requesting you to confirm your decision.");

    // Bild-Upload
    $help["BA001"]  = array("Alternative text",                                     "Here you can indicate an alternative text that will be shown if the image can not be displayed.<br>There are many reasons why an image cannot be shown, e.g. the user may have deactivated the display of images in his browser, or the user may have cancelled the download of the page before the image was transmitted.<br>The alternative text can be a single word, but also a short description.");
    $help["BA002"]  = array("Caption",                                              "Here you can indicate a legend, such as it is known in the press.<br>The text will be automatically shown in a smaller font &ndash; usually as in the captions &ndash;.<br><br><b>Example:</b><br><br>The president of the ConQuarium Inc. hands over a check to the winner.");
    $help["BA003"]  = array("Enter",                                                "Click on \"Enter\" to take over your caption data.<br><br><b>Note:</b><br>You can at any time correct these specifications through the option of the menu \"View/Change Image\".");
    $help["BA011"]  = array("ID",                                                   "ConPresso assigns automatically an explicit identification (numeric order) for each picture, which is displayed here.");
    $help["BA012"]  = array("Date/Author",                                          "Here is shown the upload date of the image and the user who performed the action.");
    $help["BA013"]  = array("Image/Description",                                    "Here are displayed all uploaded images in a limited view (not optimized).<br>If you click on a certain picture, it will be displayed in its original size (as indicated in the adjacent column).<br><br>Click on \"Change description\" to change or to complement the picture's alternative text or caption.");
    $help["BA014"]  = array("File and size of image",                               "The column shows respectively, name and file type of the image, as well as its size in pixels.<br>A click on the file name displays the picture in the indicated size.");
    $help["BA015"]  = array("Action",                                               "Through the column \"Action\" you can delete pictures directly from the system.<br>A warning note appears requesting you to confirm your decision.<br><br>A picture can not be deleted if \"Image in use\" is being displayed.<br>First you have to remove the picture from the context of use inside the article.<br>By clicking on the title, you directly get the view of the editing of the respective article.<br>After removing the picture from there, you will be able to delete it in the next step.");
    $help["BA020"]  = array("Delete image nevertheless",                            "Currently the picture is still being used in older versions of the article.<br>If you delete the image definitively, this will affect the content and the appearance of the old versions of the article, since the figure is being removed of this context of use.<br>If you want to remove the image anyway, please click on \"Delete image nevertheless.\"");
    $help["BA021"]  = array("Search",                                               "Click on \"Search\" in order to search the file in your local directory, which you want to upload.<br>Mark the corresponding file and click \"open\".<br><br><b>Note:</b><br>Please make sure to upload only files that contain a valid format for internet, e.g. *.jpg, *.gif and *png.<br>The file size may, possibily, be limited by the settings of the system. As recommendation for an acceptable size, a value of approx. 150.000 bytes or less must be assigned.<br><br>Please make sure that <b>\"Filetype: All files (*.*)\"</b> is activ. So that when choosing, all existing files can be displayed.");
    $help["BA022"]  = array("Upload image",                                         "Click on \"Upload image\" to upload the chosen picture on the server. Afterwards, it will be available for use in the related category.<br><br><b>Note 1:</b><br>If you have to upload a picture, whose name already exists, ConPresso adds automatically a continuous number.<br><br><b>Example:</b><br><br><i>chairman.jpg</i> already exists in the data bank. Another picture, that you want to upload under the same name is automatically saved as <i>chairman_2.jpg</i>.<br><br><b>Note 2:</b><br>Afterwards, you have the possibility to upload other files by following the same procedure.<br>");

    // Datei-Upload
    $help["DA001"]  = array("Search",                                               "Click \"Search\" in order to search the file in your local directory, which you want to upload.<br>Mark the corresponding file and click \"open\".<br><br><b>Note:</b><br>On principle you can upload all types of file and offer them to download (e.g. *.pdf, *.doc, *.xls, *.exe, *.pps, *.zip, *.gif, *.jpg, *.tif).<br>The maximum size of the file might be restricted by the settings of the system.<br><br>Please make sure that <b>\"Filetype: All Files (*.*)\"</b> is activ. So that when choosing, all existing files can be displayed.");
    $help["DA002"]  = array("Upload file",                                          "Click on \"Upload file\" in order to upload the chosen file on the server. Afterwards, it will be available for use in the related category.<br><br><b>Note 1:</b><br>If you have to upload a file, whose name already exists, ConPresso adds automatically a continuous number.<br><br><b>Example:</b><br><br><i>brochure.pdf</i> already exists in the data bank. Another file, that you want to upload under the same name is automatically saved as <i>brochure_2.pdf</i>.<br><br><b>Note 2:</b><br>Afterwards, you have the possibility to upload other files by following the same procedure.<br>");
    $help["DA011"]  = array("ID",                                                   "ConPresso assigns automatically an explicit identification (numeric order) for each file, which is displayed here.");
    $help["DA012"]  = array("Date/Author",                                          "Here is shown the upload date of the file and the user who performed the action.");
    $help["DA013"]  = array("File",                                                 "Here are displayed all file names.<br>Click on the file name to open it.");
    $help["DA014"]  = array("Action",                                               "Through the column \"Action\" you can delete files directly from the system.<br>A warning note appears requesting you to confirm your decision.<br><br>A file can not be deleted if \"File in use\" is being displayed.<br>First you have to remove the file from the context of use inside the article.<br>By clicking on the title, you directly get the view of the editing of the respective article.<br>After removing the file from there, you will be able to delete it in the next step.");
    $help["DA020"]  = array("Delete file nevertheless",                             "Currently the file is still being used in older versions of the article.<br>If you delete the file definitively, this will affect the content and the appearance of the old versions of the article, since the file is being removed of this context of use.<br>If you want to remove the file anyway, please click on \"Delete file nevertheless.\"");


    
    //Editor Hinweis
    $help["EH001"]  = array("Editor",                                               "<b>Note:</b><br>The function range of your editor depends on your individual rights.<br><br>The buttons of the editor, with very few exceptions, are aligned by the appearance of usual Office applications.<br>The functions of the buttons (icons) can be individually taken in the following list:<br><br><TABLE border=0 class=\"text\"> <TBODY> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_new.gif\" width=21></TD> <TD>Deletes all contents in the editor.<br>A warning note appears requesting you to confirm the erasure.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_save.gif\" width=21></TD> <TD>Saves content of the input box and integrates it to the article.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_cut.gif\" width=21></TD> <TD>Cuts out all marked elements. Afterwards, the cut elements are in the clipboard and can be, through the button \"Paste\", pasted in another place.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_copy.gif\" width=21></TD> <TD>Copys all marked elements. Afterwards, the marked elements are in the clipboard and can be, through the button \"Paste\", pasted in another place.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_paste.gif\" width=21></TD> <TD>Pastes cut or copied elements from the clipboard into the input box.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_undo.gif\" width=21></TD> <TD>Undoes your last action.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_redo.gif\" width=21></TD> <TD>Restores your last action.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_insert_table.gif\" width=21></TD> <TD>Inserts a table.<br>Another window with a separate help function opens.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD>
                                                                                    <IMG height=20 src=\"../_bsedit/images/btn_edit_table.gif\" width=21></TD> <TD>Opens editing function for the table.<br>Another window with a separate help function opens.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_edit_table_cell.gif\" width=21></TD> <TD>Opens the edit function for the cell, in which the cursor is currently located.<br>Another window with a separate help function opens.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_indent.gif\" width=21></TD> <TD>Indents to the right.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_outdent.gif\" width=21></TD> <TD>Indents to the left.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_ordered_list.gif\" width=21></TD> <TD>Inserts an ordered list (enumeration).<br><br>Note: To end the list just press enter and then click the icon again (enumeration).</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_unordered_list.gif\" width=21></TD> <TD>Inserts an unordered list (without enumeration).<br><br>Note: To end the list just press enter and then click the icon again (without enumeration).</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_hr.gif\" width=21></TD> <TD>Inserts a horizontal dividing line.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_url.gif\" width=21></TD> <TD>Inserts a hyperlink into the document or links a marked text.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_no_url.gif\" width=21></TD> <TD>Cancels an existing link. Mark the text which link you want to cancel and click the button (remove link).</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_justify_left.gif\" width=21></TD> <TD>Aligns the paragraph flush left.
                                                                                    </TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_justify_center.gif\" width=21></TD> <TD>Centers the current paragraph.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_justify_right.gif\" width=21></TD> <TD>Aligns the paragraph flush right.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_justify_none.gif\" width=21></TD> <TD>Cancels all paragraph formattings.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_bold.gif\" width=21></TD> <TD>Emphasises the marked text in <b>bold</b> and/or cancels the bold formatting.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_italic.gif\" width=21></TD> <TD>Sets the marked text in <i>italic</i> and cancels the italic formatting.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_underline.gif\" width=21></TD> <TD><u>Underlines</u> marked text and/or cancels the underlining.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_strikethrough.gif\" width=21></TD> <TD><strike>Strikesthrough</strike> the marked text and/or cancels this formatting.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_subscript.gif\" width=21></TD> <TD><sub>Subcripts</sub> marked text and/or cancels this formatting.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_superscript.gif\" width=21></TD><TD><sup>Superscripts</sup> the marked text and/or cancels this formatting.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_remove_format.gif\" width=21></TD> <TD>Cancels all text formattings.</TD></TR><TR><TD colspan=2><hr></TD></TR> <TR> <TD><IMG height=20 src=\"../_bsedit/images/btn_color1.gif\" width=21 bgcolor=\"#ff0000\"></TD> 
                                                                                    <TD>Sets the marked paragraph according to the text color last selected.</TD></TR><TR><TD colspan=2><hr></TD></TR><TR><TD><IMG height=20 src=\"../_bsedit/images/btn_fore_color.gif\" width=21></TD><TD>Opens a color table, where you can choose a text color. Just click on the desired color and then click ok.<br>Color values can be also directly indicated in the hexadecimal code.</TD></TR><TR><TD colspan=2><hr></TD></TR><TR><TD><IMG height=20 src=\"../_bsedit/images/btn_color2.gif\" width=21 bgcolor=\"#ff0000\"></TD> <TD>Sets the marked paragraph according to the background color last selected.</TD></TR><TR><TD colspan=2><hr></TD></TR><TR><TD><IMG height=20 src=\"../_bsedit/images/btn_back_color.gif\" width=21></TD><TD>Opens a color table, where you can choose a background color. Just click on the desired color and then click ok.<br>Color values can be also directly indicated in the hexadecimal code.<br></TD></TR><TR><TD colspan=2><hr></TD></TR><TR><TD><IMG height=20 src=\"../_bsedit/images/btn_insert_image.gif\" width=21></TD><TD>Opens a window where you can choose a picture to be inserted.<br>Here you can only integrate pictures that were previously uploaded on the server, through the function \"Upload image\".</TD></TR><TR><TD colspan=2><hr></TD></TR><TR><TD><IMG height=20 src=\"../_bsedit/images/btn_change_mode.gif\" width=21></TD><TD>Switches between normal mode (WYSIWYG) and HTML mode.</TD></TR> </TBODY></TABLE><hr><br><b>Format paragraph</b><br><br>Here you can assign the formatting for the paragraph, where the cursor is currently located.<br><br><hr><br><b>Size</b><br><br>Here you can assign the font size for the marked text. The specifications of the font size do not follow the standard text edition (e.g.: 10pt, 12pt), but the internet programming requirements.<hr><b><br>Snippet</b><br><br>By clicking on the menu, you can choose snippets to insert in your article. The creation of snippets requires a certain user level. If you want to make frequent use of elements (text, tables, etc), please contact your administrator.<br><hr><br><b>Select font</b><br><br>Fonts are always loaded on the page of the internet user.<br>Thus, the editors choice defines, 
                                                                                    concerning the font, the families of fonts that are probably installed on the systems of the users.<br><br>To ensure also MAC or Linux systems, you should use the fonts Arial, Verdana, Times or Courier.<br><br><br></p>");

    // Eingabe-Formular
    $help["FO001"]  = array("Index",                                                "Through the index box you can &ndash; independently of how the artcicle is sorted by the up and down arrows &ndash; control the order of articles with an index number. The order of articles appears in ascending numerical sequence.<br><br><b>Example:</b><br><br>You have posted 5 articles in a certain category. They will be automatically sorted according to their date of creation.<br>If you want that an article, due to its present time or priority, always appears in the website as the first entry (even if an editor indicates another order), you can register 1 here. The article always appears in first place, independently of its position in the article overview and its publication date.<br>If you want to set this to several articles, just distribute further sequential numbers.<br><br><b>Note:</b><br>With the input/output settings (Category settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["FO002"]  = array("Title",                                                "Type here the title of the article.<br>The article will be shown with this name, that is, the title appears as the name of the article both in ConPresso and in the online publication.<br><br><b>Note:</b><br>This field does not need, necessarily, to be filled.<br>In ConPresso the article will be shown either with its subtitle or with \"n.t.\" (\"no title\") &ndash; if the subtitle has not been idicated &ndash;. For the published article within your online project, this is irrelevant.");
    $help["FO003"]  = array("Title URL",                                            "Here you can indicate an URL (internet address), if you want the title to be linked.");
    $help["FO003a"] = array("Title target",                                         "Choose here the target, in which the link of the title shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br> Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking external websites).<br> Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO004"]  = array("Subtitle",                                             "Type here the subtitle of the article.<br>The article will be shown with this name, if no title was indicated before. That means the subtitle appears as the name of the article both in ConPresso and in the online publication.<br><br><b>Note:</b><br>This field does not need, necessarily, to be filled.<br>In ConPresso the article will be shown either with its title or with \"n.t.\" (\"no title\") &ndash; if the title has not been idicated &ndash;. For the published article within your online project, this is irrelevant.");
    $help["FO005"]  = array("Subtitle URL",                                         "Here you can indicate an URL (internet address), if you want the subtitle to be linked.");
    $help["FO005a"] = array("Subtitle target",                                      "Choose here the target, in which the link of the subtitle shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO006"]  = array("Template",                                             "Here you can define the template of the article. The available templates depends on the type of article and on your user rights.<br>To get an overview of a template, just click on the template symbol.<br>If you he are not satisfied with the layout, you can choose a different one. The choice of the layout can be repeated as much as desired.<br>Your article will be saved with the respective layout.<br><br><b>Note:</b><br>The choice of the layout concerns only to the article in edition. For the appearance of an article, the category settings (\"Settings --> Category settings\") are additionally relevant.<br>");
    $help["FO007"]  = array("Publication date",                                     "Here you can specify the exact publication date of the article within your project.<br>Please keep in mind that the publication of the article may still depend on a release.<br><br>Moreover, make sure to observe the correct format of the date/time [<b>dd.mm.yyyy  hh:mm</b>].");
    $help["FO008"]  = array("Expiry date",                                          "Here you can specify the exact date in which the article must be removed from your online project.<br>The article still remains available in ConPresso as \"ARCHIVE\" and can be reactivated at any time.<br>If you are using the archive function for this category, the article will be automatically transferred to the archive on the date of expiry. This can be avoided by blocking or deleting the article.");
    $help["FO0091"] = array("Teaser text",                                          "An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Here you can enter a teaser text.<br>Click the \"Teaser text edit\" function, under the preview box, to edit the teaser text.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><b>[more...]</b><br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered.<br>\"At the end of the commercial year [...]\" is the entered \"Teaser text\".<br>The text that appears after clicking on \"[more...]\", is the \"Article text\" which you can enter in the next step.<br>You can also arrange the \"More text\" individually.<br>");
    $help["FO0092"] = array("Article text",                                         "An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Here you can enter the article text itself, which follows the teaser text.<br>Click the \"Article text edit\" function under the preview box to edit the text.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><br>With that, the result is not only beyond 14,5% expected by the analysts, but also beyond the tendency in the sector of plastic fish manufacture.<br>Fritz Fisher, finance director of the company, stated at the press conference yesterday that the increased profit happened for two reasons: extended range of products and significant reduction of costs. Both reached through the reorganization of the production process.<br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered.<br>\"At the end of the commercial year [...]\" is the entered \"Teaser text\".<br>The detailed text is the \"Article text\" that appears after clicking on \"more &raquo;\".");
    $help["FO0093"] = array("Continuation text",                                    "Here you can type an additional text.<br>Click the \"Continuation text edit\" function under the preview box to edit the text.<br>The box \"Continuation text\" provides further possibilities of forming during the creation of the article.");
    $help["FO009a"] = array("'More' text",                                          "Here you can indicate the text supposed to refer to the content of the continuation text in case you are using the input-box \"Teaser Text\" to create an introduction of the article.<br>The text you type in the box \"Article text\" appears in a new page (detail page) when clicking on 'More' text.<br><br><b>Examples</b> for a 'More' text:<br><br>- More...<br>- Read more...<br>- Details ><br>- Further information...<br>");
    $help["FO0101"] = array("Teaser text",                                          "An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Here you can enter a teaser text.<br>Click the \"Teaser text edit\" function, under the preview box, to edit the teaser text.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><b>[more...]</b><br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered. The text that appears after a click on \"[more..]\", is the \"Article text\" which you can enter in the next step.<br>You can also arrange the \"More text\" individually.<br>");
    $help["FO0102"] = array("Article text",                                         "An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Here you can enter the proper article text, which follows the teaser text.<br>Click the \"Article text edit\" function, under the preview box, to edit the text.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><br>With that, the result is not only beyond 14,5% expected by the analysts, but also beyond the tendency in the sector of plastic fish manufacture.<br>Fritz Fisher, finance director of the company, stated at the press conference yesterday that the increased profit happened for two reasons: extended range of products and significant reduction of costs. Both reached through the reorganization of the production process.<br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered.<br>\"At the end of the commercial year [...]\" is the entered \"Teaser-Text\".<br>The detailed text is the \"Article text\" that appears after clicking on \"more &raquo;\".");
    $help["FO0103"] = array("Continuation text",                                    "Here you can type an additional text.<br>Click the \"Continuation Text edit\" function, under the preview box, to edit the text.<br>The box \"Continuation text\" provides further possibilities of forming during the creation of the article.");
    $help["FO011"]  = array("Image",                                                "With the dropdown menu you choose the image you want to use during the article forming.<br>The image upload is category-based. If you want to use the same image in different categories, you have to upload it in each category accordingly.<br><br><b>Note:</b><br>The position of an image depends on the template used in the article.<br><br>If you want to insert an image inside your article text, please use the function \"insert image\" in the editor (the use of the editor depends on your user rights).");
    $help["FO012"]  = array("Image URL",                                            "Here you can indicate an URL (internet address), if you want the image to be linked.<br><br><b>Example:</b><br><br>If you want to link the website of a fair through the logo of the fair, you can enter the URL here. Then choose \"new window (blank)\" (this is the standard choice when it is linked to an external websites).<br><br><b>Note:</b><br>Please always enter the URL address with the prefix <b>http://</b>.");
    $help["FO012a"] = array("Image target",                                         "Choose here the target, in which the link of the image shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking on external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO013"]  = array("File prolog",                                          "Here you can optionally type the text that leads to download of the document.<br><br><b>Examples:</b><br><br><b>The press release download as pdf (*.pdf-file):</b><br>pressrelease_082002.pdf<br><br><b>Download product-flyer:</b><br>flyer_product_1.pdf<br><br><b>Download information for the model company:</b><br>brochure.pdf<br><br><b>Note:</b><br>If this field remains empty, ConPresso automatically accepts the indicated suggestion as name.<br>You can, however, substitute it. Just overright. If you does not type anything in this field, no corresponding prolog will be shown.");
    $help["FO014"]  = array("File",                                                 "With the dropdown menu you select the file that you would like to make available for download.<br>The file upload is category-based. If you want to use the same file in different categories, you have to upload it in each category accordingly.<br><br><b>Note:</b><br>The position of a file depends on the template used in the article.");
    $help["FO015"]  = array("File description",                                     "Here you can indicate the text to be linked, which concerns to the available file for download.<br><br><b>Example:</b><br><br>Download information for the model company:<br><b>brochure (pdf 250 kb)</b><br><br><b>Note:</b><br>If this field remains empty, ConPresso automatically accepts the indicated suggestion as name.<br><br><b>Exemple:</b><br><br>Download information for the model company:<br><b>brochure_modelcompany.pdf</b><br>");
    $help["FO016"]  = array("Link text 1",                                          "Here you can optionally enter further links.<br>Enter the text which is supposed to be linked.<br><br><b>Example:</b><br><br><b>To the official fair website &raquo;</b><br><br><b>Note:</b><br>The positon of the link depends on the template used in the article.<br><br>If no text link is entered, ConPresso automatically takes over the URL as link text.<br><br><b>Example:</b><br><br><b>http://www.conpresso.de</b>");
    $help["FO017"]  = array("URL 1",                                                "Type here the complete URL.<br><br><b>Note:</b><br>Please always enter the URL address with the prefix <b>http://</b>.");
    $help["FO017a"] = array("Text 1 target",                                        "Choose here the target, in which the link of the text shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking on external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO018"]  = array("Link text 2",                                          "Here you can optionally enter further links.<br>Enter the text which is supposed to be linked.<br><br><b>Example:</b><br><br><b>To the official fair website &raquo;</b><br><br><b>Note:</b><br>The positon of the link depends on the template used in the article.<br><br>If no text link is entered, ConPresso automatically takes over the URL as link text.<br><br><b>Example:</b><br><br><b>http://www.conpresso.de</b>");
    $help["FO019"]  = array("URL 2",                                                "Type here the complete URL.<br><br><b>Note:</b><br>Please always enter the URL address with the prefix <b>http://</b>.");
    $help["FO019a"] = array("Text 2 target",                                        "Choose here the target, in which the link of the text shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking on external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO020"]  = array("Link text 3",                                          "Here you can optionally enter further links.<br>Enter the text which is supposed to be linked.<br><br><b>Example:</b><br><br><b>To the official fair website &raquo;</b><br><br><b>Note:</b><br>The positon of the link depends on the template used in of the article.<br><br>If no text link is entered, ConPresso automatically takes over the URL as link text.<br><br><b>Example:</b><br><br><b>http://www.conpresso.de</b>");
    $help["FO021"]  = array("URL 3",                                                "Type here the complete URL.<br><br><b>Note:</b><br>Please always enter the URL address with the prefix <b>http://</b>.");
    $help["FO021a"] = array("Text 3 target",                                        "Choose here the target, in which the link of the text shall open. The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking on external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["FO022"]  = array("Author",                                               "Here you can optionally enter the name of the author. According to standard, the information of the user who was logged in during the writing of the article is shown here.<br><br>The name of the author is published together with the article, as long as this feature was activated in the category settings.<br>The position of this information depends on the template used in article.");
    $help["FO023"]  = array("E-mail",                                               "Here you can optionally enter the e-mail address of the author. According to standard, the information of the user who was logged in during the writing of the article is shown here.<br><br>The author's name and/or his initials are linked and together with this e-mail address shown in the published article, as long as this feature was activated in the category settings.<br>The position of this information depends on the template used in the article.");
    $help["FO024"]  = array("Initials",                                             "Here you can optionally enter the author's initials. According to standard, the information of the user who was logged in during the writing of the article is shown here.<br><br>The author's initials are shown in the published article, as long as this feature was activated in the category settings.<br>The position of this information depends on the template used in the article.");

    // Header
    $help["HD001"]  = array("Basic information for the creation of articles",       "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project. You can get an impression of this in the template preview.<br><br><b>Note:</b><br>All input boxes are optional. That means, if you leave them empty, the corresponding element does not appear within your article.<br>");
    $help["HD002"]  = array("Basic information for the creation of articles",       "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project. You can get an impression of this in the template preview.<br><br><b>Note:</b><br>All input boxes are optional. That means, if you leave them empty, the corresponding element does not appear within your article.<br>");
    $help["HD003"]  = array("Basic information for the creation of articles",       "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project. You can get an impression of this in the template preview.<br><br><b>Note:</b><br>All input boxes are optional. That means, if you leave them empty, the corresponding element does not appear within your article.<br>");
    $help["HD004"]  = array("Basic information for the creation of articles",       "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project. You can get an impression of this in the template preview.<br>");
    $help["HD005"]  = array("Restore article",                                      "ConPresso offers you an efficient version management.<br>Here you can call older article versions at any time and, if necessary, restore them.");

    // Artikel Verwaltung
    $help["IN001"]  = array("Version date",                                         "The column \"Version date\" indicates in the upper line (black) the date of the article's creation. The date in the second line (green) shows the date of release.<br>In the third row, the name of the user who released the article version might be displayed in brackets.<br>If the editor is the user who released the article, no name is shown.");
    $help["IN001a"] = array("Version date",                                         "The column \"Version date\" shows the date of the creation of the article in the first line (black). The date in the second line (green) shows the date of release.<br>In the third row, the name of the user who released the article version might be displayed in brackets.<br>If the editor is the user who released the article, no name is shown.");
    $help["IN002"]  = array("Status",                                               "This column shows you the status of the respective article. Each of the specifications mean:<br><br><b>Waiting</b><br>\"Waiting\" indicates that the article is waiting to be released by an authorized user.<br><br>\"Waiting\" with a green/grey strip indicates that the article is waiting to be released by an authorized user. Even so, at the moment, an older version of this article is online.<br><br><b>Blocked</b><br>\"Blocked\" indicates that the article was blocked by an authorized user.<br><br><b>Rejected</b><br>The article was rejected by an authorized user. The user who rejects the article is requested to inform the reasons of the rejection (optional). Independently of the release system is active or not, an e-mail is sent to the author of the article.<br><br><b>Released</b><br>The article was released. If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here are displayed all articles with the status \"Waiting\", \"Blocked\" or \"Released\". Rejected articles are not shown.<br>");
    $help["IN002a"] = array("Status",                                               "This column shows you the status of the respective article. Each of the specifications mean:<br><br><b>Waiting</b><br>\"Waiting\" indicates that the article is waiting to be released by an authorized user.<br><br>\"Waiting\" with a green/grey strip indicates that the article is waiting to be released by an authorized user. Even so, at the moment, an older version of this article is online.<br><br><b>Blocked</b><br>\"Blocked\" indicates that the article was blocked by an authorized user.<br><br><b>Rejected</b><br>The article was rejected by an authorized user. The user who rejects the article is requested to inform the reasons of the rejection (optional). Independently of the release system is active or not, an e-mail is sent to the author of the article.<br><br><b>Released</b><br>The article was released. If an article is released, it does not mean automatically that the article is online within your project. Once it is determined by the date of publication, the article (that possibly is still waiting) might be still completely offline. Thus, \"Released\" means that for the period of publication time, the article is released.<br><br><b>Note:</b><br>With the \"View\" function in the main menu of ConPresso you can have a general impression of the result of your creation or modification of the article.<br>Here are displayed all articles with the status \"Waiting\", \"Blocked\" or \"Released\". Rejected articles are not shown.<br>");
    $help["IN003"]  = array("Title/Editor",                                         "The column shows you the title and the editor (the user who last edited the article).<br>By clicking in the title, you get the preview of the article.<br>If the article does not have a title, the subtitle is alternatively indicated here.<br>\"n.t.\" means \"no title\": During the creation of the article neither title nor subtitle was entered.");
    $help["IN003a"] = array("Title/Editor",                                         "The column shows you the title and the editor (the user who last edited the article).<br>By clicking in the title, you get the preview of the article.<br>If the article does not have a title, the subtitle is alternatively indicated here.<br>\"n.t.\" means \"no title\": During the creation of the article neither title nor subtitle was entered.");
    $help["IN004"]  = array("Publication/Template",                                 "This column shows the last publication date of the article.<br><br>Moreover, the status of the publication is shown (the meaning of the terms you find <a href=\"#stand\">here</a>).<br><br>It is also shown the name of the template that is being used in this article.<br>This might be useful when you want to create a new article, following the model of an already-written article. You see immediately which template you should use.<br><br><a name=\"stand\"></a>The specifications on the status of publication mean:<br><br><b>ONLINE</b><br>The article is within the target date of publication and thus online (as long as it has been released).<br><br><b>OFFLINE</b><br>The article is not within the target date of publication (date is in the future), thus OFFLINE; even after it has been released, it is still not visible in your project-online, until the date of the publication is reached.<br><br><b>EXPIRED</b><br>The publication date of the article already expired.<br>If the archive function is used for a category, this article appears inside the archive.<br><br><b>Example:</b><br><br>In your project, an article about a fair in the category \"News\" is supposed to be published between 1st-03 and 15th-03 of the current year.<br><br><b>24th-02:</b><br>The article is shown as OFFLINE-article.<br>Reason: the date of publication has not been reached yet.<br>The article remains OFFLINE until 01st-03. On 01st-03 its status changes to ONLINE.<br><br><b>02nd-03:</b><br>The article is shown ONLINE, since the date of publication was reached.<br>The article is visible inside your online-project, thus published (as long as it has been released).<br><br><b>16th-03</b><br>The article is indicated as EXPIRED.<br>Reason: The date of expiry is reached or exceeded. If the archive function is activ in the category \"News\" inside your online-project (this can be done in the category settings), the article appears inside your online-archive (if released).");
    $help["IN004a"] = array("Publication/Template",                                 "This column shows the last publication date of the article.<br><br>Moreover, the status of the publication is shown (the meaning of the terms you find <a href=\"#stand\">here</a>).<br><br>It is also shown the name of the template that is being used in this article.<br>This might be useful when you want to create a new article, following the model of an already-written article. You see immediately which template you should use.<br><br><a name=\"stand\"></a>The specifications on the status of publication mean:<br><br><b>ONLINE</b><br>The article is within the target date of publication and thus online (as long as it has been released).<br><br><b>OFFLINE</b><br>The article is not within the target date of publication (date is in the future), thus OFFLINE; even after it has been released, it is still not visible in your project-online, until the date of the publication is reached.<br><br><b>EXPIRED</b><br>The publication date of the article already expired.<br>If the archive function is used for a category, this article appears inside the archive.<br><br><b>Example:</b><br><br>In your project, an article about a fair in the category \"News\" is supposed to be published between 1st-03 and 15th-03 of the current year.<br><br><b>24th-02:</b><br>The article is shown as OFFLINE-article.<br>Reason: the date of publication has not been reached yet.<br>The article remains OFFLINE until 01st-03. On 01st-03 its status changes to ONLINE.<br><br><b>02nd-03:</b><br>The article is shown ONLINE, since the date of publication was reached.<br>The article is visible inside your online-project, thus published (as long as it has been released).<br><br><b>16th-03</b><br>The article is indicated as EXPIRED.<br>Reason: The date of expiry is reached or exceeded. If the archive function is activ in the category \"News\" inside your online-project (this can be done in the category settings), the article appears inside your online-archive (if released).");
    $help["IN005"]  = array("Article",                                              "By clicking on \"Release\", \"Reject\" or \"Block\" you modify the status of the article. You activate the following actions:<br><br><b>Release</b><br>You release the article for publication in your online-project. A separate confirmation is not required.<br><br><b>Reject</b><br>You reject the article. A window opens automatically and you are requested to justify/comment the rejection.<br>If you do not want to send any comment, just close the window. The article will be rejected nevertheless, and no e-mail will be sent.<br><br><b>Block</b><br>The article is immediately blocked and does not appear in your online-project anymore.");
    $help["IN005a"] = array("Article",                                              "Click on \"Restore\" in order to restore an older article version. Please notice that when using the release system, the version still has to be released.<br>Choose \"Delete\", if you want to erase an older version definitively. A warning note appears requesting you to confirm your decision.");

    // Log-Datei
    $help["LG001"]  = array("ID",                                                   "ConPresso assigns automatically an explicit identification for each action (numeric order).<br>The most recent action is always placed on top with the ID '1'. The older the action, the higher is the ID.");
    $help["LG002"]  = array("User",                                                 "Here is shown the name of the user who was connected to the system.");
    $help["LG003"]  = array("Date",                                                 "Here date and hour of the action of the user are shown.");
    $help["LG004"]  = array("Action",                                               "In this column you can see the action of the respective user.");
    $help["LG005"]  = array("Remark",                                               "In the column \"Remark\" is registered which files were uploaded and/or deleted, or still the category in which the user has been working.");

    // Login
    $help["LO001"]  = array("Forgot your password?",                                "ConPresso encodes all passwords. Thus, it is not possible to send you your current password by e-mail.<br>However, you can request a new password.<br>This will be sent to the e-mail address known by the system.<br><br>You can also contact your administrator.");

    // Rubrikauswahl
    $help["RA006"]  = array("Release",                                              "By clicking the link \"Edit\" in this column, you can directly edit all the releases of articles of each category.<br><br>In opposite to the \"Central article release\" (menu \"Releases --> Edit\") by clicking on \"Edit\",  all the articles of this category are shown here, including the articles for release edition.<br><br>To compare: <br>In the \"Central article release\" you are shown a <b>current</b> list with articles of <b>all</b> categories waiting for release instead.");

    // Rubrik-Rechte (User)
    $help["RC001"]  = array("Categories",                                           "The column shows to all the categories, in which articles can be edited.");
    $help["RC002"]  = array("Create",                                               "The user may (within the possibilities defined in the settings of the category) write articles.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RC003"]  = array("Change/Delete",                                        "The user is allowed to change or delete articles.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RC004"]  = array("Images/Files",                                         "The user is allowed to upload images or files onto the server in order to use them during the article construction.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RC005"]  = array("Release",                                              "The user is allowed to release articles and/or changes in articles (when using the release system).<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RC006"]  = array("+ | -",                                                "Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");

    // Rubrik-Einstellungen
    $help["RE001"]  = array("Directory",                                            "Here is indicated the name of the directory in which the category is included.");
    $help["RE002"]  = array("Option 1",                                             "In order to generate this category within your online project completely dynamically, please proceed as follows:<br><br><b>Alternative 1:</b><br>Click on the colored part of the link and copy the whole URL from the address line in the opening browser window.<br>And insert afterwards this URL as target of your navigation within your project.<br><br><b>Alternative 2:</b><br>Mark and copy the whole orange-marked link and then insert it as target of your navigation within your project.<br><br>You get a completely dynamic page.<br>If you want to generate dynamically only parts of your static page from ConPresso, please use \"Option 2\".<br><br><b>Note:</b><br>For graphical adjustment of the edition, please read the file README.txt in the main directory of ConPresso.<br>");
    $help["RE003"]  = array("Option 2",                                             "In order to transfer, within your online project, contents from ConPresso to a static page, please proceed as follows:<br><br><b>Alternative 1:</b><br>Click on the colored part of the link and copy the whole URL from the address line in the opening browser window.<br>And insert afterwards this URL into the HTML code of your project.<br><br><b>Alternative 2:</b><br>Mark and copy the whole orange-marked link and then insert it into the HTML code of your project.<br><br>You get a completely dynamic page.<br>If you want to generate the category completely dynamically, please use the \"Option 1\".<br><br><b>Note:</b><br>For graphical adjustment of the edition, please read the file README.txt in the main directory of ConPresso.<br>");
    $help["RE004"]  = array("Category",                                             "Enter here the name under which you want to manager the category. This name does not appear within your online-project.<br><br>The categories administered by you are alphabetically arranged by Conpresso according to the names indicated here.");
    $help["RE005"]  = array("Heading",                                              "Enter here the heading under which the category is to appear within your online project.<br><br><b>Note:</b><br>If no name is entered, ConPresso does not display a headline on the corresponding page.");
    $help["RE005a"] = array("Activate heading",                                     "Set a checkmark here if the indicated heading in the selected category of your online project is to appear. If the small box is deactivated no heading will be inserted.");
    $help["RE006"]  = array("Note 'no entry'",                                      "Here you can enter the text which is to appear when no entry in the category is available.<br><br><b>Example:</b><br><br>You are using ConPresso for the maintenance of your job adds. If currently no job offers exist, it is shown a text concerned to the category:<br><br><b>No current vacancies at present.</b>");
    $help["RE007"]  = array("Max. no. of articles",                                 "Here you can determine how many articles are to be maximum indicated on a page, before a further page is automatically generate where the other articles are located.<br><br><b>Example:</b><br><br>You define the number of \"3 \". If more than three articles are online in this category, a continuing link appears automatically at the end of page.<br><br><b>Title 1</b><br>Article 1<br><br><b>Title 2</b><br>Article 2<br><br><b>Title 3</b><br>Article 3<br><br><b>next page &raquo;</b><br><br>At the end of this \"next page\" appears respectively the note:<br><br><b>&laquo; previous page</b><br>");
    $help["RE008"]  = array("Archive",                                              "If the checkmark is set, you can use the archives function of ConPresso.<br>Expired articles (those whose publication period is exceeded) are then shifted automatically into archives, which are likewise published in your project.<br><br><b>Example:</b><br><br>You are using ConPresso for the maintenance of a press release area. Older articles can expire and after a fixed period finish up in press archives afterwards.<br>At the end of the current entries, a note automatically appears in the archives.<br><br><b>Title 1</b><br>Press release 1<br><br><b>Title 2</b><br>Press release 2<br><br><b>Title 3</b><br>Press release 3<br><br><b>Archive &raquo;</b><br><br><br>At the end of page of the \"Archive\" that was called up, appears respectively the note:<br><br><b>&laquo; back</b><br><br><b>Note:</b><br>You can select the name for archives in the next field. For example:<br><br><b>Press archive</b><br>");
    $help["RE009"]  = array("Archive note",                                         "If you are using the archives function in this category, here you can specify the text for the note on the archive which is to be indicated within your online project.<br><br><b>Example:</b><br><br>You are using ConPresso for the maintenance of a press release area. Older articles can expire and after a fixed period finish up in press archives afterwards. As archive note you could indicate for example:<br><br><b>To the press archive &raquo;</b><br><b>Read older press releases &raquo;</b><br><b>More information &raquo;</b><br><br>The result would look as follows:<br><br><b>Title 1</b><br>Press release 1<br><br><b>Title 2</b><br>Press release 2<br><br><b>Title 3</b><br>Press release 3<br><br><b>To the press archive &raquo;</b><br>");
    $help["RE010"]  = array("Archive heading",                                      "If you are using the archives function in this category, here you can specify the heading for the note on the archive which is to be indicated within your online project.<br><br><b>Example:</b><br><br>You are using ConPresso for the maintenance of a press release area. Older articles can expire and after a fixed period finish up in press archives afterwards. As archive heading you could indicate for example:<br><br><b><b>Press archive</b><br>");
    $help["RE010a"] = array("Language \"subject navigation\"",                      "Select here the language in which the standard navigation is to appear inside categories.<br><br>Links of the standard navigation appear, for exemple, in the form of the notes <i>forward</i> and <i>back</i>, or (<i>next page</i>, <i>previous page</i>) if a great number of articles is linked on another page (depending on indication in the field \"Max. no. of articles\").");
    $help["RE011"]  = array("Search result",                                        "Here you can decide whether the current category is to be integrated into the search function.<br>Set the checkmark in order to integrate the category into the search function.");
    $help["RE012"]  = array("Article sorting",                                      "By setting the checkmark you activate the convinient article sorting in the category.<br><br>All articles are classified by date of creation and, therefore, they appear in the corresponding order of your online-project.<br>If you want to change the article order, please click the up or down arrow.");
    $help["RE013"]  = array("Dividing line",                                        "By setting the checkmark you will be allowing the articles to be individually and respectively separated by a dividing line. The line covers the whole width of the article.<br><br><br><b>Example:</b><br><br><b>Title 1</b><br>Article 1<br><br><hr><br><b>Title 2</b><br>Article 2<br><br><hr><br><b>Title 3</b><br>Article 3<br>");
    $help["RE014"]  = array("Target window of links",                               "Here you can specify, concernig to the category, in which browser window the link is supposed to be opened.<br><br>The following alternatives are available:<br><br><b>same frame</b><br>Links are opened in the same frame.<br>Corresponds to HTML code: target=\"_self\".<br><br><b>new window</b><br>Links are opened in a new browser window (standard when linking on external websites).<br>Corresponds to HTML code: target=\"_blank\".<br><br><b>same browser window</b><br>Links are opened in the same (current) browser window.<br>Corresponds to HTML code: target=\"_top\".<br><br><b>\"&lt;Frame-Name&gt;\"</b><br>Links are opened in the frame \"&lt;Frame-Name&gt;\".<br>Corresponds to HTML code: target=\"&lt;Frame-Name&gt;\". The \"&lt;Frame-Name&gt;\" is named by the administrator.<br><br>");
    $help["RE015"]  = array("Default template",                                     "With the dropdown menu you can fix a template as standard template in order to specify in advance the structural line of the category. The positions of each article element are determined by the used template.<br><br>In the input/output settings which can be edited below, you determine which article elements are to be shown in this category.<br><br><b>Note:</b><br>In the field below \"Allowed templates\", you can allow the users of ConPresso to use alternative templates when creating articles. This ensures substancial structural flexibility when creating articles.<br>");
    $help["RE016"]  = array("Allowed templates",                                    "Here you can in addition allow the users of ConPresso to use alternative templates when creating articles. This ensures substancial structural flexibility when creating articles.<br><br><b>Note:</b><br>The positions of each article element are determined by the used template.<br>In the input/output settings which can be edited below, you determine which article elements are to be shown in this category.<br><br>You can certainly select all the templates here.");
    $help["RE020"]  = array("Edit",                                                 "By setting the checkmark in the option \"Edit\", you grant the users of ConPresso possibilities of edition in this field for all the articles of this category. That means, the ConPresso's users have in each case the option to use this field for the structuring of your article.<br>Normally the fields are not mandatory, thus they needn't be filled every time an article is created.<br><br><b>Note:</b><br>You find a help text about the meaning of each option, by clicking on <img src=\"../_images/help.gif\"> in the corresponding field.");
    $help["RE021"]  = array("Page 1",                                               "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project.<br><br>Following this principle, you have the possibility to insert components of your articles into a <b>\"Page 1\"</b>, into a continuing <b>\"Detail page\"</b> or into both pages.<br>Thus, by setting the checkmark here, you determine that this article element is to be indicated on <b>\"Page 1\"</b> of the article issue in your online-project.<br><br><b>Note:</b><br>Each article element can appear on both <b>\"Page 1\"</b> and <b>\"Detail page\"</b>.<br>The arrangement of the elements depends on the selected template.<br>");
    $help["RE022"]  = array("Detail page",                                          "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project.<br><br>Following this principle, you have the possibility to insert components of your articles into a <b>\"Page 1\"</b>, into a continuing <b>\"Detail page\"</b> or into both pages.<br>Thus, by setting the checkmark here, you determine that this article element is to be indicated on <b>\"Detail page\"</b> of the article issue in your online-project.<br><br><b>Note:</b><br>Each article element can appear on both <b>\"Page 1\"</b> and <b>\"Detail page\"</b>.<br>The arrangement of the elements depends on the selected template.<br>");
    $help["RE030"]  = array("Index",                                                "By setting the checkmark here, you enable the field \"Index\" for edition.<br><br>Through the index box you can &ndash; independently of how the artcicle is sorted by the up and down arrows &ndash; control the order of articles with an index number. The order of articles appears in ascending numerical sequence.<br><br><b>Example:</b><br><br>You have posted 5 articles in a certain category. They will be automatically sorted according to their date of creation.<br>If you want that an article, due to its present time or priority, always appears in the website as the first entry (even if an editor indicates another order), you can register one 1 here. The article always appears in first place, independently of its position in the article overview and its publication date.<br>If you want to set this to several articles, just distribute further sequential numbers.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE031"]  = array("Title",                                                "By setting the checkmark here, you enable the field \"Title\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE032"]  = array("Title URL",                                            "By setting the checkmark here, you enable the field \"Title URL\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE033"]  = array("Title target",                                         "By setting the checkmark here, you enable the field \"Title target\" for edition.<br><br>The ConPresso's user can choose if an URL, with which the title is connected, is to be opened in the same browser window or in a new one."); 
    $help["RE033a"] = array("Title = 'More' text",                                  "By setting a checkmark here, the title assumes at the same time the function of the 'More' text in the context of article composition.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered. The detailed \"Article text\" now appears after one click on the title.<br><br>If at the same time you grants the editor the possibility to link a title, and the editor actually does it, then counts what he enters.<br>That means the 'More' function for the corresponding article would be overridden.<br>");
    $help["RE034"]  = array("Subtitle",                                             "By setting the checkmark here, you enable the field \"Subtitle\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE035"]  = array("Subtitle URL",                                         "By setting the checkmark here, you enable the field \"Subtitle URL\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE036"]  = array("Subtitle target",                                      "By setting the checkmark here, you enable the field \"Subtitle target\" for edition.<br><br>The ConPresso's user can choose if an URL, with which the subtitle is connected, is to be opened in the same browser window or in a new one.");
    $help["RE037"]  = array("Teaser text",                                          "By setting the checkmark here, you enable the field \"Teaser text\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE038"]  = array("'More' text",                                          "By setting the checkmark here, you enable the field \"'More' text\" for edition.<br><br><b>Note:</b><br>If this field is not enabled for edition, ConPresso inserts the following standard 'more' text:<br><br><b>more</b><br><br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE039"]  = array("Article text",                                         "By setting the checkmark here, you enable the field \"Article text\" for edition.<br><br><b>Note:</b><br>If this field is not enabled for edition, the article cannot be arranged in this category in forms of <b>Teaser text</b> --> <b>'More' text</b> --> <b>Article text</b>, since this field is a required prerequisite.<br><br><b>Example:</b><br><br><b>ConQuarium Inc. increases its turnover by 17%.</b><br>At the end of the commercial year ConQuarium Inc., in contrast to the tendency in the sector, could increase its annual turnover to $1,3 billion.<br><br>With that, the result is not only beyond 14,5% expected by the analysts, but also beyond the tendency in the sector of plastic fish manufacture.<br>Fritz Fisher, finance director of the company, stated at the press conference yesterday that the increased profit happened for two reasons: extended range of products and significant reduction of costs. Both reached through the reorganization of the production process.<br><br><b>Note:</b><br>The line in boldface is the title of the article. A subtitle was not entered. The detailed text is the \"Article text\" that appears after clicking on \"more &raquo;\".<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE040"]  = array("Continuation text",                                    "By setting the checkmark here, you enable the field \"Continuation text\" for edition.<br>The field \"Continuation text\" provides you further structural possibilities during the article construction.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE041"]  = array("Image",                                                "By setting the checkmark here, you enable the field \"Image\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE042"]  = array("Image URL",                                            "By setting the checkmark here, you enable the field \"Image URL\" for edition.<br><br>");
    $help["RE043"]  = array("Image description",                                    "By setting the checkmark here, you enable the field \"Image description\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE044"]  = array("File",                                                 "By setting the checkmark here, you enable the field \"File\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE045"]  = array("File description",                                     "By setting the checkmark here, you enable the field \"File description\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE046"]  = array("File prolog",                                          "By setting the checkmark here, you enable the field \"File prolog\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE047"]  = array("URL 1",                                                "By setting the checkmark here, you enable the field \"URL 1\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE048"]  = array("Link text 1",                                          "By setting the checkmark here, you enable the field \"Link text 1\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE049"]  = array("URL 2",                                                "By setting the checkmark here, you enable the field \"URL 2\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE050"]  = array("Link text 2",                                          "By setting the checkmark here, you enable the field \"Link text 2\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE051"]  = array("URL 3",                                                "By setting the checkmark here, you enable the field \"URL 3\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE052"]  = array("Link text 3",                                          "By setting the checkmark here, you enable the field \"Link text 3\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE060"]  = array("Variable",                                             "For all information concerned to the author of an article  (name, email, initials), ConPresso usually takes the data from the user administration.<br><br>If you want that these data can be also edited when editing an article, please set the checkmark here.<br><br><b>Example:</b><br><br>Peter Paul writes a current news entry in the raw version. His colleague Susan Smith, who last revises the article, can edit the author data so that her data appear in the online-project.<br>It perhaps makes sense if Susanne Smith is responsible for the area with which the article is concerned.<br><br><b>Note:</b><br>The position of the element is determined by the used template.<br>");
    $help["RE061"]  = array("Page 1",                                               "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project.<br><br>Following this principle, you have the possibility to insert components of your articles into a <b>\"Page 1\"</b>, into a continuing <b>\"Detail page\"</b> or into both pages.<br>Thus, by setting the checkmark here, you determine that this article element is to be indicated on <b>\"Page 1\"</b> of the article issue in your online-project.<br><br><b>Note:</b><br>Each article element can appear on both <b>\"Page 1\"</b> and <b>\"Detail page\"</b>.<br>The arrangement of the elements depends on the selected template.<br>");
    $help["RE062"]  = array("Detail page",                                          "ConPresso works based on articles.<br>An article in ConPresso corresponds to a newspaper or magazine article in the printed media.<br>Basically, an article consists of title, subtitle, teaser text, article text and images. Depending on the need, further information can be added, e.g. links or files for download.<br>Articles can be flexibly composed. Depending on the selected template and on the category settings, the individual components of the article are arranged within your project.<br><br>Following this principle, you have the possibility to insert components of your articles into a <b>\"Page 1\"</b>, into a continuing <b>\"Detail page\"</b> or into both pages.<br>Thus, by setting the checkmark here, you determine that this article element is to be indicated on <b>\"Detail page\"</b> of the article issue in your online-project.<br><br><b>Note:</b><br>Each article element can appear on both <b>\"Page 1\"</b> and <b>\"Detail page\"</b>.<br>The arrangement of the elements depends on the selected template.<br>");
    $help["RE070"]  = array("Author",                                               "By setting the checkmark here, you enable the field \"Author\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE071"]  = array("E-mail",                                               "By setting the checkmark here, you enable the field \"E-mail\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE072"]  = array("Initials",                                             "By setting the checkmark here, you enable the field \"Initials\" for edition.<br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br><br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE073"]  = array("Format of date",                                       "By setting the checkmark here, you enable the field \"Format of date\" for edition.<br><br><b>Note:</b><br>On principle the creation date of the article is assumed by ConPresso.<br><br>Here you can preformat the date as you like. The letters stand for:<br><br><<b>d</b>ay <b>m</b>onth <b>y</b>ear <b>h</b>our:<b>i</b>minute.<br><br>By any removal or changing of symbols you can affect the corresponding edition.<br><br><b>Exemplo:</b><br><br><b>d.m.Y H:i</b> --> <b>09.09.1999 14:04</b><br><br><b>d.m.Y</b> --> <b>09.09.1999</b><br><br><b>d.m. H:i</b> --> <b>09.09. 14:04</b><br><br><b>Note:</b><br>With the input/output settings (Categroy settings), you determine definitively the appearance of the article inside of the chosen category.<br>Please note that the position of the individual elements is determined by the used template.<br>");
    $help["RE080"]  = array("Activate editor",                                      "By setting the checkmark here, you enable the editor function for creation of articles.<br><br><b>Note:</b><br>Below you can activate and/or deactivate individual buttons in the editor by setting checkmarks into the appropriate fields. The users can, concerning to the category, provide more or less wide leeway of structuring for the article creation.<br>");
    $help["RE081"]  = array("Editor settings",                                      "By setting the checkmark here, you enable the editor function for creation of articles.<br><br><b>Note:</b><br>Below you can activate and/or deactivate individual buttons in the editor by setting checkmarks into the appropriate fields. The users can, concerning to the category, provide more or less wide leeway of structuring for the article creation.<br><br>You can activate and/or deactivate the following editor's features:<br><br><b>Table</b><br>Enables the intergration and structuring of tables with the editor's assistence.<br><br><b>Indent</b><br>Enables the structuring of texts with the assistence of the indent function.<br><br><b>List</b><br>Enables the structuring of text parts with assistence of ordered and unordered list.<br><br><b>HR-Line</b><br>Enables the user to insert a narrow dividing line for the structuring of texts.<br><br><b>Hyperlinks</b><br>Enables the user to insert hyperlinks with external websites and e-mail addresses.<br><br><b>Justification</b><br>Enables the user to change the alignment of text parts (right justified, left justified, centred, grouped style).<br><br><b>Format</b><br>Enables the formatting of text parts (bold, italic, underlined, etc.).<br><br><b>Color</b><br>Enables the color structuring of text parts or backgrounds.<br><br><b>Images</b><br>Enables the user to insert extra images apart of the template default.<br><br><b>Fonts</b><br>Enables the user to format the article font (font type, font size, paragraph).<br>");

    // Rubrik-Rechte
    $help["RR001"]  = array("User",                                                 "The column shows you all users that are taking part on this project in ConPresso.");
    $help["RR002"]  = array("Create",                                               "The user may (within the possibilities defined in the settings of the category) write articles.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RR003"]  = array("Change/Delete",                                        "The user is allowed to change or delete articles.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RR004"]  = array("Images/Files",                                         "The user is allowed to upload images or files onto the server in order to use them during the article construction.<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RR005"]  = array("Release",                                              "The user is allowed to release articles and/or changes in articles (when using the release system).<br><br><b>Note:</b><br>Easier would be to click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");
    $help["RR006"]  = array("+ | -",                                                "Click on the right arrow (<b>&raquo;</b>) in the last column to set all rights for the respective category to \"Yes\".<br>A click on the left arrow (<b>&laquo;</b>) in the last column, sets all rights for the respective category to \" --- \".<br><br>If all rights of the user are at \" --- \", he has no rights on this category. This category is not shown in his category selection either.<br>It perhaps makes sense if the user is authorized to edit many categories. So he is only shown the categories, which are relevant for him.<br><br>If all rights for a category are at \"No\", the user has likewise no rights on the category. However it is shown in his category selection.");

    // Search
    $help["SC001"]  = array("Search",                                               "Type one or more terms in order to search all articles.<br>To separate them, do not use comma nor semi colon. Just let a blank space between the keywords, which must consist on at least two letters.");

    // Systemeinstellungen
    $help["SE001"]  = array("Name of the project",                                  "Here you can give a name to your project. This helps you especially if you work on several projects with ConPresso. If you use the release function, including email forwarding, then this name appears also in the emails generated automatically, which will be sent within the context of the release system.<br>In addition, the project name will be shown on the login page of ConPresso.");
    $help["SE002"]  = array("Release",                                              "Here you can choose whether a release within the project is to take place.<br><br>If you decide for the release option, you can decide in the next step if you want to be informed/supported by email or if you prefer to access ConPresso (without email reminder) and check the project where articles are waiting to be released.<br>We recommend you to decide for the release function together with the email forwarding.<br><brPlease note that with the release system activated, created articles need to be released in order to appear in your online project. This applies also to articles created by you if you are authorized to release.<br><br>You can release articles in \"Article Administration --> Edit article\" or in \"Releases --> edit\".");
    $help["SE003"]  = array("Release e-mails",                                      "If you chose the option \"Release necessary\", you can decide here whether the persons involved in the project are to be informed automatically by email about the release status.<br><br>Please note that with the release system activated, created articles need to be released in order to appear in your online project. This applies also to articles created by you if you are authorized to release.<br><br>You can release articles in \"Article Administration --> Edit article\" or in \"Releases --> edit\".");
    $help["SE004"]  = array("System e-mail",                                        "Here you can register an address to which ConPresso automatically sends generated emails.<br>With release system activated, a valid sender address is required, since ConPresso will inform you about the release status of articles.");
    $help["SE005"]  = array("Admin e-mail",                                         "Here you can register the administrator's email address (ConPresso). It will be automatically sent as contact address for technical problems together with all system emails.");
    $help["SE006"]  = array("Timeout",                                              "Here you can indicate the duration, after which a user is logged out automatically from the system (Timeout), since within this time interval no activities were registered.<br>The timeout length is given in seconds.");
    $help["SE006a"] = array("Max. Size of Image (Byte):",                           "Here you can indicate the maximum size that an image may have when uploaded by an user for the use during the creation of articles.<br><br>Due to the configuration of your Apache web server, the upload is usually limited to a size of 2 MB.<br><br><b>Note:</b><br>The size is given in bytes.<br>1 Kbyte corresponds to 1.024 bytes.<br>100 Kbytes corresponds to 102.400 bytes.<br>1 Mbyte corresponds to approx. 1.048.576 bytes.<br><br>For an acceptable size we recommend a value of 153.600 bytes (= 150 Kbytes).");
    $help["SE006b"] = array("Max. Size of File (Byte):",                            "Here you can indicate the maximum size that a file may have when uploaded by an user for the use during the creation of articles.<br><br>Due to the configuration of your Apache web server, the upload is usually limited to a size of 2 MB.<br><br><b>Note:</b><br>The size is given in bytes.<br>1 Kbyte corresponds to 1.024 bytes.<br>100 Kbytes corresponds to 102.400 bytes.<br>1 Mbyte corresponds to approx. 1.048.576 bytes.<br><br>For an acceptable size we recommend a value of 2.048.000 bytes (= 2 MBytes).");
    $help["SE007"]  = array("Width of article",                                     "Here you can indicate the maximum width of articles within the project. This serves as structural setting for your project.<br><br>The width is given is pixel.");
    $help["SE008"]  = array("Language",                                             "Here you select the ConPresso system language. This is the base setting of the system and applies thereby to a new user and to the login page.<br><br><b>Note:</b><br>In order to enable this setting to become effective, you must log out after saving the language option, by clicking on \"Save project settings\", and then log in again. Despite of the language setting has been edited by you, any user can set their own language option.");
    $help["SE009"]  = array("Base URL",                                             "Enter here the URL where the data of your ConPresso system are to be integrated into your website.<br><br><b>Example:</b><br><br>You want to integrate ConPresso into your website under http://www.my-website.com/. Create a directory (recommended: \"conpresso\") which the system can later access.<br>In this case enter as URL:<br>http://www.my-website.com/conpresso/.");
    $help["SE010"]  = array("Send password",                                        "ConPresso offers its users the possibility to set a new password on the login page in case of loss of access data. The password is sent to the email address that is registered in the user administration.<br><br>You can activate and/or deactivate the function here.<br><br><b>Note:</b><br>Please note that ConPresso encodes the passwords and therefore the original password cannot be sent to the user.<br>In spite of this, any user can change his own password at any time.");
    $help["SE011"]  = array("Helpdesk",                                             "Here you activate and/or deactivate the ConPresso helpdesk system.<br>If the help function is deactivated no <img src=\"../_images/help.gif\"> appears in the whole system.");
    $help["SE012"]  = array("News on login page",                                   "Here you can decide whether you want to see tips, comments or update notes from the developers of ConPresso on the login page.");
    $help["SE013"]  = array("Frame targets",                                        "Enter here the names of your frame targets. The name will be shown to the editor (as long as he is entitled) as a possible link target during the article creation.<br><br>If you want to make several targets available to the editors, you can enter them here. To separate them just let a blank space inbetween.");
    $help["SE020"]  = array("Database cleanup",                                     "Do a database cleanup in order to free it from useless entries.");
    $help["SE021"]  = array("Delete articles edition block",                        "ConPresso recognizes if an article is currently in editing process. Another user cannot access the same article for editing at the same time.<br>If a user leaves the system without logging out (by simply closing the browser), the article remains blocked for the editing. Click on \"run\" in order to cancel the blocking and to free all articles for editing again.<br>A warning note appears requesting you to confirm your decision.");
    $help["SE022"]  = array("Delete deleted articles",                              "ConPresso administers deleted articles in the scope of the version administration. There they can be re-activated at any time.<br><br>Click on run - \"Delete deleted articles\" in order to remove irreversibly all deleted articles from the database.<br>A warning note appears requesting you to confirm your decision.");
    $help["SE023"]  = array("Delete old article version",                           "ConPresso stores all articles in the system. If an article is revised, then the current version of the article is saved as \"older article version\" and can be restored.<br><br><b>Note:</b><br>All versions of a certain article which will be updated, for example weekly or even daily, will be respectively stored as different versions of the article in the article administration.<br><br>In order to delete all old article versions irreversibly, click on run - \"Delete old article version\".<br>A warning note appears requesting you to confirm your decision.");
    $help["SE024"]  = array("Delete old logdata",                                   "In order to delete all old logdata, click on run - \"Delete old logdata\".<br>A warning note appears requesting you to confirm your decision.");
    $help["SE100"]  = array("Buy it",                                               "If you want to work with ConPresso in the scope of the \"ConPresso Business Licence\" and thus for commercial use, you have to licence ConPresso.<br><br>By clicking on the link \"Buy it!\" you reach the official ConPresso website, where you can buy the \"ConPresso Business Licence\".");
    $help["SE101"]  = array("Licence owner",                                        "When purchasing ConPresso, indicate the name or company name with which the licencing is to be registered. Please enter this name in the field \"Licence owner\" and make sure that you are typing the exact spelling used during the software purchase process.<br><br>Only the entry of the \"Licence owner\" makes a successful licencing possible. After input of the \"Licence owner\" and \"Licence key\", you complete the licencing process by clicking on \"Save licence key\".<br><br><b>Note:</b><br>After the purchase of ConPresso you'll receive your personal valid combination of \"Licence owner\" and \"Licence key\" together with the invoice to be sent by e-mail.");
    $help["SE102"]  = array("Licence key",                                          "Please enter in the field \"Licence key\" the combination of characters informed during the purchase of ConPresso.<br><br>After input of the \"Licence owner\" and \"Licence key\", you complete the licencing process by clicking on \"Save licence key\".<br><br><b>Note:</b><br>After the purchase of ConPresso you'll receive your personal valid combination of \"Licence owner\" and \"Licence key\" together with the invoice to be sent by e-mail.");
    $help["SE103"]  = array("Product key",                                          "The product key is automatically generated on the installation of ConPresso and helps to identify its installation.");
    $help["SE104"]  = array("Product version used",                                 "Here is shown the release number of your version of ConPresso. By clicking on \"Check for new product version\" you can verify whether an update and/or a new version is available and which new functions are offered.");

    // Snippeteinstellungen
    $help["SN001"]  = array("Snippet editor",                                       "The snippet editor gives you the possibility of providing individual snippets (= code snippets) for use in your project.");
    $help["SN002"]  = array("Name",                                                 "Enter a name for the new snippet here. This name will be visible for the corresponding authorized user during the work with ConPresso.");
    $help["SN003"]  = array("Usage",                                                "Indicate here whether the snippet should be available only for the selected (and indicated) category or for the whole project.");
    $help["SN011"]  = array("Name",                                                 "The column indicates the existing snippets sorted by names.");
    $help["SN012"]  = array("Author",                                               "The column indicates the name of the user who last worked on the snippet.");
    $help["SN013"]  = array("Last change",                                          "The column indicates the date of the last change on the respective snippet.");
    $help["SN014"]  = array("Snippet",                                              "By clicking on \"Edit\", you directly get the view of the editing of the respective snippet.<br><br>By clicking on \"Copy\", you create a copy of the respective snippet. This you can adapt as desired.<br><br>Click on \"Delete\" in order to delete the respective snippet from the system. A warning note appears requesting you to confirm your decision.");
    $help["SN101"]  = array("Editing of snippets",                                  "With the help of the snippet editor you have the possibility of providing individual snippets. These can be pure text components, but also complex HTML code. However, this implies knowledge of HTML for the page production.<br>");
    $help["SN0541"] = array("Preview",                                              "Here you see a preview of the snippet.<br>Click on \"Edit\" in order to change the snippet through the editor.");

    // Teil-Anzeige
    $help["TA001"]  = array("Edit this article",                                    "By clicking on \"Edit this article\" you directly get the view of the editing of the respective article.");
    $help["TA002"]  = array("Template",                                             "Here is indicated the name of the template that is being used in this article.<br>This might be useful when you want to create a new article, following the model of an already-written article. You see immediately which template you should use.");

    // Template-Einstellungen
    $help["TP001"]  = array("Template editor",                                      "The template editor gives you the possibility of providing individual templates for the use in your project, in addition to the standard offered templates.");
    $help["TP011"]  = array("Name",                                                 "The column shows the existing templates sorted by names.");
    $help["TP012"]  = array("Author",                                               "The column shows the name of the user who last worked on the template.");
    $help["TP013"]  = array("Last change",                                          "The column shows the date of the last change on the respective template.");
    $help["TP014"]  = array("Template",                                             "By clicking on \"Edit\" you directly get the view of the editing of the respective template.<br><br>By clicking on \"Copy\", you create a copy of the respective template. This you can adapt as desired.<br><br>Click on \"Delete\" in order to delete the respective template from the system. A warning note appears requesting you to confirm your decision.<br>If the option \"Delete\" is not indicated, the template is currently being used and therefore cannot not be deleted.");
    $help["TP051"]  = array("Template",                                             "Enter here a name for the new template. This name is used only for the data base, thus it is not visible in the context of the project for the ConPresso user.");
    $help["TP052"]  = array("Name",                                                 "Enter here a name for the new template. This name will be visible for authorized users during the work in ConPresso.<br><br><b>Note:</b><br>\"Template\" and \"Name\" can bear the same name.");
    $help["TP101"]  = array("Editing of templates",                                 "With the template editor you can create individual templates. Therefore knowledge of programming and HTML code are required.<br>With the dropdown menu you can insert the available wildcard in the desired place.<br><br>Each menu provides the following features:<br><br><b>Images</b><br>You can insert images which have been previously uploaded onto your server through the image upload function.<br><br><b>Files</b><br>You can insert files which have been previously uploaded onto your server through the file upload funtion.<br><br><b>Wildcard</b><br>You can insert the offered wildcards (without wrap) in the desired place.<br><br><b>Wrapped Wildcard</b><br>You can insert the offered wildcards (including a wrap) in the desired place.<br><br><b>Conditional Wildcard</b><br>Using if-tags on the menu you can decide that contents/HTML code is indicated when a certain wildcard is set.<br><b>Note (\"Conditional Wildcard\"):</b><br>Identical &lt;%if%&gt; loops must not be interlaced.<br><br><b>Right</b><br>&lt;%if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt; <i>Contentt_1</i> &lt;%cp<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt; &lt;BR&gt; <i>Content_2</i> &lt;%/if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt;<br><br><b>Wrong</b><br>&lt;%if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt; <i>Content_1</i> &lt;%cp<font color=\"#FF0000\"><i>Wildcard</i></font>%>&lt;%if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt; &lt;BR&gt; &lt;%/if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt; <i>Content_2</i> &lt;%/if<font color=\"#FF0000\"><i>Wildcard</i></font>%&gt;");
    $help["TP0201"] = array("Preview: Page 1",                                      "Here you have a preview of the created template for the edition of \"Page 1\" of the article.<br>Click on \"edit\" in order to modify the template through the editor.");
    $help["TP0202"] = array("Preview: Detail page",                                 "Here you have a preview of the created template for the edition of \"Detail page\" of the article, thus the article part which after clicking on \"More text\" is activated.<br>Click on \"edit\" in order to modify the template through the editor.");
    $help["TP0203"] = array("Preview: Javascript",                                  "Here you have a preview of the created template when you insert in ConPresso contents created through Javascript.<br>The \"Detail page\" of the article will be further applied and edited through the template for the \"Detail page\".<br>Click on \"edit\" in order to modify the template through the editor.");

    //User &auml;ndern
    $help["UE001"]  = array("User",                                                 "This name is the user's login in ConPresso. The user's name in combination with the password serves to authenticate the user.<br><br>The user's name cannot be changed.<br>(Remedy: Delete the user and create a new one with another name.)<br><br><b>Note:</b><br>User and name can be identical.");
    $help["UE002"]  = array("Name",                                                 "Enter here the name of the user. The name is necessary for personalized elements in ConPresso, e.g. for the individual greeting or expression of goodwill at the beginning of a letter (such as \"Dear Sir\", etc.) in e-mails sent by the system in the scope of the release function.<br><br><b>Note:</b><br>User and name can be identical.");
    $help["UE003"]  = array("Level",                                                "With the dropdown menu you can assign rights to the user. The different user levels are:<br><br><b>Member:</b><br>Users classified as members are those who have no editorial function in the project, but are part of the organisation for which ConPresso is being used. Members can log with their login data into restricted areas in the scope of the project. They receive, however, no access to ConPresso and no status to edit contents.<br>With the status \"Member\" ConPresso enables you to conveniently administrate members in order to control the login rights for restricted areas of your project.<br><br><b>Editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data.<br><br><b>Chief editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users.<br><br><b>Superuser:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change the category settings; template editor; snippet editor.<br><br><b>Administrator:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change category settings; template editor; snippet editor; system settings.");
    $help["UE004"]  = array("Initials",                                             "Enter here your initials.<br>These are indicated if necessary as author identification - similar to a newspaper article - within an article (depending on the category settings).");
    $help["UE005"]  = array("E-mail",                                               "Enter here your e-mail address in order to be informed about the status of individual entries by mail (within the release system).");
    $help["UE006"]  = array("Password/Password confirmation",                       "Enter here your password and confirm it by re-typing it below.");

    // User
    $help["US001"]  = array("User",                                                 "Enter here the name with which the user is supposed to be administrated. The user's name is also the login name and serves,in combination with the password, to authenticate the user.<br><br>The user's name cannot be changed.<br>(Remedy: Delete user and create a new one with another name.)<br><br><b>Note:</b><br>User and name can be identical.");
    $help["US002"]  = array("Name",                                                 "Enter here your name. The name is necessary for personalized elements in ConPresso, e.g. for the individual greeting or expression of goodwill at the beginning of a letter (such as \"Dear Sir\", etc.) in e-mails sent by the system in the scope of the release function.<br><br><b>Note:</b><br>User and name can be identical.");
    $help["US003"]  = array("Level",                                                "With the dropdown menu you can assign the rights to the user. The different user levels are:<br><br><b>Member:</b><br>Users classified as members are those who have no editorial function in the project, but are part of the organisation for which ConPresso is being used. Members can log with their login data into resctricted areas in the scope of the project. They receive, however, no access to ConPresso and no status to edit contents.<br>With the status \"Member\" ConPresso enables you to conveniently administrate members in order to control the login rights for protected areas of your project.<br><br><b>Editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data.<br><br><b>Chief editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users.<br><br><b>Superuser:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change the category settings; template editor; snippet editor.<br><br><b>Administrator:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change the category settings; template editor; snippet editor; system settings.");
    $help["US003a"] = array("Language",                                             "Select here in which language ConPresso should be available for the user. All information and assistance (helpdesk) are displayed in the corresponding language.<br><br><b>Note:</b><br>Any user can make here the language choice.<br><br>In order to enable this setting to become effective, you must log out after saving the language option and then log in again. Despite of this language setting, the administrator edits the basic language setting for the system. This determines the language on the login page.");
    $help["US004"]  = array("Initials",                                             "Enter here your initials.<br>These are indicated if necessary as author identification - similar to a newspaper article - within an article (depending on the category settings).");
    $help["US005"]  = array("E-mail",                                               "Enter here your e-mail address in order to be informed about the status of individual entries by mail (within the release system).");
    $help["US006"]  = array("Password/Password confirmation",                       "Enter here your password and confirm it by re-typing it below.");

    // User-Verwaltung
    $help["UV001"]  = array("User",                                                 "The column \"User\" shows all authorized users ordered by names. This opinion depends on your individual user rights.<br>Click on the user to change the user's settings.");
    $help["UV002"]  = array("Level",                                                "The column \"Level\" shows which system level the respective user is assigned to.<br>Click on the user in order to change his level.<br><br>The different user levels are:<br><br><b>Editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data.<br><br><b>Chief editor:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users.<br><br><b>Superuser:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change the category settings; template editor; snippet editor.<br><br><b>Administrator:</b><br>Edition, creation and publication of articles according to the assigned rights within each category (create - change/delete - images/files - release); change own data; view category rights of other users; create new users; change users; read logfile; change category settings; template editor; snippet editor; system settings.");
    $help["UV003"]  = array("Name",                                                 "The column \"Name\" shows the \"real name\" of the user.<br>By clicking on icon <img src=\"../_images/mail.gif\"> you can write the user an e-mail.");
    $help["UV004"]  = array("Rights",                                               "Click on \"Change\" in order to see and change, if necessary, the rights of the respective users on all categories (depending on your individual user rights).");
    $help["UV005"]  = array("Delete",                                               "In the column \"Delete\" you can directly delete the users from the system (depending on your individual user rights).<br>A warning note appears requesting you to confirm your decision.");

    // Zentrale Artikelfreigabe
    $help["ZA001"]  = array("Status",                                               "This column shows you the status of the respective article. Each of the specifications mean:<br><br><b>Waiting</b><br>\"Waiting\" indicates that the article is waiting to be released by an authorized user.<br><br><b>Blocked</b><br>\"Blocked\" indicates that the article was blocked by an authorized user.<br><br><b>Rejected</b><br>The article was rejected by an authorized user. The user who rejects the article is requested to inform the reasons of the rejection (optional). Independently of the release system is active or not, an e-mail is sent to the author of the article.");
    $help["ZA002"]  = array("Category",                                             "The column \"Category\" shows in which category the corresponding article is located.<br><br>Moreover, the status of the publication is shown.<br>The specifications mean:<br><br><b>ONLINE</b><br>The article is within the target date of publication and thus (pontencially) online, after it has been released.<br><br><b>OFFLINE</b><br>The article is not within the target date of publication (date is in the future), thus OFFLINE; even after it has been released, it is still not visible in your project-online, until the date of the publication is reached.<br><br><b>EXPIRED</b><br>The publication date of the article already expired. Once the article is released, it won't appear in the current overview of the \"Central article release\" anymore.<br>If the archive function is used for a category, this article appears inside the archive.<br><br><b>Example:</b><br><br>In your project, an article about a fair in the category \"News\" is supposed to be published between 1st-03 and 15th-03 of the current year.<br><br><b>24th-02:</b><br>The article is shown as OFFLINE-article.<br>Reason: the date of publication has not been reached yet.<br>Once the article is released, it won't appear in the current overview of the \"Central article release\" anymore. The article remains, however, OFFLINE until 01st-03. On 01st-03 its status changes to ONLINE.<br><br><b>02nd-03:</b><br>The article is shown ONLINE, since the date of publication was reached.<br>Once the article is released, it won't appear in the current overview of the \"Central article release\" anymore. The article is visible inside your online-project, thus published. Its status now ONLINE.<br><br><b>16th-03</b><br>The article is indicated as EXPIRED.<br>Reason: The date of expiry is reached or exceeded. If the archive function is activ in the category \"News\" inside your online-project (this can be done in the category settings), the article appears inside your online-archive. If it is blocked, it does not appear there.");
    $help["ZA003"]  = array("Title/Author",                                         "The column shows you titles and authors of articles to be released.<br>By clicking on the title, you get the preview of the article.<br>If the article does not have a title, the subtitle is alternatively indicated here.<br>\"n.t.\" means \"no title\": During the creation of the article neither title nor subtitle was entered.");
    $help["ZA004"]  = array("Release",                                              "By clicking on \"Release\" or \"Reject\" you modify the status of the article. You activate the following actions:<br><br><b>Release</b><br>You release the article for publication in your online-project. The article won't appear in the overview of the \"Central article release\" anymore. A separate confirmation is not nessecary.<br><br><b>Reject</b><br>You reject the article. A window opens automatically and you are requested to justify/comment the rejection.<br>If you do not want to send any comment, just close the window. The article will be rejected nevertheless, and no e-mail will be sent.");

?>
