/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.HTTPUtilities;
import com.ice.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public abstract class UserProperties {
    private static final String RCS_ID = "$Id: UserProperties.java,v 1.1.1.1 2003/03/31 22:24:33 pradeep Exp $";
    private static final String RCS_NAME = "$Name:  $";
    private static final String RCS_REV = "$Revision: 1.1.1.1 $";
    private static final String PREFIX_PROPERTY = "propertyPrefix";
    private static final String DEFAULTS_RSRC_NAME = ".com.ice.global.defaultsResource.";
    private static final String GLOBAL_RSRCLIST_NAME = ".com.ice.global.propertyResourceList";
    private static final String GLOBAL_RSRC_PREFIX = ".com.ice.global.propertyResource.";
    private static final String APP_RSRCLIST_NAME = ".com.ice.local.propertyResourceList";
    private static final String APP_RSRC_PREFIX = ".com.ice.local.propertyResource.";
    private static final String LOCAL_PROPERTY = "global.localPropertyFile";
    private static final String LOCAL_DEFAULT = "properties.txt";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String osname;
    private static String userName;
    private static String userHome;
    private static String prefix;
    private static String osSuffix;
    private static String userSuffix;
    private static String defaultsResource;
    private static String localPropertyFile;
    static /* synthetic */ Class class$com$ice$util$UserProperties;

    public static String getOSName() {
        return osname;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setDebug(boolean debug) {
        UserProperties.debug = debug;
    }

    public static void setVerbose(boolean verbose) {
        UserProperties.verbose = verbose;
    }

    public static void setLocalPropertyFile(String fileName) {
        localPropertyFile = fileName;
    }

    public static void setDefaultsResource(String rsrcName) {
        defaultsResource = rsrcName;
    }

    public static void setOSSuffix(String suffix) {
        osSuffix = suffix;
    }

    public static void setUserSuffix(String suffix) {
        userSuffix = suffix;
    }

    public static void setPropertyPrefix(String prefix) {
        UserProperties.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public static String getPropertyPrefix() {
        return prefix;
    }

    public static Font getFont(String name, Font defaultFont) {
        return Font.getFont(UserProperties.fullPropertyName(name), defaultFont);
    }

    public static Color getColor(String name, Color defaultColor) {
        return Color.getColor(UserProperties.fullPropertyName(name), defaultColor);
    }

    public static String fullPropertyName(String name) {
        return prefix + name;
    }

    private static String getOverridableProperty(String name, String defval) {
        String value = null;
        String overName = null;
        String fullName = null;
        fullName = name.startsWith(".") ? name.substring(1) : UserProperties.fullPropertyName(name);
        if (fullName.endsWith(".")) {
            fullName = fullName.substring(0, fullName.length());
            value = System.getProperty(fullName, defval);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + fullName + " = '" + value + "'");
            }
            return value;
        }
        if (osSuffix != null && userSuffix != null) {
            overName = fullName + "." + osSuffix + "." + userSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (userSuffix != null) {
            overName = fullName + "." + userSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (osSuffix != null) {
            overName = fullName + "." + osSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (value == null) {
            value = System.getProperty(fullName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + fullName + " = '" + value + "'");
            }
        }
        if (value == null) {
            value = defval;
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + name + " defaulted to '" + value + "'");
            }
        }
        return value;
    }

    public static String getProperty(String name, String defval) {
        String result = UserProperties.getOverridableProperty(name, defval);
        return result;
    }

    public static int getProperty(String name, int defval) {
        int result;
        block2: {
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public static double getProperty(String name, double defval) {
        double result;
        block2: {
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Double.valueOf(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public static boolean getProperty(String name, boolean defval) {
        boolean result = defval;
        String val = UserProperties.getProperty(name, null);
        if (val != null) {
            if (val.equalsIgnoreCase("TRUE")) {
                result = true;
            } else if (val.equalsIgnoreCase("FALSE")) {
                result = false;
            }
        }
        return result;
    }

    public static void defaultProperties(Properties props) {
        props.put("com.ice.util.UserProperties.revision", RCS_REV);
        props.put("copyright", "Copyright (c) by Tim Endres");
    }

    public static void addDefaultProperties(Properties props, Properties defaultProps) {
        Enumeration<Object> enumeration = defaultProps.keys();
        while (enumeration.hasMoreElements()) {
            String key = null;
            try {
                key = (String)enumeration.nextElement();
            }
            catch (NoSuchElementException ex) {
                key = null;
            }
            if (key == null) continue;
            String value = (String)defaultProps.get(key);
            if (value == null) {
                System.err.println("UserProperties.addDefaultProperties: key '" + key + "' has null value!");
                continue;
            }
            props.put(key, value);
        }
    }

    private static boolean loadPropertiesStream(InputStream in, Properties props) throws IOException {
        props.load(in);
        return true;
    }

    private static boolean loadPropertiesFile(String path, Properties props) {
        FileInputStream in;
        boolean result = true;
        try {
            in = new FileInputStream(path);
        }
        catch (IOException ex) {
            System.err.println("ERROR opening property file '" + path + "' - " + ex.getMessage());
            result = false;
            in = null;
        }
        if (result) {
            try {
                UserProperties.loadPropertiesStream(in, props);
            }
            catch (IOException ex) {
                System.err.println("ERROR loading property file '" + path + "' - " + ex.getMessage());
                result = false;
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                System.err.println("ERROR closing property file '" + path + "' - " + ex.getMessage());
                result = false;
            }
        }
        if (result) {
            System.err.println("Loaded property file '" + path + "'.");
        }
        return result;
    }

    private static InputStream openNamedResource(String name) throws IOException {
        InputStream in = null;
        boolean result = false;
        boolean httpURL = true;
        URL propsURL = null;
        try {
            propsURL = new URL(name);
        }
        catch (MalformedURLException ex) {
            httpURL = false;
            propsURL = null;
        }
        if (propsURL == null) {
            propsURL = (class$com$ice$util$UserProperties == null ? (class$com$ice$util$UserProperties = UserProperties.class$("com.ice.util.UserProperties")) : class$com$ice$util$UserProperties).getResource(name);
        }
        if (propsURL != null) {
            String code;
            String hdrVal;
            URLConnection urlConn = propsURL.openConnection();
            if (httpURL && (hdrVal = urlConn.getHeaderField(0)) != null && (code = HTTPUtilities.getResultCode(hdrVal)) != null && !code.equals("200")) {
                throw new IOException("status code = " + code);
            }
            in = urlConn.getInputStream();
        }
        return in;
    }

    private static boolean loadPropertiesResource(String name, Properties props) {
        boolean result = false;
        try {
            InputStream in = UserProperties.openNamedResource(name);
            if (in != null) {
                UserProperties.loadPropertiesStream(in, props);
                in.close();
                result = true;
            }
        }
        catch (IOException ex) {
            System.err.println("ERROR loading properties resource '" + name + "' - " + ex.getMessage());
        }
        return result;
    }

    private static void loadPropertyResourceList(String listPropName, String rsrcPrefix, Properties props) {
        String rsrcListStr = UserProperties.getProperty(listPropName, null);
        if (rsrcListStr != null) {
            String[] rsrcList = StringUtilities.splitString(rsrcListStr, ":");
            int rIdx = 0;
            while (rsrcList != null && rIdx < rsrcList.length) {
                boolean result;
                String rsrcTag = rsrcPrefix + rsrcList[rIdx];
                String rsrcName = UserProperties.getProperty(rsrcTag, null);
                if (rsrcName != null && !(result = UserProperties.loadPropertiesResource(rsrcName, props))) {
                    System.err.println("ERROR loading property resource '" + rsrcName + "'");
                }
                ++rIdx;
            }
        }
    }

    public static void loadProperties(String packageName, Properties appProps) {
        File propFile;
        String newPrefix;
        boolean result;
        Properties sysProps;
        if (debug) {
            UserProperties.printContext(System.err);
        }
        if ((sysProps = System.getProperties()) == null) {
            return;
        }
        UserProperties.defaultProperties(sysProps);
        String rsrcName = defaultsResource;
        if (rsrcName == null) {
            rsrcName = UserProperties.getProperty(DEFAULTS_RSRC_NAME, null);
        }
        if (rsrcName != null) {
            result = UserProperties.loadPropertiesResource(rsrcName, sysProps);
            System.err.println("Loaded " + (result ? "the " : "no ") + "default properties.");
        }
        if (appProps != null) {
            UserProperties.addDefaultProperties(sysProps, appProps);
        }
        if ((newPrefix = prefix) == null) {
            UserProperties.getProperty(packageName + "." + PREFIX_PROPERTY, null);
            if (newPrefix != null) {
                UserProperties.setPropertyPrefix(newPrefix);
                if (verbose) {
                    System.err.println("Property prefix set to '" + newPrefix + "'");
                }
            }
        }
        UserProperties.loadPropertyResourceList(GLOBAL_RSRCLIST_NAME, GLOBAL_RSRC_PREFIX, sysProps);
        String propPath = localPropertyFile;
        if (propPath == null) {
            propPath = UserProperties.getProperty(LOCAL_PROPERTY, LOCAL_DEFAULT);
        }
        if (propPath != null && (propFile = new File(propPath)).exists() && !(result = UserProperties.loadPropertiesFile(propPath, sysProps))) {
            System.err.println("ERROR loading local property file '" + propPath + "'");
        }
        UserProperties.loadPropertyResourceList(APP_RSRCLIST_NAME, APP_RSRC_PREFIX, sysProps);
    }

    public static void printContext(PrintStream out) {
        out.println("os.name    = '" + osname + "'");
        out.println("user.name  = '" + userName + "'");
        out.println("user.home  = '" + userHome + "'");
        out.println("");
        out.println("prefix     = '" + prefix + "'");
        out.println("osSuffix   = '" + osSuffix + "'");
        out.println("userSuffix = '" + userSuffix + "'");
        out.println("");
    }

    public static void printUsage(PrintStream out) {
        out.println("Properties options:");
        out.println("   -propDebug             -- turns on debugging of property loading");
        out.println("   -propVerbose           -- turns on verbose messages during loading");
        out.println("   -propDefaults rsrcName -- sets default properties resource name");
        out.println("   -propFile path         -- sets application property file path");
        out.println("   -propOS suffix         -- sets the os suffix");
        out.println("   -propUser suffix       -- sets the user suffix");
        out.println("   -propPrefix prefix     -- sets application property prefix");
    }

    public static String[] processOptions(String[] args) {
        Vector<String> newArgs = new Vector<String>(args.length);
        int iArg = 0;
        while (iArg < args.length) {
            if (args[iArg].equals("-propPrefix") && iArg + 1 < args.length) {
                UserProperties.setPropertyPrefix(args[++iArg]);
            } else if (args[iArg].equals("-propFile") && iArg + 1 < args.length) {
                UserProperties.setLocalPropertyFile(args[++iArg]);
            } else if (args[iArg].equals("-propDefaults") && iArg + 1 < args.length) {
                UserProperties.setDefaultsResource(args[++iArg]);
            } else if (args[iArg].equals("-propDebug")) {
                UserProperties.setDebug(true);
            } else if (args[iArg].equals("-propVerbose")) {
                UserProperties.setVerbose(true);
            } else if (args[iArg].equals("-propOS") && iArg + 1 < args.length) {
                UserProperties.setOSSuffix(args[++iArg]);
            } else if (args[iArg].equals("-propUser") && iArg + 1 < args.length) {
                UserProperties.setUserSuffix(args[++iArg]);
            } else {
                newArgs.addElement(args[iArg]);
            }
            ++iArg;
        }
        String[] result = new String[newArgs.size()];
        int i = 0;
        while (i < newArgs.size()) {
            result[i] = (String)newArgs.elementAt(i);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        prefix = null;
        defaultsResource = null;
        localPropertyFile = null;
        osname = System.getProperty("os.name");
        userName = System.getProperty("user.name");
        userHome = System.getProperty("user.home");
        osSuffix = osname.replace(' ', '_');
        userSuffix = userName.replace(' ', '_');
    }
}

