/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LicenseStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Setup;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ImagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Panel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class LicensePanel
extends Panel
implements LicenseStep {
    JTextArea taLicense_;
    JRadioButton rdYes_;
    JRadioButton rdNo_;
    Setup setup_;

    public LicensePanel() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel pnMain = new JPanel();
        pnMain.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        pnMain.setLayout(new BorderLayout());
        JLabel lbTitle = new JLabel(Globals.i18n("UI_License"));
        lbTitle.setFont(lbTitle.getFont().deriveFont(1, 20.0f));
        lbTitle.setOpaque(true);
        lbTitle.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 0, 5, 0))));
        lbTitle.setBackground(pnMain.getBackground().darker());
        lbTitle.setForeground(Color.white);
        JPanel centerPanel = new JPanel();
        JTextArea label = new JTextArea(Globals.i18n("UI_LicenseLabel"));
        label.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBackground(pnMain.getBackground());
        centerPanel.setLayout(new BorderLayout());
        this.taLicense_ = new JTextArea();
        this.taLicense_.setEditable(false);
        this.taLicense_.setFont(new Font("Monospaced", 0, 11));
        JScrollPane spLicense = new JScrollPane(this.taLicense_);
        centerPanel.add("North", label);
        centerPanel.add("Center", spLicense);
        JPanel pnChoice = new JPanel();
        pnChoice.setLayout(new BorderLayout());
        JLabel message = new JLabel(Globals.i18n("UI_WantAcceptLicense"));
        pnChoice.add("North", message);
        JPanel pnRadios = new JPanel();
        this.rdYes_ = new JRadioButton(Globals.i18n("Common_Yes"));
        this.rdYes_.setSelected(false);
        this.rdYes_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensePanel.this.radioButtonPressed(true);
            }
        });
        this.rdNo_ = new JRadioButton(Globals.i18n("Common_No"));
        this.rdNo_.setSelected(true);
        this.rdNo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicensePanel.this.radioButtonPressed(false);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rdYes_);
        bg.add(this.rdNo_);
        pnRadios.add(this.rdYes_);
        pnRadios.add(this.rdNo_);
        pnChoice.add("South", pnRadios);
        pnMain.add("North", lbTitle);
        pnMain.add("Center", centerPanel);
        pnMain.add("South", pnChoice);
        ImagePanel pnImage = ImagePanel.IMAGE_PANEL;
        this.add(pnImage);
        this.add(pnMain);
    }

    public void setText(InputStream lic) {
        String text = "";
        if (lic == null) {
            text = text + Globals.i18n("UI_NoLicense");
        } else {
            try {
                LineNumberReader in = new LineNumberReader(new InputStreamReader(lic));
                String line = in.readLine();
                while (line != null) {
                    text = text + line + "\n";
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException e) {
                text = text + e.getMessage();
            }
        }
        this.taLicense_.setText(text);
        this.taLicense_.setCaretPosition(0);
    }

    public boolean isLicenseAccepted() {
        return this.rdYes_.isSelected();
    }

    private void radioButtonPressed(boolean isYes) {
        if (isYes) {
            if (this.setup_ != null) {
                this.setup_.setActionEnabled(7);
            }
        } else if (this.setup_ != null) {
            this.setup_.setActionEnabled(3);
        }
    }

    public void setSetUp(Setup setup) {
        this.setup_ = setup;
        this.radioButtonPressed(false);
    }
}

