/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.InstallStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ImagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Panel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class InstallPanel
extends Panel
implements InstallStep {
    JLabel lbDetails_;
    JLabel lbStatus_;
    JProgressBar pbProgress_;

    public InstallPanel() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel pnMain = new JPanel();
        pnMain.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        pnMain.setLayout(new BoxLayout(pnMain, 1));
        JPanel pnHaut = new JPanel();
        pnHaut.setLayout(new BorderLayout());
        JLabel lbTitle = new JLabel(Globals.OPERATION == 1 ? Globals.i18n("UI_Installation") : (Globals.OPERATION == 3 ? Globals.i18n("UI_Update") : (Globals.OPERATION == 2 ? Globals.i18n("UI_Uninstallation") : Globals.i18n("UI_UnknownOperation"))));
        lbTitle.setFont(lbTitle.getFont().deriveFont(1, 20.0f));
        lbTitle.setOpaque(true);
        lbTitle.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 0, 5, 0))));
        lbTitle.setBackground(pnMain.getBackground().darker());
        lbTitle.setForeground(Color.white);
        pnHaut.add("North", lbTitle);
        this.lbDetails_ = new JLabel();
        this.lbDetails_.setText(Globals.OPERATION == 2 ? Globals.i18n("UI_UnInstallClickNextToStart") : Globals.i18n("UI_InstallClickNextToStart"));
        this.lbDetails_.setOpaque(true);
        pnHaut.add("South", this.lbDetails_);
        JPanel pnBas = new JPanel();
        pnBas.setLayout(new BorderLayout());
        this.pbProgress_ = new JProgressBar();
        pnBas.add("North", this.pbProgress_);
        this.lbStatus_ = new JLabel();
        this.lbStatus_.setText(Globals.i18n("UI_ReadyToStart"));
        this.lbStatus_.setOpaque(true);
        this.lbStatus_.setBackground(pnMain.getBackground().brighter());
        pnBas.add("South", this.lbStatus_);
        pnMain.add(pnHaut);
        pnMain.add(pnBas);
        ImagePanel pnImage = ImagePanel.IMAGE_PANEL;
        this.add(pnImage);
        this.add(pnMain);
    }

    public void details(String msg) {
        int index = msg.lastIndexOf(System.getProperty("file.separator"));
        if (index > -1) {
            msg = msg.substring(index + 1);
        }
        this.lbDetails_.setText(Globals.OPERATION == 2 ? msg : "Copying " + msg);
        RepaintManager.currentManager(this.lbDetails_).paintDirtyRegions();
    }

    public void status(String msg) {
        this.lbStatus_.setText(msg);
        RepaintManager.currentManager(this.lbStatus_).paintDirtyRegions();
    }

    public void setProgression(int n) {
        this.pbProgress_.setValue(n);
        RepaintManager.currentManager(this.pbProgress_).paintDirtyRegions();
        if (n >= 100) {
            this.details(Globals.i18n("UI_DecompressionFinished"));
        }
    }

    public int getProgression() {
        return this.pbProgress_.getValue();
    }
}

