/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;

public class ImagePanel
extends JLabel {
    public static final ImagePanel IMAGE_PANEL = new ImagePanel();

    public ImagePanel() {
        Dimension d = new Dimension(150, 400);
        this.setBackground(Color.white);
        this.setBorder(new EtchedBorder());
        InputStream imgStream = Globals.BASE_CLASS.getResourceAsStream("/" + Globals.IMAGE);
        if (imgStream == null) {
            this.setPreferredSize(d);
        } else {
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            try {
                byte[] buf = new byte[1024];
                int read = imgStream.read(buf, 0, buf.length);
                while (read > 0) {
                    dataStream.write(buf, 0, read);
                    read = imgStream.read(buf, 0, buf.length);
                }
                imgStream.close();
                ImageIcon image = new ImageIcon(dataStream.toByteArray());
                dataStream.close();
                Insets i = this.getInsets();
                image.setImage(image.getImage().getScaledInstance(d.width - i.left - i.right, d.height - i.top - i.bottom, 4));
                this.setIcon(image);
                this.setPreferredSize(d);
                this.setMaximumSize(d);
            }
            catch (IOException ex) {
                this.setPreferredSize(d);
            }
        }
    }
}

