/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Step;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.BlueScreen;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ComponentsPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.DirectoryPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.EndPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.InstallPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.JvmPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.LanguagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.LicenseKeyPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.LicensePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ReadmePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ShortcutPanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.UpgradePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.WelcomePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Wizard;
import java.io.IOException;
import javax.swing.JOptionPane;

public class GraphicUI
extends StepFactory {
    BlueScreen blueScreen_;

    public void initUI() {
        this.setWizard(Wizard.createWizard());
        if (!Globals.UI_BLUESCREEN) {
            Globals.printDebug("no blue screen");
        } else {
            this.blueScreen_ = new BlueScreen();
            this.blueScreen_.show();
        }
    }

    public void activateUI() {
        if (Globals.UI_BLUESCREEN) {
            ((Wizard)this.getWizard()).setLocationRelativeTo(this.blueScreen_);
        }
        super.activateUI();
    }

    public void quitUI() {
        super.quitUI();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (Globals.UI_BLUESCREEN) {
            this.blueScreen_.dispose();
        }
    }

    public void showFatalError(Throwable t) {
        if (t instanceof IOException) {
            JOptionPane.showMessageDialog(this.blueScreen_, "Unexpected Error\nPlease try to reinstall again.", Globals.i18n("UI_Error"), 0);
        } else {
            JOptionPane.showMessageDialog(this.blueScreen_, "" + t, Globals.i18n("UI_Error"), 0);
        }
        super.showFatalError(t);
    }

    public void showError(Throwable t) {
        JOptionPane.showMessageDialog(this.blueScreen_, "" + t.getMessage(), Globals.i18n("UI_Message"), 2);
        super.showError(t);
    }

    public void uiSleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {}
    }

    public Step createSetupLanguageStep() {
        LanguagePanel pn = new LanguagePanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createWelcomeStep() {
        if (this.blueScreen_ != null) {
            this.blueScreen_.repaint();
        }
        WelcomePanel pn = new WelcomePanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createLicenseStep() {
        LicensePanel pn = new LicensePanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createReadmeStep() {
        ReadmePanel pn = new ReadmePanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createLicenseKeyStep() {
        LicenseKeyPanel pn = new LicenseKeyPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createUpgradeStep() {
        UpgradePanel pn = new UpgradePanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createComponentStep() {
        ComponentsPanel pn = new ComponentsPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createDirectoryStep() {
        DirectoryPanel pn = new DirectoryPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createJVMStep() {
        JvmPanel pn = new JvmPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createInstallStep() {
        InstallPanel pn = new InstallPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createShortcutStep() {
        ShortcutPanel pn = new ShortcutPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }

    public Step createEndStep() {
        EndPanel pn = new EndPanel();
        pn.setInstaller(this.getInstaller());
        this.getWizard().setStep(pn);
        return pn;
    }
}

