/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;
import org.jdom.Verifier;

public class Element
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.96 $ $Date: 2001/07/03 17:55:34 $ $Name: jdom_1_0_b7_rc4 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    protected Object parent;
    protected List attributes;
    protected List content;

    protected Element() {
    }

    public Element(String name) {
        this(name, (Namespace)null);
    }

    public Element(String name, String uri) {
        this(name, Namespace.getNamespace("", uri));
    }

    public Element(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace(prefix, uri));
    }

    public Element(String name, Namespace namespace) {
        this.setName(name);
        this.setNamespace(namespace);
    }

    public Element addAttribute(String name, String value) {
        return this.addAttribute(new Attribute(name, value));
    }

    public Element addAttribute(Attribute attribute) {
        if (this.getAttribute(attribute.getName(), attribute.getNamespace()) != null) {
            throw new IllegalAddException(this, attribute, "Duplicate attributes are not allowed");
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException(this, attribute, "The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        this.attributes.add(attribute);
        attribute.setParent(this);
        return this;
    }

    public Element addContent(String text) {
        Object ob;
        int size;
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        if ((size = this.content.size()) > 0 && (ob = this.content.get(size - 1)) instanceof String) {
            text = String.valueOf((String)ob) + text;
            this.content.remove(size - 1);
        }
        this.content.add(text);
        return this;
    }

    public Element addContent(CDATA cdata) {
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        this.content.add(cdata);
        return this;
    }

    public Element addContent(Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        this.content.add(comment);
        comment.setParent(this);
        return this;
    }

    public Element addContent(Element element) {
        if (element.isRootElement()) {
            throw new IllegalAddException(this, element, "The element already has an existing parent (the document root)");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException(this, element, "The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (element == this) {
            throw new IllegalAddException(this, element, "The element cannot be added to itself");
        }
        if (this.isAncestor(element)) {
            throw new IllegalAddException(this, element, "The element cannot be added as a descendent of itself");
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        element.setParent(this);
        this.content.add(element);
        return this;
    }

    public Element addContent(EntityRef entity) {
        if (entity.getParent() != null) {
            throw new IllegalAddException(this, entity, "The entity reference already has an existing parent \"" + entity.getParent().getQualifiedName() + "\"");
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        this.content.add(entity);
        entity.setParent(this);
        return this;
    }

    public Element addContent(ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        this.content.add(pi);
        pi.setParent(this);
        return this;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        Namespace ns;
        Iterator itr;
        String prefix = additionalNamespace.getPrefix();
        String uri = additionalNamespace.getURI();
        if (prefix.equals(this.getNamespacePrefix()) && !uri.equals(this.getNamespaceURI())) {
            throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides " + "with the element namespace prefix");
        }
        if (this.additionalNamespaces != null && this.additionalNamespaces.size() > 0) {
            itr = this.additionalNamespaces.iterator();
            while (itr.hasNext()) {
                ns = (Namespace)itr.next();
                if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides with an additional namespace declared " + "by the element");
            }
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            itr = this.attributes.iterator();
            while (itr.hasNext()) {
                ns = ((Attribute)itr.next()).getNamespace();
                if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides with an attribute namespace on " + "the element");
            }
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    public Object clone() {
        Iterator i;
        Element element = null;
        try {
            element = (Element)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        element.parent = null;
        element.content = this.content == null ? null : new ArrayList(5);
        List list = element.attributes = this.attributes == null ? null : new ArrayList(5);
        if (this.attributes != null) {
            i = this.attributes.iterator();
            while (i.hasNext()) {
                Attribute a = (Attribute)((Attribute)i.next()).clone();
                a.setParent(element);
                element.attributes.add(a);
            }
        }
        if (this.content != null) {
            i = this.content.iterator();
            while (i.hasNext()) {
                Cloneable e;
                Object obj = i.next();
                if (obj instanceof String) {
                    element.content.add(obj);
                    continue;
                }
                if (obj instanceof Element) {
                    e = (Element)((Element)obj).clone();
                    ((Element)e).setParent(element);
                    element.content.add(e);
                    continue;
                }
                if (obj instanceof Comment) {
                    Comment c = (Comment)((Comment)obj).clone();
                    c.setParent(element);
                    element.content.add(c);
                    continue;
                }
                if (obj instanceof CDATA) {
                    element.content.add(obj);
                    continue;
                }
                if (obj instanceof ProcessingInstruction) {
                    ProcessingInstruction p = (ProcessingInstruction)((ProcessingInstruction)obj).clone();
                    element.content.add(p);
                    continue;
                }
                if (!(obj instanceof EntityRef)) continue;
                e = (EntityRef)((EntityRef)obj).clone();
                ((EntityRef)e).setParent(element);
                element.content.add(e);
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    public Element detach() {
        if (this.parent instanceof Element) {
            ((Element)this.parent).removeContent(this);
        } else if (this.parent instanceof Document) {
            ((Document)this.parent).setRootElement(new Element("root-element-was-detached"));
        }
        return this;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String name, Namespace ns) {
        Attribute attrib = this.getAttribute(name, ns);
        if (attrib == null) {
            return null;
        }
        return attrib.getValue();
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        PartialList atts = new PartialList(this.attributes, this);
        atts.addAllPartial(this.attributes);
        return atts;
    }

    public Element getChild(String name) {
        return this.getChild(name, Namespace.NO_NAMESPACE);
    }

    public Element getChild(String name, Namespace ns) {
        if (this.content == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public String getChildText(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildText(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextTrim(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public List getChildren() {
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        PartialList elements = new PartialList(this.content, this);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Element)) continue;
            elements.addPartial(obj);
        }
        return elements;
    }

    public List getChildren(String name) {
        return this.getChildren(name, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String name, Namespace ns) {
        PartialList children = new PartialList(this.getChildren(), this);
        if (this.content != null) {
            String uri = ns.getURI();
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Element element;
                Object obj = i.next();
                if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
                children.addPartial(element);
            }
        }
        return children;
    }

    public List getContent() {
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        PartialList result = new PartialList(this.content, this);
        result.addAllPartial(this.content);
        return result;
    }

    public Element getCopy(String name) {
        return this.getCopy(name, Namespace.NO_NAMESPACE);
    }

    public Element getCopy(String name, Namespace ns) {
        Element clone = (Element)this.clone();
        clone.namespace = ns;
        clone.name = name;
        return clone;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public List getMixedContent() {
        return this.getContent();
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Namespace getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        List addl = this.getAdditionalNamespaces();
        if (addl.size() > 0) {
            Iterator itr = addl.iterator();
            while (itr.hasNext()) {
                Namespace ns = (Namespace)itr.next();
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(prefix);
        }
        return null;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Element getParent() {
        if (this.parent instanceof Element) {
            return (Element)this.parent;
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Element.getSerializedForm() is not yet implemented");
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1 || this.content.get(0) == null) {
            return "";
        }
        if (this.content.size() == 1 && this.content.get(0) instanceof String) {
            return (String)this.content.get(0);
        }
        StringBuffer textContent = new StringBuffer();
        boolean hasText = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof String) {
                textContent.append((String)obj);
                hasText = true;
                continue;
            }
            if (!(obj instanceof CDATA)) continue;
            textContent.append(((CDATA)obj).getText());
            hasText = true;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextNormalize() {
        return Element.normalizeString(this.getText());
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public boolean hasChildren() {
        if (this.content == null || this.content.size() == 0) {
            return false;
        }
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMixedContent() {
        if (this.content == null) {
            return false;
        }
        Class<?> prevClass = null;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Class<?> newClass = obj.getClass();
            if (newClass == prevClass) continue;
            if (prevClass != null) {
                return true;
            }
            prevClass = newClass;
        }
        return false;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private boolean isAncestor(Element e) {
        Object p = this.parent;
        while (p instanceof Element) {
            if (p == e) {
                return true;
            }
            p = ((Element)p).getParent();
        }
        return false;
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    private static String normalizeString(String value) {
        char[] c = value.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        int i = 0;
        while (i < c.length) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (!white) {
                    n[pos++] = 32;
                    white = true;
                }
            } else {
                n[pos++] = c[i];
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)in.readObject(), (String)in.readObject());
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String name, String uri) {
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            i.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            i.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeChild(String name) {
        return this.removeChild(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren() {
        boolean deletedSome = false;
        if (this.content != null) {
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof Element)) continue;
                Element element = (Element)obj;
                i.remove();
                element.setParent(null);
                deletedSome = true;
            }
        }
        return deletedSome;
    }

    public boolean removeChildren(String name) {
        return this.removeChildren(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        boolean deletedSome = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            deletedSome = true;
        }
        return deletedSome;
    }

    public boolean removeContent(CDATA cdata) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove(cdata);
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(comment)) {
            comment.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Element element) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(element)) {
            element.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(EntityRef entity) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(entity)) {
            entity.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(ProcessingInstruction pi) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(pi)) {
            pi.setParent(null);
            return true;
        }
        return false;
    }

    public void removeNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(additionalNamespace);
    }

    public Element setAttribute(String name, String value) {
        return this.setAttribute(new Attribute(name, value));
    }

    public Element setAttribute(String name, String value, Namespace ns) {
        return this.setAttribute(new Attribute(name, value, ns));
    }

    public Element setAttribute(Attribute attribute) {
        Iterator itr;
        if (attribute.getParent() != null) {
            throw new IllegalAddException(this, attribute, "The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        boolean preExisting = false;
        String prefix = attribute.getNamespace().getPrefix();
        String uri = attribute.getNamespace().getURI();
        if (!prefix.equals("")) {
            if (prefix.equals(this.getNamespacePrefix()) && !uri.equals(this.getNamespaceURI())) {
                throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with the element namespace prefix");
            }
            if (this.additionalNamespaces != null && this.additionalNamespaces.size() > 0) {
                itr = this.additionalNamespaces.iterator();
                while (itr.hasNext()) {
                    Namespace ns = (Namespace)itr.next();
                    if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                    throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with a namespace declared by the element");
                }
            }
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            itr = this.attributes.iterator();
            while (itr.hasNext()) {
                Attribute att = (Attribute)itr.next();
                Namespace ns = att.getNamespace();
                if (attribute.getName().equals(att.getName()) && ns.getURI().equals(att.getNamespaceURI())) {
                    preExisting = true;
                }
                if (prefix.equals("") || !prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with another attribute namespace on " + "the element");
            }
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        } else if (preExisting) {
            this.removeAttribute(attribute.getName(), attribute.getNamespace());
        }
        this.attributes.add(attribute);
        attribute.setParent(this);
        return this;
    }

    public Element setAttributes(List attributes) {
        this.attributes = attributes;
        return this;
    }

    public Element setChildren(List children) {
        return this.setContent(children);
    }

    /*
     * Unable to fully structure code
     */
    public Element setContent(List newContent) {
        block31: {
            block32: {
                if (newContent == null) {
                    this.content = new ArrayList<E>(5);
                    return this;
                }
                oldContent = this.content;
                this.content = new ArrayList<E>(5);
                ex = null;
                itemsAdded = 0;
                try {
                    try {
                        i = newContent.iterator();
                        while (i.hasNext()) {
                            obj = i.next();
                            if (obj instanceof Element) {
                                this.addContent((Element)obj);
                            } else if (obj instanceof String) {
                                this.addContent((String)obj);
                            } else if (obj instanceof Comment) {
                                this.addContent((Comment)obj);
                            } else if (obj instanceof ProcessingInstruction) {
                                this.addContent((ProcessingInstruction)obj);
                            } else if (obj instanceof CDATA) {
                                this.addContent((CDATA)obj);
                            } else if (obj instanceof EntityRef) {
                                this.addContent((EntityRef)obj);
                            } else {
                                throw new IllegalAddException("An Element may directly contain only objects of type String, Element, Comment, CDATA, EntityRef, and ProcessingInstruction: " + (obj == null ? "null" : obj.getClass().getName()) + " is not allowed");
                            }
                            ++itemsAdded;
                        }
                    }
                    catch (RuntimeException e) {
                        ex = e;
                    }
                    var6_10 = null;
                    if (ex == null) break block31;
                    this.content = oldContent;
                    i = newContent.iterator();
                    ** while (itemsAdded-- > 0)
                }
                catch (Throwable var5_12) {
                    var6_11 = null;
                    if (ex == null) break block32;
                    this.content = oldContent;
                    i = newContent.iterator();
                    ** while (itemsAdded-- > 0)
                }
lbl-1000:
                // 1 sources

                {
                    obj = i.next();
                    if (obj instanceof Element) {
                        ((Element)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof Comment) {
                        ((Comment)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof ProcessingInstruction) {
                        ((ProcessingInstruction)obj).setParent(null);
                        continue;
                    }
                    if (!(obj instanceof EntityRef)) continue;
                    ((EntityRef)obj).setParent(null);
                    continue;
                }
lbl66:
                // 1 sources

                throw ex;
lbl-1000:
                // 1 sources

                {
                    obj = i.next();
                    if (obj instanceof Element) {
                        ((Element)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof Comment) {
                        ((Comment)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof ProcessingInstruction) {
                        ((ProcessingInstruction)obj).setParent(null);
                        continue;
                    }
                    if (!(obj instanceof EntityRef)) continue;
                    ((EntityRef)obj).setParent(null);
                    continue;
                }
lbl91:
                // 1 sources

                throw ex;
            }
            throw var5_12;
        }
        if (oldContent == null) {
            return this;
        }
        itr = oldContent.iterator();
        while (itr.hasNext()) {
            obj = itr.next();
            if (obj instanceof Element) {
                ((Element)obj).setParent(null);
                continue;
            }
            if (obj instanceof Comment) {
                ((Comment)obj).setParent(null);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ((ProcessingInstruction)obj).setParent(null);
                continue;
            }
            if (!(obj instanceof EntityRef)) continue;
            ((EntityRef)obj).setParent(null);
        }
        return this;
    }

    protected Element setDocument(Document document) {
        this.parent = document;
        return this;
    }

    public Element setMixedContent(List mixedContent) {
        return this.setContent(mixedContent);
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    protected Element setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Element setText(String text) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.content = new ArrayList(5);
        }
        if (text != null) {
            this.content.add(text);
        }
        return this;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!nsuri.equals("")) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.namespace.getPrefix());
        out.writeObject(this.namespace.getURI());
    }
}

