/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.ResultSet;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.examples.lib.timerbean.Timer;
import org.netbeans.examples.lib.timerbean.TimerListener;

public class TableBrowser
extends JFrame {
    String conHost;
    String conUser;
    String conPassword;
    String conDatabase = "";
    String conDBType;
    DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;
    JTree trvTable;
    boolean blnStartup = false;
    public Frame Parent = null;
    private JPanel jPanel1;
    private JLabel lblIcon;
    private JLabel lblWait;
    private JProgressBar prbTables;
    private Timer tmrShowTab;

    public TableBrowser() {
        this.initComponents();
    }

    public void setparams(String IconHost, String IconUser, String IconPassword, String IconDatabase, String IconDBType) {
        this.conHost = IconHost;
        this.conUser = IconUser;
        this.conPassword = IconPassword;
        this.conDatabase = IconDatabase;
        this.conDBType = IconDBType;
    }

    private void initComponents() {
        this.tmrShowTab = new Timer();
        this.jPanel1 = new JPanel();
        this.prbTables = new JProgressBar();
        this.lblWait = new JLabel();
        this.lblIcon = new JLabel();
        this.tmrShowTab.setOnceOnly(true);
        this.tmrShowTab.addTimerListener(new TimerListener(){

            public void onTime(ActionEvent evt) {
                TableBrowser.this.tmrShowTab(evt);
            }
        });
        this.setTitle("DBTool Table Browser");
        this.setBackground(new Color(255, 255, 255));
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                TableBrowser.this.WindowActivate(evt);
            }

            public void windowClosing(WindowEvent evt) {
                TableBrowser.this.exitForm(evt);
            }

            public void windowOpened(WindowEvent evt) {
                TableBrowser.this.WindowOpen(evt);
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(new EtchedBorder());
        this.prbTables.setBackground(new Color(255, 255, 255));
        this.prbTables.setFont(new Font("Dialog", 1, 10));
        this.prbTables.setForeground(new Color(51, 0, 255));
        this.prbTables.setRequestFocusEnabled(false);
        this.prbTables.setStringPainted(true);
        this.jPanel1.add(this.prbTables);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.lblWait.setBackground(new Color(255, 255, 255));
        this.lblWait.setFont(new Font("Dialog", 0, 10));
        this.lblWait.setForeground(new Color(51, 0, 255));
        this.lblWait.setHorizontalAlignment(0);
        this.lblWait.setText("Collecting data. Please wait ...");
        this.getContentPane().add((Component)this.lblWait, "North");
        this.lblIcon.setBackground(new Color(255, 255, 255));
        this.lblIcon.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.lblIcon, "Center");
        this.pack();
    }

    private void tmrShowTab(ActionEvent evt) {
        this.root = new DefaultMutableTreeNode(this.conDatabase);
        this.treeModel = new DefaultTreeModel(this.root);
        this.doShowTables();
        this.trvTable = new JTree(this.treeModel);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.trvTable.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        Container cp = this.getContentPane();
        this.trvTable.setFont(new Font("Default", 1, 12));
        cp.add((Component)new JScrollPane(this.trvTable), "Center");
        this.blnStartup = false;
        this.jPanel1.setVisible(false);
        this.lblWait.setVisible(false);
        this.lblIcon.setVisible(false);
        this.show();
    }

    private void WindowActivate(WindowEvent evt) {
    }

    private void WindowOpen(WindowEvent evt) {
        URL url = this.getClass().getResource("main.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        this.setIconImage(image);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int Parentx = this.Parent.getBounds().getLocation().x;
        int Parenty = this.Parent.getBounds().getLocation().y;
        int ParentWidth = this.Parent.getWidth();
        int ParentHeight = this.Parent.getHeight();
        if (Parentx >= screenSize.width * 1 / 6) {
            this.setSize(screenSize.width * 1 / 6, ParentHeight);
            this.setLocation(Parentx - screenSize.width * 1 / 6, Parenty);
        } else {
            this.setSize(screenSize.width * 2 / 5, screenSize.height * 2 / 3);
            this.setLocation((screenSize.width - screenSize.width * 2 / 5) / 2, (screenSize.height - screenSize.height * 2 / 3) / 2);
        }
        this.show();
        this.blnStartup = true;
        this.setTitle("DBTool table browser on " + this.conHost + "     User : " + this.conUser);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/logogross.gif")));
        this.tmrShowTab.start();
        this.show();
    }

    private void doShowTables() {
        try {
            int nRowCount = 0;
            int nPercent = 0;
            String szShowPercent = "0%";
            ThoJaDBConnect tdbconn = new ThoJaDBConnect();
            tdbconn.SetDatabase(this.conDBType, this.conUser, this.conPassword, this.conHost, this.conDatabase);
            tdbconn.Connect();
            ResultSet rset1 = tdbconn.ListTables();
            if (rset1 != null) {
                rset1.first();
                nRowCount = 0;
                do {
                    ++nRowCount;
                } while (rset1.next());
                this.prbTables.setMaximum(nRowCount);
                try {
                    rset1.first();
                    do {
                        DefaultMutableTreeNode child = new DefaultMutableTreeNode(rset1.getString(1));
                        this.treeModel.insertNodeInto(child, this.root, this.root.getChildCount());
                        this.prbTables.setValue(this.prbTables.getValue() + 1);
                        nPercent = 100 * this.prbTables.getValue() / nRowCount;
                        szShowPercent = String.valueOf(nPercent) + "%";
                        this.prbTables.setString(szShowPercent);
                        ResultSet rset2 = tdbconn.ListTableDesc(rset1.getString(1));
                        rset2.first();
                        do {
                            DefaultMutableTreeNode newchild = new DefaultMutableTreeNode(rset2.getString(1));
                            this.treeModel.insertNodeInto(newchild, child, child.getChildCount());
                            DefaultMutableTreeNode newchild1 = new DefaultMutableTreeNode("Type: " + rset2.getString(2));
                            this.treeModel.insertNodeInto(newchild1, newchild, newchild.getChildCount());
                            newchild1 = new DefaultMutableTreeNode("Null: " + rset2.getString(3));
                            this.treeModel.insertNodeInto(newchild1, newchild, newchild.getChildCount());
                        } while (rset2.next());
                    } while (rset1.next());
                    tdbconn.Disconnect();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exitForm(WindowEvent evt) {
        this.hide();
    }

    public static void main(String[] args) {
        new TableBrowser().show();
    }
}

