/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class HelpWindow
extends JFrame {
    JTextPane txtHelp = new JTextPane();

    public HelpWindow() throws HeadlessException {
        try {
            this.jbInit();
            URL url = this.getClass().getResource("help.gif");
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            URL urlHelp = this.getClass().getResource("help.html");
            HTMLEditorKit eKit = new HTMLEditorKit();
            this.txtHelp.setEditable(false);
            this.txtHelp.setEditorKit(eKit);
            this.txtHelp.addHyperlinkListener(new LinkListener());
            this.txtHelp.setPage(urlHelp);
            this.setIconImage(image);
            this.setSize(750, 500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.txtHelp.setEnabled(false);
        this.setTitle("DBTool Help");
        this.getContentPane().add((Component)new JScrollPane(this.txtHelp), "Center");
    }

    class LinkListener
    implements HyperlinkListener {
        LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    URL urlHelp = this.getClass().getResource(hyperlinkEvent.getDescription().toString());
                    HelpWindow.this.txtHelp.setPage(urlHelp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

