/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;
import org.apache.xerces.util.XMLChar;

public class IDDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private DatatypeValidator fBaseValidator;
    private Object fNullValue;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Hashtable fTableOfId;
    private Locale fLocale;

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
    }

    public void validate(String string, Object object) throws InvalidDatatypeValueException {
        boolean bl = XMLChar.isValidName(string);
        if (!bl) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setKeyIntoReporter("IDInvalid");
            throw invalidDatatypeValueException;
        }
        if (!this.addId(string)) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setKeyIntoReporter("IDNotUnique");
            throw invalidDatatypeValueException;
        }
    }

    public void validate() throws InvalidDatatypeValueException {
    }

    public void initialize(Object object) {
        this.fTableOfId = (Hashtable)object;
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public Object getInternalStateInformation() {
        return this.fTableOfId;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    private boolean addId(String string) {
        if (this.fTableOfId.containsKey(string)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableOfId.put(string, this.fNullValue);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        return this.fMessageProvider.formatMessage(this.fLocale, null, null);
    }
}

