/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.util.image;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.util.image.ImageLoader;
import se.bysoft.sureshot.util.image.ImageLoaderException;

public class AppletImageLoaderImpl
implements ImageLoader {
    private final Applet _applet;

    public AppletImageLoaderImpl(Applet applet) {
        this._applet = applet;
    }

    public Image load(String string) throws ImageLoaderException {
        try {
            MediaTracker mediaTracker = new MediaTracker(new JPanel());
            URL uRL = new URL(this._applet.getCodeBase(), string);
            Image image = this._applet.getImage(uRL);
            Assertion.assertion(image != null);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                Assertion.assertion(false);
            }
            if (mediaTracker.isErrorAny()) {
                String string2 = "Could not load the image. Image name: " + string + "\n" + "Trying to load url: " + uRL + "\n";
                throw new ImageLoaderException(string2);
            }
            return image;
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = "Could not load the image. Image name: " + string + "\n" + "An MalformedURLException ocurred.\n" + malformedURLException.getMessage();
            throw new ImageLoaderException(string3);
        }
    }

    public Image[] load(String[] stringArray) throws ImageLoaderException {
        Image[] imageArray = new Image[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            imageArray[n] = this.load(stringArray[n]);
            ++n;
        }
        return imageArray;
    }
}

