/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.SwingUtilities;

class ImagePool {
    public static final int THUMBHEIGHT = 300;
    static final int POOLSIZE = 48;
    static BufferedImage[] thumbs;
    static PicturesListElement[] refs;
    static int replacePTR;
    static LinkedList loading;
    static ImageReader currentReader;
    static Object mutex;

    ImagePool() {
    }

    public static void init() {
        thumbs = new BufferedImage[48];
        refs = new PicturesListElement[48];
        for (int i = 0; i < 48; ++i) {
            ImagePool.refs[i] = null;
        }
        replacePTR = 0;
        loading = new LinkedList();
        currentReader = null;
        mutex = new Object();
    }

    public static synchronized BufferedImage find(PicturesListElement picturesListElement) {
        for (int i = 0; i < 48 && refs[i] != null; ++i) {
            if (!picturesListElement.equals(refs[i])) continue;
            return thumbs[i];
        }
        return null;
    }

    public static synchronized void load(PicturesListElement picturesListElement) {
        if (!loading.contains(picturesListElement)) {
            loading.add(picturesListElement);
            new LoadThread(picturesListElement).start();
        }
    }

    static synchronized void setImage(PicturesListElement picturesListElement, BufferedImage bufferedImage) {
        loading.remove(picturesListElement);
        while (refs[replacePTR] != null && Selector.isVisible(refs[replacePTR])) {
            if (++replacePTR < 48) continue;
            replacePTR = 0;
        }
        ImagePool.refs[ImagePool.replacePTR] = picturesListElement;
        ImagePool.thumbs[ImagePool.replacePTR++] = bufferedImage;
        if (replacePTR >= 48) {
            replacePTR = 0;
        }
    }

    static class LoadThread
    extends Thread {
        PicturesListElement ref;

        LoadThread(PicturesListElement picturesListElement) {
            this.ref = picturesListElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = mutex;
            synchronized (object) {
                Iterator<ImageReader> iterator;
                ImageInputStream imageInputStream;
                try {
                    imageInputStream = ImageIO.createImageInputStream(new File(this.ref.dir + this.ref.file));
                }
                catch (IOException iOException) {
                    return;
                }
                if (imageInputStream == null) {
                    return;
                }
                if (currentReader == null) {
                    iterator = ImageIO.getImageReaders(imageInputStream);
                    if (iterator.hasNext()) {
                        currentReader = iterator.next();
                    } else {
                        return;
                    }
                }
                currentReader.setInput(imageInputStream);
                try {
                    imageInputStream.mark();
                    iterator = currentReader.read(0);
                }
                catch (Throwable throwable) {
                    try {
                        imageInputStream.reset();
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    currentReader.dispose();
                    Iterator<ImageReader> iterator2 = ImageIO.getImageReaders(imageInputStream);
                    if (!iterator2.hasNext()) {
                        currentReader = null;
                        return;
                    }
                    currentReader = iterator2.next();
                    currentReader.setInput(imageInputStream);
                    try {
                        iterator = currentReader.read(0);
                    }
                    catch (Throwable throwable2) {
                        iterator = null;
                    }
                }
                currentReader.setInput(null);
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (((BufferedImage)((Object)iterator)).getHeight() > 300) {
                    double d = 300.0 / (double)((BufferedImage)((Object)iterator)).getHeight();
                    BufferedImage bufferedImage = new BufferedImage((int)((double)((BufferedImage)((Object)iterator)).getWidth() * d), 300, ((BufferedImage)((Object)iterator)).getType());
                    AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d, 0.0, 0.0);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    affineTransformOp.filter((BufferedImage)((Object)iterator), bufferedImage);
                    iterator = bufferedImage;
                    bufferedImage = null;
                    affineTransformOp = null;
                }
                ImagePool.setImage(this.ref, (BufferedImage)((Object)iterator));
                SwingUtilities.invokeLater(new ThumbUpdate());
            }
        }

        class ThumbUpdate
        implements Runnable {
            ThumbUpdate() {
            }

            public void run() {
                LoadThread.this.ref.actual_list.repaint();
            }
        }
    }
}

