/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kgd.card.player.gui.Config;
import kgd.card.player.gui.Tools;

public final class ConfigCodec {
    private Config ivConfig = null;

    public void decode() throws Exception {
        File file;
        if (this.ivConfig == null) {
            this.ivConfig = new Config();
        }
        if (!(file = new File(String.valueOf(Tools.DIR_USER) + "Config.cfg")).exists()) {
            return;
        }
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                this.decodeConfig(string);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inflaterInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("ERROR=Unable to decode Config file");
        }
    }

    private Color decodeBackground(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = new Integer(stringTokenizer.nextToken());
        int n2 = new Integer(stringTokenizer.nextToken());
        int n3 = new Integer(stringTokenizer.nextToken());
        return new Color(n, n2, n3);
    }

    private void decodeConfig(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string2.equals("AutoEndGame")) {
            this.ivConfig.setAutoEndGame(new Boolean(string3));
        } else if (string2.equals("Sounds")) {
            this.ivConfig.setSounds(new Boolean(string3));
        } else if (string2.equals("Anims")) {
            this.ivConfig.setAnims(new Integer(string3));
        } else if (string2.equals("BackColor1")) {
            this.ivConfig.setBackColor1(this.decodeBackground(string3));
        } else if (string2.equals("BackColor2")) {
            this.ivConfig.setBackColor2(this.decodeBackground(string3));
        } else if (string2.equals("BackColorOption")) {
            this.ivConfig.setBackColorOption(new Integer(string3));
        } else if (string2.equals("BackImage")) {
            this.ivConfig.setBackImage(string3);
        } else if (string2.equals("BackImageOption")) {
            this.ivConfig.setBackImageOption(new Integer(string3));
        } else if (string2.equals("CardSet")) {
            this.ivConfig.setCardSet(string3);
        } else if (string2.equals("CardBack")) {
            this.ivConfig.setCardBack(string3);
        } else if (string2.equals("Player")) {
            this.ivConfig.setPlayer(string3);
        } else if (string2.equals("Screen")) {
            this.ivConfig.setScreen(this.decodeScreen(string3));
        } else if (string2.equals("Scale")) {
            this.ivConfig.setScale(new Integer(string3));
        } else if (string2.equals("AITime")) {
            this.ivConfig.setAITime(new Integer(string3));
        } else if (string2.equals("Browser")) {
            this.ivConfig.setBrowser(string3);
        }
    }

    private Rectangle decodeScreen(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = new Integer(stringTokenizer.nextToken());
        int n2 = new Integer(stringTokenizer.nextToken());
        int n3 = new Integer(stringTokenizer.nextToken());
        int n4 = new Integer(stringTokenizer.nextToken());
        return new Rectangle(n, n2, n3, n4);
    }

    public void encode() throws Exception {
        this.encode(this.ivConfig);
    }

    private void encode(Config config) throws Exception {
        if (config == null) {
            throw new Exception("ERROR=Unable to encode Config file");
        }
        this.ivConfig = config;
        File file = new File(String.valueOf(Tools.DIR_USER) + "Config.cfg");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(deflaterOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        String string = "AutoEndGame=" + String.valueOf(this.ivConfig.isAutoEndGame());
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Sounds=" + String.valueOf(this.ivConfig.isSounds());
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Anims=" + this.ivConfig.getAnims();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "BackColor1=" + this.ivConfig.getBackColor1().getRed() + "," + this.ivConfig.getBackColor1().getGreen() + "," + this.ivConfig.getBackColor1().getBlue();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "BackColor2=" + this.ivConfig.getBackColor2().getRed() + "," + this.ivConfig.getBackColor2().getGreen() + "," + this.ivConfig.getBackColor2().getBlue();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "BackColorOption=" + this.ivConfig.getBackColorOption();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "BackImage=" + this.ivConfig.getBackImage();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "BackImageOption=" + this.ivConfig.getBackImageOption();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "CardSet=" + this.ivConfig.getCardSet();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "CardBack=" + this.ivConfig.getCardBack();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Player=" + this.ivConfig.getPlayer();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Scale=" + this.ivConfig.getScale();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Screen=" + this.ivConfig.getScreen().x + "," + this.ivConfig.getScreen().y + "," + this.ivConfig.getScreen().width + "," + this.ivConfig.getScreen().height;
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "AITime=" + this.ivConfig.getAITime();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        string = "Browser=" + this.ivConfig.getBrowser();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.close();
        outputStreamWriter.close();
        deflaterOutputStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public Config getConfig() {
        return this.ivConfig;
    }
}

