/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import kgd.card.player.ai.AI;
import kgd.card.player.ai.State;
import kgd.card.player.bean.KBorder;
import kgd.card.player.bean.KTitle;
import kgd.card.player.data.Drag;
import kgd.card.player.data.Foundation;
import kgd.card.player.data.Game;
import kgd.card.player.data.GameListener;
import kgd.card.player.data.Pile;
import kgd.card.player.data.Widget;
import kgd.card.player.gui.Config;
import kgd.card.player.gui.DlgAbout;
import kgd.card.player.gui.DlgAutoMove;
import kgd.card.player.gui.DlgConfig;
import kgd.card.player.gui.DlgFile;
import kgd.card.player.gui.DlgMessage;
import kgd.card.player.gui.DlgName;
import kgd.card.player.gui.DlgPause;
import kgd.card.player.gui.DlgScore;
import kgd.card.player.gui.DlgShareware;
import kgd.card.player.gui.DlgStat;
import kgd.card.player.gui.FrmHelp;
import kgd.card.player.gui.GameScore;
import kgd.card.player.gui.GameUI;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.Tools;
import kgd.card.player.gui.WinSplash;
import kgd.card.player.io.ConfigCodec;
import kgd.card.player.io.GameCodec;
import kgd.card.player.io.ScoreCodec;
import kgd.card.player.io.Shareware;
import kgd.card.player.io.StatCodec;

public final class FrmMain
extends JFrame
implements GameListener {
    private static Dimension cvFrameInsetsDimension = new Dimension(6, 25);
    private final FrmHelp ivHelp = new FrmHelp();
    private JPanel ivPanToolbar;
    private JLabel ivLblToolbar;
    private JButton ivBttStart;
    private JButton ivBttRestart;
    private JButton ivBttStat;
    private JButton ivBttConfig;
    private JButton ivBttUndo;
    private JToggleButton ivBttRecord;
    private JButton ivBttUndoRecord;
    private JButton ivBttPause;
    private JButton ivBttAuto;
    private JButton ivBttEnd;
    private JButton ivBttHelp;
    private JButton ivBttAbout;
    private JButton ivBttRegister;
    private KTitle ivLblStock;
    private KTitle ivLblRedeals;
    private KTitle ivLblBonus;
    private KTitle ivLblScore;
    private KTitle ivLblMessage;
    private ConfigCodec ivConfigCodec;
    private ScoreCodec ivScoreCodec;
    private StatCodec ivStatCodec;
    private Shareware ivShareware;
    private Game ivGame = null;
    private GameUI ivGameUI = null;
    private File ivLastFile = null;
    private AI ai;
    private Rectangle ivStandardBounds = null;

    public FrmMain() {
        this.initialize();
    }

    private void activateEvents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (FrmMain.this.confirmExit()) {
                    FrmMain.this.exit();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 112: {
                        FrmMain.this.ivBttHelp.doClick();
                        break;
                    }
                    case 116: {
                        FrmMain.this.ivBttStart.doClick();
                        break;
                    }
                    case 117: {
                        FrmMain.this.ivBttRestart.doClick();
                        break;
                    }
                    case 118: {
                        FrmMain.this.ivBttPause.doClick();
                        break;
                    }
                    case 119: {
                        FrmMain.this.ivBttEnd.doClick();
                        break;
                    }
                    case 121: {
                        FrmMain.this.ivBttAbout.doClick();
                        break;
                    }
                    case 123: {
                        FrmMain.this.superSize();
                        break;
                    }
                }
            }
        });
        this.getGlassPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (FrmMain.this.ivGameUI.isPlayingVictory()) {
                    FrmMain.this.ivGameUI.setPlayingVictory(false);
                    FrmMain.this.ivLblToolbar.setVisible(false);
                    FrmMain.this.ivPanToolbar.doLayout();
                    FrmMain.this.getGlassPane().setVisible(false);
                    FrmMain.this.updateScore();
                }
            }
        });
    }

    private void activateGame() {
        this.ivGame = new Game();
        this.ivGame.setListener(this);
        Tools.setPlayingSounds(this.ivConfigCodec.getConfig().isSounds());
        Tools.setBrowser(this.ivConfigCodec.getConfig().getBrowser());
        this.ivGameUI = new GameUI(this.ivGame);
        this.ivGameUI.setAnims(this.ivConfigCodec.getConfig().getAnims());
        this.ivGameUI.setBackColor1(this.ivConfigCodec.getConfig().getBackColor1());
        this.ivGameUI.setBackColor2(this.ivConfigCodec.getConfig().getBackColor2());
        this.ivGameUI.setBackColorOption(this.ivConfigCodec.getConfig().getBackColorOption());
        this.ivGameUI.setBackImage(this.ivConfigCodec.getConfig().getBackImage());
        this.ivGameUI.setBackImageOption(this.ivConfigCodec.getConfig().getBackImageOption());
        this.ivGameUI.setCardSet(this.ivConfigCodec.getConfig().getCardSet());
        this.ivGameUI.setCardBack(this.ivConfigCodec.getConfig().getCardBack());
        this.ivGameUI.setScale(this.ivConfigCodec.getConfig().getScale());
    }

    private void checkAutoMove() {
        this.getGlassPane().setVisible(true);
        this.ivLblToolbar.setText(Tools.translate("Main-LblToolbarWiseMan"));
        this.ivLblToolbar.setPreferredSize(this.ivPanToolbar.getSize());
        this.ivLblToolbar.setVisible(true);
        this.ivPanToolbar.doLayout();
        this.ivPanToolbar.paintImmediately(0, 0, this.ivPanToolbar.getWidth(), this.ivPanToolbar.getHeight());
        List list = this.ai.searchStates(this.ivGame, this.ivConfigCodec.getConfig().getAITime() * 1000);
        int n = list == null ? 1 : (this.ai.isBlocked() ? 2 : (this.ai.isWon() ? (list.size() > this.ivGame.getCards().size() ? 4 : 5) : 3));
        DlgAutoMove dlgAutoMove = new DlgAutoMove((Frame)this, n);
        int n2 = dlgAutoMove.getResult();
        if (n2 != 0) {
            this.getGlassPane().setVisible(false);
            this.ivLblToolbar.setVisible(false);
            return;
        }
        this.update(((Component)this).getGraphics());
        int n3 = list.size() - 1;
        while (n3 > -1) {
            long l;
            State state = (State)list.get(n3);
            if (state.getDrag() != null) {
                Drag drag = state.getDrag();
                drag.setTargetIndex(state.getDragIndex());
                Widget widget = (Widget)drag.getTargetWidgets().get(drag.getTargetIndex());
                this.ivGame.eventStopMove(drag);
                l = widget.getPile() instanceof Foundation ? 150L : 50L;
            } else {
                this.ivGame.eventDealStock();
                l = 100L;
            }
            if (n3 > 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    System.out.println("FrmMain sleep interrupted !!!");
                }
            }
            --n3;
        }
    }

    private boolean confirmEndGame() {
        if (!this.ivGame.isRunning()) {
            return true;
        }
        int n = 1;
        if (!this.ivConfigCodec.getConfig().isAutoEndGame()) {
            String string = Tools.translate("Main-ConfirmEnd");
            n = DlgMessage.display(this, 3, string);
        }
        return n == 1;
    }

    private boolean confirmExit() {
        String string = Tools.translate("Main-ConfirmExit");
        int n = DlgMessage.display(this, 3, string);
        return n == 1;
    }

    private void endGame() {
        this.ivBttRecord.setSelected(false);
        this.ivBttUndoRecord.setEnabled(false);
        this.ivGame.eventStop();
        if (this.ivGame.isWon()) {
            this.getGlassPane().setVisible(true);
            this.ivLblToolbar.setText(Tools.translate("Main-LblToolbarVictory"));
            this.ivLblToolbar.setPreferredSize(this.ivPanToolbar.getSize());
            this.ivLblToolbar.setVisible(true);
            this.ivGameUI.setPlayingVictory(true);
        } else {
            this.updateScore();
        }
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.ivBttStart) {
            if (!this.confirmEndGame()) {
                return;
            }
            if (this.ivGame.isRunning() && this.ivGame.isPlayed()) {
                this.endGame();
            }
            object = new DlgFile((Frame)this, this.ivShareware);
            this.ivBttStart.getModel().setRollover(false);
            if (((DlgFile)object).getFile() == null) {
                return;
            }
            this.startGame(((DlgFile)object).getFile());
        }
        if (actionEvent.getSource() == this.ivBttRestart) {
            if (this.ivLastFile == null) {
                this.ivBttStart.doClick();
                return;
            }
            if (!this.confirmEndGame()) {
                return;
            }
            if (this.ivGame.isRunning() && this.ivGame.isPlayed()) {
                this.endGame();
            }
            if (this.ivShareware.getGameLeftPlay(this.ivGame.getName()) < 1) {
                object = new DlgShareware((Frame)this, this.ivShareware);
                if (!this.ivShareware.isRegistered()) {
                    return;
                }
            }
            this.ivShareware.useGame(this.ivGame.getName());
            this.startGame(this.ivLastFile);
        }
        if (actionEvent.getSource() == this.ivBttStat) {
            if (this.ivGame.isRunning()) {
                this.ivGame.eventPause();
            }
            object = new DlgStat((Frame)this, this.ivStatCodec, this.ivScoreCodec);
            this.ivBttStat.getModel().setRollover(false);
            if (this.ivGame.isRunning()) {
                this.ivGame.eventRestart();
            }
        }
        if (actionEvent.getSource() == this.ivBttConfig) {
            if (this.ivGame.isRunning()) {
                this.ivGame.eventPause();
            }
            object = new DlgConfig((Frame)this, new Config(this.ivConfigCodec.getConfig()));
            this.ivBttConfig.getModel().setRollover(false);
            this.updateConfig(((DlgConfig)object).getConfig());
            if (this.ivGame.isRunning()) {
                this.ivGame.eventRestart();
            }
        }
        if (actionEvent.getSource() == this.ivBttUndo) {
            this.ivGame.eventUndo();
        }
        if (actionEvent.getSource() == this.ivBttRecord) {
            if (this.ivBttRecord.isSelected()) {
                this.ivGame.eventRecordUndo();
            }
            this.ivBttUndoRecord.setEnabled(this.ivBttRecord.isSelected());
        }
        if (actionEvent.getSource() == this.ivBttUndoRecord) {
            this.ivGame.eventUndoRecord();
            this.ivBttUndoRecord.getModel().setRollover(false);
            this.ivBttUndoRecord.setEnabled(false);
            this.ivBttRecord.setSelected(false);
        }
        if (actionEvent.getSource() == this.ivBttPause) {
            if (!this.ivGame.isRunning()) {
                return;
            }
            this.ivGame.eventPause();
            object = new DlgPause(this);
            this.ivGame.eventRestart();
            this.ivBttPause.getModel().setRollover(false);
        }
        if (actionEvent.getSource() == this.ivBttAuto) {
            if (!this.ivGame.isRunning()) {
                return;
            }
            this.checkAutoMove();
            this.ivBttAuto.getModel().setRollover(false);
        }
        if (actionEvent.getSource() == this.ivBttEnd) {
            if (!this.confirmEndGame()) {
                return;
            }
            if (this.ivGame.isRunning() && this.ivGame.isPlayed()) {
                this.endGame();
            }
        }
        if (actionEvent.getSource() == this.ivBttHelp) {
            object = this.ivGame.isRunning() ? "Rule" + this.ivGame.getCondensedName() + ".htm" : "Index.htm";
            this.ivHelp.showPage((String)object);
            this.ivBttHelp.getModel().setRollover(false);
        }
        if (actionEvent.getSource() == this.ivBttAbout) {
            object = new DlgAbout((Frame)this, this.ivShareware);
            this.ivBttAbout.getModel().setRollover(false);
        }
        if (actionEvent.getSource() == this.ivBttRegister) {
            object = new DlgShareware((Frame)this, this.ivShareware);
            this.ivBttRegister.getModel().setRollover(false);
        }
    }

    private void exit() {
        if (this.ivGame.isRunning() && this.ivGame.isPlayed()) {
            this.endGame();
        }
        this.ivConfigCodec.getConfig().setScreen(this.getBounds());
        try {
            this.ivConfigCodec.encode();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        System.exit(0);
    }

    public void gameMoveBegin(int n, int n2) {
        this.ivGameUI.moveBegin(n, n2);
    }

    public void gameMoveCards(List list, Pile pile, Pile pile2) {
        this.ivGameUI.moveCards(list, pile, pile2);
    }

    public void gameMoveEnd(int n, int n2) {
        this.ivGameUI.moveEnd(n, n2);
    }

    public void gameStateChanged() {
        if (this.ivGame.getStock() != null) {
            this.ivLblStock.setText(String.valueOf(Tools.translate("Main-Stock")) + " = " + this.ivGame.getStock().getCards().size());
            if (this.ivGame.getStock().getMaxRedeals() < 100) {
                this.ivLblRedeals.setText(String.valueOf(Tools.translate("Main-Redeals")) + " = " + (this.ivGame.getStock().getMaxRedeals() - this.ivGame.getStock().getRedealsCount()));
            } else {
                this.ivLblRedeals.setText("X");
            }
        } else {
            this.ivLblStock.setText("X");
            this.ivLblRedeals.setText("X");
        }
        this.ivLblBonus.setText(String.valueOf(Tools.translate("Main-Bonus")) + " = " + this.ivGame.getScore().getBonus());
        this.ivLblScore.setText(String.valueOf(Tools.translate("Main-Score")) + " = " + this.ivGame.getScore().getTotal());
    }

    public void gameWon() {
        this.gameStateChanged();
        this.endGame();
    }

    public static Dimension getFrameInsetsDimension() {
        return cvFrameInsetsDimension;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initialize() {
        this.ivStatCodec = new StatCodec();
        try {
            this.ivStatCodec.decode();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.ivShareware = new Shareware(this.ivStatCodec.getStats());
        String string = "Solo Cards";
        String string2 = Tools.translate("Main-Version");
        String string3 = this.ivShareware.isRegistered() ? Tools.translate("Main-Registered") : Tools.translate("Main-Unregistered");
        this.setTitle(String.valueOf(string) + " " + string2 + " " + string3);
        WinSplash winSplash = new WinSplash(this, this.getTitle());
        this.setName("FrmMain");
        ((Frame)this).setIconImage(Tools.getProgramIconImage());
        this.ivConfigCodec = new ConfigCodec();
        try {
            this.ivConfigCodec.decode();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.ivScoreCodec = new ScoreCodec();
        try {
            this.ivScoreCodec.decode();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        Tools.loadSounds();
        int n = this.ivConfigCodec.getConfig().getScreen().x;
        int n2 = this.ivConfigCodec.getConfig().getScreen().y;
        int n3 = this.ivConfigCodec.getConfig().getScreen().getSize().width;
        int n4 = this.ivConfigCodec.getConfig().getScreen().getSize().height;
        int n5 = this.getInsets().left + this.getInsets().right;
        int n6 = this.getInsets().top + this.getInsets().bottom;
        int n7 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n8 = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (n3 - n5 > n7) {
            n3 = n7;
            n = 0;
        }
        if (n4 - n6 > n8) {
            n4 = n8;
            n2 = 0;
        }
        ((Component)this).setBounds(n, n2, n3, n4);
        this.activateGame();
        this.initializeNorthPanel();
        this.initializeEastPanel();
        this.initializeSouthPanel();
        this.initializeWestPanel();
        this.initializeCenterPanel();
        this.activateEvents();
        this.setDefaultCloseOperation(0);
        ((Component)this).setVisible(true);
        winSplash.dispose();
    }

    private void initializeCenterPanel() {
        this.getContentPane().add((Component)this.ivGameUI, "Center");
    }

    private void initializeEastPanel() {
    }

    private void initializeNorthPanel() {
        this.ivPanToolbar = new JPanel(new FlowLayout(0, 1, 0), false);
        this.ivPanToolbar.setPreferredSize(new Dimension(0, 33));
        this.ivPanToolbar.setOpaque(false);
        this.ivPanToolbar.setBorder(new KBorder(1, 1));
        this.getContentPane().add((Component)this.ivPanToolbar, "North");
        this.ivLblToolbar = new JLabel();
        this.ivLblToolbar.setHorizontalAlignment(0);
        this.ivLblToolbar.setVerticalAlignment(0);
        this.ivLblToolbar.setFont(new Font("dialog.bold", 1, 16));
        this.ivLblToolbar.setVisible(false);
        this.ivPanToolbar.add(this.ivLblToolbar);
        this.ivBttStart = new JButton();
        this.ivBttStart.setPreferredSize(new Dimension(31, 31));
        this.ivBttStart.setBorder(null);
        this.ivBttStart.setIcon(Tools.getIcon("ToolStart.gif"));
        this.ivBttStart.setRolloverIcon(Tools.getIcon("ToolStartOver.gif"));
        this.ivBttStart.setPressedIcon(Tools.getIcon("ToolStartPressed.gif"));
        this.ivBttStart.setToolTipText(Tools.translate("Main-BttStart"));
        this.ivBttStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttStart);
        this.ivBttRestart = new JButton();
        this.ivBttRestart.setPreferredSize(new Dimension(31, 31));
        this.ivBttRestart.setBorder(null);
        this.ivBttRestart.setIcon(Tools.getIcon("ToolRestart.gif"));
        this.ivBttRestart.setRolloverIcon(Tools.getIcon("ToolRestartOver.gif"));
        this.ivBttRestart.setPressedIcon(Tools.getIcon("ToolRestartPressed.gif"));
        this.ivBttRestart.setToolTipText(Tools.translate("Main-BttRestart"));
        this.ivBttRestart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttRestart);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(31, 31));
        jLabel.setOpaque(false);
        this.ivPanToolbar.add(jLabel);
        this.ivBttStat = new JButton();
        this.ivBttStat.setPreferredSize(new Dimension(31, 31));
        this.ivBttStat.setBorder(null);
        this.ivBttStat.setIcon(Tools.getIcon("ToolStat.gif"));
        this.ivBttStat.setRolloverIcon(Tools.getIcon("ToolStatOver.gif"));
        this.ivBttStat.setPressedIcon(Tools.getIcon("ToolStatPressed.gif"));
        this.ivBttStat.setToolTipText(Tools.translate("Main-BttStat"));
        this.ivBttStat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttStat);
        this.ivBttConfig = new JButton();
        this.ivBttConfig.setPreferredSize(new Dimension(31, 31));
        this.ivBttConfig.setBorder(null);
        this.ivBttConfig.setIcon(Tools.getIcon("ToolConfig.gif"));
        this.ivBttConfig.setRolloverIcon(Tools.getIcon("ToolConfigOver.gif"));
        this.ivBttConfig.setPressedIcon(Tools.getIcon("ToolConfigPressed.gif"));
        this.ivBttConfig.setToolTipText(Tools.translate("Main-BttConfig"));
        this.ivBttConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttConfig);
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(new Dimension(31, 31));
        jLabel2.setOpaque(false);
        this.ivPanToolbar.add(jLabel2);
        this.ivBttUndo = new JButton();
        this.ivBttUndo.setPreferredSize(new Dimension(31, 31));
        this.ivBttUndo.setBorder(null);
        this.ivBttUndo.setIcon(Tools.getIcon("ToolUndo.gif"));
        this.ivBttUndo.setRolloverIcon(Tools.getIcon("ToolUndoOver.gif"));
        this.ivBttUndo.setPressedIcon(Tools.getIcon("ToolUndoPressed.gif"));
        this.ivBttUndo.setToolTipText(Tools.translate("Main-BttUndo"));
        this.ivBttUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttUndo);
        this.ivBttRecord = new JToggleButton();
        this.ivBttRecord.setPreferredSize(new Dimension(31, 31));
        this.ivBttRecord.setBorder(null);
        this.ivBttRecord.setIcon(Tools.getIcon("ToolRecord.gif"));
        this.ivBttRecord.setRolloverIcon(Tools.getIcon("ToolRecordOver.gif"));
        this.ivBttRecord.setPressedIcon(Tools.getIcon("ToolRecordPressed.gif"));
        this.ivBttRecord.setSelectedIcon(Tools.getIcon("ToolRecordPressed.gif"));
        this.ivBttRecord.setToolTipText(Tools.translate("Main-BttRecord"));
        this.ivBttRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttRecord);
        this.ivBttUndoRecord = new JButton();
        this.ivBttUndoRecord.setPreferredSize(new Dimension(31, 31));
        this.ivBttUndoRecord.setBorder(null);
        this.ivBttUndoRecord.setIcon(Tools.getIcon("ToolUndoRecord.gif"));
        this.ivBttUndoRecord.setRolloverIcon(Tools.getIcon("ToolUndoRecordOver.gif"));
        this.ivBttUndoRecord.setPressedIcon(Tools.getIcon("ToolUndoRecordPressed.gif"));
        this.ivBttUndoRecord.setDisabledIcon(Tools.getIcon("ToolUndoRecordDisabled.gif"));
        this.ivBttUndoRecord.setToolTipText(Tools.translate("Main-BttUndoRecord"));
        this.ivBttUndoRecord.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttUndoRecord);
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(31, 31));
        jLabel3.setOpaque(false);
        this.ivPanToolbar.add(jLabel3);
        this.ivBttPause = new JButton();
        this.ivBttPause.setPreferredSize(new Dimension(31, 31));
        this.ivBttPause.setBorder(null);
        this.ivBttPause.setIcon(Tools.getIcon("ToolPause.gif"));
        this.ivBttPause.setRolloverIcon(Tools.getIcon("ToolPauseOver.gif"));
        this.ivBttPause.setPressedIcon(Tools.getIcon("ToolPausePressed.gif"));
        this.ivBttPause.setToolTipText(Tools.translate("Main-BttPause"));
        this.ivBttPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttPause);
        this.ivBttAuto = new JButton();
        this.ivBttAuto.setPreferredSize(new Dimension(31, 31));
        this.ivBttAuto.setBorder(null);
        this.ivBttAuto.setIcon(Tools.getIcon("ToolAuto.gif"));
        this.ivBttAuto.setRolloverIcon(Tools.getIcon("ToolAutoOver.gif"));
        this.ivBttAuto.setPressedIcon(Tools.getIcon("ToolAutoPressed.gif"));
        this.ivBttAuto.setToolTipText(Tools.translate("Main-BttAuto"));
        this.ivBttAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttAuto);
        this.ivBttEnd = new JButton();
        this.ivBttEnd.setPreferredSize(new Dimension(31, 31));
        this.ivBttEnd.setBorder(null);
        this.ivBttEnd.setIcon(Tools.getIcon("ToolEnd.gif"));
        this.ivBttEnd.setRolloverIcon(Tools.getIcon("ToolEndOver.gif"));
        this.ivBttEnd.setPressedIcon(Tools.getIcon("ToolEndPressed.gif"));
        this.ivBttEnd.setToolTipText(Tools.translate("Main-BttEnd"));
        this.ivBttEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttEnd);
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(new Dimension(31, 31));
        jLabel4.setOpaque(false);
        this.ivPanToolbar.add(jLabel4);
        this.ivBttHelp = new JButton();
        this.ivBttHelp.setPreferredSize(new Dimension(31, 31));
        this.ivBttHelp.setBorder(null);
        this.ivBttHelp.setIcon(Tools.getIcon("ToolHelp.gif"));
        this.ivBttHelp.setRolloverIcon(Tools.getIcon("ToolHelpOver.gif"));
        this.ivBttHelp.setPressedIcon(Tools.getIcon("ToolHelpPressed.gif"));
        this.ivBttHelp.setToolTipText(Tools.translate("Main-BttHelp"));
        this.ivBttHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttHelp);
        this.ivBttAbout = new JButton();
        this.ivBttAbout.setPreferredSize(new Dimension(31, 31));
        this.ivBttAbout.setBorder(null);
        this.ivBttAbout.setIcon(Tools.getIcon("ToolAbout.gif"));
        this.ivBttAbout.setRolloverIcon(Tools.getIcon("ToolAboutOver.gif"));
        this.ivBttAbout.setPressedIcon(Tools.getIcon("ToolAboutPressed.gif"));
        this.ivBttAbout.setToolTipText(Tools.translate("Main-BttAbout"));
        this.ivBttAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttAbout);
        this.ivBttRegister = new JButton();
        this.ivBttRegister.setPreferredSize(new Dimension(31, 31));
        this.ivBttRegister.setBorder(null);
        this.ivBttRegister.setIcon(Tools.getIcon("ToolRegister.gif"));
        this.ivBttRegister.setRolloverIcon(Tools.getIcon("ToolRegisterOver.gif"));
        this.ivBttRegister.setPressedIcon(Tools.getIcon("ToolRegisterPressed.gif"));
        this.ivBttRegister.setToolTipText(Tools.translate("Main-BttRegister"));
        this.ivBttRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmMain.this.eventButtonClicked(actionEvent);
            }
        });
        this.ivPanToolbar.add(this.ivBttRegister);
        if (this.ivShareware.isRegistered()) {
            this.ivBttRegister.setVisible(false);
        }
    }

    private void initializeSouthPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0), false);
        jPanel.setPreferredSize(new Dimension(0, 19));
        jPanel.setOpaque(false);
        jPanel.setBorder(new KBorder(1, 1));
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 1, 1), false);
        jPanel2.setPreferredSize(new Dimension(480, 17));
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "West");
        this.ivLblStock = new KTitle("X", new Font("dialog.bold", 1, 12), Color.white, Color.black);
        this.ivLblStock.setPreferredSize(new Dimension(100, 17));
        jPanel2.add(this.ivLblStock);
        this.ivLblRedeals = new KTitle("X", new Font("dialog.bold", 1, 12), Color.white, Color.black);
        this.ivLblRedeals.setPreferredSize(new Dimension(100, 17));
        jPanel2.add(this.ivLblRedeals);
        this.ivLblBonus = new KTitle("X", new Font("dialog.bold", 1, 12), Color.white, Color.black);
        this.ivLblBonus.setPreferredSize(new Dimension(100, 17));
        jPanel2.add(this.ivLblBonus);
        this.ivLblScore = new KTitle("X", new Font("dialog.bold", 1, 12), Color.white, Color.black);
        this.ivLblScore.setPreferredSize(new Dimension(100, 17));
        jPanel2.add(this.ivLblScore);
        this.ivLblMessage = new KTitle("X", new Font("dialog.bold", 1, 12), Color.white, Color.black);
        this.ivLblMessage.setPreferredSize(new Dimension(100, 17));
        jPanel.add((Component)this.ivLblMessage, "Center");
    }

    private void initializeWestPanel() {
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                if (!Locale.getDefault().getLanguage().equals("fr")) {
                    Locale.setDefault(new Locale("en", "us"));
                }
            } else {
                try {
                    Locale.setDefault(new Locale(stringArray[0], stringArray[1]));
                }
                catch (Exception exception) {
                    Locale.setDefault(new Locale("en", "us"));
                }
            }
            FrmMain frmMain = new FrmMain();
            Thread.currentThread();
            Thread.sleep(1000L);
            int n = frmMain.getInsets().left + frmMain.getInsets().right;
            int n2 = frmMain.getInsets().top + frmMain.getInsets().bottom;
            cvFrameInsetsDimension = new Dimension(n, n2);
            frmMain.selectGame();
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of FrmMain");
            throwable.printStackTrace(System.out);
        }
    }

    public void selectGame() {
        this.ivBttStart.doClick();
    }

    private void startGame(File file) {
        if (file == null) {
            return;
        }
        try {
            GameCodec gameCodec = new GameCodec(this.ivGame, this.ivGameUI);
            gameCodec.decode(file);
            this.ivLastFile = file;
            this.ivLblMessage.setText(this.ivGame.getName());
            this.ivBttRecord.setSelected(false);
            this.ivBttUndoRecord.setEnabled(false);
            this.ivGame.eventStart();
            this.ai = new AI();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void superSize() {
        if (this.ivStandardBounds == null) {
            this.ivStandardBounds = this.getBounds();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = -this.getInsets().left;
        int n2 = -this.getInsets().top;
        int n3 = dimension.width + this.getInsets().left + this.getInsets().right;
        int n4 = dimension.height + this.getInsets().top + this.getInsets().bottom;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        System.out.println("Super Bounds = " + rectangle);
        System.out.println("Before Bounds = " + this.getBounds());
        if (this.getBounds().equals(rectangle)) {
            ((Component)this).setBounds(this.ivStandardBounds);
        } else {
            ((Component)this).setBounds(rectangle);
        }
        this.toFront();
        System.out.println("After Bounds = " + this.getBounds());
    }

    private void updateConfig(Config config) {
        block16: {
            if (config == null) {
                return;
            }
            boolean bl = false;
            Config config2 = this.ivConfigCodec.getConfig();
            if (config2.isAutoEndGame() != config.isAutoEndGame()) {
                config2.setAutoEndGame(config.isAutoEndGame());
                bl = true;
            }
            if (config2.isSounds() != config.isSounds()) {
                config2.setSounds(config.isSounds());
                Tools.setPlayingSounds(config.isSounds());
                bl = true;
            }
            if (config2.getAnims() != config.getAnims()) {
                config2.setAnims(config.getAnims());
                this.ivGameUI.setAnims(config.getAnims());
                bl = true;
            }
            if (config2.getAITime() != config.getAITime()) {
                config2.setAITime(config.getAITime());
                bl = true;
            }
            if (!config2.getBrowser().equals(config.getBrowser())) {
                config2.setBrowser(config.getBrowser());
                Tools.setBrowser(config.getBrowser());
                bl = true;
            }
            if (!config2.getBackColor1().equals(config.getBackColor1())) {
                config2.setBackColor1(config.getBackColor1());
                this.ivGameUI.setBackColor1(config.getBackColor1());
                bl = true;
            }
            if (!config2.getBackColor2().equals(config.getBackColor2())) {
                config2.setBackColor2(config.getBackColor2());
                this.ivGameUI.setBackColor2(config.getBackColor2());
                bl = true;
            }
            if (config2.getBackColorOption() != config.getBackColorOption()) {
                config2.setBackColorOption(config.getBackColorOption());
                this.ivGameUI.setBackColorOption(config.getBackColorOption());
                bl = true;
            }
            if (!config2.getBackImage().equals(config.getBackImage())) {
                config2.setBackImage(config.getBackImage());
                this.ivGameUI.setBackImage(config.getBackImage());
                bl = true;
            }
            if (config2.getBackImageOption() != config.getBackImageOption()) {
                config2.setBackImageOption(config.getBackImageOption());
                this.ivGameUI.setBackImageOption(config.getBackImageOption());
                bl = true;
            }
            if (!config2.getCardSet().equals(config.getCardSet())) {
                config2.setCardSet(config.getCardSet());
                this.ivGameUI.setCardSet(config.getCardSet());
                bl = true;
            }
            if (!config2.getCardBack().equals(config.getCardBack())) {
                config2.setCardBack(config.getCardBack());
                this.ivGameUI.setCardBack(config.getCardBack());
                bl = true;
            }
            if (config2.getScale() != config.getScale()) {
                config2.setScale(config.getScale());
                this.ivGameUI.setScale(config.getScale());
                bl = true;
            }
            if (!bl) break block16;
            try {
                this.ivConfigCodec.encode();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    private void updateScore() {
        Stat stat = (Stat)this.ivStatCodec.getStats().get(this.ivGame.getName());
        if (stat == null) {
            stat = new Stat(this.ivGame.getName());
        }
        if (this.ivGame.isWon()) {
            stat.addWon(this.ivGame.getScore().getTotal());
        } else {
            stat.addLost(this.ivGame.getScore().getTotal());
        }
        try {
            this.ivStatCodec.updateStats(stat);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        GameScore gameScore = (GameScore)this.ivScoreCodec.getGameScores().get(this.ivGame.getName());
        if (gameScore == null) {
            gameScore = new GameScore(this.ivGame.getName());
        }
        int n = gameScore.acceptScore(this.ivGame.getScore().getTotal());
        this.ivGame.getScore().setPlayer(this.ivConfigCodec.getConfig().getPlayer());
        DlgName dlgName = new DlgName((Frame)this, this.ivGame.getScore(), n + 1);
        if (n == -1) {
            return;
        }
        this.ivGame.getScore().setPlayer(dlgName.getPlayer());
        this.ivConfigCodec.getConfig().setPlayer(dlgName.getPlayer());
        try {
            this.ivConfigCodec.encode();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        gameScore.insertScore(this.ivGame.getScore());
        try {
            this.ivScoreCodec.updateGameScores(gameScore);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        DlgScore dlgScore = new DlgScore((Frame)this, gameScore, n, stat);
    }
}

